/***************************************************************************
                          openmosixmigmon.h  -  description
                             -------------------
    begin                : Son Jan  5 15:59:03 CET 2003
    copyright            : (C) 2003 by Matt
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPENMOSIXMIGMON_H
#define OPENMOSIXMIGMON_H

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qpopupmenu.h>
#include <qwhatsthis.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qtabdialog.h>
#include <qtoolbutton.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qspinbox.h>

#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <list>
#include <map>
#include <iostream>
#include <fstream>
#include <dirent.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/resource.h>
#include <math.h>
#include <unistd.h>

#include "omproc.h"
#include "nodewidget.h"
#include "procwidget.h"
#include "omnode.h"

#define VERSION "1.5"
#define clustercommand "mosctl"
#define clusterdirectory "/proc/hpc/nodes/"
#define pi 3.1415926525
#define eheight 600
#define ewide 600
#define circlewide 400
#define xcenter 300
#define ycenter 300


using namespace std;


int string2int(const string s);
string int2string(const int i);

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class OpenMosixmigmonView is
  * created which creates your view.
  */
class OpenMosixmigmonApp : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    OpenMosixmigmonApp();
    /** destructor */
    ~OpenMosixmigmonApp();
    /** initializes all QActions of the application */

    // the nodelist
    list<omnode> nodelist;

    // get how many nodes we are
    int gethowmanynodes();

    // get my my nodeID
    int getmynodeID();

    // howmany nodes we are
    int clusternodes;

    // check if the cluster configuration changed
    bool checknodes();

    // read from /proc
    char *readproc(int pid, const char *what);

    // the process-list
    list<oMProc> processlist;



  public slots:

    // updates the cluster nodes in the circle
    void updatenodes();

  	// set clusternodes to nodes
  	void setclusternodes(int nodes);

    // if the cluster changed
    void redraw();

    // howmany processes are running
    int gethowmanyprocs();

    // fills the processlist
    void fillprocesslist();

    // trigger to draw the processlist
    void drawprocesslist();

    // chooses the process group
    void setpg();

    // unselect current pg
    void unselectpg();

    // unselect all pgs
    void unselectall();

   /** shows help*/
    void slotHelp();

   // to adjust the timer by the qspinbox
   void adjusttimer(int val);


  protected:

    void paintEvent(QPaintEvent *);

    QLabel *QLabel_main;
    nodewidget *QLabel_tux;
    nodewidget *QLabel_myid;
    nodewidget *QLabel_nodes[360];
    nodewidget *QLabel_nodeID[360];
    QLabel *QLabel_pg;
    QButtonGroup *pggroup;
    QRadioButton *pg1;
    QRadioButton *pg2;
    QRadioButton *pg3;
    QRadioButton *pg4;
    QRadioButton *pg5;
    QRadioButton *pg6;
    QRadioButton *pg7;
    QRadioButton *pg8;
    QRadioButton *pg9;
    QRadioButton *pg10;
    QToolButton *helpme;
    QToolButton *unselect;
    QToolButton *clearmiggroups;

    procwidget *singleproc[100000];

    QTimer *updatetimer;
    QSpinBox *refreshtimeoutbox;
    QLabel *label_refresh1;
    QLabel *label_refresh2;

    // for multiple selection by mouse
    int xstart, ystart;
    int xcurrent, ycurrent;
    int xend, yend;
    bool dragging;
    QPainter selectrect;







  virtual void mousePressEvent(QMouseEvent *event) {
    if (event->button() == LeftButton) {
// cout << "mouse pressed" << endl;
      dragging = true;
      xstart = event->x();
      ystart = event->y()-25;
// cout << "at :" << xstart << " " << ystart << endl;

      }
    QMainWindow::mousePressEvent(event);
  }




  virtual void mouseReleaseEvent(QMouseEvent *event) {
    if (event->button() == LeftButton) {

// cout << "mouse released" << endl;

      xend = event->x();
      yend = event->y()+25;
// cout << "at :" << xend << " " << yend << endl;


      // get the current activated processgroup
       QString currentactivepg = QLabel_main->name();
// cout << "currentactivepg =" << currentactivepg << endl;


      // go through the processlist
      // and check which processes to select from the x+y pos
      list<oMProc>::iterator sp = processlist.begin();
      while (sp != processlist.end()) {
        // get a pointer to a proc
        oMProc sproc =*sp;

        int xypid=sproc.getompid();
        int xpidpos=sproc.getxpos();
        int ypidpos=sproc.getypos();

        // check out if the proc is in the rect
        if ((xpidpos>xstart) && (xpidpos<xend) && (ypidpos>ystart) && (ypidpos<yend)) {

          singleproc[xypid]->setmiggroup(currentactivepg.toInt());

          if(!singleproc[xypid]->is_selected()) {
            singleproc[xypid]->toggle_selected();
          } // end of if-selected

        } // it is not in the selection
        sp++;
      }

      // release the mouse
      dragging = false;
      releaseMouse();

      }
    QMainWindow::mouseReleaseEvent(event);
  }






  virtual void mouseMoveEvent(QMouseEvent *event) {
    if (event->state()) {
      xcurrent=event->pos().x()-xstart;
      ycurrent=(event->pos().y()-ystart)-25;

      QLabel_main->repaint();

      selectrect.begin(QLabel_main);
      selectrect.setPen(Qt::black);
      selectrect.drawRect(xstart, ystart, xcurrent, ycurrent);
      selectrect.end();

    }
    QMainWindow::mouseMoveEvent(event);
  }




  private:


};
#endif 

