/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Son Jul 14 10:15:18 CEST 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtranslator.h>

#include "openmosixview.h"
#include "openmosixviewlogo.xpm"

int main(int argc, char *argv[])
{
	DIR *dir;
	struct dirent *dir_info;
	int howmany=0;

	if ((dir=opendir(clusterdirectory))!=NULL) {
		while ((dir_info = readdir(dir))!=NULL) {
			howmany++;
		}
		howmany--;
		howmany--;
		closedir(dir);
		if(howmany<=0) {
       		cout << "openMosix not started!" << endl;
			} else {
			cout << "openMosix is started!" << endl;
			cout << "openMosix cluster contains " << howmany << " members." << endl;
		}
		} else {
		cout << "openMosix not started!" << endl;
	}

	if (argc > 1)	{
		cout << "usage :" << argv[0] << endl;
		cout << argv[0] << " -style=motif" << endl;
		cout << argv[0] << " -style=motifplus" << endl;
		cout << argv[0] << " -style=cde" << endl;
		cout << argv[0] << " -style=platinum" << endl;
		cout << argv[0] << " -style=windows" << endl;
		cout << argv[0] << " -help" << endl;
		cout << argv[0] << " --help" << endl;
		cout << "" << endl;
		cout << "openMosixview" << endl;
		cout << "Visit http://www.mosixview.com for documentation/howto/faq on openMosixview" << endl;
		cout << "or open the html-documentation in your openMosixview-installation directory" << endl;
		cout << "(e.g. /usr/local/openmosixview/openmosixview/docs/en/index.html depending on your installation)" << endl;
		cout << "If you have problems with openMosixview or found a bug please report it per mail to:" << endl;
		cout << "http://lists.sourceforge.net/lists/listinfo/mosixview-user or directly to me" << endl;
		cout << "(mosixview@t-online.de)" << endl;
		cout << "" << endl;
		cout << "have fun" << endl;
		cout << "Matt Rechenburg" << endl;
	}

	QApplication a(argc, argv);
	QLabel  *QLabel_intro;
	QPixmap intro;
	intro= QPixmap(openmosixview);
	QLabel_intro= new QLabel(0,"NoName");
	QLabel_intro->setGeometry(20,50,420,100);
	QLabel_intro->setMinimumSize(0,0);
	QLabel_intro->setBackgroundPixmap(QPixmap(intro));
	QLabel_intro->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	QLabel_intro->show();

	a.setFont(QFont("helvetica", 12));
	QTranslator tor( 0 );
	tor.load( QString("openmosixview.") + QTextCodec::locale(), "." );
	a.installTranslator( &tor );

	OpenMosixViewApp *openmosixview=new OpenMosixViewApp();
	a.setMainWidget(openmosixview);
	QFont font("helvetica");
	font.setPixelSize(12);
	openmosixview->setFont(font);

	int many=openmosixview->gethowmanynodes();
	openmosixview->setMinimumSize(740,100);
	openmosixview->setMaximumSize(740,600);
	openmosixview->setGeometry(20,200,740,120+(many*20));
	openmosixview->setclusternodes(many);

	openmosixview->show();
	QTimer::singleShot( 2000, QLabel_intro, SLOT(hide()) );
	return a.exec();
}

