// -*- mode: C++; tab-width: 2; -*-
// vi: set ts=2:
//
// --------------------------------------------------------------------------
//                   OpenMS Mass Spectrometry Framework
// --------------------------------------------------------------------------
//  Copyright (C) 2003-2011 -- Oliver Kohlbacher, Knut Reinert
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// --------------------------------------------------------------------------
// $Maintainer: Mathias Walzer$
// $Authors: $
// --------------------------------------------------------------------------

#include <OpenMS/CONCEPT/ClassTest.h>

///////////////////////////
#include <OpenMS/COMPARISON/SPECTRA/BinnedSpectrumCompareFunctor.h>
#include <OpenMS/CONCEPT/Factory.h>

using namespace OpenMS;
using namespace std;

START_TEST(BinnedSpectrumCompareFunctor, "$Id: BinnedSpectrumCompareFunctor_test.C 7797 2011-01-20 14:22:58Z cbielow $")

/////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

START_SECTION(BinnedSpectrumCompareFunctor())
{
  NOT_TESTABLE
}
END_SECTION

START_SECTION(~BinnedSpectrumCompareFunctor())
{
  NOT_TESTABLE
}
END_SECTION

//interface class is not testable

START_SECTION((BinnedSpectrumCompareFunctor(const BinnedSpectrumCompareFunctor &source)))
{
  NOT_TESTABLE
}
END_SECTION

START_SECTION((BinnedSpectrumCompareFunctor& operator=(const BinnedSpectrumCompareFunctor &source)))
{
  NOT_TESTABLE
}
END_SECTION

START_SECTION((virtual double operator()(const BinnedSpectrum &spec1, const BinnedSpectrum &spec2) const =0))
{
  NOT_TESTABLE
}
END_SECTION

START_SECTION((virtual double operator()(const BinnedSpectrum &spec) const =0))
{
  NOT_TESTABLE
}
END_SECTION

START_SECTION((static void registerChildren()))
{
  BinnedSpectrumCompareFunctor* c1 = Factory<BinnedSpectrumCompareFunctor>::create("BinnedSharedPeakCount");
  TEST_EQUAL(c1->getName(), "BinnedSharedPeakCount")
  c1 = Factory<BinnedSpectrumCompareFunctor>::create("BinnedSpectralContrastAngle");
  TEST_EQUAL(c1->getName(), "BinnedSpectralContrastAngle")
  c1 = Factory<BinnedSpectrumCompareFunctor>::create("BinnedSumAgreeingIntensities");
  TEST_EQUAL(c1->getName(), "BinnedSumAgreeingIntensities")
}
END_SECTION

START_SECTION((static const String getProductName()))
{
	TEST_EQUAL(BinnedSpectrumCompareFunctor::getProductName(), "BinnedSpectrumCompareFunctor")
}
END_SECTION

START_SECTION(([BinnedSpectrumCompareFunctor::IncompatibleBinning] IncompatibleBinning(const char *file, int line, const char *function, const char *message="compared spectra have different settings in binsize and/or binspread")))
{
  NOT_TESTABLE
}
END_SECTION

START_SECTION(([BinnedSpectrumCompareFunctor::IncompatibleBinning] virtual ~IncompatibleBinning()))
{
  NOT_TESTABLE
}
END_SECTION


/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
END_TEST



