// -*- mode: C++; tab-width: 2; -*-
// vi: set ts=2:
//
// --------------------------------------------------------------------------
//                   OpenMS Mass Spectrometry Framework
// --------------------------------------------------------------------------
//  Copyright (C) 2003-2011 -- Oliver Kohlbacher, Knut Reinert
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// --------------------------------------------------------------------------
// $Maintainer: Sandro Andreotti$
// $Authors: Sandro Andreotti$
// --------------------------------------------------------------------------

#include <OpenMS/CONCEPT/ClassTest.h>
#include <OpenMS/CHEMISTRY/SvmTheoreticalSpectrumGeneratorTrainer.h>


using namespace OpenMS;
using namespace std;

START_TEST(SvmTheoreticalSpectrumGeneratorTrainer, "$Id: SvmTheoreticalSpectrumGeneratorTrainer_test.C 9162 2011-11-15 14:10:55Z andreott $")

/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

SvmTheoreticalSpectrumGeneratorTrainer* ptr = 0;
SvmTheoreticalSpectrumGeneratorTrainer* nullPointer = 0;
START_SECTION(SvmTheoreticalSpectrumGeneratorTrainer())
{
	ptr = new SvmTheoreticalSpectrumGeneratorTrainer();
	TEST_NOT_EQUAL(ptr, nullPointer)
}
END_SECTION

START_SECTION((SvmTheoreticalSpectrumGeneratorTrainer(const SvmTheoreticalSpectrumGeneratorTrainer &source)))
{
  SvmTheoreticalSpectrumGeneratorTrainer train_c(*ptr);
  TEST_EQUAL(train_c.getParameters(), ptr->getParameters())
}
END_SECTION

START_SECTION((SvmTheoreticalSpectrumGeneratorTrainer& operator=(const SvmTheoreticalSpectrumGeneratorTrainer &tsg)))
{

  SvmTheoreticalSpectrumGeneratorTrainer train_a;
  train_a = *ptr;
  TEST_EQUAL(train_a.getParameters(), ptr->getParameters())
}
END_SECTION

START_SECTION((virtual ~SvmTheoreticalSpectrumGeneratorTrainer()))
{
  delete ptr;
}
END_SECTION


START_SECTION((void trainModel(const PeakMap &spectra, const std::vector< AASequence > &annotations, String filename, Int precursor_charge)))
{
  NOT_TESTABLE
}
END_SECTION

START_SECTION((void normalizeIntensity(PeakSpectrum &S) const ))
{
  NOT_TESTABLE
}
END_SECTION


/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
END_TEST



