// $Id: Layer.cc 8223 2008-09-14 19:17:24Z m9710797 $

#include "Layer.hh"
#include "LayerListener.hh"

namespace openmsx {

Layer::Layer(Coverage coverage_, ZIndex z_)
	: display(NULL), coverage(coverage_), z(z_)
{
}

Layer::~Layer()
{
}

void Layer::setCoverage(Coverage coverage_)
{
	coverage = coverage_;
}

void Layer::setZ(ZIndex z_)
{
	z = z_;
	if (display) display->updateZ(*this);
}

Layer::ZIndex Layer::getZ() const
{
	return z;
}

} // namespace openmsx
