// $Id: RomPageNN.cc 10587 2009-09-15 19:35:34Z m9710797 $

#include "RomPageNN.hh"
#include "Rom.hh"
#include "serialize.hh"

namespace openmsx {

RomPageNN::RomPageNN(MSXMotherBoard& motherBoard, const XMLElement& config,
                     std::auto_ptr<Rom> rom, byte pages)
	: Rom8kBBlocks(motherBoard, config, rom)
{
	int bank = 0;
	for (int page = 0; page < 4; ++page) {
		if (pages & (1 << page)) {
			setRom(page * 2 + 0, bank++);
			setRom(page * 2 + 1, bank++);
		} else {
			setUnmapped(page * 2 + 0);
			setUnmapped(page * 2 + 1);
		}
	}
}

REGISTER_MSXDEVICE(RomPageNN, "RomPageNN");

} // namespace openmsx

