/*************************************************************************
 *
 *  $RCSfile: instinfo.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:50:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SETUP_INSTINFO_HXX
#define _SETUP_INSTINFO_HXX


#include "stpwatch.hxx"

class SiSlide;

/////////////////////////////////////////////////////////////////////
// Diashow
/////////////////////////////////////////////////////////////////////

class SlideWindow : public Window
{
private:
	Point		m_aBmpPos;
	Bitmap		m_aBmp;
	Point		m_aTextPos;
	Size		m_aTextSize;
	ByteString		m_sText;

	void			CalcBmpPos();
	virtual void 	Paint(Rectangle const& rRect);
public:
	SlideWindow( Window* pParent, const ResId& rResId );

		void SetSlide(ByteString const& rFilename);
		void SetSlide(SiSlide*, ByteString const& rPath);
};

enum InstallMode
{
	INSTALLMODE_FIRST,
	INSTALLMODE_UPDATE,
	INSTALLMODE_RECOVER,
	INSTALLMODE_DEINST,
	INSTALLMODE_NETWORK,
	INSTALLMODE_WORKSTAT
};

// class SetupInstallInfoDialog ------------------------------------------

class SiAgenda;
class FileCopier;

class SetupInstallInfoDialog : public ModelessDialog
{
private:
	ProgressBar		m_aProgress;
	FixedLine		m_aFixedLine;
	CancelButton	m_aCancel;
	SlideWindow		m_aSlideWin;

	FixedText		m_aDescText;
	FixedText		m_aInfoText;
	ByteString          m_aProgramName;
	BOOL			m_bStop;
	FixedText		m_aEstimateText;
	FixedText		m_aEstimate;
	SiStopWatch		m_aStopWatch;
	long			m_lGuess;

	DECL_LINK(ExitHdl, Button*);
public:
	SetupInstallInfoDialog(Window* pParent, ByteString const& aProgramName );

	virtual BOOL Close();

	void SetDescText ( InstallMode );
	void SetInfoText ( USHORT nID );
	void SetInfoText ( const ByteString& rStr );
	void SetPercent  ( USHORT nPerc );
	void SetComplete () { SetPercent( 100 ); }

	DECL_LINK(ProgressHdl, SiAgenda*);

	#ifdef MAC
	DECL_LINK( StopHdl, Button * );
	#endif

	void DisableCancel(BOOL bEnable = TRUE);
	BOOL UserCanceled() const { return m_bStop; }

	void CalcSizeForSlide(SiSlide* pSiSlide, ByteString const& rPath);
	void CalcSizeForNOSlide();

	void ShowSlide() { m_aSlideWin.Show(); }
	void HideSlide() { m_aSlideWin.Hide(); }
	void SetSlide(ByteString const& rFilename)
				{ m_aSlideWin.SetSlide(rFilename); }
	void SetSlide(SiSlide* pSiSlide, ByteString const& rPath)
				{ m_aSlideWin.SetSlide(pSiSlide, rPath); }
};

#endif

