/*************************************************************************
 *
 *  $RCSfile: plugin.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: mba $ $Date: 2001/12/07 15:01:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _PLUGIN_HXX
#define _PLUGIN_HXX

#include <ipobj.hxx>
#include <svtools/ownlist.hxx>
#include <ipenv.hxx>

//=========================================================================
class Timer;
class INetURLObject;
struct SvPlugInData_Impl;
class SjJScriptPluginObject;
class SjJScriptJavaObject;
class SvPlugInObject : public SvInPlaceObject
/*	[Beschreibung]

	Die Klasse PlugInObject ist die Abbildung eines InPlace-Objektes
	auf einen PlugIn-Server. Dieses Objekt kann nur InPlace- und
	nicht UI-Aktiviert werden.

	[Probleme]
	Es handelt sich bei diesem Objekt immer um einen Link. Dieser Link
	kann allerdings InPlace aktiviert werden.
*/
{
friend class SvPlugInEnvironment;
friend class Executor_Impl;
	SvPlugInEnvironment * pPlugInEnv;
	SvPlugInData_Impl *	pImpl;
	SvCommandList	aCmdList;
	INetURLObject*	pURL;
	USHORT			nPlugInMode;// nicht ein Enum, wegen header file
								// und streamen

	DECL_STATIC_LINK( SvPlugInObject, NewPlugInHdl_Impl, Timer * );
	DECL_STATIC_LINK( SvPlugInObject, DataAvailable, void* );

	void			DataChanged_Impl( BOOL bOnlyEmbedSource );
protected:
	BOOL			DoStartPlugIn( );
	BOOL			StartPlugIn( );
	virtual void    FillClass( SvGlobalName * pClassName,
							   ULONG * pFormat,
							   String * pAppName,
							   String * pFullTypeName,
							   String * pShortTypeName,
                               long nFileFormat = SOFFICE_FILEFORMAT_CURRENT ) const;
					// Protokoll
	virtual void    Open( BOOL bOpen );
	virtual void    Embed( BOOL );
	virtual void    InPlaceActivate( BOOL );
	virtual ErrCode Verb( long, SvEmbeddedClient * pCallerClient,
						Window * pWin, const Rectangle * pWorkRectPixel );

					// Datenaustausch
	virtual void    SetVisArea( const Rectangle & rVisArea );
	virtual void    Draw( OutputDevice *,
						  const JobSetup & rSetup,
						  USHORT nAspect = ASPECT_CONTENT );

					// Laden speichern
	virtual BOOL    InitNew( SvStorage * );
	virtual BOOL    Load( SvStorage * );
	virtual BOOL    Save();
	virtual BOOL    SaveAs( SvStorage * );
	virtual void    HandsOff();
	virtual BOOL    SaveCompleted( SvStorage * );

	// Spaeter gerne mal virtuell...
	void            SetMIMEDetectedLink( const Link& rLink );

					~SvPlugInObject();
public:
					SO2_DECL_BASIC_CLASS_DLL(SvPlugInObject,SOAPP)
					SvPlugInObject();

	virtual ULONG	GetMiscStatus() const;
	virtual BOOL	IsLink() const;

					// spezielle Internet Methoden
	void			SetCommandList( const SvCommandList & rList );
	const SvCommandList & GetCommandList() const { return aCmdList; }
	void			SetURL( const INetURLObject & rURL );
	INetURLObject *	GetURL() const { return pURL; }
	void			SetMimeType( const String & rMimeType );
	const String &	GetMimeType() const;
	void			SetPlugInMode( USHORT );
	USHORT  		GetPlugInMode() const { return nPlugInMode; }
};

SO2_DECL_IMPL_REF(SvPlugInObject)


#endif // _PLUGIN_HXX
