/*************************************************************************
 *
 *  $RCSfile: fmtftntx.hxx,v $
 *
 *  $Revision: 1.5.34.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/01/28 16:51:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _FMTFTNTX_HXX
#define _FMTFTNTX_HXX

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif
#ifndef _FORMAT_HXX //autogen
#include <format.hxx>
#endif
#ifndef _NUMRULE_HXX
#include <numrule.hxx>
#endif


enum SwFtnEndPosEnum
{
	FTNEND_ATPGORDOCEND,				// at page or document end
	FTNEND_ATTXTEND,					// at end of the current text end
	FTNEND_ATTXTEND_OWNNUMSEQ,			// -""- and with own number sequence
	FTNEND_ATTXTEND_OWNNUMANDFMT,		// -""- and with onw numberformat
	FTNEND_ATTXTEND_END
};


class SwFmtFtnEndAtTxtEnd : public SfxEnumItem
{
	String 		sPrefix;
	String 		sSuffix;
	SvxNumberType aFmt;
	USHORT 	  	nOffset;

protected:
	SwFmtFtnEndAtTxtEnd( USHORT nWhich, SwFtnEndPosEnum ePos )
		: SfxEnumItem( nWhich, ePos ), nOffset( 0 )
	{}
	SwFmtFtnEndAtTxtEnd( const SwFmtFtnEndAtTxtEnd& rAttr )
		: SfxEnumItem( rAttr ), nOffset( rAttr.nOffset ), aFmt( rAttr.aFmt ),
		sPrefix( rAttr.sPrefix ), sSuffix( rAttr.sSuffix )
	{}

public:
	virtual USHORT 			GetValueCount() const;
	virtual SfxPoolItem*	Create(SvStream &, USHORT nVer ) const;
	virtual SvStream&		Store(SvStream &, USHORT nIVer) const;
	virtual USHORT			GetVersion( USHORT nFFVer ) const;

	virtual int				operator==( const SfxPoolItem& ) const;

	virtual	BOOL        	 QueryValue( com::sun::star::uno::Any& rVal, BYTE nMemberId = 0 ) const;
	virtual	BOOL			 PutValue( const com::sun::star::uno::Any& rVal, BYTE nMemberId = 0 );

// will be used at time??
//	void					FillVariable( SbxVariable &rVar,
//										  SfxMapUnit eCoreMetric,
//										  SfxMapUnit eUserMetric ) const;
//	virtual SfxArgumentError SetVariable( const SbxVariable &rVal,
//										  SfxMapUnit eCoreMetric,
//										  SfxMapUnit eUserMetric );
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper* pIntl = 0 ) const;

	inline BOOL IsAtEnd() const { return FTNEND_ATPGORDOCEND != GetValue(); }

	SwFmtFtnEndAtTxtEnd & operator=( const SwFmtFtnEndAtTxtEnd & rAttr );

	sal_Int16 GetNumType() const 		{ return aFmt.GetNumberingType(); }
	void SetNumType( sal_Int16 eType )	{ aFmt.SetNumberingType(eType); }

	const SvxNumberType& GetSwNumType() const 	{ return aFmt; }

	USHORT GetOffset() const 				{ return nOffset; }
	void SetOffset( USHORT nOff ) 			{ nOffset = nOff; }

	const String& GetPrefix() const 		{ return sPrefix; }
	void SetPrefix(const String& rSet)		{ sPrefix = rSet; }

	const String& GetSuffix() const 		{ return sSuffix; }
	void SetSuffix(const String& rSet)		{ sSuffix = rSet; }
};

class SwFmtFtnAtTxtEnd : public SwFmtFtnEndAtTxtEnd
{
public:
	SwFmtFtnAtTxtEnd( SwFtnEndPosEnum ePos = FTNEND_ATPGORDOCEND )
		: SwFmtFtnEndAtTxtEnd( RES_FTN_AT_TXTEND, ePos )
	{}

	virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
};

class SwFmtEndAtTxtEnd : public SwFmtFtnEndAtTxtEnd
{
public:
	SwFmtEndAtTxtEnd( SwFtnEndPosEnum ePos = FTNEND_ATPGORDOCEND )
		: SwFmtFtnEndAtTxtEnd( RES_END_AT_TXTEND, ePos )
	{
		SetNumType( SVX_NUM_ROMAN_LOWER );
	}

	virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
};

inline const SwFmtFtnAtTxtEnd &SwAttrSet::GetFtnAtTxtEnd(BOOL bInP) const
	{ return (const SwFmtFtnAtTxtEnd&)Get( RES_FTN_AT_TXTEND, bInP); }
inline const SwFmtEndAtTxtEnd &SwAttrSet::GetEndAtTxtEnd(BOOL bInP) const
	{ return (const SwFmtEndAtTxtEnd&)Get( RES_END_AT_TXTEND, bInP); }


inline const SwFmtFtnAtTxtEnd &SwFmt::GetFtnAtTxtEnd(BOOL bInP) const
	{ return aSet.GetFtnAtTxtEnd(bInP); }
inline const SwFmtEndAtTxtEnd &SwFmt::GetEndAtTxtEnd(BOOL bInP) const
	{ return aSet.GetEndAtTxtEnd(bInP); }

#endif

