/*************************************************************************
 *
 *  $RCSfile: wizdoku.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: fme $ $Date: 2001/06/01 11:29:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _WIZDOKU_HXX
#define _WIZDOKU_HXX

#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif

#include "wizmulti.hxx"

class WizardDokuDlg
{
	SwWizardDialog* pWizDlg;
public:
	FixedText*	pD_Text_SavOpt;
	FixedText*	pD_Text_InfTit;
	ListBox*	pD_List_InfTit;
	FixedText*	pD_Text_InfTem;
	ListBox*	pD_List_InfTem;
    FixedLine*   pD_FL_DokInf;
	CheckBox*	pD_CBox_AutoFN;
	FixedText*	pD_Text_AutoFN;
	Edit*		pD_Edit_AutoFN;

	PushButton*	pD_PBtn_Folder;
	FixedText*	pD_Text_Folder;

    FixedLine*   pD_FL_DokSav;
	FixedText*	pD_Text_VorNam;
	Edit*		pD_Edit_VorNam;
	FixedText*	pD_Text_VorInf;
	Edit*		pD_Edit_VorInf;
    FixedLine*   pD_FL_VorSav;
	PushButton*	pOkayBtn;
	String		aMerk1;
	String		aMerk2;
	USHORT		nDBFieldAnz;
public:
	WizardDokuDlg(SwWizardDialog* pDlgWin);
	~WizardDokuDlg();

	void Fill(MultiOne& WinArr);
	void SetPtr(PushButton* pBtn);
	void SetEventHandler();
	void InitUI();
	void ToUI();
	void SetDisable();
	void SetDocInfDisable();
	void SetAutoFNDisable();
	DECL_LINK( ClckHdl, CheckBox * );
	DECL_LINK( FldClckHdl, PushButton * );
	DECL_LINK( ModifyHdl, Edit * );
	DECL_LINK( OkClckHdl, PushButton * );
	void SetOkayDisable();

	void SetDBFieldAnz(USHORT nAnz);
	void SetDBFieldNam(USHORT nNum, const String& aNam);
	void SetTxFieldAnz(USHORT nAnz);
	void SetTxFieldNam(USHORT nNum, const String& aNam);
	USHORT GetDBFieldAnz() { return nDBFieldAnz; }
	USHORT GetTxFieldAnz() { return USHORT(pD_List_InfTit->GetEntryCount()-nDBFieldAnz-1); }
	USHORT GetDBFieldOfs() { return 1; }
	USHORT GetTxFieldOfs() { return GetDBFieldOfs()+GetDBFieldAnz(); }

	void MerkDocInfListSel();
	void RestDocInfListSel();

	BOOL IsDocInfoDBFeld(USHORT nNum)
		{ return nNum >= 1 && nNum < 1 + nDBFieldAnz; }
	BOOL IsDocInfoTxFeld( USHORT nNum )
		{ return nNum >= 1 + nDBFieldAnz; }

	BOOL IsDocInfoDBFeldSelected(USHORT nTyp); // 0=Titel 1=Thema
private:
	void SetDocInfListEntryOne(USHORT nNum, const String& aNam, ListBox& rLst);
	void SetDocInfListEntry(USHORT nNum, const String& aNam);
};


#endif  //_WIZDOKU_HXX

