/*************************************************************************
 *
 *  $RCSfile: db.cxx,v $
 *
 *  $Revision: 1.1.4.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/10/28 11:53:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <rtl/alloc.h>
#ifndef _DB_HXX_
#include <provider/db.hxx>
#endif


using namespace chelp;


Db::Db(DB_ENV* pDbenv,u_int32_t flags) 
{  
  db_create(&m_pDBP,pDbenv,flags);
}


Db::~Db()
{
  // does nothing
}


int Db::close(u_int32_t flags)
{
  return m_pDBP->close(m_pDBP,flags);
}

int Db::open(DB_TXN *txnid, 
			 const char *file,
			 const char *database, 
			 DBTYPE type, 
			 u_int32_t flags, 
			 int mode)
{
  return m_pDBP->open(m_pDBP,txnid,file,database,type,flags,mode);
}

	
int Db::get(DB_TXN *txnid, Dbt *key, Dbt *data, u_int32_t flags)
{
  return m_pDBP->get(m_pDBP,txnid,key->m_pDBT,data->m_pDBT,flags);
}


int Db::cursor(DB_TXN *txnid, Dbc **cursorp, u_int32_t flags)
{
  *cursorp = new Dbc();
  return m_pDBP->cursor(m_pDBP,txnid,&(*cursorp)->m_pDBC,flags);
}



Dbt::Dbt()
  : m_pDBT((DBT*)rtl_allocateZeroMemory(sizeof(DBT)))
{  
}


Dbt::Dbt(void *data_arg, u_int32_t size_arg)
  : m_pDBT((DBT*)rtl_allocateZeroMemory(sizeof(DBT)))
{
  set_data(data_arg);
  set_size(size_arg);
}


Dbt::~Dbt() {
  rtl_freeMemory(m_pDBT);
}

void * Dbt::get_data() const
{ 
  return m_pDBT->data;
}

void Dbt::set_data(void *value)
{
  m_pDBT->data = value;
}

u_int32_t Dbt::get_size() const
{ 
  return m_pDBT->size;
}

void Dbt::set_size(u_int32_t value)
{
  m_pDBT->size = value; 
}

void Dbt::set_flags(u_int32_t value)
{ 
  m_pDBT->flags = value;
}

Dbc::Dbc()
{
}

Dbc::~Dbc() {
}

int Dbc::close()
{
  return m_pDBC->c_close(m_pDBC);
}

int Dbc::get(Dbt *key, Dbt *data, u_int32_t flags)
{
  return m_pDBC->c_get(m_pDBC,key->m_pDBT,data->m_pDBT,flags);
}














