/*************************************************************************
 *
 *  $RCSfile: OOoMasterDocument.java,v $
 *
 *  $Revision: 1.1.4.1 $
 *
 *  last change: $Author: vg $ $Date: 2005/06/10 13:31:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2002 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/**
 * Description: This class is used for the transformation of Global documents.
 * For each child document referenced by a URL of the text:section a transformation will
 * be started.
 * This is necessary as master document children don't 'know' of each other nor of the global
 * document.
 * Due to that no consequence numbering of the chapter would be possible nor a HTML linking between
 * child documents an to the content-table (master document).
 * The class collects all necessary parameters and starts the transformation of each child document.
 *
 * This class works only with the XT processor of James Clark. This was the easiest way to go and should be
 * expanded/splitt later.
 * <p>
 *	For further documentation and updates visit http://xml.openoffice.org/sx2ml
 */
package org.openoffice.xslt;

import java.io.*;
import java.util.*;
import java.net.*;
import java.lang.reflect.Array;

import org.xml.sax.*;
import javax.xml.parsers.SAXParser;
import com.jclark.xsl.sax.*;
import com.jclark.xsl.om.NodeIterator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xml.sax.helpers.XMLReaderAdapter;
import com.jclark.xsl.expr.*;
import com.jclark.xsl.om.*;
import java.lang.NullPointerException;
import javax.xml.parsers.SAXParserFactory;



public class OOoMasterDocument
{
    static boolean mDebug = false;

    // helper for calcChapterNumbers()
    static int[] childHeaderLevel;

    // helper for getCurrentChildHeadingNo()
    static String fileBefore;
    static double headingCounter;
    static HashMap fileHeadingNos;

    // gives the number of preceding header for an external document via path
    static HashMap precedingHeaderCounterMap;
    static HashMap chapterNames;

    // bug workaround members
    static final String STOP_ELEMENT = "all-styles";
    static double allHeadings;
    static double previousHeading;
    static double headingNo;
    static double currentChildNo;
    static String currentChildUrl;
    static String currentChildContentRef;
    static final int LEVELMAX = 10; // maximum number of header levels
    static Vector  externalDocumentVector;
    static int[] initialHeaderLevel;

    // used for the child reference solution in getRelativeURLbetweenMasterChildren()
    static Vector m_vMasterDocPath;



    static void initialize(){
        try{
            // helper for getCurrentChildHeadingNo()
            fileHeadingNos = new HashMap();
            fileBefore = "dummyFileName";
            m_vMasterDocPath = getPathAsVector(OOoTransformProps.masterDocumentDir);
        }catch(Exception e) {
            System.out.println(e.getMessage());
            java.io.StringWriter sw = new java.io.StringWriter();
            e.printStackTrace(new java.io.PrintWriter(sw));
            System.out.println(sw.toString());
        }
    }

    // OOo Bug Workaround: XSLT memory helper for previous headings of child documents
    public static double getPreviousChildDocumentsHeadingCount(double childHeadingCount){

        double previous = previousHeading;

        allHeadings     += childHeadingCount;
        previousHeading += childHeadingCount;

        return previous;

    }


    // OOo Bug Workaround: XSLT memory helper for previous headings of child documents
    public static double getAllChildDocumentsHeadingCount(){
        return allHeadings;
    }

    public static double getHeadingNo(){
        return headingNo;
    }

    public static double getCurrentChildNo(){
        return currentChildNo;
    }

    public static String getCurrentChildUrl(){
        return currentChildUrl;
    }


    public static void setHeadingNo(double newHeadingNo){
        headingNo = newHeadingNo;
    }

    public static void setCurrentChildNo(double newCurrentChildNo){
        currentChildNo = newCurrentChildNo;
    }

    public static void setCurrentChildUrl(String newCurrentChildUrl){
        currentChildUrl = newCurrentChildUrl;
    }



    // gives back the last used heading of the specified file
    // (double is used as number for the interface to XT)
    public static double getNextCurrentChildHeadingNo(String file){

        // a new child will be worked on
        if(file.compareToIgnoreCase(fileBefore) != 0)
        {
            fileHeadingNos.put(fileBefore, new Double(headingCounter));
            Double oldHeadingCounter;
            // if on the file has been worked before
            if((oldHeadingCounter = (Double) fileHeadingNos.get(file)) != null){
                headingCounter = oldHeadingCounter.doubleValue();
            }else{
              headingCounter = 1.0;
            }
            fileBefore = file;

        }else
            headingCounter++;
        return headingCounter;
    }


    // gives back the last used heading of the specified file
    // (double is used as number for the interface to XT)
    public static double getCurrentChildHeadingNo(){
        return headingCounter;
    }

    public static String getMasterDocumentDir(){
        return OOoTransformProps.masterDocumentDir;
    }

    // gives back the last used heading of the specified file
    // (double is used as number for the interface to XT)
    public static String getGlobalHeadingNo(String currentHeadingNo, double precedingChapterLevel1){

        int precedingNo = (int)precedingChapterLevel1 + 1;

        StringBuffer output = new StringBuffer();
        output.append(precedingNo);

        if(currentHeadingNo.indexOf('.') != -1)
            output.append(currentHeadingNo.substring(currentHeadingNo.indexOf('.')));

        return output.toString();
    }



    /**

    A StarOffice/OpenOffice master document contains relative links to all his
    child documents, but the child documents do not know from each other.
    This method resolves a relative link inbetween two child documents.

    @param  sourcePath      A reference to the document, where the desired
                            relative link will start.
    @param  targetPath      A reference to the document, where the desired
                            relative link will end.
    @param  baseDirVector   The path of the master document. For ease of use
                            provided as a vector of the path directory names.

    @return  A relative link from the provided 'sourcePath' to the 'targetPath'.


    Examples:

    Example I)
    We have a master document in the direcotry a/b/c/
    A child (C1) in directory a/b/c/d/e
    Another child (C2) in directory a/B

    Both child are relative linked from the master document:
    path of C1 = d/e/C1
    path of C2 = ../../B/C2



    Example Ia:

    A reference from C2 -> C1 would be ../b/c/d/e/C1
    This can be split up to:

    ../b/c + d/e/C1
    The latter part is simply the reference to C1
    The first part (../b/c) is a somehow inverted C2 link (../../B).
    Every directory name became a '..', and ever '..' a directory name.
    Therfore, the B became '..' and the ../.. are taken from the master dir path



    Example Ib:

    A reference from C1 -> C2 would be ../../../../B/C2
    This again can be split up to:

    ../.. + ../../B/C2
    The latter part is simply the reference to C2
    The first is a somehow inverted C1 link (d/e)
    The d/e are written as ../..



    Example II)

    We have a master document in the direcotry a/b/c/
    A child (C1) in directory a/b/c/d/e
    A child (C3) in directory a/b/c/d/e/f/g

    C1 = d/e/C1
    C3 = d/e/f/g/C3


    Example IIa:
    A reference from C1 -> C3 would be f/g/C3


    Example IIa:
    A reference from C3 -> C1 would be ../../C3



    Example III)

    We have a master document in the direcotry a/b/c/
    A child (C1) in directory a/b/c/d/e
    A child (C3) in directory a/b/c/d/E/f/g

    C1 = d/e/C1
    C3 = d/E/f/g/C3


    Example IIIa:
    A reference from C1 -> C3 would be ../E/f/g/C3

    Here is again a split up, but the common directories are
    taken earlier away..
    C1     C3
    .. + E/f/g/C3


    Example IIIa:
    A reference from C3 -> C1 would be ../../../e/C1

    C3          C1
    ../../.. + e/C3

    */
    public static String getRelativeURL(String sourcePath, String targetPath, Vector baseDirVector){

        if(sourcePath == null || targetPath == null)
            return "null-from-RelativeURL()";

        sourcePath = getRelativeURLFromPath(sourcePath, true);
        targetPath = getRelativeURLFromPath(targetPath, false);

        StringTokenizer fromTkn  = new StringTokenizer(sourcePath);
        StringTokenizer toTkn = new StringTokenizer(targetPath);
        String fromToken = null;
        String toToken = null;
        StringBuffer outStringBuffer = new StringBuffer();

        // removing of similar preceding directories
        boolean isUnequal = false;
        while (fromTkn.hasMoreTokens() && toTkn.hasMoreTokens()) {
            fromToken  = fromTkn.nextToken("/");
            toToken = toTkn.nextToken("/");
            if(fromToken.equals(toToken)){
                continue;
            }else
                isUnequal = true;
            break;
        }
        StringBuffer part2 = new StringBuffer();
        if(fromToken != null && fromToken.equals("..")){
            int dirNo = 0;
            do{
                dirNo++;
                fromToken = fromTkn.nextToken("/");
            }while(fromToken.equals("..") && fromTkn.hasMoreTokens());

            if(baseDirVector != null){
                int numberOfDirs = baseDirVector.size();
                for(int i = numberOfDirs - dirNo;i < numberOfDirs;i++){
                    part2.append(baseDirVector.get(i));
                    part2.append("/");
                }
            }
        }
        if(isUnequal)
            outStringBuffer.append("../");
        for (int i = 0; i < fromTkn.countTokens();i++){
            outStringBuffer.append("../");
        }
        
        // patch as absolute instead of relative paths are given out
        if (outStringBuffer == null || outStringBuffer.length() < 2)
            outStringBuffer.append(".");         

        // inverse adding (cmp. javadoc example above)
        outStringBuffer.append(part2);

        // adding the (not equal) rest to the output path
        if(isUnequal)
            outStringBuffer.append(toToken);

        while (toTkn.hasMoreTokens()){
            outStringBuffer.append("/");
            toToken = toTkn.nextToken();
            outStringBuffer.append(toToken);
        }

        return outStringBuffer.toString();
    }



    public static String getRelativeURL(String sourcePath, String targetPath){
        return getRelativeURL(sourcePath, targetPath, null);
    }

    public static String getRelativeURLBetweenMasterChildren(String sourcePath, String targetPath){
        return getRelativeURL(sourcePath, targetPath, m_vMasterDocPath);
    }


    /** A relative URL from provided child to master
        @param  sourcePath  Child from which the desired reference to
                            the master document will start.

        @return             relative URL to the output of the master document -
                            usually the content table - from the given child
    */
    public static String getRelativeContentTableURL(String sourcePath){
        return getRelativeURL(sourcePath, OOoTransformProps.getContentTableURL() , null);
    }


    /** A relative URL from master to provided child
        @param  targetPath  Child to which the desired reference from
                            the master document will end.

        @return             relative URL from the output of the master document -
                            usually the content table - to the given child
    */
    public static String getRelativeChildURL(String targetPath){
        return getRelativeURL(OOoTransformProps.getContentTableURL(), targetPath, null);
    }

    /**
        Provided paths or URLs (e.g. JAR: to the enzipped content.xml), will
        be stripped to a relative URL

        @param  path            Can be any kind of URL or path
                                no matter of DOS or UNIX.
        @param  cutFileName     If set to true, a filename will be truncated at
                                the end of the path

        @return         A relative (or absolute) URL */
    private static String getRelativeURLFromPath(String path, boolean cutFileName){

        //removing protocols (e.g. file:, jar:) and DOS drive letter
        while(path.indexOf(':') != -1)
            path = path.substring(path.indexOf(':')+ 1);

        // removing in case of JAR URL the zipped content suffix
        int cut;
        if((cut = path.indexOf('!')) != -1)
            path = path.substring(0, cut + 1);

        // removing potential DOS separators
        path = path.replace('\\','/');

        // removing dublicate path separators "./" and "//"
        // \x2E is '.' so the expression is
        // if any ("./") or (more than one '/') found, replace against '/'
        path = path.replaceAll("(\\x2E/)|(/+)","/");

        if(cutFileName){
            // if a file separator exists, the document name is removed from path
            if((cut = path.lastIndexOf('/')) != -1)
                path = path.substring(0, cut + 1);
            // otherwise the whole path is set to an empty string
            else
                path = "";
        }

        // a beginning '/' will be removed
        if(path.startsWith("/"))
            path = path.substring(1, path.length());

        return path;
    }

    /**
        A path is been splitted to a Vector of it's directories,
        for ease later use.
    */
    private static Vector getPathAsVector(String path){

        path = getRelativeURLFromPath(path, true);
        StringTokenizer globalTkn = new StringTokenizer(path);
        Vector directoryVector = new Vector();
        // earlier discount of one as the vector also have a zero element
        while(globalTkn.hasMoreElements()){
            directoryVector.add(globalTkn.nextToken("/"));
        }
        return directoryVector;
    }



    public static String getContentURL(String sourcePath){

        if(mDebug) System.out.println("Relative Child SourcePath is: " + sourcePath);
        String contentURL = sourcePath.replace('\\', '/');
        sourcePath = contentURL.toLowerCase();
        if( // NOT an absolute DOS path
               !(sourcePath.charAt(1) == ':')

            // NOR an absolute Unix path
            && !sourcePath.startsWith("/")

            // NOR a file URL
            && !sourcePath.startsWith("file:")

            // NOR a http URL
            && !sourcePath.startsWith("http:")

            // NOR a jar URL
            && !sourcePath.startsWith("jar:"))
        {
            // THEN
            //      it is most probably a relative URL
            //      source directory will be added as prefix in front of the relative PATH
            contentURL = OOoTransformProps.getAbsoluteSourceDirURL() + contentURL;
            if(mDebug) System.out.println("Added source directy to content URL: " + contentURL);
        }

        // a zipped SX? file have to be accessed by JAR URL
        // IF a String '.sx' exists and IF NOT already a JAR URL
        if(sourcePath.indexOf(".sx") != -1 && !sourcePath.startsWith("jar:")){
            contentURL = "jar:" + OOoTransform.file2URL(new File(contentURL)).toString() + "!/content.xml";
            if(mDebug) System.out.println("Created a JAR content URL: " + contentURL);
        }
        if(contentURL.charAt(1) == ':')
            contentURL = "file:/" + contentURL;
        if(mDebug) System.out.println("Absolute Child Content URL is: " + contentURL);
        return contentURL;
    }

    /**
        An output URL will be created, depending on the sourceRef.
        Usually the sourceRef is the reference to a child document from a
        master document. The output will be created aside of the source document.

        The suffix is created dependent on the transformation. In this case
        '.xhtml' is being used.

        @param  sourceRef    Reference to the new content to be transformed

    */
    public static String getOutputURLForHTML(String sourceRef){
        return getOutputURL(sourceRef, ".xhtml");
    }


    /**

        @param  newSourceRef    Reference to the new content to be transformed
        @param  outputSuffix    Suffix of the desired output
    */
    public static String getOutputURL(String newSourceRef, String outputSuffix){

        String testRef = newSourceRef.toLowerCase();
        if(testRef.startsWith("jar:")){
            newSourceRef = newSourceRef.substring(newSourceRef.indexOf("jar:") + 4, newSourceRef.lastIndexOf("!"));
            testRef = newSourceRef.toLowerCase();
        }
        // if there is a suffix (a dot in the name), it will be replaced with a new suffix '.xhtml'
        int cuttingChar = newSourceRef.lastIndexOf('.');
        if(cuttingChar == -1)
            cuttingChar = newSourceRef.length();
        newSourceRef = newSourceRef.substring(0, cuttingChar) + outputSuffix;
        if(mDebug) System.out.println("The sourceRef is: " + newSourceRef);

        String outputURL = null;
        if( // NOT an absolute DOS path
               !(testRef.charAt(1) == ':')

            // NOR an absolute Unix path
            && !testRef.startsWith("/")

            // NOR a file URL
            && !testRef.startsWith("file:")

            // NOR a http URL
            && !testRef.startsWith("http:")

            // NOR a jar URL
            && !testRef.startsWith("jar:"))
        {
            // THEN
            //      it is most probably a relative URL
            //      the target URL will be changed --
            // 2DO what about if newSourceRef is relative form the old source and source and destination differs!!!!
            outputURL = OOoTransformProps.getDestinationDirURL() + newSourceRef;
            if(mDebug) System.out.println("Adding DestinationDir to the output URL - " + outputURL);
        }else{
            outputURL = newSourceRef;
            if(mDebug) System.out.println("The output URL is " + outputURL);
        }
        return outputURL;
    }

    public static Object getContentTableHeadings(){
        return (NodeIterator) OOoNodeHandlingXT.contentTableHeadings;
    }

    public static String calcChapterNumbers(double d_Level){
        //2DO: We have to distinguish between XT and W3C Node usage!!
        return OOoNodeHandlingXT.calcChapterNumbers(d_Level);
    }
}
