<?xml version="1.0" encoding="UTF-8"?>
<!--

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:office="http://openoffice.org/2000/office"
    xmlns:style="http://openoffice.org/2000/style"
    xmlns:text="http://openoffice.org/2000/text"
    xmlns:table="http://openoffice.org/2000/table"
    xmlns:draw="http://openoffice.org/2000/drawing"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:number="http://openoffice.org/2000/datastyle"
    xmlns:svg="http://www.w3.org/2000/svg"
    xmlns:chart="http://openoffice.org/2000/chart"
    xmlns:dr3d="http://openoffice.org/2000/dr3d"
    xmlns:math="http://www.w3.org/1998/Math/MathML"
    xmlns:form="http://openoffice.org/2000/form"
    xmlns:script="http://openoffice.org/2000/script"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:meta="http://openoffice.org/2000/meta"
    xmlns:config="http://openoffice.org/2001/config"
    xmlns:help="http://openoffice.org/2000/help"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:xt="http://www.jclark.com/xt"
    xmlns:common="http://exslt.org/common"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:urlencoder="http://www.jclark.com/xt/java/java.net.URLEncoder"
    xmlns:sxg="http://www.jclark.com/xt/java/org.openoffice.xslt.OOoMasterDocument"
    xmlns:sxg-xt="http://www.jclark.com/xt/java/org.openoffice.xslt.OOoNodeHandlingXT"
    exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help java urlencoder">

	<!-- Start of OOo2.0 common/measure_conversion.xsl stylesheet  -->
	<!-- DPI (dots per inch) the standard resolution of given pictures (necessary for the conversion of 'cm' into 'pixel')
		 Although many pictures have a 96 dpi resolution, a higher resoltion give better results for common browsers -->
	<xsl:param name="dpi" select="111"/>
	<xsl:param name="centimeter-in-mm" select="10"/>
	<xsl:param name="inch-in-mm" select="25.4"/>
	<xsl:param name="didot-point-in-mm" select="0.376065"/>
	<xsl:param name="pica-in-mm" select="4.2333333"/>
	<xsl:param name="point-in-mm" select="0.3527778"/>
	<xsl:param name="twip-in-mm" select="0.017636684"/>
	<xsl:param name="pixel-in-mm" select="$inch-in-mm div $dpi"/>
	<!-- ***** MEASUREMENT CONVERSIONS *****
	  PARAM 'value'
		The measure to be converted.
		The current measure is judged by a substring (e.g. 'mm', 'cm', 'in', 'pica'...)
		directly added to the number.

	  PARAM 'rounding-factor'
		Is used for the rounding of decimal places.
		The parameter number is the product of 1 and some '10', where
		every zero represents a decimal place.

		For example, providing as parameter:
			<xsl:param name="rounding-factor" select="10000" />
		Gives by default four decimal places.

		To round two decimal places, basically the following is done:
			<xsl:value-of select="round(100 * value) div 100"/>

	  RETURN    The converted number, by default rounded to four decimal places.
				In case the input measure could not be matched the same value is
				returned and a warning message is written out.



	 MEASURE LIST:
	 * 1 milimeter (mm), the basic measure

	 * 1 centimeter (cm) = 10 mm

	 * 1 inch (in) = 25.4 mm
		While the English have already seen the light (read: the metric system), the US
		remains loyal to this medieval system.

	 * 1 point (pt) = 0.35277777.. mm
		Sometimes called PostScript point (ppt), as when Adobe created PostScript, they added their own system of points.
		There are exactly 72 PostScript points in 1 inch.

	 * 1 twip = twentieth of a (PostScript) point
		A twip (twentieth of a point) is a 1/20th of a PostScript point, a traditional measure in printing.

	 * 1 didot point (dpt) = 0.376065 mm
		Didot point after the French typographer Firmin Didot (1764-1836).

		More details under
		http://www.unc.edu/~rowlett/units/dictP.html:
		"A unit of length used by typographers and printers. When printing was done
		from hand-set metal type, one point represented the smallest element of type
		that could be handled, roughly 1/64 inch. Eventually, the point was standardized
		in Britain and America as exactly 1/72.27 = 0.013 837 inch, which is
		about 0.35 mm (351.46 micrometers). In continental Europe, typographers
		traditionally used a slightly larger point of 0.014 83 inch (about
		1/72 pouce, 0.377 mm, or roughly 1/67 English inch), called a Didot point
		after the French typographer Firmin Didot (1764-1836). In the U.S.,
		Adobe software defines the point to be exactly 1/72 inch (0.013 888 9 inch
		or 0.352 777 8 millimeters) and TeX software uses a slightly smaller point
		of 0.351 459 8035 mm. The German standards agency DIN has proposed that
		all these units be replaced by multiples of 0.25 millimeters (1/101.6 inch).

	 * 1 pica = 4.233333 mm
		1/6 inch or 12 points

	 * 1 pixel (px) = 0.26458333.. mm   (relative to 'DPI', here: 96 dpi)
		Most pictures have the 96 dpi resolution, but the dpi variable may vary by stylesheet parameter


	-->
	<!-- changing measure to mm -->
	<xsl:template name="convert2mm">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="substring-before($value, 'mm')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm' ) * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in' ) * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'mm'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to cm -->
	<xsl:template name="convert2cm">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="substring-before($value, 'cm')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $centimeter-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $centimeter-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $centimeter-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $centimeter-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') div $centimeter-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $centimeter-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'cm'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to inch (cp. section comment) -->
	<xsl:template name="convert2in">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $inch-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="substring-before($value, 'in')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $inch-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $inch-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $inch-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') div $inch-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $inch-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'in'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to dpt (cp. section comment) -->
	<xsl:template name="convert2dpt">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $didot-point-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $didot-point-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $didot-point-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="substring-before($value, 'dpt')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $didot-point-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') div $didot-point-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $didot-point-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'dpt'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to pica (cp. section comment) -->
	<xsl:template name="convert2pica">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $pica-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $pica-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $pica-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $pica-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="substring-before($value, 'pica')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') div $pica-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $pica-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'pica'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to pt (cp. section comment) -->
	<xsl:template name="convert2pt">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $point-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $point-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="substring-before($value, 'pt')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $point-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $point-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') div $point-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $point-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'pt'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to pt (cp. section comment) -->
	<xsl:template name="convert2twip">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $twip-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $twip-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $twip-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $twip-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $twip-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="substring-before($value, 'twip')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $twip-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'twip'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to pixel by via parameter provided dpi (dots per inch) standard factor (cp. section comment) -->
	<xsl:template name="convert2px">
		<xsl:param name="value"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round(number(substring-before($value, 'mm')) div $pixel-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round(number(substring-before($value, 'cm')) div $pixel-in-mm * $centimeter-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round(number(substring-before($value, 'in')) div $pixel-in-mm * $inch-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round(number(substring-before($value, 'pt')) div $pixel-in-mm * $point-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round(number(substring-before($value, 'dpt')) div $pixel-in-mm * $didot-point-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round(number(substring-before($value, 'pica')) div $pixel-in-mm * $pica-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round(number(substring-before($value, 'twip')) div $pixel-in-mm * $twip-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="$value"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'px'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- End of OOo2.0 common/measure_conversion.xsl stylesheet  -->
	<!-- Start of OOo2.0 export/common/body.xsl stylesheet  -->

	<!-- ****************** -->
	<!-- *** Whitespace *** -->
	<!-- ****************** -->

	<xsl:template match="text:s">
		<xsl:call-template name="write-breakable-whitespace">
			<xsl:with-param name="whitespaces" select="@text:c" />
		</xsl:call-template>
	</xsl:template>


	<!--write the number of 'whitespaces' -->
	<xsl:template name="write-breakable-whitespace">
		<xsl:param name="whitespaces" />

		<!--write two space chars as the normal white space character will be stripped
			and the other is able to break -->
		<xsl:text>&#160;</xsl:text>
		<xsl:if test="$whitespaces >= 2">
			<xsl:call-template name="write-breakable-whitespace-2">
				<xsl:with-param name="whitespaces" select="$whitespaces - 1" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>


	<!--write the number of 'whitespaces' -->
	<xsl:template name="write-breakable-whitespace-2">
		<xsl:param name="whitespaces" />
		<!--write two space chars as the normal white space character will be stripped
			and the other is able to break -->
		<xsl:text> </xsl:text>
		<xsl:if test="$whitespaces >= 2">
			<xsl:call-template name="write-breakable-whitespace">
				<xsl:with-param name="whitespaces" select="$whitespaces - 1" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>



	<!--
	TABHANDLING PROBLEM: Tabs are possible to be shown in the HTML text file, but will be later stripped as whitespaces.
		To prevent this one way would be the PRE tag which unfortunately ALWAYS result into a line-break. No surrounding NOBR tags help.

	<xsl:template match="text:tab-stop">
		<xsl:if test="not(preceding-sibling::text:tab-stop)">
			<xsl:element namespace="{$namespace}" name="pre"><xsl:text>&#9;</xsl:text><xsl:for-each select="following-sibling::text:tab-stop"><xsl:text>&#9;</xsl:text></xsl:for-each></xsl:element>
		</xsl:if>
	 </xsl:template>

	<xsl:template match="text:tab-stop"><xsl:text>&#9;</xsl:text></xsl:template>
	-->
	<!-- currentSolution: 8 non-breakable-spaces instead of a TAB is an approximation.
		 Sometimes less spaces than 8 might be needed and the output might be more difficult to read -->
	<xsl:template match="text:tab-stop">
		<xsl:call-template name="write-breakable-whitespace">
			<xsl:with-param name="whitespaces" select="8" />
		</xsl:call-template>
	</xsl:template>



	<!-- *************** -->
	<!-- *** Textbox *** -->
	<!-- *************** -->

	<!-- ID / NAME of text-box -->
	<xsl:template match="@draw:name">
		<xsl:attribute name="id">
			<xsl:value-of select="translate(., '. %()/\+', '_')" />
		</xsl:attribute>
	</xsl:template>



	<xsl:template match="text:line-break">
		<xsl:element namespace="{$namespace}" name="br" />
	</xsl:template>



	<!-- currently there have to be an explicit call of the style attribute nodes, maybe the attributes nodes have no priority only order relevant-->
	<!-- STRANGE: checked with biorythm.sxc a simple xsl:apply-templates did not recognice the styles. Maybe caused by the template match order?  -->
	<xsl:template name="apply-styles-and-content">
		<xsl:param name="globalData" />

		<xsl:apply-templates select="@text:style-name | @draw:style-name | @draw:text-style-name | @table:style-name"><!-- | @presentation:style-name -->
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:apply-templates>

		<xsl:apply-templates>
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:apply-templates>
	</xsl:template>



	<xsl:template match="text:sequence">
		<xsl:param name="globalData" />

		<xsl:apply-templates>
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:apply-templates>
	</xsl:template>


	<!-- ************************ -->
	<!-- *** Reference Fields *** -->
	<!-- ************************ -->

	<xsl:template match="text:reference-ref">
		<xsl:param name="globalData" />
		<!-- Java is needed as we have to encode the relative links (bug#102311) -->
		<xsl:choose>
			<xsl:when test="$javaEnabled">
				<xsl:element namespace="{$namespace}" name="a">
					<xsl:attribute name="href">
						<xsl:text>#</xsl:text>
						<xsl:call-template name="encode-string">
						<!-- the space has to be normalized,
							otherwise an illegal argument exception will be thrown for XT-->
							<xsl:with-param name="textToBeEncoded" select="@text:ref-name" />
						</xsl:call-template>
					</xsl:attribute>

					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates>
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="text:reference-mark">
		<xsl:param name="globalData" />

		<!-- Java is needed as we have to encode the relative links (bug#102311) -->
		<xsl:choose>
			<xsl:when test="$javaEnabled">
				<xsl:element namespace="{$namespace}" name="a">
					<xsl:attribute name="name">
						<xsl:call-template name="encode-string">
						<!-- the space has to be normalized,
							otherwise an illegal argument exception will be thrown for XT-->
							<xsl:with-param name="textToBeEncoded" select="@text:name" />
						</xsl:call-template>
					</xsl:attribute>

					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>

				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates>
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<xsl:template match="text:reference-mark-start">
		<xsl:param name="globalData" />

		<!-- Java is needed as we have to encode the relative links (bug#102311) -->
		<xsl:choose>
			<xsl:when test="$javaEnabled">
				<xsl:element namespace="{$namespace}" name="a">
					<xsl:attribute name="name">
						<xsl:call-template name="encode-string">
						<!-- the space has to be normalized,
							otherwise an illegal argument exception will be thrown for XT-->
							<xsl:with-param name="textToBeEncoded" select="@text:name" />
						</xsl:call-template>
					</xsl:attribute>

					<xsl:variable name="endOfReference">
						<xsl:for-each select="text:reference-mark-end[@name=current()/@text:name]">
							<xsl:value-of select="position()" />
						</xsl:for-each>
					</xsl:variable>

					<xsl:for-each select="following-sibling::*[position() &lt; $endOfReference]">
						<xsl:apply-templates>
							<xsl:with-param name="globalData" select="$globalData" />
						</xsl:apply-templates>
					</xsl:for-each>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates>
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>




	<!-- *************** -->
	<!-- *** HELPER  *** -->
	<!-- *************** -->


	<xsl:template name="create-href">
		<xsl:param name="href" />

		<xsl:choose>
			<!-- internal OOo URL used in content tables -->
			<xsl:when test="contains($href, '%7Coutline')">
				<!-- the simple workaround for content tables in a single document is to create create an anchor from every heading element
					 work-around downside: Multiple identical headings won't refer always to the first.
				-->
				<xsl:text>#</xsl:text>
				<xsl:variable name="title"><xsl:apply-templates mode="concatenate" /></xsl:variable>
				<xsl:call-template name="encode-string">
				<!-- the space has to be normalized,
					otherwise an illegal argument exception will be thrown for XT-->
					<xsl:with-param name="textToBeEncoded" select="normalize-space(string($title))" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					 <!-- for images jared in open office document -->
					<xsl:when test="starts-with($href, '#')">
						<xsl:choose>
							<xsl:when test="starts-with($href, '#.')">
								<!-- creating an absolute http URL to the packed image file (removing the '.')-->
								<xsl:value-of select="concat($sourceBaseURL, '/', substring-after($href, '#.'), $optionalURLSuffix)" />
							</xsl:when>
							<xsl:otherwise>
								<!-- creating an absolute http URL to the packed image file -->
								<xsl:value-of select="concat($sourceBaseURL, '/', substring-after($href, '#'), $optionalURLSuffix)" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					 <!-- for absolute URLs -->
					<xsl:when test="contains($href, ':')">
						<xsl:value-of select="concat($href, $optionalURLSuffix)" />
					</xsl:when>
					 <!-- for relative URLs -->
					<xsl:otherwise>
						<xsl:value-of select="concat($targetBaseURL, $href, $optionalURLSuffix)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template match="text()" mode="concatenate"><xsl:value-of select="."/></xsl:template>
	<xsl:template match="*" mode="concatenate"><xsl:apply-templates mode="concatenate"/></xsl:template>

	<!-- ********************* -->
	<!-- *** Common Helper *** -->
	<!-- ********************* -->

	<!-- Chapters from the Content Table have currently no anchor to child documents in OOo XML.
		 As solution, whenever a a master document  every header of the HTML output gets get's an anchor in the Therefore-->
	<xsl:template name="encode-string">
		<xsl:param name="encoding" select="'UTF-8'" />
		<xsl:param name="textToBeEncoded" />

		<xsl:choose>
			<xsl:when test="function-available('urlencoder:encode')">
				<xsl:value-of select="translate(urlencoder:encode(normalize-space($textToBeEncoded),$encoding), '%+', '__')" />
			</xsl:when>
			<xsl:when test="function-available('java:java.net.URLEncoder.encode')">
				<xsl:value-of select="translate(java:java.net.URLEncoder.encode(string(normalize-space($textToBeEncoded)),string($encoding)), '%+', '__')" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Function not found: java:java.net.URLEncoder.encode</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- ******************** -->
	<!-- *** Common Rules *** -->
	<!-- ******************** -->

	<!-- deactivating default template -->
	<xsl:template match="*" />

	<!-- allowing all matched text nodes -->
	<xsl:template match="text()">
		<xsl:value-of select="." />
	</xsl:template>
	<!-- End of OOo2.0 export/common/body.xsl stylesheet  -->
	<!-- Start of OOo2.0 export/common/styles/style_collector.xsl stylesheet  -->

	<!-- ***************************************** -->
	<!-- *** Gathering office style properties *** -->
	<!-- ***************************************** -->

	<!-- REASON FOR STYLESHEET:
			In the OpenOffice documents styles are represented by a hierarchy.
			(e.g. most styles are inherited from a default style).
			Many other languages (as XHTML/CSS) do not support inherited styles.
			The style inheritance have to be made flat/absolute for each style.

			A further reason was, that the earlier style collection mechanism
			had problems with CSS inline, which do not inherit from XML office defaults
			nor font:family defaults as the style header does
			(cp. stylesheet 'style_collector.xsl' and the 'write-default-styles' template)

		 RESULT OF STYLESHEET:
			All styles will be returned in a variable containing styles with their inherited style:properties:

				<all-styles>
					<style style:family="foo" style:name="x1">
						<style:properties fo:margin-left="0cm" fo:margin-right="0cm" />
					</style>
					<style style:family="muh" style:name="x2" >
						<style:properties fo:margin-left="3cm" ...                  />
					</style>
					...

				</all-styles>
	-->


	<xsl:template name="collect-global-OOo-properties">
		<!-- to access the variable as a node-set by XPATH expressions, it is necessary to convert it
			 from a result-tree-fragment (RTF) to a node set by a in a XSLT 1.0 non standarized function -->
		<xsl:variable name="globalDataRTF">
			<xsl:call-template name="collect-document-links-RTF" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="function-available('xalan:nodeset')">
				<xsl:call-template name="collect-style-properties">
					<xsl:with-param name="globalData" select="xalan:nodeset($globalDataRTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('xt:node-set')">
				<xsl:call-template name="collect-style-properties">
					<xsl:with-param name="globalData" select="xt:node-set($globalDataRTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('common:node-set')">
				<xsl:call-template name="collect-style-properties">
					<xsl:with-param name="globalData" select="common:node-set($globalDataRTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">The required node-set function was not found!</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<xsl:template name="collect-style-properties">
		<xsl:param name="globalData" />

		<!-- Add the input file references to the new collected style properties -->
		<xsl:variable name="globalDataRTF">
			<xsl:copy-of select="$globalData" />
			<xsl:call-template name="collect-style-properties-RTF">
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="function-available('xalan:nodeset')">
				<xsl:call-template name="map-ooo-style-properties">
					<xsl:with-param name="globalData" select="xalan:nodeset($globalDataRTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('xt:node-set')">
				<xsl:call-template name="map-ooo-style-properties">
					<xsl:with-param name="globalData" select="xt:node-set($globalDataRTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('common:node-set')">
				<xsl:call-template name="map-ooo-style-properties">
					<xsl:with-param name="globalData" select="common:node-set($globalDataRTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">The required node-set function was not found!</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="collect-document-links-RTF">
		<!-- works for zipped office files, unzipped office files as for flat filter single office file format as well -->
		<xsl:variable name="documentLinksRTF">
			<xsl:choose>
				<xsl:when test="office:document-content">
					<xsl:element name="styles-file" namespace="">
						<xsl:copy-of select="document(concat($sourceBaseURL, 'styles.xml'))" />
					</xsl:element>
					<xsl:element name="meta-file" namespace="">
						<xsl:copy-of select="document(concat($sourceBaseURL, 'meta.xml'))" />
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="styles-file" namespace="">
						<xsl:copy-of select="/" />
					</xsl:element>
					<xsl:element name="meta-file" namespace="">
						<xsl:copy-of select="/" />
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="function-available('xalan:nodeset')">
				<xsl:call-template name="collect-document-links">
					<xsl:with-param name="documentLinks" select="xalan:nodeset($documentLinksRTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('xt:node-set')">
				<xsl:call-template name="collect-document-links">
					<xsl:with-param name="documentLinks" select="xt:node-set($documentLinksRTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('common:node-set')">
				<xsl:call-template name="collect-document-links">
					<xsl:with-param name="documentLinks" select="common:node-set($documentLinksRTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">The required node-set function was not found!</xsl:message>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<xsl:template name="collect-document-links">
		<xsl:param name="documentLinks" />

		<xsl:element name="styles-file" namespace="">
			<xsl:copy-of select="$documentLinks/styles-file/*" />
		</xsl:element>

		<xsl:element name="meta-file" namespace="">
			<xsl:copy-of select="$documentLinks/meta-file/*" />
		</xsl:element>

		<xsl:copy-of select="$documentLinks/styles-file/*/office:styles" />
		<xsl:copy-of select="$documentLinks/styles-file/*/office:font-decls" />

		<!-- office:automatic-styles may be containted in two files (i.e. content.xml and styles.xml).
			 Wild card necessary as top level element differs from flat office files ("SampleName.fsxw") -->
		<xsl:copy-of select="/*/office:automatic-styles" />

	</xsl:template>


	<xsl:template name="collect-style-properties-RTF">
		<xsl:param name="globalData" />

	   <!--** DEFAULT STYLES: First adding some office defaults unwritten in XML -->
		<xsl:variable name="defaultOfficeStyle-RTF">
			<xsl:element name="style" namespace="">
				<xsl:element name="style:properties">
				   <!-- otherwise it would be written as '* { margin:0; padding:0;}' into the CSS header' -->
					<xsl:if test="$outputType = 'CSS_INLINED'">
						<xsl:attribute name="fo:margin-left">0</xsl:attribute>
						<xsl:attribute name="fo:margin-right">0</xsl:attribute>
					</xsl:if>
				</xsl:element>
			</xsl:element>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="function-available('xalan:nodeset')">
				<xsl:call-template name="collect-properties-defaults">
					<xsl:with-param name="globalData" select="$globalData" />
					<xsl:with-param name="defaultOfficeStyle" select="xalan:nodeset($defaultOfficeStyle-RTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('xt:node-set')">
				<xsl:call-template name="collect-properties-defaults">
					<xsl:with-param name="globalData" select="$globalData" />
					<xsl:with-param name="defaultOfficeStyle" select="xt:node-set($defaultOfficeStyle-RTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('common:node-set')">
				<xsl:call-template name="collect-properties-defaults">
					<xsl:with-param name="globalData" select="$globalData" />
					<xsl:with-param name="defaultOfficeStyle" select="common:node-set($defaultOfficeStyle-RTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Function not found: 'Nodeset'</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="collect-properties-defaults">
		<xsl:param name="globalData" />
		<xsl:param name="defaultOfficeStyle" />

		<!--** DEFAULT STYLES: Adding the default styles of a style:family, by adding each office:styles/style:default-style element **-->
		<xsl:variable name="defaultFamilyStyles-RTF">
			<xsl:for-each select="$globalData/office:styles/style:default-style">
				<xsl:element name="style" namespace="">
					<xsl:copy-of select="@style:family" />
					<xsl:call-template name="create-inherited-style-properties">
						<xsl:with-param name="inheritedStyleProperties" select="$defaultOfficeStyle/style/style:properties" />
					</xsl:call-template>
				</xsl:element>
			</xsl:for-each>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="function-available('xalan:nodeset')">
				<xsl:call-template name="collect-properties">
					<xsl:with-param name="globalData" select="$globalData" />
					<xsl:with-param name="defaultOfficeStyle" select="$defaultOfficeStyle" />
					<xsl:with-param name="defaultFamilyStyles" select="xalan:nodeset($defaultFamilyStyles-RTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('xt:node-set')">
				<xsl:call-template name="collect-properties">
					<xsl:with-param name="globalData" select="$globalData" />
					<xsl:with-param name="defaultOfficeStyle" select="$defaultOfficeStyle" />
					<xsl:with-param name="defaultFamilyStyles" select="xt:node-set($defaultFamilyStyles-RTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('common:node-set')">
				<xsl:call-template name="collect-properties">
					<xsl:with-param name="globalData" select="$globalData" />
					<xsl:with-param name="defaultOfficeStyle" select="$defaultOfficeStyle" />
					<xsl:with-param name="defaultFamilyStyles" select="common:node-set($defaultFamilyStyles-RTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Function not found: nodeset</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="collect-properties">
		<xsl:param name="globalData" />
		<xsl:param name="defaultOfficeStyle" />
		<xsl:param name="defaultFamilyStyles" />

	   <!--** traversee all style trees - branch after branch - collecting style properties **-->
		<xsl:element name="all-ooo-styles" namespace="">

	   <!-- Background Information:

		   There are two different types of styles in the Office:
			   1) The office:styles from the user pre-defined style templates
			   2) The automatic:styles, which are created whenever a user uses explicit style formatting.

		   The office:styles only have parent styles in the office:styles,
		   but automatic:styles may inherit from both office:styles and themself.
		-->

		   <!--** traversee all office:styles trees beginning with the top-level styles **-->
			<xsl:for-each select="$globalData/office:styles/style:style[not(@style:parent-style-name)]">
			   <!-- Looking for parents from style:family
			   <xsl:for-each select="$globalData/office:styles/style:style[@style:family=current()/@style:family][not(@style:parent-style-name)]"> -->
				<xsl:choose>
					<xsl:when test="$defaultFamilyStyles/style[@style:family=current()/@style:family]">
						<xsl:call-template name="inherit-style-for-self-and-children">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="inheritedStyleProperties" select="$defaultFamilyStyles/style[@style:family=current()/@style:family]/style:properties" />
							<xsl:with-param name="searchOnlyInAutomaticStyles" select="false()" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="inherit-style-for-self-and-children">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="inheritedStyleProperties" select="$defaultOfficeStyle/style/style:properties" />
							<xsl:with-param name="searchOnlyInAutomaticStyles" select="false()" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			   <!--** creates a style element with style:name and style:family attribute and
					   an element representing the absolute style properties style:property  ** -->
			</xsl:for-each>

	   <!--** traversee all office:automatic-styles trees beginning with the top-level styles **-->
			<xsl:for-each select="$globalData/office:automatic-styles/style:style[not(@style:parent-style-name)]">
			   <!--** creates a style element with style:name and style:family attribute and
					   an element representing the absolute style properties style:property  ** -->
				<xsl:choose>
					<xsl:when test="$defaultFamilyStyles/style[@style:family=current()/@style:family]">
						<xsl:call-template name="inherit-style-for-self-and-children">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="inheritedStyleProperties" select="$defaultFamilyStyles/style[@style:family=current()/@style:family]/style:properties" />
							<xsl:with-param name="searchOnlyInAutomaticStyles" select="true()" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="inherit-style-for-self-and-children">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="inheritedStyleProperties" select="$defaultOfficeStyle/style/style:properties" />
							<xsl:with-param name="searchOnlyInAutomaticStyles" select="true()" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>

			</xsl:for-each>

		</xsl:element>
	   <!-- debug output in case only styles should be given out (regression test)  -->
		<xsl:if test="$onlyStyleOutputEnabled">
			<xsl:element name="defaultOfficeStyle" namespace="">
				<xsl:copy-of select="$defaultOfficeStyle" />
			</xsl:element>
			<xsl:element name="defaultFamilyStyles" namespace="">
				<xsl:copy-of select="$defaultFamilyStyles" />
			</xsl:element>
		</xsl:if>

	</xsl:template>


	<xsl:template name="inherit-style-for-self-and-children">
		<xsl:param name="globalData" />
		<xsl:param name="inheritedStyleProperties" />
		<xsl:param name="searchOnlyInAutomaticStyles" />

		   <!--** create an absolute style by inherting properties from the given parent properties **-->
		<xsl:variable name="newStyleProperties-RTF">
			<xsl:call-template name="create-inherited-style-properties">
				<xsl:with-param name="inheritedStyleProperties" select="$inheritedStyleProperties" />
			</xsl:call-template>
		</xsl:variable>

		   <!-- debug output in case only styles should be given out (regression test)
		   <xsl:if test="$onlyStyleOutputEnabled">
			   <xsl:element name="parent" namespace="">
				   <xsl:copy-of select="$inheritedStyleProperties" />
			   </xsl:element>
			   <xsl:element name="child" namespace="">
				   <xsl:copy-of select="style:properties" />
			   </xsl:element>
			   <xsl:element name="inherited" namespace="">
				   <xsl:copy-of select="$newStyleProperties-RTF" />
			   </xsl:element>
		   </xsl:if>-->

		<xsl:choose>
			<xsl:when test="function-available('xalan:nodeset')">
				<xsl:variable name="newStyleProperties" select="xalan:nodeset($newStyleProperties-RTF)" />

				<xsl:element name="style" namespace="">
					<xsl:copy-of select="@style:family" />
					<xsl:copy-of select="@style:name" />
					<xsl:copy-of select="$newStyleProperties" />
				</xsl:element>

				<xsl:choose>
					<xsl:when test="$searchOnlyInAutomaticStyles">
						<xsl:call-template name="get-children">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="searchOnlyInAutomaticStyles" select="true()" />
							<xsl:with-param name="inheritedStyleProperties" select="$newStyleProperties/style:properties" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						   <!--** for all automatic-children of the current office:styles  **-->
						<xsl:call-template name="get-children">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="searchOnlyInAutomaticStyles" select="false()" />
							<xsl:with-param name="inheritedStyleProperties" select="$newStyleProperties/style:properties" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="function-available('xt:node-set')">
				<xsl:variable name="newStyleProperties" select="xt:node-set($newStyleProperties-RTF)" />

				<xsl:element name="style" namespace="">
					<xsl:copy-of select="@style:family" />
					<xsl:copy-of select="@style:name" />
					<xsl:copy-of select="$newStyleProperties" />
				</xsl:element>

				<xsl:choose>
					<xsl:when test="$searchOnlyInAutomaticStyles">
						<xsl:call-template name="get-children">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="searchOnlyInAutomaticStyles" select="true()" />
							<xsl:with-param name="inheritedStyleProperties" select="$newStyleProperties/style:properties" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						   <!--** for all automatic-children of the current office:styles  **-->
						<xsl:call-template name="get-children">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="searchOnlyInAutomaticStyles" select="false()" />
							<xsl:with-param name="inheritedStyleProperties" select="$newStyleProperties/style:properties" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="function-available('common:node-set')">
				<xsl:variable name="newStyleProperties" select="common:node-set($newStyleProperties-RTF)" />

				<xsl:element name="style" namespace="">
					<xsl:copy-of select="@style:family" />
					<xsl:copy-of select="@style:name" />
					<xsl:copy-of select="$newStyleProperties" />
				</xsl:element>

				<xsl:choose>
					<xsl:when test="$searchOnlyInAutomaticStyles">
						<xsl:call-template name="get-children">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="searchOnlyInAutomaticStyles" select="true()" />
							<xsl:with-param name="inheritedStyleProperties" select="$newStyleProperties/style:properties" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						   <!--** for all automatic-children of the current office:styles  **-->
						<xsl:call-template name="get-children">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="searchOnlyInAutomaticStyles" select="false()" />
							<xsl:with-param name="inheritedStyleProperties" select="$newStyleProperties/style:properties" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Function not found: nodeset</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="get-children">
		<xsl:param name="globalData" />
		<xsl:param name="searchOnlyInAutomaticStyles" />
		<xsl:param name="inheritedStyleProperties" select="@style:properties" />

<!-- QUESTION: Parent style is only unique by name and family, but what about cross family inheritance? -->
	   <!-- For each child style (that is every style which has the given parentStyleName as style:parent-style-name and the same style:family -->
		<xsl:variable name="parentStyleFamily" select="@style:family" />
		<xsl:variable name="parentStyleName" select="@style:name" />
		<xsl:if test="not($searchOnlyInAutomaticStyles)">
			<xsl:for-each select="$globalData/office:styles/style:style[@style:family=$parentStyleFamily and @style:parent-style-name=$parentStyleName]">
				<xsl:call-template name="inherit-style-for-self-and-children">
					<xsl:with-param name="globalData" select="$globalData" />
					<xsl:with-param name="inheritedStyleProperties" select="$inheritedStyleProperties" />
					<xsl:with-param name="searchOnlyInAutomaticStyles" select="$searchOnlyInAutomaticStyles" />
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
		<xsl:for-each select="$globalData/office:automatic-styles/style:style[@style:family=$parentStyleFamily and @style:parent-style-name=$parentStyleName]">
			<xsl:call-template name="inherit-style-for-self-and-children">
				<xsl:with-param name="globalData" select="$globalData" />
				<xsl:with-param name="inheritedStyleProperties" select="$inheritedStyleProperties" />
				<xsl:with-param name="searchOnlyInAutomaticStyles" select="$searchOnlyInAutomaticStyles" />
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>


	<xsl:template name="create-inherited-style-properties">
		<xsl:param name="inheritedStyleProperties" />

		<xsl:element name="style:properties">

		   <!-- Writing all inherited style properties -->
			<xsl:for-each select="$inheritedStyleProperties/@*">
				<xsl:sort select="name(@*)" />
				<xsl:copy-of select="." />
			</xsl:for-each>

		   <!--All current attributes will override already inserted attributes of the same name
			   XSLT Spec: "Adding an attribute to an element replaces any existing attribute of that element with the same expanded-name." -->
			<xsl:for-each select="style:properties/@*[name() != 'style:font-size-rel']">
				<xsl:copy-of select="." />
			</xsl:for-each>

			<xsl:if test="style:properties/@style:font-size-rel">
				<xsl:variable name="fontSizeAbsolute">
					<xsl:call-template name="convert2pt">
						<xsl:with-param name="value" select="$inheritedStyleProperties/@fo:font-size" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="fontSizeRelative">
					<xsl:call-template name="convert2pt">
						<xsl:with-param name="value" select="style:properties/@style:font-size-rel" />
					</xsl:call-template>
				</xsl:variable>

				<xsl:attribute name="fo:font-size">
					<xsl:value-of select="$fontSizeAbsolute + $fontSizeRelative"/><xsl:text>pt</xsl:text>
				</xsl:attribute>
			</xsl:if>

		   <!-- inner elements are not copied (e.g. 'style:tab-stops' from the style -->
		</xsl:element>
	</xsl:template>

   <!-- debugging & testing purpose -->
	<xsl:template name="write-collected-styles">
		<xsl:param name="globalData" />

		<xsl:message>&lt;all-ooo-styles&gt;</xsl:message>
		<xsl:for-each select="$globalData/all-ooo-styles/style">
			<xsl:message>&lt;style</xsl:message>
			<xsl:message>style:family="<xsl:value-of select="current()/@style:family" />"&gt;</xsl:message>
			<xsl:message>style:name="<xsl:value-of select="current()/@style:name" />" </xsl:message>
			<xsl:message>   &lt;style:properties</xsl:message>
			<xsl:for-each select="style:properties/@*">
				<xsl:message>
					<xsl:text>       </xsl:text>
					<xsl:value-of select="name()" />="<xsl:value-of select="." />"</xsl:message>
			</xsl:for-each>
			<xsl:message>/&gt;</xsl:message>
			<xsl:message>&lt;/style&gt;</xsl:message>
		</xsl:for-each>
		<xsl:message>&lt;/all-ooo-styles&gt;</xsl:message>
	</xsl:template>



	<xsl:template name="map-ooo-style-properties">
		<xsl:param name="globalData" />

		<xsl:choose>
		   <!--+++++ DEBUG STYLE OUTPUT FOR REGRESSION TEST +++++-->
		   <!-- create styles file from the style variable (testing switch) -->
			<xsl:when test="$onlyStyleOutputEnabled">

				<xsl:element name="debug-output" namespace="">
					<xsl:copy-of select="$globalData" />
					<xsl:call-template name="map-ooo-properties">
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>
				</xsl:element>
			</xsl:when>

		   <!-- create XHTML file -->
			<xsl:otherwise>
			   <!-- to access the variable like a node-set it is necessary to convert it
					from a result-tree-fragment (RTF) to a node set using the James Clark extension -->
				<xsl:variable name="globalDataRTF">
				   <!-- raw properties still needed for table width attribute creation -->
					<xsl:copy-of select="$globalData" />
					<xsl:call-template name="map-ooo-properties">
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>
				</xsl:variable>

				<xsl:choose>
					<xsl:when test="function-available('xalan:nodeset')">
						<xsl:call-template name="start-main">
							<xsl:with-param name="globalData" select="xalan:nodeset($globalDataRTF)" />
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="function-available('xt:node-set')">
						<xsl:call-template name="start-main">
							<xsl:with-param name="globalData" select="xt:node-set($globalDataRTF)" />
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="function-available('common:node-set')">
						<xsl:call-template name="start-main">
							<xsl:with-param name="globalData" select="common:node-set($globalDataRTF)" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:message terminate="yes">ERROR: Function not found: nodeset</xsl:message>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- REASON FOR TEMPLATE:
	   The OpenOffice style properities gathered in the variable 'globalData' have to be mapped to the CSS style format
	-->
	<xsl:template name="map-ooo-properties">
		<xsl:param name="globalData" />

		<xsl:element name="all-styles" namespace="">
			<xsl:for-each select="$globalData/all-ooo-styles/style">
				<xsl:sort select="@style:family" />
				<xsl:sort select="@style:name" />
				<xsl:element name="style" namespace="">
					<xsl:copy-of select="@style:family" />
					<xsl:copy-of select="@style:name" />
					<xsl:element name="final-properties" namespace="">
						<xsl:call-template name="write-style-properties">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="style:properties" select="style:properties" />
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
	<!-- End of OOo2.0 export/common/styles/style_collector.xsl stylesheet  -->
	<!-- Start of OOo2.0 export/common/styles/style_mapping_css.xsl stylesheet  -->

	<!--+++++ CSS PROPERTIES  +++++-->
	<xsl:template name="write-style-properties">
		<xsl:param name="globalData" />
		<xsl:param name="style:properties" />

        <!-- NOTE: The OOo attribute 'style:number-wrapped-paragraphs' is not matched yet -->
		<xsl:for-each select="$style:properties/@*">
			<xsl:choose>
                <!-- *** Properties with a 'fo:' prefix *** -->
                <xsl:when test="starts-with(name(), 'fo:')">
                    <xsl:choose>
                        <xsl:when test='name()="fo:background-color"'>
                            <xsl:text>background-color:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='starts-with(name(),"fo:border")'>
                            <!-- generic type for five attributes: fo:border, fo:border-top, fo:border-bottom, fo:border-left, fo:border-right -->
                            <xsl:variable name="borderType" select="substring-after(name(), ':')" />
                            <xsl:choose>
                                <xsl:when test=". = 'none'">
                                    <xsl:value-of select="$borderType" /><xsl:text>-style:none; </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:variable name="borderWidth" select="substring-before(., ' ')" />
                                    <xsl:variable name="borderStyle" select="substring-before(substring-after(., ' '), ' ')" />
                                    <xsl:variable name="borderColor" select="substring-after(substring-after(., ' '), ' ')" />

                                    <!-- More information at template 'round-up-border-width' -->
                                    <xsl:variable name="borderWidthFixed">
                                        <xsl:call-template name="round-up-border-width">
                                            <xsl:with-param name="borderWidth" select="$borderWidth" />
                                            <xsl:with-param name="multiplier">
                                                <xsl:choose>
                                                    <xsl:when test="$borderStyle = 'double'">3</xsl:when>
                                                    <xsl:otherwise>1</xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:variable>

                                    <xsl:value-of select="$borderType" /><xsl:text>-width:</xsl:text><xsl:value-of select="$borderWidthFixed"/><xsl:text>; </xsl:text>
                                    <xsl:value-of select="$borderType" /><xsl:text>-style:</xsl:text><xsl:value-of select="$borderStyle" /><xsl:text>; </xsl:text>
                                    <xsl:value-of select="$borderType" /><xsl:text>-color:</xsl:text><xsl:value-of select="$borderColor" /><xsl:text>; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <!-- NOTE: Still there have to be placed a <br clear='all' /> to disable the flow!!!!-->
                        <xsl:when test='name()="fo:clear"'>
                            <xsl:text>clear:both; </xsl:text>
                        </xsl:when>
                        <!-- text-shadow is a CSS2 feature and yet not common used in user-agents -->
                        <xsl:when test='name() = "fo:color" or
                                        name() = "fo:font-family" or
                                        name() = "fo:font-size" or
                                        name() = "fo:font-style" or
                                        name() = "fo:font-weight" or
                                        name() = "fo:text-indent" or
                                        name() = "fo:text-shadow"'>
                            <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <!-- Maps fo:margin as well fo:margin-top, fo:margin-bottom, fo:margin-left, fo:margin-right -->
                        <!-- Maps fo:padding as well fo:padding-top, fo:padding-bottom, fo:padding-left, fo:padding-right -->
                        <xsl:when test='name() = "fo:line-height" or
                                        name() = "fo:width" or
                                        starts-with(name(), "fo:margin") or
                                        starts-with(name(), "fo:padding")'>
                            <xsl:value-of select="substring-after(name(), ':')" /><xsl:text>:</xsl:text>
                            <!-- Map OOo inch shortage 'inch' to CSS shortage 'in' -->
                            <xsl:choose>
                                <xsl:when test="contains(., 'inch')">
                                    <xsl:value-of select="substring-before(.,'ch')" />
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="." />
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='name()="fo:text-align"'>
                            <!-- 'important' is necessary as table cell value alignment is decided by runtime over the valuetype
                                 Otherwise a table cell style-class would always be outnumbered by the run-time alignment value -->
                             <xsl:choose>
                                <xsl:when test="contains(., 'start')">
                                    <xsl:text>text-align:left ! important; </xsl:text>
                                </xsl:when>
                                <xsl:when test="contains(., 'end')">
                                    <xsl:text>text-align:right ! important; </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>text-align:</xsl:text><xsl:value-of select='.' /><xsl:text> ! important; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test='name()="fo:vertical-align"'>
                            <xsl:choose>
                                <xsl:when test='contains(., "bottom")'>
                                    <xsl:text>vertical-align:bottom; </xsl:text>
                                </xsl:when>
                                <xsl:when test='contains(., "middle")'>
                                    <xsl:text>vertical-align:middle; </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>vertical-align:top; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>

                <!-- *** Properties with a 'style:' prefix *** -->
                <xsl:when test="starts-with(name(), 'style:')">
                    <xsl:choose>
                        <xsl:when test='name()="style:background-image"'>
                            <xsl:text>background-image:url(</xsl:text><xsl:value-of select="@xlink:href" /><xsl:text>); </xsl:text>
                            <xsl:choose>
                                <xsl:when test="@style:repeat = 'repeat'">
                                    <xsl:text>background-repeat:repeat; </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>background-repeat:no-repeat; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <!-- NOTE: Can 'inside' | 'from-inside' better be handled:
                            <!ATTLIST style:properties style:horizontal-pos (from-left|left|center|right|from-inside|inside|outside)#IMPLIED>-->
                        <xsl:when test='name() = "style:horizontal-pos"'>
                            <xsl:choose>
                                <xsl:when test='.="left"'>
                                    <xsl:text>text-align:left; </xsl:text>
                                </xsl:when>
                                <xsl:when test='. = "right"'>
                                    <xsl:text>text-align:right; </xsl:text>
                                </xsl:when>
                                <xsl:when test='.="center"'>
                                    <xsl:text>text-align:center; </xsl:text>
                                </xsl:when>
                                <!-- NOTE: currently other values are not used.
                                    If the property value is from-left or from-inside,
                                    the svg:x attribute associated with the frame element specifies
                                    the horizontal position of the frame.
                                    Otherwise the svg:x attribute is ignored for text documents.
                                -->
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test='name()="style:column-width"'>
                            <xsl:text>width:</xsl:text>
                            <xsl:choose>
                                <!-- changing the distance measure: inch to in -->
                                <xsl:when test="contains(., 'inch')">
                                    <xsl:value-of select="substring-before(.,'ch')" />
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="." />
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='name()="style:font-name"'>
                            <xsl:text>font-family:</xsl:text>
                            <xsl:variable name="content" select="." />
                            <xsl:value-of select="$globalData/office:font-decls/style:font-decl[@style:name=$content]/@fo:font-family" />
                            <xsl:text>; </xsl:text>
                            <xsl:if test="contains($globalData/office:font-decls/style:font-decl[@style:name=$content]/@style:font-style-name, 'Italic')">
                                <xsl:text>font-style:italic; </xsl:text>
                            </xsl:if>
                            <xsl:if test="contains($globalData/office:font-decls/style:font-decl[@style:name=$content]/@style:font-style-name, 'Bold')">
                                <xsl:text>font-weight:bold; </xsl:text>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test='name()="style:row-height"'>
                            <xsl:text>height:</xsl:text>
                            <xsl:choose>
                                <!-- changing the distance measure: inch to in -->
                                <xsl:when test="contains(., 'inch')">
                                    <xsl:value-of select="substring-before(.,'ch')" />
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="." />
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='name()="style:text-background-color"'>
                            <xsl:text>background-color:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='name()="style:text-crossing-out"'>
                            <xsl:if test='not(.="none")'>
                                <xsl:text>text-decoration:line-through; </xsl:text>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test='name()="style:text-position"'>
                            <xsl:if test='contains(., "sub")'>
                                <xsl:text>vertical-align:sub; </xsl:text>
                            </xsl:if>
                            <xsl:if test='contains(., "sup")'>
                                <xsl:text>vertical-align:sup; </xsl:text>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test='name()="style:text-underline"'>
                            <xsl:if test='not(.="none")'>
                                <xsl:text>text-decoration:underline; </xsl:text>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test='name() = "style:vertical-pos"'>
                            <xsl:choose>
                                <xsl:when test='.="from-top"'>
                                    <xsl:text>vertical-align:top; </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>vertical-align:</xsl:text><xsl:value-of select="." /><xsl:text>; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test='name()="style:width"'>
                            <xsl:text>width:</xsl:text>
                            <xsl:choose>
                                <!-- changing the distance measure: inch to in -->
                                <xsl:when test="contains(., 'inch')">
                                    <xsl:value-of select="substring-before(.,'ch')" />
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="." />
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:text>; </xsl:text>
                        </xsl:when>
                        <xsl:when test='name()="style:wrap"'>
                            <xsl:choose>
                                <xsl:when test='.="left"'>
                                    <xsl:text>float:right; </xsl:text>
                                </xsl:when>
                                <xsl:when test='.="right"'>
                                    <xsl:text>float:left; </xsl:text>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>
                <!-- *** Properties with a no 'fo:' or 'style:' prefix *** -->
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test='name() = "table:align"'>
                            <xsl:choose>
                                <xsl:when test='.="left"'>
                                <!-- Note: problems with meeting minutes example
                                    <xsl:text>float:right; </xsl:text> -->
                                </xsl:when>
                                <xsl:when test='.="right"'>
                                <!-- Note: problems with meeting minutes example
                                    <xsl:text>float:left; </xsl:text> -->
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>float:none; </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                    </xsl:choose>
                </xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<!-- Changing border width measure to cm and enlarging border-width to the Mozilla browser(1.7)
         visible minimum width
            - 0.0133cm for solid style
            - 0.0399cm for double style
         as there are three border lines painted -->
	<xsl:template name="round-up-border-width">
		<xsl:param name="borderWidth" />
        <xsl:param name="multiplier" />

		<xsl:variable name="borderWidthByCentimeter">
			<xsl:call-template name="convert2cm">
				<xsl:with-param name="value" select="$borderWidth" />
			</xsl:call-template>
		</xsl:variable>
        <xsl:variable name="minimalBorderWidth" select="0.0133 * $multiplier" />
		<xsl:choose>
			<xsl:when test="number($borderWidthByCentimeter) &lt; $minimalBorderWidth">
				<xsl:value-of select="$minimalBorderWidth" /><xsl:text>cm</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$borderWidthByCentimeter" /><xsl:text>cm</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- End of OOo2.0 export/common/styles/style_mapping_css.xsl stylesheet  -->
	<!-- Start of OOo2.0 export/common/table/table.xsl stylesheet  -->
	<xsl:param name="tableElement" select="'table'" />

	<!-- ******************* -->
	<!-- *** main table  *** -->
	<!-- ******************* -->


	<xsl:template match="table:table | table:sub-table" name="table:table">
		<xsl:param name="globalData" />

		<!-- The table will only be created if the table:scenario is active -->
		<xsl:if test="not(table:scenario) or table:scenario/@table:is-active">
			<xsl:call-template name="create-table">
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>



	<xsl:template name="create-table">
		<xsl:param name="globalData" />

		<!-- by default '1', for each new sub/inner/nested table the number counts one up -->
		<xsl:variable name="tableLevel" select="count(ancestor-or-self::table:table | ancestor-or-self::table:sub-table)" />
		<!-- collecting all visible "table:table-row" elements of the table -->
		<xsl:variable name="allVisibleTableRows" select="table:table-row[not(@table:visibility = 'collapse' or @table:visibility = 'filter')][count(ancestor-or-self::table:table | ancestor-or-self::table:sub-table) = $tableLevel] |
														 table:table-header-rows/descendant::table:table-row[not(@table:visibility = 'collapse' or @table:visibility = 'filter')][count(ancestor-or-self::table:table | ancestor-or-self::table:sub-table) = $tableLevel] |
														 table:table-row-group/descendant::table:table-row[not(@table:visibility = 'collapse' or @table:visibility = 'filter')][count(ancestor-or-self::table:table | ancestor-or-self::table:sub-table) = $tableLevel]" />
		<xsl:choose>
			<xsl:when test="$outputType = 'WML'">
			<!-- for WML devices only ASCII table are written as tables are not implemented widley.
				 Beginning from 'repeat-write-row' the templates are handled by the table_wml.xsl stylesheet -->
				<xsl:call-template name="create-column-style-variable">
					<xsl:with-param name="globalData" select="$globalData" />
					<xsl:with-param name="allVisibleTableRows" select="$allVisibleTableRows" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- As the alignment of a table is by 'align' attribut is deprecated and as the CSS 'float' attribute not well displayed,
					 we do a trick by encapsulating the table with a aligned 'div' element-->
				<xsl:variable name="table-alignment" select="$globalData/office:automatic-styles/style:style[@style:name = current()/@table:style-name]/style:properties/@table:align" />
				<xsl:choose>
					<xsl:when test="string-length($table-alignment) != 0">
						<xsl:element namespace="{$namespace}" name="div">
							<xsl:attribute name="style">
								<xsl:choose>
									<xsl:when test='$table-alignment="left" or $table-alignment="margins"'>
										<xsl:text>text-align:left</xsl:text>
									</xsl:when>
									<xsl:when test='$table-alignment="right"'>
										<xsl:text>text-align:right</xsl:text>
									</xsl:when>
									<xsl:when test='$table-alignment="center"'>
										<xsl:text>text-align:center</xsl:text>
									</xsl:when>
								</xsl:choose>
							</xsl:attribute>
							<xsl:call-template name="create-table-element">
								<xsl:with-param name="globalData" select="$globalData" />
								<xsl:with-param name="allVisibleTableRows" select="$allVisibleTableRows" />
							</xsl:call-template>
						</xsl:element>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="create-table-element">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="allVisibleTableRows" select="$allVisibleTableRows" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="create-table-element">
		<xsl:param name="globalData" />
		<xsl:param name="allVisibleTableRows" />

		<xsl:element namespace="{$namespace}" name="{$tableElement}">
			<xsl:attribute name="border">0</xsl:attribute>
			<xsl:attribute name="cellspacing">0</xsl:attribute>
			<xsl:attribute name="cellpadding">0</xsl:attribute>
			<xsl:choose>
				<xsl:when test='name()="table:table"'>
					<xsl:variable name="value" select="$globalData/all-ooo-styles/style[@style:name = current()/@table:style-name]/style:properties/@style:rel-width" />
					<xsl:if test="$value">
						<xsl:attribute name="width">
							<xsl:value-of select="$value" />
						</xsl:attribute>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="width">100%</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:choose>
				<!--+++++ SPECIAL HANDLING HTML 4.0 INLINED WAY  +++++-->
				<!-- The office default value 'border-spacing:0;' have to be added to the style -->
				<xsl:when test="$outputType = 'CSS_INLINED'">
					<xsl:attribute name="style">
						<xsl:text>border-spacing:0;  empty-cells:show; </xsl:text>
						<xsl:value-of select="$globalData/all-styles/style[@style:name = current()/@table:style-name]/final-properties" />
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="@table:style-name">
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:call-template name="create-column-style-variable">
				<xsl:with-param name="globalData" select="$globalData" />
				<xsl:with-param name="allVisibleTableRows" select="$allVisibleTableRows" />
			</xsl:call-template>
		</xsl:element>
	</xsl:template>
	<!-- End of OOo2.0 export/common/table/table.xsl stylesheet  -->
	<!-- Start of OOo2.0 export/common/table/table_cells.xsl stylesheet  -->

	<!-- *********************************** -->
	<!-- *** write repeating table cells *** -->
	<!-- *********************************** -->


	<!-- matching cells to give out -> covered table cells are not written out -->
	<xsl:template match="table:table-cell">
		<xsl:param name="globalData" />
		<!-- position of the current input cell to get the correct colum style (hidden are also counted)-->
		<xsl:param name="allTableColumns" />
		<xsl:param name="maxRowLength" />
		<xsl:param name="tableDataType" />


		<!-- The column position of the current cell has to be determined
		to get the adequate column styles during later cell creation,
		or hiding the cell when @table:visibility is not set to 'visible'.

		The position is archieved by adding up all table:number-columns-repeated of the preceding cells.
			Step1: creating '$precedingCells/quantity/@table:number-columns-repeated').
			Step2: sum(xxx:nodeset($precedingCells)/quantity) + 1        -->
		<xsl:variable name="precedingCells">
			<xsl:for-each select="preceding-sibling::*">
				<xsl:choose>
					<!-- maybe a parser is used, which reads the DTD files (e.g. Xerces),
						then '1' is the default for 'table:number-columns-repeated' -->
					<xsl:when test="not(@table:number-columns-repeated and @table:number-columns-repeated > 1)">
						<xsl:element name="quantity" namespace="">
							<xsl:text>1</xsl:text>
						</xsl:element>
					</xsl:when>
					<xsl:otherwise>
						<xsl:element name="quantity" namespace="">
							<xsl:value-of select="@table:number-columns-repeated" />
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="function-available('xt:node-set')">
				<xsl:call-template name="create-table-cell">
					<!-- position of the current input cell to get the correct colum style (hidden are also counted)-->
					<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"     select="$maxRowLength" />
					<xsl:with-param name="columnPosition"   select="sum(xt:node-set($precedingCells)/*) + 1" />
					<xsl:with-param name="globalData"       select="$globalData" />
					<xsl:with-param name="tableDataType"    select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('common:nodeset')">
				<xsl:call-template name="create-table-cell">
					<!-- position of the current input cell to get the correct colum style (hidden are also counted)-->
					<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"     select="$maxRowLength" />
					<xsl:with-param name="columnPosition"   select="sum(common:nodeset($precedingCells)/*) + 1" />
					<xsl:with-param name="globalData"       select="$globalData" />
					<xsl:with-param name="tableDataType"    select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('xalan:nodeset')">
				<xsl:call-template name="create-table-cell">
					<!-- position of the current input cell to get the correct colum style (hidden are also counted)-->
					<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"     select="$maxRowLength" />
					<xsl:with-param name="columnPosition"   select="sum(xalan:nodeset($precedingCells)/*) + 1" />
					<xsl:with-param name="globalData"       select="$globalData" />
					<xsl:with-param name="tableDataType"    select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Function not found: nodeset</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- current node is a table:table-cell -->
	<xsl:template name="create-table-cell">
		<!-- position of the current input cell to get the correct colum style (hidden are also counted)-->
		<xsl:param name="allTableColumns" />
		<xsl:param name="globalData" />
		<xsl:param name="maxRowLength" />
		<xsl:param name="columnPosition" />
		<xsl:param name="tableDataType" />

		<xsl:if test="$debugEnabled">
			<xsl:message>
				<xsl:text>
					table:table-cell #</xsl:text>
				<xsl:value-of select="$columnPosition" />
				<xsl:text> has been entered with node value: </xsl:text>
				<xsl:value-of select="." />
				<xsl:text>
					table:number-columns-repeated: </xsl:text>
				<xsl:value-of select="@table:number-columns-repeated" />
				<xsl:text>
					maxRowLength: </xsl:text>
				<xsl:value-of select="$maxRowLength" />
			</xsl:message>
		</xsl:if>

		<!-- only non hidden column will be given out -->
		<xsl:variable name="currentTableColumn" select="$allTableColumns/table:table-column[position() = $columnPosition]" />
		<xsl:if test="$currentTableColumn[not(@table:visibility = 'collapse' or @table:visibility = 'filter')]">
			<xsl:choose>
				<!-- if parser reads DTD the default is set to '1' -->
				<xsl:when test="@table:number-columns-repeated > 1">
					<!-- writes multiple entries of a cell -->
					<xsl:call-template name="repeat-write-cell">
						<xsl:with-param name="globalData"               select="$globalData" />
						<xsl:with-param name="allTableColumns"          select="$allTableColumns" />
						<xsl:with-param name="columnPosition"           select="$columnPosition" />
						<xsl:with-param name="currentTableColumn"       select="$currentTableColumn" />
						<xsl:with-param name="maxRowLength"             select="$maxRowLength" />
						<xsl:with-param name="numberColumnsRepeated"    select="@table:number-columns-repeated" />
						<xsl:with-param name="tableDataType"            select="$tableDataType" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- writes an entry of a cell -->
					<xsl:call-template name="write-cell">
						<xsl:with-param name="globalData"           select="$globalData" />
						<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
						<xsl:with-param name="columnPosition"       select="$columnPosition" />
						<xsl:with-param name="currentTableColumn"   select="$currentTableColumn" />
						<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
						<xsl:with-param name="tableDataType"        select="$tableDataType" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>


	<xsl:template name="repeat-write-cell">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />
		<xsl:param name="columnPosition" />
		<xsl:param name="currentTableColumn" />
		<xsl:param name="maxRowLength" />
		<xsl:param name="numberColumnsRepeated" />
		<xsl:param name="tableDataType" />

		<xsl:choose>
			<!-- This is the current workaround for the flood of cells, simulation background by repeating cell -->
			<xsl:when test="$numberColumnsRepeated > 1 and $maxRowLength > $columnPosition">

				<!-- writes an entry of a cell -->
				<xsl:call-template name="write-cell">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
					<xsl:with-param name="columnPosition"       select="$columnPosition" />
					<xsl:with-param name="currentTableColumn"   select="$currentTableColumn" />
					<xsl:with-param name="tableDataType"        select="$tableDataType" />
				</xsl:call-template>
				<!-- repeat calling this method until all elements written out -->
				<xsl:if test="$debugEnabled">
					<xsl:message>+++++++++ cell repetition +++++++++</xsl:message>
				</xsl:if>
				<xsl:call-template name="repeat-write-cell">
					<xsl:with-param name="globalData"               select="$globalData" />
					<xsl:with-param name="allTableColumns"          select="$allTableColumns" />
					<xsl:with-param name="columnPosition"           select="$columnPosition + 1" />
					<xsl:with-param name="currentTableColumn"       select="$allTableColumns/table:table-column[position() = ($columnPosition + 1)]" />
					<xsl:with-param name="maxRowLength"             select="$maxRowLength" />
					<xsl:with-param name="numberColumnsRepeated"    select="$numberColumnsRepeated - 1" />
					<xsl:with-param name="tableDataType"            select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- This is the current workaround for the flood of cells, simulation background by repeating cell -->
				<!--      When the maxRowLength is reached a last entry of a cell is written -->
				<xsl:call-template name="write-cell">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
					<xsl:with-param name="columnPosition"       select="$columnPosition" />
					<xsl:with-param name="currentTableColumn"   select="$currentTableColumn" />
					<xsl:with-param name="tableDataType"        select="$tableDataType" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="write-cell">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />
		<xsl:param name="columnPosition" />
		<xsl:param name="currentTableColumn" />
		<xsl:param name="tableDataType" />

		<!-- a non hidden column will be give out -->
		<xsl:choose>
			<xsl:when test="$currentTableColumn[not(@table:visibility = 'collapse' or @table:visibility = 'filter')]">
				<xsl:call-template name="create-table-cell-content">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
					<xsl:with-param name="columnPosition"       select="$columnPosition" />
					<xsl:with-param name="currentTableColumn"   select="$currentTableColumn" />
					<xsl:with-param name="tableDataType"        select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<!-- a hidden column -->
			<xsl:otherwise>
				<xsl:if test="$debugEnabled">
					<xsl:message>table column is hidden!</xsl:message>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- End of OOo2.0 export/common/table/table_cells.xsl stylesheet  -->
	<!-- Start of OOo2.0 export/common/table/table_columns.xsl stylesheet  -->

	<xsl:param name="tableColumnElement"            select="'col'" />

	<!-- ******************************************** -->
	<!-- *** Create table columns style variable  *** -->
	<!-- ******************************************** -->

	<!-- current node is a table:table or table:sub-table -->
	<xsl:template name="create-column-style-variable">
		<xsl:param name="globalData" />
		<xsl:param name="allVisibleTableRows" />

		<!-- all columns of the table -->
		<xsl:variable name="allTableColumns" select="table:table-column |
													 table:table-column-group/descendant::table:table-column |
													 table:table-header-columns/descendant::table:table-column" />
		<!-- allTableColumns: Containing all columns of the table, hidden and viewed.
			- if a column is hidden, if table:visibility has the value 'collapse' or 'filter', otherwise the value is 'visible'
			- if a column is being repeated, each repeated column is explicitly written as entry in this variable.
			  Later (during template "write-cell") the style of the column will be mixed with the cell-style by using
			  the position() of the column entry and comparing it with the iterating cell number. -->
		<xsl:variable name="allTableColumns-RTF">
			<xsl:for-each select="$allTableColumns">
				<xsl:call-template name="adding-column-styles-entries">
					<xsl:with-param name="globalData"       select="$globalData" />
					<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
				</xsl:call-template>
			</xsl:for-each>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="function-available('xt:node-set')">
				<xsl:call-template name="create-table-children">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
					<xsl:with-param name="allTableColumns"      select="xt:node-set($allTableColumns-RTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('xalan:nodeset')">
				<xsl:call-template name="create-table-children">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
					<xsl:with-param name="allTableColumns"      select="xalan:nodeset($allTableColumns-RTF)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="function-available('common:node-set')">
				<xsl:call-template name="create-table-children">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
					<xsl:with-param name="allTableColumns"      select="common:node-set($allTableColumns-RTF)" />
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>


	<!-- current node is a table:table or table:sub-table
	OVERWRITTEN by xhtml/table.xsl included in table.xsl
	<xsl:template name="create-table-children">
		<xsl:param name="globalData" />
		<xsl:param name="allVisibleTableRows" />
		<xsl:param name="allTableColumns" />


		<xsl:for-each select="$allTableColumns/table:table-column">
			<xsl:if test="not(@table:visibility = 'collapse' or @table:visibility = 'filter')">

				<xsl:call-template name="create-column-element">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>

		<xsl:call-template name="create-table-rows">
			<xsl:with-param name="globalData"           select="$globalData" />
			<xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
			<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
		</xsl:call-template>
	</xsl:template> -->

	<!-- To be OVERWRITTEN -->
	<xsl:template name="create-column-element" />

	<!-- current node is a table:table-column -->
	<xsl:template name="adding-column-styles-entries">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />

		<xsl:choose>
			<!-- if parser reads DTD the default is set to '1' -->
			<xsl:when test="not(@table:number-columns-repeated and @table:number-columns-repeated > 1)">
				<!-- writes an entry of a column in the columns-variable -->
				<xsl:copy-of select="." />
			</xsl:when>
			<!-- No higher repetition of cells greater than 99 for the last and second last column.
				 This is a workaround for some sample document (Waehrungsumrechner.sxc),
				 having 230 repeated columns in the second last column to emulate background -->
			<!-- NOTE: Testcase with a table containing table:table-column-group and/or table:table-header-columns -->
			<xsl:when test="(last() or (last() - 1)) and @table:number-columns-repeated &gt; 99">
				<!-- writes an entry of a column in the columns-variable -->
				<xsl:call-template name="repeat-adding-table-column">
					<xsl:with-param name="numberColumnsRepeated"    select="1" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- repeated colums will be written explicit several times in the variable-->
				<xsl:call-template name="repeat-adding-table-column">
					<xsl:with-param name="numberColumnsRepeated"    select="@table:number-columns-repeated" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>


	<!-- WRITES THE REPEATED COLUMN STYLE EXPLICIT AS AN ELEMENT IN THE COLUMNS-VARIABLE -->
	<!-- current node is a table:table-column -->
	<xsl:template name="repeat-adding-table-column">
		<xsl:param name="table:table-column" />
		<xsl:param name="numberColumnsRepeated" />


		<xsl:choose>
			<xsl:when test="$numberColumnsRepeated > 1">
				<!-- writes an entry of a column in the columns-variable -->
				<xsl:copy-of select="." />
				<!-- repeat calling this method until all elements written out -->
				<xsl:call-template name="repeat-adding-table-column">
					<xsl:with-param name="numberColumnsRepeated"    select="$numberColumnsRepeated - 1" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- writes an entry of a column in the columns-variable -->
				<xsl:copy-of select="." />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!--debugEnabled-START-->
	<!-- giving out the 'allColumnStyle' variable:
		For each 'table:table-column' of the 'allTableColumns' variable the style-name is given out.
		In case of 'column-hidden-flag' attribute the text 'Column is hidden is given out.-->
	<!-- current node is a table:table or table:sub-table -->
	<xsl:template name="table-debug-allTableColumns">
		<xsl:param name="allTableColumns" />

		<!-- debug output as table summary attribut in html -->
		<xsl:attribute name="summary">
			<xsl:call-template name="table-debug-column-out">
				<xsl:with-param name="allTableColumns" select="$allTableColumns" />
			</xsl:call-template>
		</xsl:attribute>
		<!-- debug output to console -->
		<xsl:message>
			<xsl:call-template name="table-debug-column-out">
				<xsl:with-param name="allTableColumns" select="$allTableColumns" />
			</xsl:call-template>
		</xsl:message>
	</xsl:template>

	<!-- current node is a table:table or table:sub-table -->
	<xsl:template name="table-debug-column-out">
		<xsl:param name="allTableColumns" />
			<xsl:text>
			DebugInformation: For each 'table:table-column' of the 'allTableColumns' variable the style-name is given out.
							  In case of table:visibility attribute unequal 'visible' the 'column is hidden' no text is given out.
			</xsl:text>
				<xsl:for-each select="$allTableColumns/table:table-column">
				<xsl:choose>
				<xsl:when test="@table:visibility = 'collapse' or @table:visibility = 'filter' ">
			<xsl:text>  </xsl:text><xsl:value-of select="@table:style-name" /><xsl:text>column is hidden</xsl:text><xsl:text>
			</xsl:text>
				</xsl:when>
				<xsl:otherwise>
			<xsl:text>  </xsl:text><xsl:value-of select="@table:style-name" /><xsl:text> </xsl:text><xsl:value-of select="@table:default-cell-style-name" /><xsl:text>
			</xsl:text>
				</xsl:otherwise>
				</xsl:choose>
						   </xsl:for-each>
	</xsl:template>
	<!--debugEnabled-END-->
	<!-- End of OOo2.0 export/common/table/table_columns.xsl stylesheet  -->
	<!-- Start of OOo2.0 export/common/table/table_rows.xsl stylesheet  -->

	<xsl:param name="rowElement" select="'tr'" />

	<!-- ********************************** -->
	<!-- *** write repeating table rows *** -->
	<!-- ********************************** -->

	<!-- current node is a table:table or table:sub-table -->
	<xsl:template name="create-table-rows">
		<xsl:param name="globalData" />
		<xsl:param name="allVisibleTableRows" />
		<xsl:param name="allTableColumns" />

		<!-- Some Office Calc documents simulate a background by repeating one of the later cells until end of used space
			 (The value of "table:number-columns-repeated" is enourmous). Writing out all these cells would be fatal in time
			 and output size. Therefore, this global variable shows us the longest row with content. -->
		<xsl:variable name="maxRowLength" select="count($allTableColumns/table:table-column)" />
		<xsl:if test="$debugEnabled">
			<xsl:message>maxRowLength: <xsl:value-of select="$maxRowLength" /></xsl:message>
			<xsl:call-template name="table-debug-allTableColumns">
				<xsl:with-param name="allTableColumns" select="$allTableColumns" />
			</xsl:call-template>
		</xsl:if>

		<!-- a table is a table header, when it has a "table:table-header-rows" ancestor -->
		<xsl:variable name="tableDataType">
			<xsl:choose>
				<xsl:when test="ancestor::table:table-header-rows">
					<xsl:text>th</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>td</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$outputType = 'WML'">
				<xsl:for-each select="$allVisibleTableRows">
					<xsl:call-template name="wml-repeat-write-row">
						<xsl:with-param name="globalData"           select="$globalData" />
						<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
						<xsl:with-param name="numberRowsRepeated"   select="@table:number-rows-repeated" />
						<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<!-- removes repetition of rows, most probably done for background emulating -->
				<xsl:for-each select="$allVisibleTableRows">
					<xsl:choose>
						<xsl:when test="(last() or (last() - 1)) and @table:number-rows-repeated &gt; 99">
							<xsl:call-template name="repeat-write-row">
								<xsl:with-param name="globalData"           select="$globalData" />
								<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
								<xsl:with-param name="numberRowsRepeated"   select="1" />
								<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
								<xsl:with-param name="tableDataType"        select="$tableDataType" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="repeat-write-row">
								<xsl:with-param name="globalData"           select="$globalData" />
								<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
								<xsl:with-param name="numberRowsRepeated"   select="@table:number-rows-repeated" />
								<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
								<xsl:with-param name="tableDataType"        select="$tableDataType" />
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="repeat-write-row">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />
		<xsl:param name="numberRowsRepeated" select="1" />
		<xsl:param name="maxRowLength" />
		<xsl:param name="tableDataType" />

		<xsl:choose>
			<!-- write an entry of a row and repeat calling this method until all elements are written out -->
			<xsl:when test="$numberRowsRepeated > 1 and table:table-cell">
				<xsl:call-template name="write-row">
					<xsl:with-param name="globalData"       select="$globalData" />
					<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"     select="$maxRowLength" />
					<xsl:with-param name="tableDataType"    select="$tableDataType" />
				</xsl:call-template>

				<!-- NOTE: take variable from the output of repeated write-row and iterate giving out the variable -->
				<xsl:call-template name="repeat-write-row">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
					<xsl:with-param name="numberRowsRepeated"   select="$numberRowsRepeated - 1" />
					<xsl:with-param name="tableDataType"        select="$tableDataType" />
				</xsl:call-template>
			</xsl:when>
			<!-- write a single entry of a row -->
			<xsl:otherwise>
				<xsl:call-template name="write-row">
					<xsl:with-param name="globalData"           select="$globalData" />
					<xsl:with-param name="allTableColumns"      select="$allTableColumns" />
					<xsl:with-param name="maxRowLength"         select="$maxRowLength" />
					<xsl:with-param name="tableDataType"        select="$tableDataType" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="add-table-row-attributes">
		<xsl:param name="globalData" />

		<!-- writing the style of the row -->
		<xsl:if test="@table:style-name">
			<xsl:call-template name='add-style-properties'>
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="write-row">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />
		<xsl:param name="maxRowLength" />
		<xsl:param name="tableDataType" />


		<xsl:element namespace="{$namespace}" name="{$rowElement}">
			<xsl:call-template name='add-table-row-attributes'>
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>

			<xsl:if test="$debugEnabled">
				<xsl:message>'tr' element has been added!</xsl:message>
			</xsl:if>

			<xsl:apply-templates select="table:table-cell">
				<xsl:with-param name="globalData"       select="$globalData" />
				<xsl:with-param name="allTableColumns"  select="$allTableColumns" />
				<xsl:with-param name="maxRowLength"     select="$maxRowLength" />
				<xsl:with-param name="tableDataType"    select="$tableDataType" />
			</xsl:apply-templates>

		</xsl:element>
	</xsl:template>


	<!-- **************************** -->
	<!-- *** HELPER: table styles *** -->
	<!-- **************************** -->

	<xsl:template name="add-style-properties">
		<xsl:param name="globalData" />
		<xsl:param name="allTableColumns" />
		<xsl:param name="node-position" />

		<xsl:choose>
			<!--+++++ CSS (CASCADING STYLE SHEET) HEADER STYLE WAY +++++-->
			<xsl:when test="$outputType = 'CSS_HEADER'">
				<xsl:attribute name="class">
					<xsl:value-of select="translate(@table:style-name, '. %()/\+', '')" />
				</xsl:attribute>
			</xsl:when>

			<!--+++++ HTML 4.0 INLINED WAY  +++++-->
			<xsl:when test="$outputType = 'CSS_INLINED'">
				<xsl:attribute name="style">
					<xsl:value-of select="$globalData/all-styles/style[@style:name = current()/@table:style-name]/final-properties" />
				</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- default template to be overwritten -->
	<xsl:template name="wml-repeat-write-row" />
	<!-- End of OOo2.0 export/common/table/table_rows.xsl stylesheet  -->
	<!-- Start of OOo2.0 export/common/table_of_content.xsl stylesheet  -->

    <!-- ****************************** -->
    <!-- ***    Table of Content    *** -->
    <!-- ****************************** -->


    <xsl:template match="text:table-of-content">
        <xsl:param name="globalData" />

        <xsl:apply-templates>
            <xsl:with-param name="globalData" select="$globalData" />
        </xsl:apply-templates>
    </xsl:template>


    <xsl:template match="text:index-body">
        <xsl:param name="globalData" />

        <xsl:choose>
            <xsl:when test="$javaEnabled">
                <xsl:apply-templates mode="content-table">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates>
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template match="text:index-title" mode="content-table">
        <xsl:param name="globalData" />

        <xsl:apply-templates>
            <xsl:with-param name="globalData" select="$globalData" />
        </xsl:apply-templates>
    </xsl:template>


    <!-- ************************************************ -->
    <!-- *** Create Table for Content Table Paragraph *** -->
    <!-- ************************************************ -->

    <!-- Usually the paragraph in a content-table are ordered by tab-stops, which can not be displayed correctly by XHTML/CSS
     Therefore they will be simulated by a table -->
    <xsl:template match="text:p" mode="content-table">
        <xsl:param name="globalData" />
        <xsl:variable name="allTabStopStyles-RTF">
            <xsl:call-template name="get-tab-stops">
                <xsl:with-param name="globalData" select="$globalData" />
                <xsl:with-param name="styleName" select="current()/@text:style-name" />
            </xsl:call-template>
        </xsl:variable>

        <xsl:element namespace="{$namespace}" name="table">
            <xsl:attribute name="border">0</xsl:attribute>
            <xsl:attribute name="cellspacing">0</xsl:attribute>
            <xsl:attribute name="cellpadding">0</xsl:attribute>
            <xsl:variable name="value" select="$globalData/all-ooo-styles/style[@style:name = current()/@table:style-name]/style:properties/@style:rel-width" />
            <xsl:if test="$value">
                <xsl:attribute name="width">
                    <xsl:value-of select="$value" />
                </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="class">
                <xsl:value-of select="translate(@text:style-name, '. %()/\+', '')" />
            </xsl:attribute>

            <xsl:element namespace="{$namespace}" name="colgroup">
                <xsl:choose>
                    <xsl:when test="function-available('xt:node-set')">
                        <xsl:call-template name="create-col-element">
                            <xsl:with-param name="lastNodePosition" select="count(xt:node-set($allTabStopStyles-RTF)/style:tab-stops/style:tab-stop)" />
                            <xsl:with-param name="allTabStopStyles" select="xt:node-set($allTabStopStyles-RTF)" />
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="function-available('xalan:nodeset')">
                        <xsl:call-template name="create-col-element">
                            <xsl:with-param name="lastNodePosition" select="count(xalan:nodeset($allTabStopStyles-RTF)/style:tab-stops/style:tab-stop)" />
                            <xsl:with-param name="allTabStopStyles" select="xalan:nodeset($allTabStopStyles-RTF)" />
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="function-available('common:node-set')">
                        <xsl:call-template name="create-col-element">
                            <xsl:with-param name="lastNodePosition" select="count(common:node-set($allTabStopStyles-RTF)/style:tab-stops/style:tab-stop)" />
                            <xsl:with-param name="allTabStopStyles" select="common:node-set($allTabStopStyles-RTF)" />
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:message terminate="yes">ERROR: Function not found: nodeset</xsl:message>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>

            <!-- all elements before the first tabStop -->
            <xsl:variable name="testNo-RTF">
                <xsl:apply-templates select="node()" mode="cell-content" />
            </xsl:variable>

            <xsl:choose>
                <xsl:when test="function-available('xt:node-set')">
                    <xsl:variable name="tabNodePositions" select="xt:node-set($testNo-RTF)" />
                    <xsl:element namespace="{$namespace}" name="tr">
                        <xsl:call-template name="create-td-elements">
                            <xsl:with-param name="lastNodePosition" select="count(xt:node-set($allTabStopStyles-RTF)/style:tab-stops/style:tab-stop)" />
                            <xsl:with-param name="position" select="1" />
                            <xsl:with-param name="allTabStopStyles" select="xt:node-set($allTabStopStyles-RTF)" />
                            <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                            <xsl:with-param name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <xsl:when test="function-available('xalan:nodeset')">
                    <xsl:variable name="tabNodePositions" select="xalan:nodeset($testNo-RTF)" />
                    <xsl:element namespace="{$namespace}" name="tr">
                        <xsl:call-template name="create-td-elements">
                            <xsl:with-param name="lastNodePosition" select="count(xalan:nodeset($allTabStopStyles-RTF)/style:tab-stops/style:tab-stop)" />
                            <xsl:with-param name="position" select="1" />
                            <xsl:with-param name="allTabStopStyles" select="xalan:nodeset($allTabStopStyles-RTF)" />
                            <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                            <xsl:with-param name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <xsl:when test="function-available('common:node-set')">
                    <xsl:variable name="tabNodePositions" select="common:node-set($testNo-RTF)" />
                    <xsl:element namespace="{$namespace}" name="tr">
                        <xsl:call-template name="create-td-elements">
                            <xsl:with-param name="lastNodePosition" select="count(common:node-set($allTabStopStyles-RTF)/style:tab-stops/style:tab-stop)" />
                            <xsl:with-param name="position" select="1" />
                            <xsl:with-param name="allTabStopStyles" select="common:node-set($allTabStopStyles-RTF)" />
                            <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                            <xsl:with-param name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:message terminate="yes">ERROR: Function not found: nodeset</xsl:message>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <!-- Gathering all tab-stops from a style-hierarchy -->
    <xsl:template name="get-tab-stops">
        <xsl:param name="globalData" />
        <xsl:param name="styleName" />
        <xsl:variable name="tabStyle" select="/*/office:automatic-styles/style:style[@style:name = $styleName]" />

        <xsl:if test="$tabStyle/style:properties/style:tab-stops">
            <xsl:copy-of select="$tabStyle/style:properties/style:tab-stops" />
        </xsl:if>

        <xsl:if test="$tabStyle/@style:parent-style-name">
            <xsl:call-template name="get-tab-stops">
                <xsl:with-param name="globalData" select="$globalData" />
                <xsl:with-param name="styleName" select="$tabStyle/@style:parent-style-name" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="create-col-element">
        <xsl:param name="lastNodePosition" />
        <xsl:param name="allTabStopStyles" />

        <xsl:for-each select="$allTabStopStyles/style:tab-stops/style:tab-stop">
            <xsl:element namespace="{$namespace}" name="col">
                <xsl:attribute name="style">
                    <xsl:text>width: </xsl:text>
                    <xsl:choose>
                        <xsl:when test="contains(@style:position, 'cm')">
                            <xsl:call-template name="create-cell-width">
                                <xsl:with-param name="width" select="number(substring-before(@style:position,'cm'))" />
                                <xsl:with-param name="unit" select="'cm'" />
                                <xsl:with-param name="position" select="position() - 1" />
                                <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="contains(@style:position, 'in')">
                            <xsl:call-template name="create-cell-width">
                                <xsl:with-param name="width" select="number(substring-before(@style:position,'in'))" />
                                <xsl:with-param name="unit" select="'in'" />
                                <xsl:with-param name="position" select="position() - 1" />
                                <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="contains(@style:position, 'ch')">
                            <xsl:call-template name="create-cell-width">
                                <xsl:with-param name="width" select="number(substring-before(@style:position,'ch'))" />
                                <xsl:with-param name="unit" select="'ch'" />
                                <xsl:with-param name="position" select="position() - 1" />
                                <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="contains(@style:position, 'pt')">
                            <xsl:call-template name="create-cell-width">
                                <xsl:with-param name="width" select="number(substring-before(@style:position,'pt'))" />
                                <xsl:with-param name="unit" select="'pt'" />
                                <xsl:with-param name="position" select="position() - 1" />
                                <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                            </xsl:call-template>
                        </xsl:when>
                    </xsl:choose>

                </xsl:attribute>
            </xsl:element>
        </xsl:for-each>

    </xsl:template>
<!--
Scenarios tabstops

1) style:type of style:tab-stop is 'right' and earlier tabStop is not right
 -> Earlier text-nodes and following text-nodes, will be put into an inner table, with two TD first aligned left, with proceding textnodes, the latter aligned right.

2) style:type is 'right' and earlier tabStop is right
 -> following text-nodes, will be put into a right aligned TD

3) style:type is 'non-right' and earlier tabStop 'non-right' as well
 -> put the preceding tab stops into a TD (left aligned is default)

4) first style:type would have no right preceding tabStop
 -> works well with first sceanrios 1 and 3

5) last style:type would be a special case, if it would be left aligned, but this won't happen in our case.. :D

Scenarios unmatched:
- text:styleposition 'center' will not be matched in our case (effort for nothing), there will be only 'right' and not 'right'
- If the last tabStop is not from text:stylepostion 'right', the length of the last cell is undefined and a document length must be found.
  Not happens in our master document case. Also the algorithm below would have to be expanded (cp. scenario 5).

-->
    <xsl:template name="create-td-elements">
        <xsl:param name="globalData" />
        <xsl:param name="lastNodePosition" />
        <xsl:param name="position" />
        <xsl:param name="allTabStopStyles" />
        <xsl:param name="tabNodePositions" />

        <xsl:variable name="currentTabStop" select="$allTabStopStyles/style:tab-stops/style:tab-stop[$position]" />
        <xsl:variable name="earlierTabStop" select="$allTabStopStyles/style:tab-stops/style:tab-stop[$position - 1]" />

        <xsl:choose>
            <xsl:when test="not($currentTabStop/@style:position) and not($earlierTabStop/@style:position)">
                <!-- in case no TAB STOP is being set -->
                <xsl:element namespace="{$namespace}" name="td">
                    <xsl:apply-templates mode="content-table">
                        <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$currentTabStop/@style:type = 'right'">
                        <xsl:choose>
                            <xsl:when test="$earlierTabStop/@style:type = 'right'">
                                <!--
                                2) style:type is 'right' and earlier tabStop is right
                                    -> following text-nodes, will be put into a right aligned TD -->
                                <xsl:element namespace="{$namespace}" name="td">
                                    <xsl:attribute name="style">
                                        <xsl:text>align: right</xsl:text>
                                    </xsl:attribute>
                                    <xsl:call-template name="grap-cell-content-before-tab-stop">
                                        <xsl:with-param name="globalData" select="$globalData" />
                                        <xsl:with-param name="endingTabStopPosition" select="$position + 1" />
                                        <xsl:with-param name="lastNodePosition" select="$lastNodePosition" />
                                        <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                                    </xsl:call-template>
                                </xsl:element>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:element namespace="{$namespace}" name="td">
                                    <xsl:call-template name="grap-cell-content-before-tab-stop">
                                        <xsl:with-param name="globalData" select="$globalData" />
                                        <xsl:with-param name="endingTabStopPosition" select="$position" />
                                        <xsl:with-param name="lastNodePosition" select="$lastNodePosition" />
                                        <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                                    </xsl:call-template>
                                </xsl:element>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="$earlierTabStop/@style:type = 'right'">
                            </xsl:when>
                            <xsl:otherwise>
                            <!--
                               3) style:type is 'non-right' and earlier tabStop 'non-right' as well
                                    -> put the preceding tab stops into a TD (left aligned is default) -->
                                <xsl:element namespace="{$namespace}" name="td">
                                    <xsl:call-template name="grap-cell-content-before-tab-stop">
                                        <xsl:with-param name="globalData" select="$globalData" />
                                        <xsl:with-param name="endingTabStopPosition" select="$position" />
                                        <xsl:with-param name="lastNodePosition" select="$lastNodePosition" />
                                        <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                                    </xsl:call-template>
                                </xsl:element>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>

                <xsl:if test="$position != $lastNodePosition">
                    <xsl:call-template name="create-td-elements">
                        <xsl:with-param name="globalData" select="$globalData" />
                        <xsl:with-param name="lastNodePosition" select="$lastNodePosition" />
                        <xsl:with-param name="position" select="$position + 1" />
                        <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                        <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                    </xsl:call-template>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template name="grap-cell-content-before-tab-stop">
        <xsl:param name="globalData" />
        <xsl:param name="endingTabStopPosition" />
        <xsl:param name="tabNodePositions" />
        <xsl:param name="lastNodePosition" />

        <xsl:choose>
            <xsl:when test="$endingTabStopPosition = 1">
                <xsl:apply-templates mode="content-table" select="node()[position() &lt; $tabNodePositions/tab-stop-node-position[$endingTabStopPosition]]">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="$endingTabStopPosition > $lastNodePosition">
                <xsl:apply-templates mode="content-table" select="node()[position() > $tabNodePositions/tab-stop-node-position[$endingTabStopPosition - 1]]">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates mode="content-table" select="node()[position() &lt; $tabNodePositions/tab-stop-node-position[$endingTabStopPosition]][position() > $tabNodePositions/tab-stop-node-position[$endingTabStopPosition - 1]]">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- As the span width will be mapped to column width, the preceding span widths have to be substracted -->
    <xsl:template name="create-cell-width">
        <xsl:param name="width" />
        <xsl:param name="unit" />
        <xsl:param name="position" />
        <xsl:param name="allTabStopStyles" />

        <xsl:choose>
            <!-- beyond second width -->
            <xsl:when test="$position > 1">
                <xsl:call-template name="create-cell-width">
                    <xsl:with-param name="width" select="$width - number(substring-before($allTabStopStyles/style:tab-stops/style:tab-stop[$position]/@style:position,$unit))" />
                    <xsl:with-param name="unit" select="$unit" />
                    <xsl:with-param name="position" select="$position - 1" />
                    <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                </xsl:call-template>
            </xsl:when>
            <!-- second width -->
            <xsl:when test="$position = 1">
                <xsl:value-of select="concat($width - number(substring-before($allTabStopStyles/style:tab-stops/style:tab-stop[$position]/@style:position,$unit)), $unit)" />
            </xsl:when>
            <!-- first width -->
            <xsl:otherwise>
                <xsl:value-of select="concat($width, $unit)" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <!-- ************************************** -->
    <!--    CREATION OF A CONTENT TABLE LINK    -->
    <!-- ************************************** -->


     <!-- content table link  -->
    <xsl:template match="text:a" mode="content-table">
        <xsl:param name="globalData" />

        <!-- For anchors in content-headers a bug exists (cp. bug id# 102311) and they have to be worked out separately.
            Currently the link used in the content-table of an Office XML (e.g. in the content table as '#7.Some%20Example%20Headline%7Outline')
            is not a valid URL (cp. bug id# 102311). No file destination is specified nor exist any anchor element for these
            links in the Office XML, nor is the chapter no. known in the linked files.
            A workaround for this transformation therefore had to be made. This time-consuming mechanism is disabled by default and
            can be activated by a parameter (i.e. 'parseChildDocuments'). A creation of an anchor is made for each header element.
            All header titles gonna be encoding to be usable in a relative URL. -->
        <xsl:choose>
            <xsl:when test="$javaEnabled and $masterDocumentEnabled">
                <xsl:call-template name="create-content-table-link">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="create-common-anchor-link">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <!-- a special behavior of text:a
        (called from the 'text:a' template) -->

    <xsl:template name="create-content-table-link">
        <xsl:param name="globalData" />

        <xsl:element namespace="{$namespace}" name="a">
            <xsl:attribute name="href">
                <xsl:choose>
                    <xsl:when test="starts-with(@xlink:href, '#')">
                        <xsl:variable name="correctHeading" select="$globalData/content-table-headings/heading[current()/@xlink:href = @content-table-id]" />
                        <xsl:call-template name="get-relative-child-u-r-l">
                            <xsl:with-param name="toChildFileRef" select="$correctHeading/@out-file-url" />
                        </xsl:call-template>
                        <xsl:text>#</xsl:text>
                        <xsl:value-of select="$correctHeading/@absolute-chapter-level" />
                        <xsl:text>_</xsl:text>
                        <xsl:value-of select="$correctHeading/@encoded-title" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="create-common-anchor-link">
                            <xsl:with-param name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>

            <xsl:call-template name="apply-styles-and-content">
                <xsl:with-param name="globalData" select="$globalData" />
            </xsl:call-template>
        </xsl:element>
    </xsl:template>


    <xsl:template match="text:s" mode="content-table">
        <xsl:call-template name="write-breakable-whitespace">
            <xsl:with-param name="whitespaces" select="@text:c" />
        </xsl:call-template>
    </xsl:template>



    <!-- ***************************************************************** -->
    <!-- *** Extern of ToC - Creating an Anchor Name for every heading *** -->
    <!-- ***************************************************************** -->

    <!-- necessary as anchor for the content table -->
    <xsl:template name="create-content-table-anchor">
        <xsl:param name="globalData" />

        <!--
        Currently the link used in the Office XML (e.g. in the content table as '#7.Some%20Example%20Headline%7Outline')
        is not a valid URL (cp. bug id# 102311). No file destination is specified nor exist any anchor element for these
        links in the Office XML.
        Here we are creating an anchor with the space normalized text of this header as potential jump address of the content table -->
        <xsl:choose>
            <xsl:when test="$currentChildContentRef">
                <!-- NOTE: Have to be removed (here a Java-Helper is necessary)  -->
                <xsl:variable name="currentFileHeadingNo">
                    <xsl:call-template name="get-next-current-file-heading-no">
                        <xsl:with-param name="file" select="$currentChildContentRef" />
                    </xsl:call-template>
                </xsl:variable>

                <xsl:variable name="testResult" select="$contentTableHeadings/heading[$currentChildContentRef = @file-url][number($currentFileHeadingNo)]" />
                <xsl:if test="$debugEnabled">
                    <xsl:message>Matching child document header No. <xsl:value-of select="$currentFileHeadingNo" />
                    </xsl:message>
                    <xsl:message>absolute-chapter-level:         <xsl:value-of select="$testResult/@absolute-chapter-level" />
                    </xsl:message>
                    <xsl:message>encodedTitle:                   <xsl:value-of select="$testResult/@encoded-title" />
                    </xsl:message>
                    <xsl:message>currentChildContentRef: <xsl:value-of select="$currentChildContentRef" />
                    </xsl:message>
                    <xsl:message>*** </xsl:message>
                </xsl:if>
                <xsl:element namespace="{$namespace}" name="a">
                    <xsl:attribute name="name">
                        <xsl:value-of select="$testResult/@absolute-chapter-level" />
                        <xsl:text>_</xsl:text>
                        <xsl:value-of select="$testResult/@encoded-title" />
                    </xsl:attribute>
                </xsl:element>
            </xsl:when>

            <xsl:otherwise>
                <!-- When the chapter is in the master document itself the link has to be relative (e.g. #index) a absolute href does not
                    work with the browser. In case of chapter in the master document, the output URL of the master document was taken. -->
                <xsl:variable name="currentFileHeadingNo">
                    <xsl:call-template name="get-next-current-file-heading-no">
                        <xsl:with-param name="file" select="$contentTableURL" />
                    </xsl:call-template>
                </xsl:variable>
                <xsl:variable name="testResult" select="$globalData/content-table-headings/heading[$contentTableURL = @file-url][number($currentFileHeadingNo)]" />

                <xsl:if test="$debugEnabled">
                    <xsl:message>Matching master document header No. <xsl:value-of select="$currentFileHeadingNo" />
                    </xsl:message>
                    <xsl:message>absolute-chapter-level:  <xsl:value-of select="$testResult/@absolute-chapter-level" />
                    </xsl:message>
                    <xsl:message>encodedTitle:            <xsl:value-of select="$testResult/@encoded-title" />
                    </xsl:message>
                    <xsl:message>contentTableURL:         <xsl:value-of select="$contentTableURL" />
                    </xsl:message>
                    <xsl:message>*** </xsl:message>
                </xsl:if>

                <xsl:element namespace="{$namespace}" name="a">
                    <xsl:attribute name="name">
                        <xsl:value-of select="$testResult/@absolute-chapter-level" />
                        <xsl:text>_</xsl:text>
                        <xsl:value-of select="$testResult/@encoded-title" />
                    </xsl:attribute>
                </xsl:element>

            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="get-relative-child-u-r-l">
        <xsl:param name="toChildFileRef" />

        <xsl:choose>
            <xsl:when test="function-available('sxg:get-relative-child-u-r-l')">
                <xsl:value-of select="sxg:get-relative-child-u-r-l(string($toChildFileRef))" />
            </xsl:when>
            <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getRelativeChildURL')">
                <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.getRelativeChildURL(string($toChildFileRef))" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getRelativeChildURL</xsl:message>
            </xsl:otherwise>
       </xsl:choose>
    </xsl:template>


    <!-- ******************** -->
    <!-- *** Common Rules *** -->
    <!-- ******************** -->

    <!-- deactivating default template -->
    <xsl:template match="*" mode="content-table" />

    <xsl:template match="*" mode="cell-content">
        <xsl:if test="name() = 'text:tab-stop' or *[name() = 'text:tab-stop']">
            <xsl:element name="tab-stop-node-position" namespace="">
                <xsl:value-of select="position()" />
            </xsl:element>
        </xsl:if>
    </xsl:template>
	<!-- End of OOo2.0 export/common/table_of_content.xsl stylesheet  -->

</xsl:stylesheet>
