'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_106_.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: pj $ $Date: 2005/11/28 14:24:38 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Detailed test of Calc features in menu Tools
'*
'************************************************************************
'*
' #1 C_106_ ' Initial routine
' #1 tToolsSpellCheck
' #1 tToolsSpellCheckAutomatic
' #1 tToolsThesaurus
' #1 tToolsAutocorrection
' #1 tToolsGoalSeek
' #1 tToolsScenarios
' #1 tToolsProtectSheet
' #1 tToolsAutomaticCalculate
' #1 tToolsRecalculate
' #1 tToolsAutoInput
' #0 tToolsConfigure
'*
'\***********************************************************************

sub C_106_
Printlog "--------- C_106_ ---------"

   qaErrorLog "SKIPPING tToolsSpellCheck due to redesign"
 '  Call tToolsSpellCheck
 '  Call tToolsSpellCheckAutomatic
   Call tToolsThesaurus
   Call tToolsAutocorrection
   Call tToolsGoalSeek
   Call tToolsScenarios
   Call tToolsProtectSheet
   Call tToolsAutomaticCalculate
   Call tToolsRecalculate
   Call tToolsAutoInput
'OBSOLETE   Call tToolsConfigure

end sub
'
'-----------------------------------------------------
'
testcase tToolsSpellCheck
'/// This testcase test the spellcheck by inserting the Word 'Teeest' ///
'/// The spellcheck should detect this word. ///


    select case iSprache
        case = 55 : QAErrorLog "Brasilian version not complete yet" : goto endsub
        case >80: QAErrorLog "There is no spellchecker for asian languages available"
                  goto endsub
    end select

    Call hNewDocument
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "Teeest<return><up>"
    ToolsSpellcheckCheckCalc
    Sleep 1
    Kontext "Rechtschreibung"
    if Rechtschreibung.exists(2) then
       printlog "Spellcheck dialog was invoked."
    else
       warnlog "Spellcheck dialog didn't came up."
       Kontext
       If active.exists(2) then active.OK
       Kontext
       If active.exists(2) then active.OK
       goto endsub
    endif
    
    Kontext "Rechtschreibung"
    If Wort.GetText <> "" then
        printlog "OK, There is an suggestion for the wrong word"
    else
        warnlog "There is no suggestion for this word"
    end if
    Rechtschreibung.close
    Call hCloseDocument

endcase
'
'-----------------------------------------------------
'
testcase tToolsSpellCheckAutomatic
'/// At first the automatic spellcheck must be switched on. Then the word
'/// 'Teeest' or 'polsski' (for the polish version) is inserted into
'/// a cell. In the options dialog it is checked, if the automatic spellcheck
'/// is activated. If it is, it will be deactivated. Then the automatic spellcheck
'/// is activated again with the button in the toolbar and it is checked, if in the
'/// opened contextmenu are suggestions for the inserted word in the cell.
'/// At the end it is checked if the activated automatic spellcheck is detected
'/// in the options dialog ("LANGUAGESETTINGS", "WRITINGAIDS").

        dim nID as integer

    Call hNewDocument

        select case iSprache
        case 55 : QAErrorLog "Brasilian version not complete yet" : goto endsub
        case >80: QAErrorLog "There is no spellchecker for asian languages available"
                          goto out
        case else : DocumentCalc.TypeKeys "Teeest<RETURN><UP><F2><MOD1 SHIFT LEFT>"
    end select

    ToolsOptions
        hToolsOptions ("LANGUAGESETTINGS", "WRITINGAIDS")
        Kontext "Optionen"
        Optionen.TypeKeys "<PAGEUP>", 4
        Optionen.TypeKeys "<DOWN>", 5
    if Optionen.IsChecked then
        Optionen.UnCheck
    end if
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Ok

        Kontext "DocumentCalc"

        ToolsSpellcheckAutoSpellcheck

        ' Now the function must check with the contexmenu
        Kontext "DocumentCalc"
        DocumentCalc.MouseDown 2,2
        DocumentCalc.MouseUp 2,2
        DocumentCalc.OpenContextMenu
                nid = MenuGetItemID (1)
                printlog "ContextMenuItemText: " & MenuGetItemText(nID)
            if left(MenuGetItemText(nID), 2) = "Te" then
                printlog "It seems that the autocorrection works"
            else
                warnlog "It seems that the autocorrection doesn't work"
            end if
        call hMenuClose

    ToolsOptions
        Kontext "ExtrasOptionenDlg"
    hToolsOptions ("LANGUAGESETTINGS", "WRITINGAIDS")
    Kontext "Optionen"
        Optionen.TypeKeys "<PAGEUP>", 4
        Optionen.TypeKeys "<DOWN>", 5
    if Optionen.IsChecked then
        printlog "OK, AutoCheck is activated"
        Optionen.UnCheck
    else
        warnlog "AutoCheck not activated"
    end if
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Ok
out:
    Call hCloseDocument

endcase
'
'-----------------------------------------------------
'
testcase tToolsThesaurus
'/// This test checks, if there appears any suggestion for an inserted word in a document.

    dim merksdir$,merksdir2$

    Call hNewDocument

    select case iSprache
        case 01   : merksdir$ = "example"
        case 03   : merksdir$ = "controlo"
        case 07   : QAErrorLog "For the language: " & iSprache & " there is no thesaurus available"
        case 31   : merksdir$ = "test"
        case 33   : merksdir$ = "test"
        case 34   : merksdir$ = "ensayo"
        case 39   : merksdir$ = "controllo"
        case 45   : merksdir$ = "sum"
        case 49   : merksdir$ = "Experiment"
        case 46   : merksdir$ = "Experiment"
        case 48   : QAErrorLog "For this language there is no thesaurus available"
        case 55   : QAErrorLog "Brasilian version not complete yet" : goto endsub
        case >80  : QAErrorLog "There is no thesaurus available for asian languages"
                                goto out
        case else : QAErrorlog "language adjustment for: " & iSprache & " doesn't exist" : goto endsub
    end select

    DocumentCalc.TypeKeys merksdir$ & "<Return><Up>"
    try
       ToolsLanguageThesaurusCalc
    catch
       warnlog "Thesaurus menu item seems to be inactive."
       goto endsub
    endcatch

    Kontext "Thesaurus"
    if Thesaurus.exists then
       if Synonym.getItemCount > 0 then
          Synonym.select 1
          if Ersetzen.GetText <> "" then
              printlog "OK"
          else
              warnlog "Thesaurus has no suggestion"
          end if
       else 
           warnlog "Empty list - maybe wrong language settings - please verify"
       endif
       Thesaurus.Ok
    else
        Warnlog "Thesaurus don't appears"
    end if
out:
    Call hCloseDocument

endcase
'
'-----------------------------------------------------
'
testcase tToolsAutocorrection
'/// This test checks, if the autocorrection appears when a false word is
'/// inserted into a document

    dim wh as integer
    dim merksdir$,merksdir2$

    Call hNewDocument

        select case iSprache
        ' The second parameter isn't used at this time
        case 01   : merksdir$ = "reccommend" : merksdir2$ = "Recommend"
        case 03   : merksdir$ = "aer"        : merksdir2$ = "era"
        case 31   : merksdir$ = "abcent"     : merksdir2$ = "absent"
        case 33   : merksdir$ = "problemme" : merksdir2$ = "problÃ¨me"
        case 34   : merksdir$ = "Poblema" : merksdir2$ = "Problema"
        case 39   : merksdir$ = "inportante" : merksdir2$ = "importante"
        case 45   : merksdir$ = "addresse" : merksdir2$ = "adresse"
        case 46   : merksdir$ = "CHFE" : merksdir2$ = "chef"
        case 48   : QAErrorlog "There is no replacement table"
        case 49   : merksdir$ = "GECHICHTE" : merksdir2$ = "Geschichte"
        case 55   : QAErrorLog "Brasilian version not complete yet" : goto endsub
        case >80  : QAErrorLog "There is no autocorrection available for asian languages"
                                goto out
        case else : QAErrorlog "There is no language adjustment for :" & iSprache : goto endsub
    end select

    DocumentCalc.TypeKeys "<Mod1 Home>"

        ToolsAutocorrect
    try
        kontext "Active"
        if active.exists then
                active.ok
                warnlog "Bug occured!"
        end if
    catch
    endcatch
    Kontext
    active.SetPage TabOptionen
    Kontext "TabOptionen"
    try
        if Einstellungen.getseltext = "Ersetzungstabelle anwenden" then
                printlog " Replacement table apply found"
        end if
    catch
        Printlog " Treelistbox don't work (isn't still yet available!)"
    endcatch
    SetControlType CTBrowseBox
    try
        Kontext "TabOptionen"
        TabOptionen.Ok
    catch
        Kontext "TabAusnahmen"
        TabAusnahmen.OK
        warnlog "Tabpage Exceptions was activated"
    endcatch

    try
        kontext "Active"
        if active.exists then
                printlog "Active.GetText: " & Active.GetText
                active.ok
                Kontext "TabOptionenAutokorrektur"
                TabOptionenAutokorrektur.Ok
        end if
    catch
    endcatch
    Kontext
    DocumentCalc.TypeKeys merksdir$ & "<Return><Up>"
        'EditCopy
        'call cClipboardVergleichen (merksdir2$)
        if czellinhalt("A1") <> merksdir$ then
                printlog "OK, the word has been replaced"
        else
                warnlog "It seems that the Autocorrection doesn't work"
        end if
        printlog "Note: If an error message is visible, check the language adjustment in 'Extras|Optionen|Allgemein|Linguistik'"
out:
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsGoalSeek
'/// In this test two values are inserted into two cells. Then in the next cell a sum formula
'/// calculates the sum from this cells. Now the menu ToolsGoalSeek is called and the goal and
'/// the variable cell is set. Then this dialog is closed with OK, and it is checked, if the
'/// result of the variable cell has been correct calculated.

    dim merksdir$,merksdir2$

    Call hNewDocument

    select case iSprache
        case 01   : merksdir$ = "1<Return>2<Return>=Sum(A1:A2)<Return>"
        case 03   : merksdir$ = "1<Return>2<Return>=SOMA(A1:A2)<Return>"
        case 31   : merksdir$ = "1<Return>2<Return>=SOM(A1:A2)<Return>"
        case 33   : merksdir$ = "1<Return>2<Return>=Somme(A1:A2)<Return>"
        case 34   : merksdir$ = "1<Return>2<Return>=Suma(A1:A2)<Return>"
        case 39   : merksdir$ = "1<Return>2<Return>=Somma(A1:A2)<Return>"
        case 45   : merksdir$ = "1<Return>2<Return>=Sum(A1:A2)<Return>"
        case 46   : merksdir$ = "1<Return>2<Return>=Summa(A1:A2)<Return>"
        case 48   : merksdir$ = "1<Return>2<Return>=Suma(A1:A2)<Return>"
        case 49   : merksdir$ = "1<Return>2<Return>=Summe(A1:A2)<Return>"
        case 55   : merksdir$ = "1<Return>2<Return>=Soma(A1:A2)<Return>"
        case >80  : merksdir$ = "1<Return>2<Return>=Sum(A1:A2)<Return>"
        case else : QAErrorlog "Still missing the language adjustment!" : goto endsub
    end select
        DocumentCalc.TypeKeys merksdir$
        ToolsGoalSeek
        Sleep 3
        Kontext "Zielwertsuche"
        Formelzelle.SetText "$A$3"
        Zielwert.SetText "13"
        VariableZelle.SetText "$A$2"
        Zielwertsuche.Ok
        Sleep 2
        Kontext "Active"
        Active.Yes
        Kontext
        DocumentCalc.TypeKeys "<Up><Up>"
        EditCopy
        call cClipboardVergleichen "12"

    Call hCloseDocument

endcase
'
'------------------------------------------------------------
'
testcase tToolsScenarios
'/// This test if a scenario is created. ///

    dim merksdir$,merksdir2$

    Call hNewDocument

    select case iSprache
        case 01   : merksdir$ = "Sheet1_Scenario_1"
        'case 03   : merksdir$ = "Folha1_CenÃ¡rio_1"
        case 31   : merksdir$ = "Werkblad1_Scenario_1"
        case 33   : merksdir$ = "Feuille1_Scénario_1"
        case 34   : merksdir$ = "Hoja1_Escenario_1"
        case 39   : merksdir$ = "Tabella1_Scenario_1"
        'case 45   : merksdir$ = "Ark1_Scenarie_1"
        case 46   : merksdir$ = "Tabell1_Scenario_1"
        'case 48   : merksdir$ = "Arkusz1_Scenariusz_1"
        case 49   : merksdir$ = "Tabelle1_Szenario_1"
        case 55   : merksdir$ = "Planilha1_Cenário_1"
        case >80  : merksdir$ =  ""                                             'The scenarioname is evaluate later
        case else : merksdir$ = "Tabelle1_Szenario_1" : QAErrorLog "No Big Ten language - No test" : goto endsub
    end select

        DocumentCalc.Typekeys "1<Return>2<Return><Up><Shift Up>"
        ToolsScenarios
        Kontext "SzenarioAnlegen"
        GanzeTabelle.check
        SzenarioAnlegen.Ok
        if iSprache > 80 then merksdir$ = getSheetName()
        FormatSheetRename
        Kontext "TabelleUmbenennen"
        if TabellenName.GetText = merksdir$ then
                printlog "OK"
        else
            warnlog "No scenario created"
    end if
    TabelleUmbenennen.Ok

    Call hCloseDocument

endcase
'
'------------------------------------------------------------
'
testcase tToolsProtectSheet
'/// This test checks, if the protection of a sheet works.
'/// After activating the protection, it must be appear a hint, that
'/// protected cells cannot be modified, if you attempt it.

    Call  hNewDocument

        ToolsProtectDocumentSheet
        Kontext "TabelleSchuetzen"
        TabelleSchuetzen.Ok
        Kontext
        DocumentCalc.TypeKeys " "
        if Active.exists (2) then
                Kontext
            Active.Ok
            printlog "OK"
        else
            warnlog "Sheet not protected"
        end if

    Call hCloseDocument

endcase
'
'------------------------------------------------------------
'
testcase tToolsAutomaticCalculate
'/// It is tested, if the automatic calculate works. Insert in cell 'A1' a '1'.
'/// Insert in cell 'A2' a '2'. The sum in cell 'A3' must be '3'. Now
'/// deactivate the automatic calculation and insert in cell 'A2' a '4'.
'/// The result in cell 'A3' must be still a '3'. After reactivating the
'/// automatic calculation

    Call  hNewDocument

        Kontext
        DocumentCalc.TypeKeys "1<Return>2<Return>=A1+A2<Return><Up>"
        EditCopy
        if GetClipboardText = "3" then
                printlog "Switch off automatic calculate"
                ToolsCellContentsAutoCalculate  'switch off
        end if
    Kontext
        DocumentCalc.TypeKeys "<Up><Up>4<Return><Down>"
        EditCopy
        if GetClipboardText = "3" then
                printlog "Switch on automatic calculate"
                ToolsCellContentsAutoCalculate  'switch on
        Kontext
            EditCopy
            if GetClipboardText = "6" then
                printlog "OK, the result is 6"
            else
                warnlog "Automatic Recalculate not switched on"
            end if
        else
                warnlog "Automatic Recalculate not switched off"
        end if

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsRecalculate
'/// This test checks, if the manuel recalculation works. The automatic
'/// calculation must be switched off at first. Then values are inserted
'/// in cells 'A1' and 'A2'. In cell 'A3' the sum from 'A1' and 'A2' is created.
'/// After modifying the cellcontents of 'A1' and 'A2' the result in cell
'/// 'A3' must be the same. After recalculating manually the result of
'/// cell 'A3' must be updated.

        Call  hNewDocument

        Kontext
        DocumentCalc.TypeKeys "1<Return>2<Return>=A1+A2<Return><Up>"
        EditCopy
        if GetClipboardText = "3" then
                ToolsCellContentsAutoCalculate  'switch off
        end if

        Kontext
        DocumentCalc.TypeKeys "<up><up>2<Return>3<Return>"
        if cZellwert("A3") = "3" then
                printlog "OK, the result is 3"
        else
                warnlog "The autocalculation has not been switched off"
        end if
   ToolsCellContentsRecalculate
        if cZellwert("A3") = "5" then
                printlog "OK, the result is 5 after new calculation"
        else
          warnlog "Result wasn't recalculated automatically"
        end if

        ToolsCellContentsAutoCalculate  'switch on

   Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsAutoInput
'/// This test checks, if the autocompletion works.
'/// A document is opened. Then a string is inerted into the first cell.
'/// In the next cell downwards a character which is the same as the first
'/// character in the string above is inserted and the RETURN button is pressed.
'/// Now it is checked, if the content of the second cell is the same as in
'/// the first cell.
'/// After this, the autocompletion is turned off, and the same procedure
'/// is repeated. Now it is checked if the cellcontent of the second cell is different
'/// to the content of the first cell.

        Call  hNewDocument
        Kontext
        DocumentCalc.TypeKeys "Bla Bla Bla<Return>"
        DocumentCalc.TypeKeys "B<Return><Up>"

        EditCopy
        if GetClipboardText = "Bla Bla Bla" then
                ToolsCellContentsAutoInput      'ausschalten
        end if

        Kontext
        DocumentCalc.TypeKeys "<Right>Bla Bla Bla<Return>"
        DocumentCalc.TypeKeys "B<Return><Up>"
        EditCopy
        if GetClipboardText = "B" then
                ToolsCellContentsAutoInput      'einschalten
            Kontext
                DocumentCalc.TypeKeys "<Right>Bla Bla Bla<Return>"
                DocumentCalc.TypeKeys "B<Return><Up>"
                EditCopy
                if GetClipboardText = "Bla Bla Bla" then
                        Printlog "Ok"
                end if
        else
                Warnlog "AutoInput doesn't work"
        end if

    Call hCloseDocument

endcase
'
'------------------------------------------------------------
'
'OBSOLETE
testcase tToolsConfigure
'/// This test call the menuitem "Tools|Configure" and check, if all tabpages
'/// are available.

  call hNewDocument

'-   -   -   -   -   -   -   -   -   -   -   -
    ToolsCustomize

    Kontext
    active.SetPage TabMenu              'nicht zum testen
    Kontext "TabMenu"
    Sleep 2
    try
                Menu.select 1
                printlog "TabMenu is now available!"
    catch
                warnlog "TabMenu isn't available!"
    endcatch

    Kontext
        active.SetPage TabTastatur
        Sleep 3
    Kontext "TabTastatur"
    Sleep 2
    try
        Tastatur.select 25
        printlog "TabTastatur is now available"
    catch
        warnlog "TabTastatur isn't available!"
    endcatch


    Kontext
    try
        active.SetPage TabStatusleiste          'nicht zum testen
        Sleep 3
        Kontext "TabStatusleiste"
        printlog "TabStatusleiste is available!"
    catch
        warnlog "TabStatusleite isn't available!"
    endcatch

    Kontext
    try
        active.SetPage TabSymbolleisten
        Sleep 3
        Kontext "TabSymbolleisten"
    printlog "TabSymbolleisten is available!"
    catch
        warnlog "TabSymbolleisten isn't available!"
    endcatch

    Kontext
        active.SetPage TabEreignisse
        Sleep 3
        Kontext "TabEreignisse"
    TabEreignisse.Cancel

    ' Disable this test until it's clear who is responsible for this part
    goto out

    printlog "* Check the current safety adjustment *"
    call hDateiOeffnen convertpath(gTesttoolpath & "input\calc\stufe1\c_106\macro_example" & Ext)
    try
        Kontext "MakroAusfuehren"
        if MakroAusfuehren.Exists then
                printlog "OK, warning dialog is visible!"
                MakroAusfuehren.OK
                Sleep 5
                DateiEigenschaften
                Kontext
                Active.SetPage TabDokument
                Kontext "TabDokument"
                if Dokumentname.GetText = "macro_example" & Ext then
                        printlog "OK, the rigth document was opened!"
                else
                        warnlog "Document macro_example" & Ext & " wasn't opened!"
                end if
                TabDokument.OK
                call hCloseDocument
        end if
    catch
        warnlog "Warning dialog wasn't active!"
        call hCloseDocument
    endcatch


    ToolsConfigure

        Kontext
        active.SetPage TabEreignisse
        Kontext "TabEreignisse"
    Warnung.Uncheck
        TabEreignisse.Ok

        printlog "* Check if the document 'makrofile.sxc' is opened without warning *"
        call hDateiOeffnen convertpath(gTesttoolpath & "input\calc\stufe1\c_106\macro_example" & Ext)
        try
                Kontext "MakroAusfuehren"
                if MakroAusfuehren.Exists then
                        Sleep 1
                warnlog "Adjustment 'warning.uncheck' wasn't taken over!"
                        MakroAusfuehren.OK
                else
                        printlog "OK, adjustment 'warning.uncheck' was taken over!"
                end if
        catch
                printlog "OK, adjustment 'warning.uncheck' was taken over!"
        endcatch

  call hCloseDocument

out:
  call hCloseDocument

endcase
'
'------------------------------------------------------------

