'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: keyboardaccessibility3.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:29 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : hercule.li@sun.com
'*
'* short description : Reference input dialogs
'*
'************************************************************************
'*
' #1 tReferenceInputDlg1
' #1 tReferenceInputDlg2
' #1 tReferenceInputDlg3
' #1 tReferenceInputDlg4
' #1 tReferenceInputDlg5
' #1 tReferenceInputDlg6
' #1 tReferenceInputDlg7
' #1 tReferenceInputDlg8
' #1 tReferenceInputDlg9
' #1 tReferenceInputDlg10
' #1 tReferenceInputDlg11
' #1 tReferenceInputDlg12
' #1 tReferenceInputDlg13
' #1 tReferenceInputDlg14
' #1 tControlKey1
' #1 tControlKey2
' #1 tControlKey3
' #1 tControlKey4
' #1 tControlKey5
' #1 tControlKey6
' #1 tControlKey7
' #1 tControlKey8
' #1 tControlKey9
' #1 tControlKey10
' #1 tControlKey11
' #1 tControlKey12
' #1 tControlKey13
' #1 tControlKey14
'*
'\***********************************************************************

sub C_Keyboard_Accessibility_3

   printLog Chr(13) + "=== Keyboard_Accessibility 3 ==="
   printLog Chr(13) + "-- Check F2 in edit field ..."
  '/// Check F2 in edit field ...
  '/// - Check if F2 in edit field sets focus to document. (YES)
  '/// - Check if it's possible to move the cursor equal to standard Calc cursor control. (NO)
  '/// - Check if F2 again returns to the dialog. (YES)
  '/// - Check if it's possible to move the cursor equal to standard Calc cursor control. (NO )
  '/// HINTS: standard Calc cursor control means we can move focus from A1 to A2, then Sheet Area should display A2

      Call tReferenceInputDlg1    'Formula Auto Pilot Dlg
      Call tReferenceInputDlg2    'Define Name Dlg
      Call tReferenceInputDlg3    'Define Database Name Dlg
      Call tReferenceInputDlg4    'Standard Filter Dlg
      Call tReferenceInputDlg5    'Advanced Filter Dlg
      Call tReferenceInputDlg6    'Edit Print Areas Dlg
      Call tReferenceInputDlg7    'Define Lable Ranges Dlg
      Call tReferenceInputDlg8    'Conditional Formatting Dlg
      Call tReferenceInputDlg9    'Consolidation Dlg
      Call tReferenceInputDlg10   'Multiple Operation Dlg
      Call tReferenceInputDlg11   'Goal Seek Dlg
      Call tReferenceInputDlg12   'Accept/Reject Changes Dlg
      Call tReferenceInputDlg13   'DataPilot Layout Dlg
      Call tReferenceInputDlg14   'Insert Chart Dlg

   printLog Chr(13) + "-- Check the keyboard controls"
  '/// Check the keyboard controls

      Call tControlKey1      'Check cursor keys , include UP, DOWN, RIGHT, LEFT
      Call tControlKey2      'Check Ctrl + all cursor keys
      Call tControlKey3      'Check PageDown/PageUp
      Call tControlKey4      'Check Alt + PageDown/PageUP
      Call tControlKey5      'Check Ctrl + PageDown/PageUP
      Call tControlKey6      'Check Home/End
      Call tControlKey7      'Check Ctrl + Home/End
      Call tControlKey8      'Check Shift + all cursor keys
      Call tControlKey9      'Check Ctrl + all cursor keys
      Call tControlKey10     'Check PageDown/PageUp
      Call tControlKey11     'Check Shift + Alt + PageDown/PageUP
'      Call tControlKey12     'Check shift + Ctrl + PageDown/PageUP 
      Call tControlKey13     'Check shift + Home/End
      Call tControlKey14     'Check shift + Ctrl + Home/End
end sub

'-------------------------------------------------------------------------

testcase tReferenceInputDlg1

   printLog "Check F2 functionality in Formula Auto Pilot Dlg"
  '/// Check F2 functionality in Formula Auto Pilot Dlg

   Dim locationOfAssign1, locationOfAssign2 as String
   Dim iFunction                            as Integer

   locationOfAssign1 = "B1"
   locationOfAssign2 = "A2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Formula Auto Pilot Dlg , and choose ABS function
    InsertFunction
    Kontext "Funktionsautopilot"

    Select case iSprache
       case 01   : iFunction = 1   '(English USA)         ABS
       case 31   : iFunction = 6   '(Dutch)               ABS
       case 33   : iFunction = 1   '(French)              ABS
       case 34   : iFunction = 1   '(Spanish)             ABS
       case 39   : iFunction = 31  '(Italian)             ASS
       case 46   : iFunction = 1   '(Swedish)             ABS
       case 49   : iFunction = 2   '(German)              ABS
       case 55   : iFunction = 2   '(Portuguese)          ABS
       case 81   : iFunction = 1   '(Japanese)            ABS
       case 82   : iFunction = 1   '(Korean)              ABS
       case 86   : iFunction = 1   '(Simplified Chinese)  ABS
       case 88   : iFunction = 1   '(Traditional Chinese) ABS
       case else : QAErrorLog "The test does not support the language " + iSprache
                   Funktionsautopilot.Cancel
                   Call hCloseDocument
                   Goto endsub
    end select

    Funktion.Select iFunction
    Sleep 1

   '/// Click 'Next>>' button
    Weiter.Click
    sleep 2

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Editfeld1.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "Funktionsautopilot"
    if locationOfAssign1 <> Editfeld1.GetText then Warnlog "1. The position should be moved, you get " +Editfeld1.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"
    sleep 2
    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "Funktionsautopilot"
    if locationOfAssign2 <> Editfeld1.GetText then Warnlog "2. The position should be moved, you get " +Editfeld1.GetText+ " instead of " + locationOfAssign2
    Funktionsautopilot.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg2

   printLog "Check F2 functionality in Define Name Dlg"
  '/// Check F2 functionality in Define Name Dlg

   Dim sName , locationOfAssign1, locationOfAssign2 as String

   sName             = "testB1"
   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Define Name Dlg with Insert/name/Define
    InsertNamesDefine
    Kontext "Namenfestlegen"

   '/// Input something in 'Name'
    BereichsName.settext sName

    printLog "Set focus to 'Assign to'"
   '/// Set focus to 'Assign to'
    BereichsName.TypeKeys "<TAB>"

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    ZugeordnetZu.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "Namenfestlegen"
    if locationOfAssign1 <> Right(ZugeordnetZu.GetText , 4) then Warnlog "1. The position should be moved, you get " +ZugeordnetZu.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "Namenfestlegen"
    if locationOfAssign2 <> Right(ZugeordnetZu.GetText , 4) then Warnlog "2. The position should be moved, you get " +ZugeordnetZu.GetText+ " instead of " + locationOfAssign2
    Namenfestlegen.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg3

   printLog "Check F2 functionality in Define Database Name Dlg"
  '/// Check F2 functionality in Define Database Name Dlg

   Dim sName , locationOfAssign1, locationOfAssign2 as String

   sName             = "testB1"
   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Define Database Name Dlg with Data/Define/Range
    DataDefineRange
    Kontext "DatenbankbereichFestlegen"

   '/// input something in Name
    BereichsName.settext sName

    printLog "Set focus to 'Range'"
   '/// Set focus to 'Range'
    BereichsName.TypeKeys "<TAB>"

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Bereich.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "DatenbankbereichFestlegen"
    if locationOfAssign1 <> Right(Bereich.GetText , 4) then Warnlog "1. The position should be moved, you get " +Bereich.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "DatenbankbereichFestlegen"
    if locationOfAssign2 <> Right(Bereich.GetText , 4) then Warnlog "2. The position should be moved, you get " +Bereich.GetText+ " instead of " + locationOfAssign2
    DatenbankbereichFestlegen.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg4

   printLog "Check F2 functionality in Standard Filter Dlg"
  '/// Check F2 functionality in Standard Filter Dlg

   Dim locationOfAssign1, locationOfAssign2 as String

   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Standard Filter Dlg
    DataFilterStandardFilter
    Kontext "StandardFilter"
   '/// Click 'More>>' button
    Zusaetze.Click
   '/// Choose 'Copy result to'
    FilterergebnisNach.Check
    sleep 2

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Ausgeben.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "StandardFilter"
    if locationOfAssign1 <> Right(Ausgeben.GetText , 4) then Warnlog "1. The position should be moved, you get " +Ausgeben.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"
    sleep 2
    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "StandardFilter"
    if locationOfAssign2 <> Right(Ausgeben.GetText , 4) then Warnlog "2. The position should be moved, you get " +Ausgeben.GetText+ " instead of " + locationOfAssign2
    StandardFilter.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg5

   printLog "Check F2 functionality in Advanced Filter Dlg"
  '/// Check F2 functionality in Advanced Filter Dlg

   Dim locationOfAssign1, locationOfAssign2 as String

   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Advanced Filter Dlg
    DataFilterAdvancedFilter
    Kontext "Spezialfilter"

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Befinden.TypeKeys "<F2>"
    sleep 2

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    Sleep 2
    Kontext "Spezialfilter"
    if locationOfAssign1 <> Right(Befinden.GetText , 4) then Warnlog "1. The position should be moved, you get " +Befinden.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"
    sleep 2
    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "Spezialfilter"
    if locationOfAssign2 <> Right(Befinden.GetText , 4) then Warnlog "2. The position should be moved, you get " +Befinden.GetText+ " instead of " + locationOfAssign2
    Spezialfilter.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg6

   printLog "Check F2 functionality in Edit Print Areas  Dlg"
  '/// Check F2 functionality in Edit Print Areas Dlg

   Dim locationOfAssign1, locationOfAssign2 as String

   locationOfAssign1 = "$B$1:$B$1"
   locationOfAssign2 = "$A$2:$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Edit Print Areas Dlg
    FormatPrintRangesEdit
    Kontext "DruckbereicheBearbeiten"

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Druckbereich.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "DruckbereicheBearbeiten"
    if locationOfAssign1 <> Druckbereich.GetText then Warnlog "1. The position should be moved, you get " +Druckbereich.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "DruckbereicheBearbeiten"
    if locationOfAssign2 <> Druckbereich.GetText then Warnlog "2. The position should be moved, you get " +Druckbereich.GetText+ " instead of " + locationOfAssign2
    DruckbereicheBearbeiten.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg7

   printLog "Check F2 functionality in Define Label Ranges Dlg"
  '/// Check F2 functionality in Define Label Ranges Dlg

   Dim locationOfAssign1, locationOfAssign2 as String
   Dim sName                                as String

   sName             = "testB1"
   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Define Label Ranges Dlg with Insert/name/Define
    InsertNamesLabels
    Kontext "BeschriftungsbereichFestlegen"

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Zellbereich.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "BeschriftungsbereichFestlegen"
    if locationOfAssign1 <> Right(Zellbereich.GetText , 4) then Warnlog "1. The position should be moved, you get " +Zellbereich.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "BeschriftungsbereichFestlegen"
    if locationOfAssign2 <> Right(Zellbereich.GetText , 4) then Warnlog "2. The position should be moved, you get " +Zellbereich.GetText+ " instead of " + locationOfAssign2
    BeschriftungsbereichFestlegen.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg8

   printLog "Check F2 functionality in Conditional Formatting Dlg"
  '/// Check F2 functionality in Conditional Formatting Dlg

   Dim locationOfAssign1 , locationOfAssign2 as String

   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Conditional Formatting Dlg
    FormatConditionalFormatting
    Kontext "BedingteFormatierung"

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    TextField1.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"

    Kontext "BedingteFormatierung"
    if locationOfAssign1 <> Right(TextField1.GetText , 4) then Warnlog "1. The position should be moved, you get " +TextField1.GetText+ " instead of " + locationOfAssign1
    sleep(2)

    Kontext "DocumentCalc"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "BedingteFormatierung"
    if locationOfAssign2 <> Right(TextField1.GetText , 4) then Warnlog "2. The position should be moved, you get " +TextField1.GetText+ " instead of " + locationOfAssign2
    BedingteFormatierung.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg9

   printLog "Check F2 functionality in Consolidation Dlg"
  '/// Check F2 functionality in Consolidation Dlg

   Dim locationOfAssign1, locationOfAssign2 as String

   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Consolidation Dlg
    DataConsolidate
    Kontext "Konsolidieren"

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Quelldaten.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "Konsolidieren"
    if locationOfAssign1 <> Right(Quelldaten.GetText , 4) then Warnlog "1. The position should be moved, you get " +Quelldaten.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "Konsolidieren"
    if locationOfAssign2 <> Right(Quelldaten.GetText , 4) then Warnlog "2. The position should be moved, you get " +Quelldaten.GetText+ " instead of " + locationOfAssign2
    Konsolidieren.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg10

   printLog "Check F2 functionality in Multiple Operation Dlg"
  '/// Check F2 functionality in Multiple Operation Dlg

   Dim locationOfAssign1, locationOfAssign2 as String

   locationOfAssign1 = "$C$1"
   locationOfAssign2 = "$B$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Shift+Right to Select a range"
   '/// Press Shift+Right to Select a range
    DocumentCalc.TypeKeys "<Shift Right>"

   '/// Open Multiple Operation Dlg
    DataMultipleOperations
    Kontext "Mehrfachoperationen"

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Formeln.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "Mehrfachoperationen"
    if locationOfAssign1 <> Right(Formeln.GetText , 4) then Warnlog "1. The position should be moved, you get " +Formeln.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "Mehrfachoperationen"
    if locationOfAssign2 <> Right(Formeln.GetText , 4) then Warnlog "2. The position should be moved, you get " +Formeln.GetText+ " instead of " + locationOfAssign2
    Mehrfachoperationen.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg11

   printLog "Check F2 functionality in Goal Seek Dlg"
  '/// Check F2 functionality in Goal Seek Dlg

   Dim locationOfAssign1, locationOfAssign2 as String

   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Goal Seek Dlg
    ToolsGoalSeek
    Kontext "Zielwertsuche"

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Formelzelle.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "Zielwertsuche"
    if locationOfAssign1 <> Formelzelle.GetText then Warnlog "1. The position should be moved, you get " +Formelzelle.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "Zielwertsuche"
    if locationOfAssign2 <> Formelzelle.GetText then Warnlog "2. The position should be moved, you get " +Formelzelle.GetText+ " instead of " + locationOfAssign2
    Zielwertsuche.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg12

   printLog "Check Accept/Reject Changes Dlg ( in shrunken mode)"
  '/// Check Accept/Reject Changes Dlg ( in shrunken mode)

   Dim  locationOfAssign1, locationOfAssign2 as String

   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"
    EditChangesRecordCalc

   '/// Open Accept/Reject Changes Dlg
    EditChangesAcceptOrDiscardCalc
    Kontext "TabAenderungenAnzeigen"
    Kontext "AenderungenAnzeigen"
    Kontext "TabControl"
    TabControl.setpage TabFilter
    sleep 2
    Kontext "AenderungenAnzeigen"
    sleep 2

    printLog "Check Range"
   '/// Check Range
    Aktion.Check
    sleep 2

    printLog "Click button to the shrunken mode"
   '/// Click button to the shrunken mode
    Button.Click
    sleep 2

    Kontext "AcceptOrRejectChangesArea"
    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    AreaEditField.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "AcceptOrRejectChangesArea"
    if locationOfAssign1 <> Right(AreaEditField.GetText , 4) then Warnlog "1. The position should be moved, you get " +AreaEditField.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "AcceptOrRejectChangesArea"
    if locationOfAssign2 <> Right(AreaEditField.GetText , 4) then Warnlog "2. The position should be moved, you get " +AreaEditField.GetText+ " instead of " + locationOfAssign2
    AcceptOrRejectChangesArea.Close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg13

   printLog "Check F2 functionality in DataPilot Layout Dlg"
  '/// Check F2 functionality in DataPilot Layout Dlg

   Dim locationOfAssign1, locationOfAssign2 as String
   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open DataPilot Layout Dlg
    DataDataPilotStart
    Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
    QuelleAuswaehlen.OK
    sleep 2

    Kontext "Datenpilot"

   '/// Click 'More >>' key
    Zusaetze.Click

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Bereich.TypeKeys "<Home><Shift End>"
    sleep 2
    Bereich.TypeKeys "<Delete>"
    sleep 2
    Bereich.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"
    sleep 2

    Kontext "Datenpilot"
    if locationOfAssign1 <> Right(Bereich.GetText , 4) then Warnlog "1. The position should be moved, you get " +Bereich.GetText+ " instead of " + locationOfAssign1

    Kontext "DocumentCalc"
    sleep 2
    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "Datenpilot"
    if locationOfAssign2 <> Right(Bereich.GetText , 4) then Warnlog "2. The position should be moved, you get " +Bereich.GetText+ " instead of " + locationOfAssign2
    Datenpilot.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tReferenceInputDlg14

   printLog "Check F2 functionality in Insert Chart Dlg"
  '/// Check F2 functionality in Insert Chart Dlg

   Dim locationOfAssign1, locationOfAssign2 as String

   locationOfAssign1 = "$B$1"
   locationOfAssign2 = "$A$2"

   call  hNewDocument

   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

   '/// Open Insert Chart Dlg
    InsertChartCalc
    Kontext "AutoFormatDiagrammBeginn"

    printLog "Check if F2 in edit field sets focus to document."
   '/// Check if F2 in edit field sets focus to document.
    Bereich.TypeKeys "<F2>"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control."
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"
    sleep 2

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    DocumentCalc.TypeKeys "<F2>"

    Kontext "AutoFormatDiagrammBeginn"
    if locationOfAssign1 <> Right(Bereich.GetText , 4) then Warnlog "1. The position should be moved, you get " +Bereich.GetText+ " instead of " + locationOfAssign1

    printLog "Check if F2 again returns to the dialog. "
   '/// Check if F2 again returns to the dialog.
    Kontext "DocumentCalc"

    printLog "Check if it's possible to move the cursor equal to standard Calc cursor control. "
   '/// Check if it's possible to move the cursor equal to standard Calc cursor control.
    DocumentCalc.TypeKeys "<Down>"
    sleep 2

    Kontext "AutoFormatDiagrammBeginn"
    if locationOfAssign2 <> Right(Bereich.GetText , 4) then Warnlog "2. The position should be moved, you get " +Bereich.GetText+ " instead of " + locationOfAssign2
    AutoFormatDiagrammBeginn.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey1

  printLog "Check all cursor keys , include UP, DOWN, RIGHT, LEFT"
  '/// Check  all cursor keys, include UP, DOWN, RIGHT, LEFT

  Dim testFile      as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Move to RIGHT"
   '/// Move to RIGHT
     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<Right>"
     sleep 2
     if wobinich <> "B1" then Warnlog "The Right Key work doesn't well , get " + wobinich

    printLog "Move to DOWN"
   '/// Move to DOWN
     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<DOWN>"
     sleep 2
     if wobinich <> "B2" then Warnlog "The Down Key work doesn't well , get " + wobinich

    printLog "Move to LEFT"
   '/// Move to LEFT
     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<Left>"
     sleep 2
     if wobinich <> "A2" then Warnlog "The Left Key work doesn't well  , get " + wobinich

    printLog "Move to UP"
   '/// Move to UP
     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<Up>"
     sleep 2
     if wobinich <> "A1" then Warnlog "The Up Key work doesn't well , get " + wobinich

     Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey2

  printLog "Check Ctrl + all cursor keys"
  '/// Check Ctrl + all cursor keys

  Dim testFile  as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Ctrl + Down"
   '/// Press Ctrl + Down
    DocumentCalc.TypeKeys "<MOD1 DOWN>"
    if wobinich <> "A65536" then
        if wobinich = "A32000" then 
            QAErrorLog "You're using an old office. Pls. try the new one which is newer than src680m42"
        else        
            warnlog "Button Ctrl + DOWN has moved the selection to " & wobinich & " instead of A65536"
        end if
    end if

    printLog "Press Ctrl + Right"
   '/// Press Ctrl + Right
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 RIGHT>"
    if wobinich <> "IV65536" then
        if wobinich = "IV32000" then 
            QAErrorLog "You're using an old office. Pls. try the new one which is newer than src680m42"
        else        
            warnlog "Button Ctrl + RIGHT has moved the selection to " & wobinich & " instead of IV65536"
        end if
    end if

    printLog "Press Ctrl + Up"
   '/// Press Ctrl + Up
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 UP>"
    if wobinich <> "IV1" then warnlog "Button Ctrl + UP has moved the selection to " & wobinich & " instead of IV1"

    printLog "Press Ctrl + Left"
   '/// Press Ctrl + Left
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 LEFT>"
    if wobinich <> "IQ1" then warnlog "Button Ctrl + LEFT has moved the selection to " & wobinich & " instead of IQ1"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey3

  printLog "Check PageDown/PageUp"
  '/// Check PageDown/PageUp
  '/// Hints : Since Page depends on screen size, so we conside
  '/// + if pagedown or pageup exceeds 20 rows, that means the
  '/// + function is OK!

  Dim testFile  as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press PageDown"
   '/// Press PageDown
    DocumentCalc.TypeKeys "<PageDown>"
    if wobinich < "A20" then warnlog "Button PageDown has moved the selection to " & wobinich

    printLog "Press PageUp"
   '/// Press PageUp
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<PageUp>"
    if wobinich <> "A1" then warnlog "Button Pageup has moved the selection to " & wobinich & " instead of A1"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey4

  printLog "Check Alt + PageDown/PageUp"
  '/// Check Alt + PageDown/PageUp
  '/// Hints : Since Page depends on screen size, so we conside
  '/// + if Alt + pagedown or pageup exceeds 8 columns, that means
  '/// + the function is OK!

  Dim testFile  as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press ALT + PageDown"
   '/// Press ALT + PageDown
    DocumentCalc.TypeKeys "<MOD2 PageDown>"
    if wobinich < "H1" then warnlog "Alt PageDown has moved the selection to " & wobinich

    printLog "Press Alt + PageUp"
   '/// Press Alt + PageUp
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD2 PageUp>"
    if wobinich <> "A1" then warnlog "Alt Pageup has moved the selection to " & wobinich & " instead of A1"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey5

  printLog "Check Ctrl + PageDown/PageUp"
  '/// Check Ctrl + PageDown/PageUp

  Dim testFile                as String
  Dim sheetName1 , sheetName2 as String

  testFile   = "control-test.sxc"
  sheetName1 = "$Sheet1.$A$1"
  sheetName2 = "$Sheet2.$A$1"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press CTRL + PageDown"
   '/// Press CTRL + PageDown
    DocumentCalc.TypeKeys "<MOD1 PAGEDOWN>"
    DocumentCalc.TypeKeys "<MOD1 HOME>"
    DataConsolidate
    Kontext "Konsolidieren"
    if Ausgeben.getText <> sheetName2 then  warnlog "The Ctrl+pagedown has moved to " & Ausgeben.getText & " instead of  " + sheetName2
    Konsolidieren.close

    printLog "Press CTRL + PageUP"
   '/// Press Ctrl + PageUP
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 PageUP>"
    DocumentCalc.TypeKeys "<MOD1 HOME>"
    DataConsolidate
    Kontext "Konsolidieren"
    if Ausgeben.getText <> sheetName1 then  warnlog "The Ctrl+pagedown has moved to " & Ausgeben.getText & " instead of  " + sheetName1
    Konsolidieren.close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey6

  printLog "Check Home/End"
  '/// Check Home/End

  Dim testFile  as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press End"
   '/// Press End
    DocumentCalc.TypeKeys "<End>"
    if wobinich <> "IQ1" then warnlog "Button End has moved the selection to " & wobinich & "instead of IQ1"

    printLog "Press Home"
   '/// Press Home
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Home>"
    if wobinich <> "A1" then warnlog "Button Home has moved the selection to " & wobinich & " instead of A1"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey7

  printLog "Check Ctrl + Home/End"
  '/// Check Ctrl + Home/End

  Dim testFile  as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press PageDown to ensure the focus is out of A1
    DocumentCalc.TypeKeys "<PageDown>"

    printLog "Press Ctrl+End"
   '/// Press Ctrl+End
    DocumentCalc.TypeKeys "<MOD1 End>"
    if wobinich <> "IQ1" then warnlog "Ctrl + End has moved the selection to " & wobinich & "instead of IQ1"

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<PageDown>"
    printLog "Press Home"
   '/// Press Home
    DocumentCalc.TypeKeys "<MOD1 Home>"
    if wobinich <> "A1" then warnlog "Ctrl + Home has moved the selection to " & wobinich & " instead of A1"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey8

  printLog "Check Shift + all cursor keys"
  '/// Check  Shift + all cursor keys

  Dim testFile      as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Shift + RIGHT"
   '/// Press Shift + RIGHT
     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<Shift Right>"
     sleep 2
     if wobinich <> "A1:B1" then Warnlog "The Shift+Right Key work doesn't well, get " +wobinich

     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<DOWN><UP>"
    printLog "Press Shift + DOWN"
   '/// Press Shift + DOWN
     DocumentCalc.TypeKeys "<Shift DOWN>"
     sleep 2
     if wobinich <> "B1:B2" then Warnlog "The Shift+Down Key work doesn't well, get " +wobinich

     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<DOWN><UP>"
    printLog "Press Shift + LEFT"
   '/// Press shift + LEFT
     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<Shift Left>"
     sleep 2
     if wobinich <> "A2:B2" then Warnlog "The Shift + Left Key work doesn't well, get " +wobinich

     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<DOWN><UP>"
    printLog "Press Shift + UP"
   '/// Press Shift + UP
     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<Shift Up>"
     sleep 2
     if wobinich <> "A1:A2" then Warnlog "The Shift + Up Key work doesn't well , get " + wobinich

     Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey9

  printLog "Check Shift + Ctrl + all cursor keys"
  '/// Check Shift + Ctrl + all cursor keys

  Dim testFile  as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Shift + Ctrl + Down"
   '/// Press Shift + Ctrl + Down
    DocumentCalc.TypeKeys "<Shift MOD1 DOWN>"
    if wobinich <> "A1:A65536" then
        if wobinich = "A1:A32000" then 
            QAErrorLog "You're using an old office. Pls. try the new one which is newer than src680m42"
        else        
            warnlog "Shift + Ctrl + DOWN has moved the selection to " & wobinich & " instead of A1:A65536"
        end if
    end if

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<UP><Down>"
    printLog "Press Shift + Ctrl + Right"
   '/// Press Shift + Ctrl + Right
    DocumentCalc.TypeKeys "<Shift MOD1 RIGHT>"
    if wobinich <> "A65536:IV65536" then 
        if wobinich = "A65536:IV65536" then 
            QAErrorLog "You're using an old office. Pls. try the new one which is newer than src680m42"
        else        
            warnlog "Shift Ctrl + RIGHT has moved the selection to " & wobinich & " instead of A65536:IV65536"
        end if
    end if

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<UP><Down>"
    printLog "Press Shift + Ctrl + Up"
   '/// Press Shift + Ctrl + Up
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Shift MOD1 UP>"
    if wobinich <> "IV1:IV65536" then
        if wobinich = "IV1:IV32000" then 
            QAErrorLog "You're using an old office. Pls. try the new one which is newer than src680m42"
        else        
            warnlog "Shift + Ctrl + UP has moved the selection to " & wobinich & " instead of IV1:IV65536"
        end if
    end if

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Down><Up>"
    printLog "Press Shift + Ctrl + Left"
   '/// Press Shift + Ctrl + Left
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Shift MOD1 LEFT>"
    if wobinich <> "IQ1:IV1" then warnlog "Shift + Ctrl + LEFT has moved the selection to " & wobinich & " instead of IQ1:IV1"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey10

  printLog "Check Shift + PageDown/PageUp"
  '/// Check Shift + PageDown/PageUp
  '/// Hints : Since Page depends on screen size, so we conside
  '/// + if pagedown or pageup exceeds 20 rows, that means the function is OK!

  Dim testFile  as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Shift + PageDown"
   '/// Press Shift + PageDown
    DocumentCalc.TypeKeys "<Shift PageDown>"

    if Left(wobinich,2)  = "A1" then
       if wobinich < "A1:A20" then warnlog "Shift + PageDown has moved the selection to " & wobinich
    else
       warnlog "Something wrong when pressing Shift + PageDown ,the first cell is " + Left(wobinich,2) + " should be A1"
    end if

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>"

    printLog "Press Shift + PageUp"
   '/// Press Shift + PageUp
    DocumentCalc.TypeKeys "<Shift PageUp>"
    if Left(wobinich,2)  = "B1" then
       if wobinich < "B1:B20" then warnlog "Shift + PageUP has moved the selection to " & wobinich
    else
       warnlog "Something wrong when pressing Shift + PageUp ,the first cell is " + Left(wobinich,2) + " should be B1"
    end if

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey11

  printLog "Check Shift + Alt + PageDown/PageUp"
  '/// Check Shift + Alt + PageDown/PageUp
  '/// Hints : Since Page depends on screen size, so we conside
  '/// + if Alt + pagedown or pageup exceeds 8 columns, that means the function is OK!

  Dim testFile  as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Shift + ALT + PageDown"
   '/// Press Shift + ALT + PageDown
    DocumentCalc.TypeKeys "<Shift MOD2 PageDown>"
    if wobinich < "A1:H1" then warnlog "Shift + alt + PageDown has moved the selection to " & wobinich

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Down>"

    printLog "Press Shift + Alt + PageUp"
   '/// Press Alt + PageUp
    DocumentCalc.TypeKeys "<Shift MOD2 PageUp>"
    if wobinich < "A2:H2" then warnlog "Shift + alt + Pageup has moved the selection to " & wobinich

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey12

  printLog "Check Shift + Ctrl + PageDown/PageUp"
  '/// Check Shift + Ctrl + PageDown/PageUp

  Dim testFile  as String
  Dim sheetName as String

  testFile  = "control-test.sxc"
  sheetName = "$Sheet1.$A$1"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Shift + CTRL + PageDown"
   '/// Press Shift + CTRL + PageDown
    DocumentCalc.TypeKeys "<Shift  MOD1 PAGEDOWN>"
    DataConsolidate
    Kontext "Konsolidieren"
    if Ausgeben.getText <> sheetName then  warnlog "The Ctrl+pagedown has moved to " & Ausgeben.getText & " instead of  " + sheetName
    Konsolidieren.close

    printLog "Press Shift + CTRL + PageUP"
   '/// Press Shift + Ctrl + PageUP
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Shift MOD1 PageUP>"
    DataConsolidate
    Kontext "Konsolidieren"
    if Ausgeben.getText <> sheetName then  warnlog "The Ctrl+pagedown has moved to " & Ausgeben.getText & " instead of  " + sheetName
    Konsolidieren.close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey13

  printLog "Check Shift + Home/End"
  '/// Check Shift + Home/End

  Dim testFile  as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Shift + End"
   '/// Press Shift + End
    DocumentCalc.TypeKeys "<Shift End>"
    if wobinich <> "A1:IQ1" then warnlog "Shift End has moved the selection to " & wobinich & "instead of A1:IQ1"

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Down>"
    printLog "Press Shift + Home"
   '/// Press Shift + Home
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Shift Home>"
    if wobinich <> "A2:IQ2" then warnlog "Shift Home has moved the selection to " & wobinich & " instead of A2:IQ2"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tControlKey14

  printLog "Check Shift + Ctrl + Home/End"
  '/// Check Shift + Ctrl + Home/End

  Dim testFile  as String
  testFile  = "control-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\control-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\control-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    sleep 2

    Kontext "DocumentCalc"
   '/// Press Ctrl+PageUp to ensure the focus is in First sheet
    DocumentCalc.TypeKeys "<MOD1 PAGEUP>"
   '/// Press Ctrl+Home to ensure the focus is in A1
    DocumentCalc.TypeKeys "<MOD1 HOME>"
   '/// Press Ctrl+Home to ensure the focus is in A4
    DocumentCalc.TypeKeys "<Down>",3

    printLog "Press Shift+Ctrl+End"
   '/// Press Shift+Ctrl+End
    DocumentCalc.TypeKeys "<Shift MOD1 End>"
    if wobinich <> "A1:IQ4" then warnlog "Shift+Ctrl+End has moved the selection to " & wobinich & "instead of A1:IQ4"

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Down>" , 2
    printLog "Press Home"
   '/// Press Home
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Shift MOD1 Home>"
    if wobinich <> "A1:IQ3" then warnlog "Shift+Ctrl+Home has moved the selection to " & wobinich & " instead of A1:IQ3"

   Call hCloseDocument

endcase

