'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_printrange.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:32 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : calc printrange level 2 test
'*
'*************************************************************************
'*
' #1 c_printrange ' Initial routine
' #1 tDefinePrintRange
' #1 tAddPrintRange
' #1 tRemovePrintRangeByContext
' #1 tRemovePrintRangeByMenu
' #1 tNamedRangeToPrintRange
' #1 tEntireSheet
' #1 tPrintRangeMouseSelection
'*
'\************************************************************************
'TODO: three test cases to go

sub c_printrange

Printlog Chr(13) + "--------- printrange ---------"

   call tDefinePrintRange
   call tAddPrintRange
   call tRemovePrintRangeByContext
   call tRemovePrintRangeByMenu
   call tNamedRangeToPrintRange
   call tEntireSheet
   call tPrintRangeMouseSelection
   
End sub
'
'---------------------------------------------------------------------------

testcase tDefinePrintRange

  dim sRangeFile
  dim sLocalFile

  sRangeFile = convertpath ( gTesttoolpath & "calc/special/input/printrange.sxc" )
  sLocalFile = convertpath ( gOfficepath & "user/work/defineprintrange." & sDefaultExtension )

'///<b>Define print range</b>

  '///+<ul><li>Load testdocument</li>
  call hDateiOeffnen ( sRangeFile )
  sleep(2)
  if NOT hSpeichernUnterMitFilterKill ( sLocalFile , sDefaultCalcFilter ) then
      warnlog "Saving test document localy failed -> Aborting"
      call hCloseDocument
      goto endsub
  endif

     '///+<li>Select area B2:E5</li>
     call fCalcSelectRange("B2:E5")
     '///+<li>Define print range by menu Format-Print Ranges-Define</li>
     FormatPrintRangesDefine
     '///+<li>Activate Page Preview (File-Page Preview)</li>
     try
        FilePageView
        sleep(2)
     '///+<li>Check if there is only one page as output</li>
        Kontext "Previewbar"
     'this try/catch is a work around because page preview doesn't know about number of pages
     'after being called.
'     try
        OL_SEITENANSICHT_NaechsteSeiteCalc
'     catch
'        warnlog "Behaviour of page preview seems to have changed"
'     endcatch
     catch
        warnlog "#i44073# - Invoking 'File::Page Preview' crashes the office"
        sleep (20)
        goto endsub
     endcatch
     'now all navigation buttons should be deactivated
     'if this is true there's only one page to print
     'that's what we check now
     printlog "Check if all navigation buttons do not work"
     printlog "True -> Only one page to print (expected result)"
     printlog "False -> BUG"
     Kontext "Previewbar"
     try
        OL_SEITENANSICHT_NaechsteSeiteCalc
        warnlog "+ There seems to be more than one page -> BUG!?"
     catch
        printlog "+ OK, 'next page' button does not work" 
     endcatch
     Kontext "Previewbar"
     try
        OL_SEITENANSICHT_VorherigeSeiteCalc
        warnlog "+ There seems to be more than one page -> BUG!?"
     catch
        printlog "+ OK, 'previous page' button does not work" 
     endcatch
     Kontext "Previewbar"
     try
        OL_SEITENANSICHT_ErsteSeiteCalc
        warnlog "+ There seems to be more than one page -> BUG!?"
     catch
        printlog "+ OK, 'first page' button does not work" 
     endcatch
     Kontext "Previewbar"
     try
        OL_SEITENANSICHT_LetzteSeiteCalc
        warnlog "+ There seems to be more than one page -> BUG!?"
     catch
        printlog "+ OK, 'last page' button does not work" 
     endcatch
     '///+<li>Close page preview</li>
     try
        FilePageView
        '///+<li>Enable View-Page Break Preview</li>
        ViewPageBreakPreview
     catch
        warnlog "#i44073# - Invoking 'File::Page Preview' crashes the office"
        sleep (20)
        goto endsub
     endcatch
     '///+<li>Select area A1:C10</li>
     call fCalcSelectRange("A1:C10")
     '///+<li>Call context Define Print Range</li>
     Kontext "DocumentCalc"
     DocumentCalc.MouseMove(5,5)
     sleep(2)
     DocumentCalc.OpenContextMenu
     sleep(2)
     printlog "+ <" & hMenuSelectNr(3) & "> was selected in context menu"
     '///+<li>Activate Page Preview (File-Page Preview)</li>
     try
         FilePageView
         sleep(2)
         '///+<li>Check if there is only one page as output</li>
         Kontext "Previewbar"
     'this try/catch is a work around because page preview doesn't know about number of pages
     'after being called.
'     try
        OL_SEITENANSICHT_NaechsteSeiteCalc
'     catch
'        warnlog "Behaviour of page preview seems to have changed"
'     endcatch
     catch
        warnlog "#i44073# - Invoking 'File::Page Preview' crashes the office"
        sleep (20)
        goto endsub
     endcatch
     'now all navigation buttons should be deactivated
     'if this is true there's only one page to print
     'that's what we check now
     printlog "Check if all navigation buttons do not work"
     printlog "True -> Only one page to print (expected result)"
     printlog "False -> BUG"
     Kontext "Previewbar"
     try
        OL_SEITENANSICHT_NaechsteSeiteCalc
        warnlog "+ There seems to be more than one page -> BUG!?"
     catch
        printlog "+ OK, 'next page' button does not work" 
     endcatch
     Kontext "Previewbar"
     try
        OL_SEITENANSICHT_VorherigeSeiteCalc
        warnlog "+ There seems to be more than one page -> BUG!?"
     catch
        printlog "+ OK, 'previous page' button does not work" 
     endcatch
     Kontext "Previewbar"
     try
        OL_SEITENANSICHT_ErsteSeiteCalc
        warnlog "+ There seems to be more than one page -> BUG!?"
     catch
        printlog "+ OK, 'first page' button does not work" 
     endcatch
     Kontext "Previewbar"
     try
        OL_SEITENANSICHT_LetzteSeiteCalc
        warnlog "+ There seems to be more than one page -> BUG!?"
     catch
        printlog "+ OK, 'last page' button does not work" 
     endcatch
     '///+<li>Close page preview</li>
     try
         FilePageView
         '///+<li>At last check if the expected print range is selected</li></ul>
         FormatPrintRangesEdit
     catch
        warnlog "#i44073# - Invoking 'File::Page Preview' crashes the office"
        sleep (20)
        goto endsub
     endcatch
     Kontext "DruckbereicheBearbeiten"
     if DruckBereich.GetText = "$A$1:$C$10" then
        printlog "Print range selection as expected"
     else
        warnlog "Expected print range is <$A$1:$C$10>, but we got: " & DruckBereich.GetText
     end if
     DruckbereicheBearbeiten.Cancel
     sleep(2)
     call hCloseDocument
endcase

'
'---------------------------------------------------------------------------
'
testcase tAddPrintRange

  dim sRangeFile
  dim sLocalFile

  sRangeFile = convertpath ( gTesttoolpath & "calc/special/input/printrange.sxc" )
  sLocalFile = convertpath ( gOfficepath & "user/work/addprintrange." & sDefaultExtension )

'///<b>Add print range</b>

  '///+<ul><li>Load testdocument</li>
     call hDateiOeffnen ( sRangeFile )
     sleep(2)
     if NOT hSpeichernUnterMitFilterKill ( sLocalFile , sDefaultCalcFilter ) then
         warnlog "Saving test document localy failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif

     '///+<li>Select area H11:J15</li>
     ViewPageBreakPreview
     call fCalcSelectRange("H11:J15")
     '///+<li>Define print range by menu Format-Print Ranges-Define</li>
     FormatPrintRangesDefine
     '///+<li>Select area E41:H55</li>
     call fCalcSelectRange("E41:H55")
     '///+<li>Add print range by menu Format-Print Ranges-Add</li>
     FormatPrintRangesAdd
     '///+<li>Select area A1:F15</li>
     call fCalcSelectRange("A1:F20")
     '///+<li>Call context Add Print Range</li>
     Kontext "DocumentCalc"
     DocumentCalc.MouseMove(5,5)
     sleep(2)
     DocumentCalc.OpenContextMenu
     sleep(2)
     printlog "+ <" & hMenuSelectNr(4) & "> was selected in context menu"
     sleep(2)
     '///+<li>Save and Reload</li>
     FileSave
     sleep(5)
     FileReload
     sleep(10)
     '///+<li>Check if the expected print range is selected</li>
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     if DruckBereich.GetText = "$H$11:$J$15;$E$41:$H$55;$A$1:$F$20" then
        printlog "Print range selection as expected"
     else
        warnlog "Expected print range is <$H$11:$J$15;$E$41:$H$55;$A$1:$F$20>, but we got: " & DruckBereich.GetText
     end if
     DruckbereicheBearbeiten.Cancel
     sleep(1)
     '///+<li>Check if the expected number of pages will be print</li></ul>
     FilePrint
     Kontext "DruckenDlg"
     Seiten.check
     if SeitenText.GetText = "1-3" then
        printlog "Pages to print as expected"
     else
        warnlog "Expected pages to print are <1-3>, but we got: " & SeitenText.GetText
     end if
     DruckenDlg.Cancel
     sleep(2)
     call hCloseDocument
endcase

'
'---------------------------------------------------------------------------
'
testcase tRemovePrintRangeByContext

     dim sRangeFile
         sRangeFile = convertpath ( gTesttoolpath & "calc/special/input/printranges_3defined.ods" )
     dim sLocalFile
         sLocalFile = convertpath ( gOfficepath & "user/work/removeprintrange." & sDefaultExtension )
'///<b>Remove print range using the context menu</b>///
     '///<ul>
     '///<li>Open test document '.../calc/special/input/printranges_3defined.ods'</li>///
     call hDateiOeffnen ( sRangeFile )
     sleep(2)
     '///<li>Save file locally '.../user/work/removeprintrange.ods'</li>///
     if NOT hSpeichernUnterMitFilterKill ( sLocalFile , sDefaultCalcFilter ) then
         warnlog "Saving test document localy failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif

     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if print range is '$H$11:$J$15;$E$41:$H$55;$A$1:$F$20'</li>///
     if DruckBereich.GetText = "$H$11:$J$15;$E$41:$H$55;$A$1:$F$20" then
        printlog "Print range selection as expected"
     else
        warnlog "Expected print range is <$H$11:$J$15;$E$41:$H$55;$A$1:$F$20>, but we got: " & DruckBereich.GetText
     end if
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     
     Kontext "DocumentCalc"
     '///<li>Click in right buttom corner</li>///
     call gMouseClick ( 95, 95 )
     sleep(2)
     '///<li>Open context menu</li>///
     DocumentCalc.OpenContextMenu
     sleep(2)
     '///<li>Select 'Undo Print Range' in context menu</li>///
     printlog "+ <" & hMenuSelectNr ( 7 ) & "> was selected in context menu"
     
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if no print range is defined</li>///
     if DruckBereich.GetText = "" then
        printlog "No print range selected as expected"
     else
        warnlog "Expected print range is <EMPTY>, but we got: " & DruckBereich.GetText
     end if
     DruckbereicheBearbeiten.Cancel

     sleep(2)
     '///<li>Close document</li>///
     call hCloseDocument
     '///</ul>

endcase

'
'---------------------------------------------------------------------------
'
testcase tRemovePrintRangeByMenu

     dim sRangeFile
         sRangeFile = convertpath ( gTesttoolpath & "calc/special/input/printranges_3defined.ods" )
     dim sLocalFile
         sLocalFile = convertpath ( gOfficepath & "user/work/removeprintrange." & sDefaultExtension )
'///<b>Remove print range using the menu</b>///
     '///<ul>
     '///<li>Open test document '.../calc/special/input/printranges_3defined.ods'</li>///
     call hDateiOeffnen ( sRangeFile )
     sleep(2)
     '///<li>Save file locally '.../user/work/removeprintrange.ods'</li>///
     if NOT hSpeichernUnterMitFilterKill ( sLocalFile , sDefaultCalcFilter ) then
         warnlog "Saving test document localy failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif
     
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if print range is '$H$11:$J$15;$E$41:$H$55;$A$1:$F$20'</li>///
     if DruckBereich.GetText = "$H$11:$J$15;$E$41:$H$55;$A$1:$F$20" then
        printlog "Print range selection as expected"
     else
        warnlog "Expected print range is <$H$11:$J$15;$E$41:$H$55;$A$1:$F$20>, but we got: " & DruckBereich.GetText
     end if
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     
     Kontext "DocumentCalc"
     '///<li>Invoke Format::Print Ranges::Remove</li>///
     FormatPrintRangesRemove
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     '///<li>Check if no print range is defined</li>///
     Kontext "DruckbereicheBearbeiten"
     if DruckBereich.GetText = "" then
        printlog "No print range selected as expected"
     else
        warnlog "Expected print range is <EMPTY>, but we got: " & DruckBereich.GetText
     end if
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     '///<li>Undo removal</li>///
     EditUndo
     
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if print range is '$H$11:$J$15;$E$41:$H$55;$A$1:$F$20'</li>///
     if DruckBereich.GetText = "$H$11:$J$15;$E$41:$H$55;$A$1:$F$20" then
        printlog "Print range selection as expected"
     else
        warnlog "Expected print range is <$H$11:$J$15;$E$41:$H$55;$A$1:$F$20>, but we got: " & DruckBereich.GetText
     end if
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     '///<li>Redo removal</li>///
     EditRedo
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if no print range is defined</li>///
     if DruckBereich.GetText = "" then
        printlog "No print range selected as expected"
     else
        warnlog "Expected print range is <EMPTY>, but we got: " & DruckBereich.GetText
     end if
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     '///<li>Undo removal</li>///
     EditUndo
     '///<li>File::Save</li>///
     FileSave

     sleep(2)
     '///<li>Close document</li>///
     call hCloseDocument
     sleep(2)
     '///<li>Re-open document</li>///
     call hDateiOeffnen ( sLocalFile )
     sleep(2)
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if print range is '$H$11:$J$15;$E$41:$H$55;$A$1:$F$20'</li>///
     if DruckBereich.GetText = "$H$11:$J$15;$E$41:$H$55;$A$1:$F$20" then
        printlog "Print range selection as expected"
     else
        warnlog "Expected print range is <$H$11:$J$15;$E$41:$H$55;$A$1:$F$20>, but we got: " & DruckBereich.GetText
     end if
     
     DruckbereicheBearbeiten.Cancel
     '///<li>Cancel print range dialog</li>///
     sleep(2)
     '///<li>Close document</li>///
     call hCloseDocument
     '///</ul>

endcase

'
'---------------------------------------------------------------------------
'
testcase tNamedRangeToPrintRange

     dim sLocalFile as STRING
         sLocalFile = convertpath ( gOfficepath & "user/work/namedRange." & sDefaultExtension )
     dim sAnotherFile as STRING
         sAnotherFile = convertpath ( gOfficepath & "user/work/namedRange1." & sDefaultExtension )
     dim sLocalFileXLS as STRING
         sLocalFileXLS = convertpath ( gOfficepath & "user/work/namedRange.xls" )
     dim sFormatXLS as STRING
         sFormatXLS = fGetCalcFiltername ( "xls97" ) 
     dim sRangeToSelect as STRING
         sRangeToSelect = "$B$3:$D$5"
     dim sRangeName as STRING
         sRangeName = "NamedRange"
     dim sNewRangeToSelect as STRING
         sNewRangeToSelect = "$C$4:$E$6"
'///<b>Use named range as print range</b>///
     '///<ul>
     '///<li>Open new document</li>///
     call hNewDocument
     '///<li>Select range '$B$3:$D$5'</li>///
     fCalcSelectRange ( sRangeToSelect )
     '///<li>Name this range 'NamedRange'</li>///
     fCalcNameRange ( sRangeName )
     '///<li>Invoke Insert::Names::Define</li>///     
     InsertNamesDefine
     Kontext "NamenFestlegen"
     '///<li>Select previously defined range</li>///
     BereichsName.typekeys "N"
     '///<li>Click 'More' button</li>///
     Zusaetze.Click
     '///<li>Check 'Print range'</li>///
     Druckbereich.Check
     '///<li>Click OK</li>///
     NamenFestlegen.OK
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Select 'NamedRange' as print range</li>///
     DruckbereichListe.select ( sRangeName )
     '///<li>Check if this is item no.5</li>///
     if NOT DruckbereichListe.getSelIndex = 5 then
         warnlog "Unexpected selection for 'print range' listbox"
     endif
     '///<li>Check if the according string is '$B$3:$D$5'</li>///
     if Druckbereich.getText <> sRangeToSelect then
         warnlog "Unexpected string in 'print range' textbox"
     endif
     '///<li>Click OK</li>///
     DruckbereicheBearbeiten.OK
     '///<li>Save file locally '.../user/work/namedRange.ods'</li>///
     if NOT hSpeichernUnterMitFilterKill ( sLocalFile , sDefaultCalcFilter ) then
         warnlog "Saving test document localy failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif
     '///<li>Close document</li>///
     call hCloseDocument
     sleep(2)
     '///<li>Open document</li>///
     call hDateiOeffnen ( sLocalFile )
     sleep(2)
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if item no.5 is selected as print range</li>///
     if DruckbereichListe.getSelIndex <> 5 then
         warnlog "Unexpected selection for 'print range' listbox"
     endif
     '///<li>Check if 'NamedRange' is selected as print range</li>///
     if DruckbereichListe.getSelText <> sRangeName then
         warnlog "Unexpected selection for 'print range' listbox"
     endif
     '///<li>Check if the according string is '$B$3:$D$5'</li>///
     if Druckbereich.getText <> sRangeToSelect then
         warnlog "Unexpected string in 'print range' textbox"
     endif
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     '///<li>Save filein Excel97/2000/XP format '.../user/work/namedRange.xls'</li>///
     if NOT hSpeichernUnterMitFilterKill ( sLocalFileXLS , sFormatXLS ) then
         warnlog "Saving test document localy failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif
     '///<li>Close document</li>///
     call hCloseDocument
     sleep(2)
     '///<li>Open document</li>///
     call hDateiOeffnen ( sLocalFileXLS )
     sleep(2)
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if item no.5 is selected as print range</li>///
     if DruckbereichListe.getSelIndex <> 5 then
         warnlog "Unexpected selection for 'print range' listbox"
     endif
     '///<li>Check if the according string is '$B$3:$D$5'</li>///
     if Druckbereich.getText <> sRangeToSelect then
         warnlog "Unexpected string in 'print range' textbox"
     endif
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     '///<li>Invoke Insert::Names::Define</li>/// 
     InsertNamesDefine
     Kontext "NamenFestlegen"
     '///<li>Select entry 'NamedRange'</li>///
     BereichsName.typekeys "N"
     '///<li>Assign new range, '$C$4:$E$6'</li>///
     ZugeordnetZu.SetText ( sNewRangeToSelect )
     '///<li>Click 'More'</li>///
     Zusaetze.Click
     '///<li>Check 'Print range'</li>///
     Druckbereich.Check
     '///<li>Click OK</li>///
     NamenFestlegen.OK
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Select 'NamedRange' as print range</li>///
     DruckbereichListe.select ( sRangeName )
     '///<li>Check if this is item no.6</li>///
     if NOT DruckbereichListe.getSelIndex = 6 then
         warnlog "Unexpected selection for 'print range' listbox"
     endif
     '///<li>Check if the according string is '$C$4:$E$6'</li>///
     if Druckbereich.getText <> sNewRangeToSelect then
         warnlog "Unexpected string in 'print range' textbox"
     endif
     '///<li>Click OK</li>///
     DruckbereicheBearbeiten.OK
     '///<li>Save file locally '.../user/work/namedRange1.ods'</li>///
     if NOT hSpeichernUnterMitFilterKill ( sAnotherFile , sDefaultCalcFilter ) then
         warnlog "Saving test document localy failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif
     '///<li>Close document</li>///
     call hCloseDocument
     sleep(2)
     '///<li>Open document again</li>///
     call hDateiOeffnen ( sAnotherFile )
     sleep(2)
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if item no.6 is selected as print range</li>///
     if DruckbereichListe.getSelIndex <> 6 then
         warnlog "Unexpected selection for 'print range' listbox"
     endif
     '///<li>Check if 'NamedRange' is selected as print range</li>///
     if DruckbereichListe.getSelText <> sRangeName then
         warnlog "Unexpected selection for 'print range' listbox"
     endif
     '///<li>Check if the according string is '$C$4:$E$6'</li>///
     if Druckbereich.getText <> sNewRangeToSelect then
         warnlog "Unexpected string in 'print range' textbox"
     endif
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     '///<li>Close document</li>///
     call hCloseDocument
     '///</ul>
endcase

'
'---------------------------------------------------------------------------
'
testcase tEntireSheet

     dim sRangeFile as STRING
         sRangeFile = convertpath ( gTesttoolpath & "calc/special/input/printrange.xls" )
     dim sLocalFile as STRING
         sLocalFile = convertpath ( gOfficepath & "user/work/entireSheet." & sDefaultExtension )
     dim sLocalFileXLS as STRING
         sLocalFileXLS = convertpath ( gOfficepath & "user/work/entireSheet.xls" )
     dim sFormatXLS as STRING
         sFormatXLS = fGetCalcFiltername ( "xls97" ) 
'///<b>Check print range option 'Entire Sheet'</b>///     
     '///<ul>
     '///<li>Open test document '.../calc/special/input/printrange.xls'</li>///
     call hDateiOeffnen ( sRangeFile )
     sleep(2)
     '///<li>Save file locally '.../user/work/entireSheet.ods'</li>///
     if NOT hSpeichernUnterMitFilterKill ( sLocalFile , sDefaultCalcFilter ) then
         warnlog "Saving test document localy failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif
     '///<li>Select second sheet</li>///
     if NOT fCalcSelectSheet ( 2 ) then
         warnlog "Selecting sheet no. 2 failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if item no.2 (should be 'entire sheet') is selected in print range listbox</li>///
     if DruckbereichListe.getSelIndex = 2 then
        printlog "OK, print range is '- entire sheet -'"
     else
        warnlog "Unexpected print range defined -> Check this out!"
     endif
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     '///<li>Close document</li>///
     call hCloseDocument
     sleep(2)
     '///<li>Open document</li>///
     call hDateiOeffnen ( sLocalFile )
     sleep(2)
     '///<li>Select second sheet</li>///
     if NOT fCalcSelectSheet ( 2 ) then
         warnlog "Selecting sheet no. 2 failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if item no.2 (should be 'entire sheet') is selected in print range listbox</li>///
     if DruckbereichListe.getSelIndex = 2 then
        printlog "OK, print range is '- entire sheet -'"
     else
        warnlog "Unexpected print range defined -> Check this out!"
     endif
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     '///<li>Save filein Excel97/2000/XP format '.../user/work/entireSheet.xls'</li>///
     if NOT hSpeichernUnterMitFilterKill ( sLocalFileXLS , sFormatXLS ) then
       warnlog "Saving test document localy failed -> Aborting"
       call hCloseDocument
       goto endsub
     endif
     '///<li>Close document</li>///
     call hCloseDocument
     sleep(2)
     '///<li>Open document again</li>///
     call hDateiOeffnen ( sLocalFileXLS )
     sleep(2)
     '///<li>Select second sheet</li>///
     if NOT fCalcSelectSheet ( 2 ) then
         warnlog "Selecting sheet no. 2 failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check if item no.2 (should be 'entire sheet') is selected in print range listbox</li>///
     if DruckbereichListe.getSelIndex = 2 then
        printlog "OK, print range is '- entire sheet -'"
     else
        warnlog "Unexpected print range defined -> Check this out!"
     endif
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     '///<li>Close document</li>///
     call hCloseDocument
     '///</ul>

endcase

'
'---------------------------------------------------------------------------
'
testcase tPrintRangeMouseSelection
     dim sLocalFile as STRING
         sLocalFile = convertpath ( gOfficepath & "user/work/mouseSelection." & sDefaultExtension )
     dim sSelectedRange as STRING
     dim sSelectedRows as STRING
     dim sSelectedColumns as STRING
'///<b>Selecting print ranges using the mouse</b>///
     '///<ul>
     '///<li>Open new document</li>///
     call hNewDocument
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     '///<li>Check if all settings are in initial state</li>///
     Kontext "DruckbereicheBearbeiten"
     if NOT DruckbereichListe.getSelIndex = 1 then
         warnlog "Unexpected selection for 'print range' listbox"
     endif
     if NOT WiederholungszeileListe.getSelIndex = 1 then
         warnlog "Unexpected selection for 'rows to repeat' listbox"
     endif
     if NOT WiederholungsspalteListe.getSelIndex = 1 then
         warnlog "Unexpected selection for 'columns to repeat' listbox"
     endif
     if Druckbereich.getText <> "" then
         warnlog "Unexpected string in 'print range' textbox"
     endif
     if Wiederholungszeile.getText <> "" then
         warnlog "Unexpected string in 'rows to repeat' textbox"
     endif
     if Wiederholungsspalte.getText <> "" then
         warnlog "Unexpected string in 'columns to repeat' textbox"
     endif
     sleep(1)
     '///<li>Click print range button to shrink dialog</li>///
     DruckbereichButton.typekeys "<RETURN>"
     sleep(1)
     Kontext "DocumentCalc"
     '///<li>Select print range using mouse</li>///
     DocumentCalc.MouseDown ( 20 , 20 )
     DocumentCalc.MouseMove ( 60 , 60 )
     DocumentCalc.MouseUp ( 60 , 60 )
     sleep(1)
     Kontext "DruckbereicheBearbeiten"
     '///<li>Click print range button to unshrink dialog again</li>///
     DruckbereichButton.typekeys "<RETURN>"
     '///<li>Rember to selection for later comparisson</li>///
     sleep(1)
     sSelectedRange = Druckbereich.getText
     '///<li>Click 'rows to repeat' button to shrink dialog</li>///
     WiederholungszeileButton.typekeys "<RETURN>"
     sleep(1)
     Kontext "DocumentCalc"
     '///<li>Select 'rows to repeat' using mouse</li>///
     DocumentCalc.MouseDown ( 10 , 10 )
     DocumentCalc.MouseMove ( 15 , 30 )
     DocumentCalc.MouseUp ( 15 , 30 )
     sleep(1)
     Kontext "DruckbereicheBearbeiten"
     '///<li>Click 'rows to repeat' button to unshrink dialog again</li>///
     WiederholungszeileButton.typekeys "<RETURN>"
     sleep(1)
     '///<li>Rember to selection for later comparisson</li>///
     sSelectedRows = Wiederholungszeile.getText
     '///<li>Click 'columns to repeat' button to shrink dialog</li>///
     WiederholungsspalteButton.typekeys "<RETURN>"
     sleep(1)
     Kontext "DocumentCalc"
     '///<li>Select 'columns to repeat' using mouse</li>///
     DocumentCalc.MouseDown ( 10 , 10 )
     DocumentCalc.MouseMove ( 50 , 15 )
     DocumentCalc.MouseUp ( 50 , 15 )
     sleep(1)
     Kontext "DruckbereicheBearbeiten"
     '///<li>Click 'columns to repeat' button to unshrink dialog again</li>///
     WiederholungsspalteButton.typekeys "<RETURN>"
     sleep(1)
     '///<li>Rember to selection for later comparisson</li>///
     sSelectedColumns = Wiederholungsspalte.getText
     sleep(1)
     '///<li>Click OK</li>///
     DruckbereicheBearbeiten.OK
     sleep(1)
     '///<li>Save file locally '.../user/work/mouseSelection.ods'</li>///
     if NOT hSpeichernUnterMitFilterKill ( sLocalFile , sDefaultCalcFilter ) then
         warnlog "Saving test document localy failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif
     
     sleep(2)
     '///<li>Close document</li>///
     call hCloseDocument
     sleep(2)
     '///<li>Open document again</li>///
     call hDateiOeffnen ( sLocalFile )
     sleep(2)
     '///<li>Invoke Format::Print Ranges::Edit</li>///
     FormatPrintRangesEdit
     Kontext "DruckbereicheBearbeiten"
     '///<li>Check persistance of all settings</li>///
     if NOT DruckbereichListe.getSelIndex = 3 then
         warnlog "Unexpected selection for 'print range' listbox: Item No. " & DruckbereichListe.getSelIndex
     endif
     if NOT WiederholungszeileListe.getSelIndex = 2 then
         warnlog "Unexpected selection for 'rows to repeat' listbox: Item No. " & WiederholungszeileListe.getSelIndex
     endif
     if NOT WiederholungsspalteListe.getSelIndex = 2 then
         warnlog "Unexpected selection for 'columns to repeat' listbox: Item No. " & WiederholungsspalteListe.getSelIndex
     endif
     if Druckbereich.getText <> sSelectedRange then
         warnlog "Unexpected selection in 'print range' textbox"
         qaErrorLog "Found:  " & Druckbereich.getText
         qaErrorLog "Should: " & sSelectedRange
     endif
     if Wiederholungszeile.getText <> sSelectedRows then
         warnlog "Unexpected selection in 'rows to repeat' textbox"
         qaErrorLog "Found:  " & Wiederholungszeile.getText
         qaErrorLog "Should: " & sSelectedRows
     endif
     if Wiederholungsspalte.getText <> sSelectedColumns then
         warnlog "Unexpected selection in 'columns to repeat' textbox"
         qaErrorLog "Found:  " & Wiederholungsspalte.getText
         qaErrorLog "Should: " & sSelectedColumns
     endif
     '///<li>Cancel print range dialog</li>///
     DruckbereicheBearbeiten.Cancel
     '///<li>Close document</li>///
     call hCloseDocument
     '///</ul>
endcase

