'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_tool_1.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:00:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Base Routines for Calc Tests
'*
'**************************************************************************************************
'*                                                                **
' #1 Extract_String
' #1 extractFilename
' #1 getFilename
' #1 replaceCharacter
' #1 atAuswertung
' #1 atFehlertest
' #1 atListeBereich
' #1 atBereichsUebernahme
' #1 atBereichsvergleich
' #1 atZuruecknehmen
' #1 atMarkierenHome
' #1 atBereicheanlegen
' #1 sbeep
'*                                                                **
'\******************************************************************

function Extract_String (strText as string, strchar as string, optional align as boolean)

        dim i, k as integer
        dim resString as string
        i = 1
        k = len(strText)
        if k = 0 then
                printlog "Fealure in the searchstring, the len of it is 0!"
                exit function
        end if
        while str(mid(strText,i,1))<> strchar
                i = i + 1
                if i = k then
                        printlog "Search string " & chr(34) & strchar & chr(34) & " not found!"
                        exit function
                end if
        wend
        if align = true then
                resString = left(strText, i-1)
        else
                resString = right(strText, k-i)
        end if
        Extract_String = resString

end function

'///

function extractFilename(strText as string) as string
' extract the filename from an input string without the extension

        dim number, k as integer, ps as integer
        dim fname as string

        if gplatgroup = "unx" then
                ps = asc("/")
        else
                ps = asc("\")
        end if
        number = len(strText)
        k = 0

        while asc(mid(strText, number-k, 1)) <> ps
                k = k + 1
        wend
        fname = right(strText, k)
        k = 1
        while asc(mid(fname, k, 1)) <> 46 ' asciicode for the point "."
                k = k + 1
        wend
        fname = left(fname, k-1)
        extractFilename = fname

end function

function getFilename(i as integer) as string
' extract the filename from the string "lsliste(i)"
    dim fname as String
        dim number, k as integer
        if gplatgroup = "unx" then
                ps = asc("/")
        else
                ps = asc("\")
        end if
        number = len(lsliste(i))
        k = 0

        while asc(mid(lsliste(i), number-k, 1)) <> ps
                k = k + 1
        wend
        fname = right(lsliste(i), k)
        k = 1
        while asc(mid(fname, k, 1)) <> 46 ' asciicode for the point "."
                k = k + 1
        wend
        fname = left(fname, k-1)
        filename = fname
        printlog "filename : " & filename

end function

function replaceCharacter(InputString as String, SString as String, RString as String) as String
'/// This function replace in a given String the appropriate given Characters
        dim i as integer
        dim Result as String
        Result = ""
        dim Character(1 to 100) as String
        for i = 1 to len(InputString)
                Character(i) = mid(InputString, i, 1)
                if Character(i) = SString then
                        Character(i) = RString
                end if
        next i
        for i = 1 to len(InputString)
                Result = Result & Character(i)
        next i
        replaceCharacter = Result

end function

'***************************************
'*** Auswertung von Optionseinstellungen
'***************************************
sub atAuswertung (Zustand1,Zustand2,Optionsname)
Dim V_Kommentar as String
Zustand = Zustand1-Zustand2
  if Zustand = 2 then
    V_Kommentar = Optionsname + " at the 1.run ON at the 2.run Off" '*** richtig
    'WarnLog V_Kommentar
  elseif Zustand = 1 then
    V_Kommentar = Optionsname + " at the 1.run Off at the 2.run Off"
    WarnLog V_Kommentar
  elseif Zustand = 0 then
    V_Kommentar = Optionsname + " at the 1.run On at the 2.run On"
    WarnLog V_Kommentar
  else
    V_Kommentar = Optionsname + " at the 1.run Off at the 2.run On"
    WarnLog V_Kommentar
  end if
end sub



'***********************************************
'*** Zum testen der moeglichen Einstellungen ***
'***********************************************
sub atFehlertest
  print "At first make the modifies, the click OK and it is going on"
end sub



'***************************************
'*** Pruefung der Bereichsuebernahme ***
'***************************************
sub atBereichsUebernahme (Bereich0 ,Bereich1 ,V_Kommentar)
  try
    Bereichsname.select Bereich0
      if ZugeordnetZu.Gettext = Bereich1 then
        'printlog V_Kommentar + " Ok"   '***richtig
      else
        warnlog V_Kommentar + " The assigned area isn't correct"
      end if
  catch
    warnlog V_Kommentar + " it isn't taken over"
  endcatch
end sub



'**************************************
'*** Liste aus Bereich.sdc einlesen ***
'**************************************
sub atListeBereich (Zustand1)
Dim Transporter(20) as String
Dim V_Kommentar as string

'** Transporterleeren
for Zustand = 1 to 20
  ListDelete( Transporter(), Zustand )
next Zustand

  Kontext "DocumentCalc"
  DocumentCalc.TypeKeys "<Up><Left>",50
  DocumentCalc.TypeKeys "<Down>",10

  for Zustand = 1 to 5
    DocumentCalc.TypeKeys "<Right>",1
        EditCopy
      ListAppend( Transporter(), GetClipboardText )
  next Zustand

  Kontext "DocumentCalc"
  DocumentCalc.TypeKeys "<Left>",5
  DocumentCalc.TypeKeys "<Down>",2

  for Zustand = 1 to 5
    DocumentCalc.TypeKeys "<Right>",1
        EditCopy
      ListAppend( Transporter(), GetClipboardText )
  next Zustand

  Kontext "DocumentCalc"
  DocumentCalc.TypeKeys "<Left>",3

  for Zustand = 1 to 4
    DocumentCalc.TypeKeys "<Down>",1
        EditCopy
      ListAppend( Transporter(), GetClipboardText )
  next Zustand

  Kontext "DocumentCalc"
  DocumentCalc.TypeKeys "<Down>",2
      EditCopy
    ListAppend( Transporter(), GetClipboardText )


'***Transporter hintereinandersetzen
V_Kommentar = ""
  for Zustand = 1 to Listcount(Transporter())
    V_Kommentar = V_Kommentar + " " + Transporter(Zustand)
  next Zustand

'*** Transporter auf Fehler durchsuchen
  for Zustand = 1 to Listcount(Transporter())
    if Transporter(Zustand) = "Ok" then
      Zustand2 = 0
    elseif Transporter(Zustand) = "Failure" then
      Zustand2 = 1
      Zustand = Listcount(Transporter())
    else
      Zustand2 = 1
      Zustand = Listcount(Transporter())
    end if
  next Zustand

'*** Fehler schreiben
if Zustand2 = 0 then
  'V_Kommentar = "run" + Zustand1 + ": " + V_Kommentar
  'Printlog V_Kommentar
else
  V_Kommentar = "run" + Zustand1 + ": " + V_Kommentar
  Warnlog V_Kommentar
end if
end sub


'****************************
'*** Bereiche vergleichen ***
'****************************
sub atBereichsvergleich(Bereich0,Bereich1,Bereich2)     '(BereichsName,Bereich org,Bereich gel)
  InsertNamesDefine
  Kontext "NamenFestlegen"
    Bereichsname.select Bereich0
      if ZugeordnetZu.gettext = Bereich1 then
        V_Kommentar = Bereich0 + " not adapted"
        WarnLog V_Kommentar
      elseif ZugeordnetZu.gettext = Bereich2 then
        'V_Kommentar = Bereich0 + " korrekt angepasst"  '***richtig
        'Printlog V_Kommentar
      else
        V_Kommentar = Bereich0 + " it's not clear why the area was modified"
        WarnLog V_Kommentar
      end if
  NamenFestlegen.cancel
end sub


'***************************
'*** Rueckgaengig machen ***
'***************************
sub atZuruecknehmen
  try
    EditUndo
  catch
  endcatch
'call atFehlertest
end sub

'*******************
'*** Wiederholen ***
'*******************
sub atNochmal
  try
    EditRedo
  catch
  endcatch
'call atFehlertest
end sub

'*********************
'*** Drei Bereiche ***
'*********************
sub atBereicheanlegen
    Kontext
    call ZellenMarkieren (2,2)
      InsertNamesDefine
        Kontext "NamenFestlegen"
          BereichsName.SetText "A1B21"
            ZugeordnetZu.setText "1701"
          Hinzufuegen.Click
        NamenFestlegen.Ok

  Kontext
  DocumentCalc.Typekeys "<Down><Right>",3
    call ZellenMarkieren (1,3)
      InsertNamesDefine
        Kontext "NamenFestlegen"
          BereichsName.SetText "E5G52"
        NamenFestlegen.Ok

  Kontext
  DocumentCalc.Typekeys "<Left><Up>",3
    call ZellenMarkieren (3,2)
      InsertNamesDefine
        Kontext "NamenFestlegen"
          BereichsName.SetText "D2E43"
        NamenFestlegen.Ok
end sub

'**************************
'*** Markieren und Home ***
'**************************
sub atMarkierenHome
  call atgehezuA1
  call ZellenMarkieren 4,4
  call atgehezuA1
end sub

'****************************************************************
'*** Protokoliert die Größe der Auslagerungsdatei
'***   benötigt die Batchdatei c:\programme\stapel\swapper.bat,
'***   die mit DIR die Größe der Datei WIN386.SWP in die Datei
'***   D:\temp\swapper.log schreibt
'****************************************************************

sub swapgroesse
Dim IsList(25) as String
Dim i
Dim Swapper
Dim wh
Dim wdh
Dim swap
Dim schwabbel as Double

for wh = 1 to 3

Shell (gTesttoolpath & "\Bas\calc\Batch\swapper.bat")
  sleep 2
listread (IsList(),"d:\swapper.log")
swapper = mid((IsList(1)),13,len((IsList(1))))

For wdh = 1 to len(swapper)
  if mid(swapper,wdh,1) = ":" then
    swapper = Left(swapper,wdh-15
  else
    swapper = swapper
  end if
next wdh

For wdh = 1 to len(swapper)
  if mid(swapper,wdh,1) = " " then
    swapper = mid(swapper,wdh+1,len(swapper))
  else
    swapper = swapper
  end if
next wdh

For wdh = 1 to len(swapper)
  if mid(swapper,wdh,1) = "." then
    swap = swap
  else
    swap = swap + mid(swapper,wdh,1)
  end if
next wdh

Schwabbel = Val(swap) / 1048576

if Schwabbel > 0 then
  printlog "Size of the swapfile: " + Schwabbel + " MB um " + Time
  wh = 3
end if
next wh

end sub

'****************************************************************
'*** Warten inAbhängigkeit zur Größeder der Auslagerungsdatei
'****************************************************************

sub swapWait
Dim swIsList(25) as String
Dim Swapper
Dim wdh
Dim wh
Dim swap
Dim schwabbel as Double

for wh = 1 to 10

Shell ("c:\programme\stapel\swapper.bat")
listread (swIsList(),"c:\temp\swapper.log")
swapper = mid((swIsList(1)),13,len((swIsList(1))))

For wdh = 1 to len(swapper)
  if mid(swapper,wdh,1) = ":" then
    swapper = Left(swapper,wdh-15
  else
    swapper = swapper
  end if
next wdh

For wdh = 1 to len(swapper)
  if mid(swapper,wdh,1) = " " then
    swapper = mid(swapper,wdh+1,len(swapper))
  else
    swapper = swapper
  end if
next wdh

For wdh = 1 to len(swapper)
  if mid(swapper,wdh,1) = "." then
    swap = swap
  else
    swap = swap + mid(swapper,wdh,1)
  end if
next wdh
Schwabbel = Val(swap)

if Schwabbel > 31457280 then
  sleep (10)
else
  wh = 10
end if
  next wh
end sub

'****************************************************************
'*** Piept drei mal
'****************************************************************

sub sbeep
 beep
 wait 700
 beep
 wait 700
 beep
end sub


'****************************************************************
'*** This sub inserts 5 contents with different formattings in
'*** the cells which are following the indicated cell downward.
'*** As returnvalue you recieves the cellformat
'****************************************************************
'*** needed files: inc\c_tool.inc: cgotoCell


sub atinsertcontent6 (Celladdress)

        dim lng as integer
        dim lngentry as integer
        dim date_sep as string

        printlog " - Insert contents!"

        DocumentCalc.TypeKeys "<Mod1 Home>"
        DocumentCalc.TypeKeys "<Mod1 Shift down>"
        printlog "iSystemSprache " & iSystemsprache

'        if iSystemsprache <> 01 then
'           QAErrorLog "This testcase is designed to work on en_US locales. " &_
'           "You may get 6 warnlogs now."
        ' if iSystemsprache <> 49 then
' 
                ' FormatCells
                ' ' Set the language to german
                ' Kontext
        ' active.setpage TabZahlen
        ' Kontext "TabZahlen"
        ' select case iSprache
                ' case 01:      lngentry = 36
                ' case 46:      lngentry = 71
                        ' case 49:      lngentry = 12
                        ' case 88:      lngentry = 16
                        ' case 82:      lngentry = 8
                        ' case else : warnlog "There is no adjustmane for language: " & iSprache
                                                ' lngentry = 8
        ' end select
        ' Sprache.Select lngentry               ' Set language to german
        ' printlog "Selected language for CellFormat is: " &  Sprache.getSelText
        ' TabZahlen.OK
'        end if

        cgotoCell(Celladdress)
        Kontext
        DocumentCalc.TypeKeys "01/01/99<down>100<down>Text<down>"
        DocumentCalc.TypeKeys "$55.25"
        DocumentCalc.TypeKeys "<down>"
        DocumentCalc.TypeKeys "75%<down>10:15<return>"

        cgotocell(Celladdress)

end sub

'****************************************************************
'*** This sub checks the right format of the sub "atinsertcontent6"
'****************************************************************
'*** needed files: inc\C_Tool.inc: cgotoCell, wobinich
'*** Note: This sub functions only if the office language is the same as the
'*** system language

'-------------------------------------------------------------------------

sub atinsertcontent6chk(sCelladdress AS String)

        dim i, lng As Integer
        dim vl_format$(1 to 6)

        printlog " - Checking cellformat!"

' The following lines were remarked, because it isn't possible to check all possibilities in depending
' of all kinds of platforms, officelanguages, systemlanguages, multikulti officeversion or one language officeversion

'       if iSystemSprache = 01 then
'                       vl_format$(1) = "M/D/YY"        'English(US)
'                       vl_format$(2) = "General"
'                       vl_format$(3) = "General"
'                       vl_format$(4) = "#,##0.00 DM;[ROT]-#,##0,00 DM"
'                       vl_format$(5) = "0.00%"
'                       vl_format$(6) = "HH:MM:SS"
'       end if

'       if iSystemSprache = 33 then
'                       vl_format$(1) = "JJ/MM/AAAA"    'French
'                       vl_format$(2) = "Standard"
'                       vl_format$(3) = "Standard"
'                       vl_format$(4) = "#.##0,00 [$DM-407];[RED]-#.##0,00 [$DM-407]"
'                       vl_format$(5) = "0,00%"
'                       vl_format$(6) = "HH:MM:SS"
'       end if


'       if iSystemSprache = 34 then
'                       vl_format$(1) = "D/MM/AA"       'Spanish
'                       vl_format$(2) = "Estandar"
'                       vl_format$(3) = "Estandar"
'                       vl_format$(4) = "#.##0,00 [$DM-407];[RED]-#.##0,00 [$DM-407]"
'                       vl_format$(5) = "0,00%"
'                       vl_format$(6) = "HH:MM:SS"
'       end if

'       if iSystemSprache = 39 then
'                       vl_format$(1) = "GG/MM/AA"      'Italian
'                       vl_format$(2) = "Standard"
'                       vl_format$(3) = "Standard"
'                       vl_format$(4) = "#.##0,00 [$DM-407];[RED]-#.##0,00 [$DM-407]"
'                       vl_format$(5) = "0,00%"
'                       vl_format$(6) = "HH:MM:SS"
'       end if

'       if iSystemSprache = 46 then
'                       vl_format$(1) = "YYYY-MM-DD"    'Swedish
'                       vl_format$(2) = "Standard"
'                       vl_format$(3) = "Standard"
'                       vl_format$(4) = "#.##0,00 [$DM-407];[RED]-#.##0,00 [$DM-407]"
'                       vl_format$(5) = "0,00%"
'                       vl_format$(6) = "HH.MM.SS"
'       end if

'        if iSystemSprache = 01 then
'        if iSystemSprache = 49 then
           vl_format$(1) = "MM/DD/YY"      
           vl_format$(2) = "General"
           vl_format$(3) = "General"
           vl_format$(4) = "[$$-409]#,##0.00;[RED]-[$$-409]#,##0.00"
           vl_format$(5) = "0.00%"
           vl_format$(6) = "HH:MM:SS AM/PM"
        ' else
           ' vl_format$(1) = "TT.MM.JJ"      'General
           ' vl_format$(2) = "Standard"
           ' vl_format$(3) = "Standard"
           ' vl_format$(4) = "[$€-C07] #.##0,00;[ROT]-[$€-C07] #.##0,00"
           ' vl_format$(5) = "0,00%"
           ' vl_format$(6) = "HH:MM:SS"
        ' end if


        cgotoCell(sCelladdress)
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Shift down>"
        DocumentCalc.TypeKeys "<Mod1 Home>"

        for i = 1 to 6
                FormatCells
                Kontext
        active.setpage TabZahlen
        Kontext "TabZahlen"
        dim FCode as String
        FCode = FormatCode.GetText
        if FormatCode.GetText <> vl_format$(i) then
                TabZahlen.OK
                warnlog " The cellformat of cell " & wobinich & " is " & FCode & " instead of " & vl_format$(i)
                Kontext "DocumentCalc"
                DocumentCalc.TypeKeys "<down>"
        else
                TabZahlen.OK
                Kontext "DocumentCalc"
                DocumentCalc.TypeKeys "<down>"
        end if
    next i

         Kontext

end sub

'****************************************************************
'*** This sub insert a table in a calcdocument
'****************************************************************

sub atinserttable

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<right>Jan<right>Feb<right>Mar<return>11<left>"
        DocumentCalc.TypeKeys "8<left>6<left>Nord<return>Süd<right>9<right>12"
        DocumentCalc.TypeKeys "<right>11<return>14<left>8<left>7<left>West<return>"
        DocumentCalc.TypeKeys "<up>",4

end sub

' ** GetFileListName( sPath$, sMatch$ ,lsFile() as String  )
' **
' ** Input  : sPath$ = das Verzeichnis welches nach Dateien durchsucht werden soll
' **            sMatch$ = Suchoperator, es kann auch '*.*' eingegeben werden, dann wird nach allen Dateien gesucht
' **            lsFile() = die Liste an die die neuen Eintraege angefuegt werden
' **
' ** Output : files() = die Liste der gesuchten Dateien aus dem Verzeichnis mit den neuen Eintraegen
' **
sub GetFileListName ( sPath$, sMatch$ ,lsFile() as String  )

        Dim Count% : Dim Datname as String
        Dim i as Integer
    Count% = 0

    if right ( sPath$, 1 ) <> gPathSigne then sPath$ = sPath$ + gPathSigne        ' am Pfadende muss der Pfadtrenner stehen, damit der Dir-Befhel funzt
    Datname = app.Dir( sPath$ + sMatch$ , 0)
    for i=1 to 5
       if Right ( Datname, 1 ) = "." then
          Datname = app.Dir
       else
          i=10
       end if

    next i

    while Len(Datname) <> 0
        lsFile(0) = Val(lsFile(0)) + 1
        lsFile( lsFile(0) ) =sPath$ + Datname
        Count% = Count% + 1
        Datname = app.Dir
    wend

end sub







