'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: chart_types_tools.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:49 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description  :  The subs and functions for the chart types test
'*
'************************************************************************
'*
' #1 CheckCharttype        ' Check chart type
' #1 CheckAxisFormat       ' Check number format of chart axis
' #1 ChangeFormat          ' Change number format on axis and check the results
' #1 SaveCloseReloadUpdate ' Check if data are consistent after loading new
'*
'\***********************************************************************

sub CheckCharttype(Sheetname as String)
   dim xyaxis as String
   call hDateiOeffnen gFile
   sleep (2)
   try
       if NOT hSpeichernUnterMitFilterKill (sFile, FileFormat) then
           warnlog "Saving test document localy failed -> Aborting"
           call hCloseDocument
           exit sub
       endif
   catch 
       qaErrorLog "Most probably there's no filter name for this language available. Trying to save without filter."
       'PJ: I would consider calling the following code a hack!
       Kontext "SpeichernDlg"
       Dateiname.SetText sFile
       DateiTyp.Select 1
       Speichern.Click
       Kontext "Active"
       if active.exists(2) then
           active.YES
       endif
   endcatch
   sleep (2)
'/// Then goto sheet 'ColumnDeep'
   call fCalcSelectSheet (Sheetname)
'/// select the chart as inplaced object
'/// + and check, if the number format from the Y-axis is the same as the source format
   if Sheetname = "XY" then
      xyaxis = "x"
      CheckAxisFormat(xyaxis, dateformat_49, dateformat_01)
      printlog "*** Change the source format from 'dateformat' to 'percent'"
   else
      xyaxis = "y"
      CheckAxisFormat(xyaxis, currencyformat_49, currencyformat_01)
      printlog "*** Change the source format from 'currency' to 'percent'"
   end if
'/// now we change the source format from currency to percent

   ChangeFormat ("A2:A5", "percent")
'/// then we have to press <F9> to update the datas in the chart
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<F9>"
'/// after the change of the source format we check, if these changes have been taken over in the chart
'/// first we must select the chart as inplace object
   printlog "Check, if the number format at the X-axis is the same as the source format"
   CheckAxisFormat(xyaxis, percentformat_49, percentformat_01)
'/// After the first source format change we save the document, close it, reload it and check the number format
'/// + from the Y-axis again
   SaveCloseReloadUpdate(sFile)
   printlog "Check the numberformat after saving, closing and reloading the document"
   CheckAxisFormat(xyaxis, percentformat_49, percentformat_01)
'/// Now we change the source format from 'percent' to 'date'
   printlog "*** Change the source format from 'percent' to 'date'"
   ChangeFormat("A2:A5", "date")
'/// then we have to press <F9> to update the chart
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<F9>"
'/// after the change of the source format we check, if these changes have been taken over in the chart
'/// first we must select the chart as inplace object
   printlog "Check, if the numberformat from the chart is the same as the source format"
   CheckAxisFormat(xyaxis, dateformat_49, dateformat_01)
'/// After the first source format change we save the document, close it, reload it and check the numberformat
'/// + from the Y-axis again
   SaveCloseReloadUpdate(sFile)
   printlog "Check the number format after saving, closing and reloading the document"
   CheckAxisFormat(xyaxis, dateformat_49, dateformat_01)
   printlog "*** Change the source format from 'date' to 'number'"
   ChangeFormat("A2:A5", "number")
   '/// then we have to press <F9> to update the chart
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<F9>"
'/// after the change of the source format we check, if these changes have been taken over in the chart
'/// first we must select the chart as inplace object
   printlog "Check, if the numberformat from the chart is the same as the source format"
   CheckAxisFormat(xyaxis, numberformat_49, numberformat_01)
'/// After the first source format change we save the document, close it, reload it and check the number format
'/// + from the Y-axis again
   SaveCloseReloadUpdate(sFile)
   printlog "Check the number format after saving, closing and reloading the document"
   CheckAxisFormat(xyaxis, numberformat_49, numberformat_01)
   call hCloseDocument

end sub

sub CheckAxisFormat(xyaxis as String , RefFormat as String , optional RefFormat1 as String )
'/// This sub check the number format from the Y-axis of the selected chart, by compare the
'/// + current format with one or two given reference formats
   dim seccheck as boolean
   if IsMissing ( RefFormat1 ) then
      seccheck = false
   else
      seccheck = true
   end if
   Kontext "DocumentCalc"
   'Because of one bug more in this office we have to press <F9> to update the chart, because the
   'checkbox "SourceFormat" isn't available in the tab page numbers.
   DocumentCalc.TypeKeys "<F9>"
   DocumentCalc.MouseMove 30,30
   DocumentCalc.MouseDown 30,30
   DocumentCalc.MouseUp 30,30
   EditObjectEdit
'/// check, if the number format of the Y-axis is the same as the source format
   if xyaxis = "x" then
      FormatAxisXAxis
   else
      FormatAxisYAxis
   end if
   Kontext
   Active.setPage TabZahlen
   Kontext "TabZahlen"
   Standardformat.uncheck
   if seccheck then
     if FormatCode.getText = RefFormat or FormatCode.getText = RefFormat1 then
        printlog "OK, the number format of the Y-axis is the same as the source format"
     else
        warnlog "The number format of the " & xyaxis & "-axis is: " & FormatCode.getText & " instead of " &  RefFormat
     end if
   else
      if FormatCode.getText = RefFormat then
        printlog "OK, the number format of the " & xyaxis & "-axis is the same as the source format"
     else
        warnlog "The number format of the " & xyaxis & "-axis is: " & FormatCode.getText & " instead of " &  RefFormat
     end if
   end if
   Standardformat.check
   TabZahlen.Cancel
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"

end sub

sub ChangeFormat(CellRange as String, CellFormat as String)
'/// This subroutine changes the cell format of the selected cells

   dim i as integer

   select case CellFormat
      case "number"     :  i = 3
      case "percent"    :  i = 4
      case "currency"   :  i = 5
      case "date"       :  i = 6
   end select

   call cBereichmarkieren(CellRange)
   FormatCells
   Kontext
   Active.setPage TabZahlen
   Kontext "TabZahlen"
   Kategorie.select i
   TabZahlen.OK

end sub

sub SaveCloseReloadUpdate(File as String)

   sleep (2)
   FileSave
   sleep (2)
   call hCloseDocument
   sleep (2)
   call hDateiOeffnen File
   sleep (2)
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<F9>"
   sleep (2)

end sub
