'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras_autotext.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.co
'*
'*  short description : Test the autotext feature
'*
'*******************************************************************************
'**
' #1 tCheck_Autotexts ' Test the autotext feature
'**
'\******************************************************************************

testcase tCheck_Autotexts

    const MAXLIST = 1000 

    Dim i, j, Zaehler, iMax as Integer
    Dim aUIList ( MAXLIST ) as String
    dim aRefList( MAXLIST ) as string
    Dim sFileIn, sListenEintrag as String
    Dim Bereiche(15) as String
    dim iRefItems as integer
    dim sFileOut as string
    dim brc as boolean
    
    '///<h1>This test checks all names of autotext-dialog ( edit / autotext )</h1>
    '///<i>edit / autotext</i>
    '///<i>check for each group the entries</i>
    '///<ul>
    '///<li>- the lists for comparison are : [TesttoolPath]\setup\allinst\input\formats\autotext\atext_[languageID].txt</li>
    '///<li>- if the comparison-file does not exists, it will be created automatically</li>
    
    sFileIn = gTesttoolPath & "framework\extras\input\formats\autotext\atext_"
    sFileIn = sFileIn & siSprache & ".txt"
    sFileIn = convertpath( sFileIn )
    
    sFileOut = hGetWorkPath() & "atext_" & siSprache & ".txt"
    sFileOut = convertPath( sFileOut )
    
    ListAllDelete ( aUIList () )
    ListAllDelete ( aRefList() ) 
    Zaehler = 0
    
    printlog "check all autotext-entries"
    Call  hNewDocument
    printlog "- open a new writer-document"
    printlog "- edit / autotext"
    printlog "  check each entry with a comparison-list"
    EditAutotext

    kontext "autotext"
    Vorschau_anzeigen.Uncheck
    Liste.Select 1

    for j=1 to 15
        sleep( 1 )
        Liste.TypeKeys "-"
        Liste.TypeKeys "<Down>"
    next j

    iMax = Liste.GetItemCount

    for i = 1 to iMax
        Liste.Select 1

        for j=1 to iMax
            sleep( 1 )
            Bereiche(j) = Liste.GetSelText
            Liste.TypeKeys "-"
            Liste.TypeKeys "<Down>"
        next j

        Liste.Select i
        Liste.TypeKeys "+"

        for j = 1 to ( Liste.GetItemCount - iMax )
            Liste.Select j+i
            sListenEintrag = Bereiche(i) + ":" + NameText.GetText + ":" + Kuerzel.GetText
            ListAppend ( aUIList(), sListenEintrag )
        next j

    next i
    '///</ul>
    
    
    
    iRefItems = hGetDataFileSection( sFileIn , aRefList() , "" , "" , "" )
    if ( iRefItems = 0 ) then
        ListWrite( aUIList() , sFileOut , "UTF8" )
        printlog( "File has been created at....: " & sFileOut )
        printlog( "Please verify and copy it to: " & sFileIn  )
    else
        brc = gCompare2Lists( aUIList() , aRefList() )
        if ( not brc ) then
            warnlog( "Autotexts have changed, please check" )
        else
            printlog( "Comparision succeeded" )
        endif
    endif

    
    '///<h3>all autotexts are inserted</h3>
    '///<ul>
    '///<li>- edit / autotext</li>
    '///<li>- select one autotext after the other and press for each insert</li>
    '///<li>- check if the autotext in correct inserted</li>
    printlog "  - insert all entries and check if something is inserted"

    for i = 1 to iMax
        Liste.Select 1

        for j=1 to iMax
            Liste.TypeKeys "-"
            Liste.TypeKeys "<Down>"
            wait 500
        next j

        Liste.Select i
        Liste.TypeKeys "+"

        for j = 1 to ( Liste.GetItemCount-iMax )
            Liste.Select j+i

            try
                AutoText.OK
                Sleep (5)

                kontext "active"

                If Active.Exists then
                    printlog Active.GetText
                    Active.OK

                    kontext "macrobar"

                    if MacroBar.Exists then
                        Warnlog "Macro-error at autotext " + i + " " + j + "!"
                        FileClose
                    endif

                endif


                kontext "documentwriter"
                documentWriter.TypeKeys( "<MOD1 HOME>" )
                documentWriter.TypeKeys( "<MOD1 SHIFT END>" )
                EditCopy
                if GetClipboard = "" then
                    Warnlog "Perhaps no text is inserted. Variant: "+ i + "  " + j
                endif
            catch

                if ( (iSprache = 82) AND (i = 1) AND (j = 4) ) then
                    qaerrorlog "At "+ i + " " + j +" it gives a problem."
                    printlog ("Probably Bugid: #110949" )
                else
                    Warnlog "Autotext "+ i + " " + j +" failed."
                endif

            endcatch


            kontext "documentwriter"
            DocumentWriter.TypeKeys "<Delete>"
            EditAutotext

            kontext "autotext"
        next j

    next i

    AutoText.Close
    
    '///</ul>
    Call hCloseDocument()
    
endcase
