'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras_labels.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsk $ $Date: 2005/09/14 12:45:11 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.co
'*
'*  short description : test names of labels
'*
'*******************************************************************************
'**
' #1 tCheck_NamesOfLabels ' test names 
'**
'\******************************************************************************

testcase tCheck_NamesOfLabels

    Dim i as Integer, j as Integer
    Dim lsListe(1000) as String, lsList(20) as string
    Dim sFname as String, s1stLable as String, sLab as String
    Dim bnew as Boolean
    '///<h1>This test checks all names of labels that can be edited in writer</h1>
    '///<i>file / new / lables</i>
    '///<i>check for each entry in brand the type names ( depends on the language )</i>
    '///<ul>
    '///<li>the lists for comparison are : [TesttoolPath]setup\allinst\input\\formats\labels\labX_[Groupnumber][LanguageID]..txt</li>
    printlog "Check all type-entries for each brand"
    gApplication = "WRITER"
    Call hCreateLabels()

    kontext
    Active.SetPage TabEtiketten

    kontext "tabetiketten"
    if Marke.GetItemCount = 0 then
        Warnlog "No brand-name is activated!"
    endif
    sFname = gTesttoolPath + "framework\extras\input\formats\labels\first.txt"
    sFname = ConvertPath ( sFname )
    ListRead ( lsList(), sFname, "UTF8" )

    for i=1 to ListCount ( lsList () )

        if Left ( lsList(i), 2 ) = siSprache then
            s1stLable = Right ( lsList(i), Len ( lsList(i) ) -3 )
            bNew = FALSE
            i=100
        else
            s1stLable = ""
            bNew = TRUE
        endif

    next i


    for i=1 to Marke.GetItemCount
        Marke.Select i
        printlog "  - Brand : " + Marke.GetSelText
        sLab = Typ.GetItemText (1)

        if s1stLable <> "" then
            if sLab <> s1stLable then
                warnlog "1. type-entry is not " + s1stLable + ", but " + sLab
            endif
        else
            Warnlog "The first label entry is missing in " + sFname + "! The entry is inserted now, please check it!"
            ListAppend ( lsList(), siSprache + "=" + sLab
            ListWrite ( lsList(), sFname, "utf8" )
            s1stLable = sLab
        endif

        ListAllDelete ( lsListe() )

        for j=1 to Typ.GetItemCount
            ListAppend ( lsListe(), Typ.GetItemText(j) )
        next j

        hCompareStylesAndFormats ( lsListe(), 8, i )
    next i

    TabEtiketten.Cancel
    
    '///</ul>
endcase
