'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg8.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:04:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'************************************************************************
'**
' #1 tOnlyReadReadOnly    ' load read-only files with 'only read'-flag in the file-open-dialog
' #1 tFileSearch          ' find files with wildcards
'**
'\***************************************************************************

testcase tOnlyReadReadOnly

    '///Open files which are 'Read only' on the system with the 'read only'-flag in the file-open-dialog
    '///+test directory : [TesttoolPath]\framework\filedlg\input\readonly

    'Files in use during the test
    'TODO: Shrink the routine by using Arrays.

    dim BASEPATH as string
    BASEPATH = gTesttoolPath + "framework\filedlg\input\readonly\"
    dim SXWFILE  as string : SXWFILE  = BASEPATH + "fdlg.sxw"
    dim SXCFILE  as string : SXCFILE  = BASEPATH + "fdlg.sxc"
    dim SXIFILE  as string : SXIFILE  = BASEPATH + "fdlg.sxi"
    dim SXDFILE  as string : SXDFILE  = BASEPATH + "fdlg.sxd"
    dim SXMFILE  as string : SXMFILE  = BASEPATH + "fdlg.sxm"
    dim SXGFILE  as string : SXGFILE  = BASEPATH + "fdlg.sxg"
    dim JPGFILE  as string : JPGFILE  = BASEPATH + "borabora.jpg"
    dim DXFFILE  as string : DXFFILE  = BASEPATH + "columbia.dxf"
    dim SDWFILE  as string : SDWFILE  = BASEPATH + "erwin.sdw"
    dim SDCFILE  as string : SDCFILE  = BASEPATH + "erwin.sdw"
    dim SDDFILE  as string : SDDFILE  = BASEPATH + "schach.sdd"
    dim SDAFILE  as string : SDAFILE  = BASEPATH + "aendern.sda"
    dim SDSFILE  as string : SDSFILE  = BASEPATH + "ls3_3_15.sds"
    dim SMFFILE  as string : SMFFILE  = BASEPATH + "ffortpf.smf"
    dim HTMFILE  as string : HTMFILE  = BASEPATH + "body.htm"
    dim HTMLFILE as string : HTMLFILE = BASEPATH + "fdlg.html"

    printlog "Open files with the 'Read only'-Flag in the file/open-dialog"
    '///- open a Writer-File
    printlog " - open a Writer-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXWFILE ), 1, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Calc-File
    printlog " - open a Calc-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXCFILE ), 2, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Impress-File
    printlog " - open a Impress-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXIFILE ), 3, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Draw-File
    printlog " - open a Draw-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXDFILE ), 4, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Math-File
    printlog " - open a Math-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXMFILE ), 6, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Master-Document-File
    printlog " - open a Master-Document-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXGFILE ), 1, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open an Image-File ( JPG )
    printlog " - open an Image-File ( JPG )"

    if LoadDocumentReadOnly ( ConvertPath ( JPGFILE ), 4, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open an Image-File ( DXF )
    printlog " - open an Image-File ( DXF )"

    if LoadDocumentReadOnly ( ConvertPath ( DXFFILE ), 4, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Writer-File ( 5.2 )
    printlog " - open a Writer-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDWFILE ), 1, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Calc-File ( 5.2 )
    printlog " - open a Calc-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDCFILE ), 2, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Impress-File ( 5.2 )
    printlog " - open a Impress-File ( 5.2 )"
    '  warnlog( "#i39041# - skipping SDD file" )

    if LoadDocumentReadOnly ( ConvertPath ( SDDFILE ), 3, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Draw-File ( 5.2 )
    printlog " - open a Draw-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDAFILE ), 4, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Chart-File ( 5.2 )
    printlog " - open a Chart-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDSFILE ), 5, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a Math-File ( 5.2 )
    'qaerrorlog( "#i49003# Math (5.2) triggers filterdialog, excluded" )
    printlog " - open a Math-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SMFFILE ), 6, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a HTML-File ( with extension 'htm' )
    printlog " - open a HTML-File ( with extension 'htm' )"

    if LoadDocumentReadOnly ( ConvertPath ( HTMFILE ), 1, TRUE ) = TRUE then
        call hCloseDocument()
    end if


    '///- open a HTML-File ( with extension 'html' )
    printlog " - open a HTML-File ( with extension 'html' )"

    if LoadDocumentReadOnly ( ConvertPath ( HTMLFILE ), 1, TRUE ) = TRUE then
        call hCloseDocument()
    end if


endcase

'*******************************************************************************

testcase tFileSearch

    '///search and control files by enter the names with wildcards

    Dim i as Integer, iCounter as Integer
    Dim sEntry as String, sSuffix as String, sDok as String, altsEntry as String

    '///file/open
    '///+test directory : [TesttoolPath]\framework\filedlg\input\alldocs
    FileOpen

    Kontext "OeffnenDlg"

    Sleep 1
    Dateiname.SetText ConvertPath ( gTesttoolPath + "framework\filedlg\input\alldocs" )
    oeffnen.click()
    Sleep 2

    '///list all StarOffice-files only with the exact extension
    '///+insert *.sxw, *.sxc, *.sxd, *.sxi, *.sxg, *.sxm, *.sdw, *.sdc, *.sdd, *.sda, *.sds, *.smf, *.jpg, *.htm, *.htm
    '///+in the filename-field and press 'open'. Check if a file is shown in the file-list.
    printlog " - list all StarOffice-files only with the exact extension"

    for i=1 to 14

        select case i
        case 1  : sSuffix = "*.sxw"  : sDok = "fdlg.sxw"
        case 2  : sSuffix = "*.sxc"  : sDok = "fdlg.sxc"
        case 3  : sSuffix = "*.sxd"  : sDok = "fdlg.sxd"
        case 4  : sSuffix = "*.sxi"  : sDok = "fdlg.sxi"
        case 4  : sSuffix = "*.sxg"  : sDok = "fdlg.sxg"
        case 5  : sSuffix = "*.sxm"  : sDok = "fdlg.sxm"
        case 6  : sSuffix = "*.sdw"  : sDok = "erwin.sdw"
        case 7  : sSuffix = "*.sdc"  : sDok = "bereich.sdc"
        case 8  : sSuffix = "*.sdd"  : sDok = "schach.sdd"
        case 9  : sSuffix = "*.sda"  : sDok = "aendern.sda"
        case 11 : sSuffix = "*.smf"  : sDok = "ffortpf.smf"
        case 12 : sSuffix = "*.sds"  : sDok = "ls3_3_15.sds"
        case 10 : sSuffix = "*.jpg"  : sDok = "borabora.jpg"
        case 13 : sSuffix = "*.htm"  : sDok = "body.htm"
        case 14 : sSuffix = "*.html" : sDok = "fdlg.html"
        end select


        Dateiname.SetText sSuffix
        oeffnen.click()
        Sleep 2

        try
            sEntry = GetFirstNameOfFileList

            if sEntry <> sDok then
                Warnlog "For " + sSuffix + " the wrong file was shown!  '" + sEntry +"'"
            endif

        catch
            Warnlog "No entry was in the listbox, or another error was occurred!"
        endcatch

    next i


    printlog " - list the files with wildcards *.sd? "
    '///list the files with wildcards *.sd?
    '///+insert '*.sd?' in filename-field and press 'open'
    '///+check if 5 correct files are shown file-list
    Dateiname.SetText "*.sd?"
    oeffnen.click()
    Sleep 2
    altsEntry = ""
    hMouseClick ( Dateiauswahl, 10, 10 )
    Dateiauswahl.TypeKeys "<Up>", 10

    try

        for i=1 to 10

            if i=1 then
                sEntry = GetFirstNameOfFileList
            else
                sEntry = lcase ( Dateiauswahl.GetSelText )
            end if

            if altsEntry <> sEntry AND sEntry <> "cvs" then
                Dateiauswahl.TypeKeys "<Down>"
                iCounter = iCounter + 1
                altsEntry = sEntry
            else
                i = 11
            end if

        next i

        if iCounter <> 5 then
            Warnlog "For *.sd? are not 5 entries are shown, only " + iCounter
        endif

    catch
        Warnlog "No entry was in the listbox, or another error was occurred!"
    endcatch


    printlog " - list a file with the wildcard '?'"
    '///list a file with the wildcard '?'
    '///+insert 'b??ei??.sd?' in filename-field and press 'open'
    '///+check if 'bereich.sdc' is shown
    Dateiname.SetText "b??ei??.sd?"
    oeffnen.click()
    Sleep 2

    try
        sEntry = GetFirstNameOfFileList

        if sEntry <> "bereich.sdc" then
            Warnlog "Search with 'b??ei??.sd?' : the listed file is not 'bereich.sdc' but '" + sEntry + "'"
        endif

    catch
        Warnlog "No entry is in the listbox, or another error is occurred!"
    endcatch


    printlog " - list a file with some '*'-wildcards"
    '///list a file with some '*'-wildcards
    '///+insert 'er*.s*' in filename-field and press 'open'
    '///+check if 'erwin.sdw' is shown
    Dateiname.SetText "er*.s*"
    oeffnen.click()
    Sleep 2

    try
        sEntry = GetFirstNameOfFileList

        if sEntry <> "erwin.sdw" then
            Warnlog "Search with 'er*.s*' : the listed file is not 'erwin.sdw' but '" + sEntry + "'"
        endif

    catch
        Warnlog "No entry is in the listbox, or another error is occurred!"
    endcatch


    printlog " - list a file with different wildcards '*' + '?'"
    '///list a file with different wildcards '*' + '?'
    '///+insert 'er*.s??' in filename-field and press 'open'
    '///+check if 'erwin.sdw' is shown
    Dateiname.SetText "er*.s??"
    oeffnen.click()
    Sleep 2

    try
        sEntry = GetFirstNameOfFileList

        if sEntry <> "erwin.sdw" then
            Warnlog "Search with 'er*.s??' : the listed file is not 'erwin.sdw' but '" + sEntry + "'"
        endif

    catch
        Warnlog "No entry is in the listbox, or another error is occurred!"
    endcatch


    printlog " - list a file with different wildcards '*' + '?', no file has to be found"
    '///list a file with different wildcards '*' + '?', no file has to be found
    '///+insert '*r?xx*.s*' in filename-field and press 'open'
    '///+check if no file is shown
    Dateiname.SetText "*r?xx*.s*"
    oeffnen.click()
    Sleep 2

    try
        sEntry = GetFirstNameOfFileList

        if sEntry <> "cvs" then
            Warnlog "Search with '*r?xx*.s*' : no file should be listed, but '" + sEntry + "' is shown!"
        endif

    catch
    endcatch


    OeffnenDlg.Cancel

endcase


