'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filename2.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:05:04 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( extended tests )
'*
'*******************************************************************************
'**
' #1 tSaveLoadDelFilesCJK    ' checks for strange names on windows that are allowed
' #1 tCJKFolders             ' checks if folders and files w. cjk chars are handled ok
'**
'\******************************************************************************

testcase tSaveLoadDelFilesCJK()

   dim cStrangeName as string
   dim iCounter as integer ' iterator
   dim iRandom  as long    ' random number.(needs long for cjk chars) 
   const ICWAIT as Integer = 1

   '///Check allowed filenames on Windows using the File-Save dialog
   printlog( CHR$(13) )
   printlog( "Check if CJK-filenames are loaded/saved/deleted" )
   printlog( CHR$(13) )
   
   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument

   '///+Save/Load/Delete files containing  permitted UNICODE/CJK-characters
   ' This test randomizes through a number of characters, a full test of all 
   ' possible ascii characters would simply take too long.
   ' Note that the range of unified CJK characters lies between 
   ' dec 19968 (#4E00) and dec 40879 (#9FAF) which makes a range of 20911
   ' different characters!
   printlog( CHR$(13) + "Names with CJK-chars" )
   printlog( "" )
   
   call randomize()
   
   for iCounter = 1 to 2
   
      iRandom = int( 19968 + ( 20911 * rnd ) )
      printlog( "" )
      printlog( " * Using decimal char: " & iRandom )      

      cStrangeName = hNameGen_append( iRandom , true )
      SaveLoadDelSuccess( cStrangeName , TRUE )
            
      cStrangeName = hNameGen_lead( iRandom , true )
      SaveLoadDelSuccess( cStrangeName , TRUE )

      kontext "active"
      if( active.exists() ) then
         qaerrorlog( "#i33964# Document does not exist when the last document is deleted from filepicker" )
         printlog( active.gettext() )
         active.ok()
      endif
      
   next iCounter

   '///+Close the document
   printlog( "Close the document" )
   hCloseDocument

endcase

'*******************************************************************************

testcase tCJKFolders()

   '///Check if files/folders containing CJK characters are handled ok
   '///+create a folder containing cjk characters
   '///+save a file w. cjk characters to the newly created directory
   '///+load the file again
   '///+delete the file
   '///+delete the folder

   dim cStrangeFolder as string
   dim cStrangeFile as string
   dim iCounter as integer ' iterator
   dim iRandom  as long    ' random number.(needs long for cjk chars) 
   const ICWAIT as Integer = 1

   printlog( CHR$(13) )
   printlog( "Check if CJK-files/folders are handled ok" )
   printlog( CHR$(13) )

   printlog( "Open a new document" )
   hNewDocument

   printlog( CHR$(13) + "Names with CJK-chars" )
   printlog( "" )
   
   call randomize()

   for iCounter = 1 to 3
   
      iRandom = int( 19968 + ( 20911 * rnd ) )
      printlog( " * Using decimal char: " & iRandom )

      ' Create a directory containing CJK characters
      cStrangeFolder = hNameGen_append( iRandom , false )
      call CreateDirctoryExpectSuccess( cStrangeFolder ) 
      
      cStrangeFile = hNameGen_append( iRandom , true )
      cStrangeFile = convertpath( cStrangeFolder & "\" & cStrangeFile )
      SaveLoadDelSuccess( cStrangeFile , TRUE )

      call DeleteFileExpectSuccess( cStrangeFolder )

      cStrangeFile = hNameGen_lead( iRandom , true )
      SaveLoadDelSuccess( cStrangeName , TRUE )

   next iCounter

   '///+Close the document
   printlog( "Close the document" )
   hCloseDocument

endcase
