'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ftpserver2.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:05:31 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( extended tests )
'*
'*******************************************************************************
'**
' #1 tFTPServerDirectories1   ' Create/delete a directory via FTP (case 1)
' #1 tFTPServerDirectories2   ' Create/delete a directory via FTP (case 2)
'**
'\******************************************************************************

testcase tFTPServerDirectories1( cFTPServer as string )

   ' The application can create/delete files and folders via FTP.

   'This test checks if
   '- a directory can be created via FTP
   '- a file can be written to a directory via FTP
   '- a file can be deleted from within a directory via FTP
   '- a directory can be deleted via FTP

   'This test should work on any ftp-server
   
   '///Test creating directories via FTP 
   printlog( CHR$(13) + "Testing FTP-Server: " + cFTPServer )

   const WORKDIR = "ftpdlg1"
   dim workfile as string
      
   dim cNewDir as string
       cNewDir = cFTPServer + WORKDIR + "/"
   dim cFullPath as string

   '///+Open a new document
   printlog( CHR$(13) + " - Open a new document" )
   call hNewDocument
   
   ' Append a suffix depending on gApplication
   workfile = hAppendSuffix( "ftpdlg1" )
   
   '///+Disable the proxies in Tools->Options
   call DisableProxies()

   '///+Create a directory
   call FTPCreateDirectoryExpectSuccess( cFTPServer , WORKDIR )
   
   '///+Try to save a file to the new directory
   cFullPath =  cNewDir + workfile 
   call FTPSaveFileExpectSuccess( cFullPath )
   
   '///+Try to delete the file again ( the clean way )
   call FTPDeleteFileExpectSuccess( cNewDir , workfile )
   
   '///+Delete the directory
   call FTPDeleteFileExpectSuccess( cFTPServer , WORKDIR )

   '///+Enable the proxies in Tools->Options
   call EnableProxies()

   '///+Close the document
   printlog( " - Close the document" )
   call hCloseDocument
   
   printlog( "" )
   
endcase

'*******************************************************************************

testcase tFTPServerDirectories2( cFTPServer as string )

   'The application cannot delete directories on FTP-Servers that contain files.

   'This test checks if
   '- a directory can be created via FTP
   '- a file can be written to a directory via FTP
   '- a non-empty directory can be deleted via FTP
   '- a file can be deleted from within a directory via FTP
   '- a directory can be deleted via FTP
   
   'This test should work on any ftp-server

   '///Test FTP Server.
   printlog( CHR$(13) + "Testing FTP-Server: " + cFTPServer )

   const WORKDIR  = "ftpdlg2"
   dim workfile as string
       workfile = "ftpdlg2"
   dim cNewDir as string
       cNewDir = cFTPServer + WORKDIR + "/"
   dim cFullPath as string
   
   '///+Open a new document
   printlog( CHR$(13) + " - Open a new document" )
   call hNewDocument
   
   ' Append a suffix depending on gApplication
   workfile = hAppendSuffix( "ftpdlg2" )
   
   '///+Disable the proxies in Tools->Options
   call DisableProxies()

   '///+Create a directory
   call FTPCreateDirectoryExpectSuccess( cFTPServer , WORKDIR )
   
   '///+Try to save a file to the new directory
   cFullPath = cNewDir + workfile 
   call FTPSaveFileExpectSuccess( cFullPath )
   
   '///+Delete the directory without removing the containing file
   call FTPDeleteFileExpectFailure( cFTPServer , WORKDIR )

   '///+Try to delete the file (this should work)
   call FTPDeleteFileExpectSuccess( cNewDir , workfile )

   '///+Delete the directory 
   call FTPDeleteFileExpectSuccess( cFTPServer , WORKDIR )
   
   '///+Enable the proxies in Tools->Options
   call EnableProxies()

   '///+Close the document
   printlog( " - Close the document" )
   call hCloseDocument
   
   printlog( "" )
   
endcase

'*******************************************************************************

testcase tFTPServerDirectories3( cFTPServer as string )

   'This test checks if
   '- a weird-named directory can be created via FTP
   '- a file can be written to a directory via FTP
   '- a file can be deleted from within a directory via FTP
   '- a directory can be deleted via FTP
   
   'This test should work on any ftp-server

   '///Test FTP Server.
   printlog( CHR$(13) + "Testing FTP-Server: " + cFTPServer )

   const WORKDIR  = "diröäüß test%20A"
   const WORKFILE = "workfile"
   
   dim cNewDir as string
       cNewDir = cFTPServer + WORKDIR + "/"
   dim cFullPath as string

   '///+Disable the proxies in Tools->Options
   call DisableProxies()

   '///+Create a directory
   call FTPCreateDirectoryExpectSuccess( cFTPServer , WORKDIR )
   
   '///+Try to save a file to the new directory
   cFullPath = cNewDir + WORKFILE 
   call FTPSaveFileExpectSuccess( cFullPath )
   
   '///+Try to delete the file again
   call FTPDeleteFileExpectSuccess( cNewDir , WORKFILE )
   
   '///+Delete the directory
   call FTPDeleteFileExpectSuccess( cFTPServer , WORKDIR )

   '///+Enable the proxies in Tools->Options
   call EnableProxies()   
   
endcase

'*******************************************************************************

