'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: graph_in.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:20 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : Graphic import (2nd file for the first.bas)
'*
'************************************************************************
'**
' #1 tQuickInsertGraphNotAsLink         ' insert all graphics types not linked ( can used in all applications )
' #1 tQuickInsertGraphAsLink            ' insert all graphics types as a link ( can used in all applications )
' #1 tInFilterCountCompare              ' check all graphic import filter names
' #0 tGrafikEinfuegenSchnellUnverknuepft ' old name for the testcase tQuickInsertGraphNotAsLink
' #0 tGrafikEinfuegenSchnellVerknuepft   ' old name for the testcase tQuickInsertGraphAsLink
'*'
'\***********************************************************************


testcase tQuickInsertGraphNotAsLink
'/// tQuickInsertGraphNotAsLink : insert all types of graphics ( StarOffice knows ) into a document not linked
'///- the document will be opened depends on 'gApplication' -> so the test can used in all application tests
'///The following 25 files will be inserted ( the path is [TesttoolPath]/global/input/graf_inp ) without selecting the filtername
'///+- desp.bmp ( Windows Bitmap )
'///+- columbia.dxf ( AutoCAD Interchange Format )
'///+- extrud.emf ( Enhanced Metafile )
'///+- ball.eps ( Encapsulated PostScript )
'///+- airshw.met ( OS/2 Metafile )
'///+- eface.gif ( GIF : Graphics Interchange Format )
'///+- purzel.gif ( Animated Gif )
'///+- borabora.jpg ( Joint Photographic Experts Group )
'///+- grafix1.pbm ( Portable Bitmap )
'///+- circle.pcx ( Zsoft Paintbrush )
'///+- papagei1.pcd ( Kodak Photo CD (768x512) / (192x128) / (384x256) )
'///+- newtonme.pct ( Mac Pict )
'///+- grafix2.pgm ( Portable Graymap )
'///+- obst.png ( Portable Network Graphic )
'///+- london.ppm ( Portable Pixelmap )
'///+- tiger.psd ( Adobe Photoshop )
'///+- grafix3.ras ( Sun Raster Image )
'///+- mickym.sgf ( StarWriter Graphics Format )
'///+- faxpfeil.sgv ( StarDraw 2.0 )
'///+- picture.svm ( StarView Metafile )
'///+- pilz.tga ( Truevision Targa )
'///+- stabler.tif ( Tagged Image File Format )
'///+- krokodil.wmf ( Windows Metafile )
'///+- grafix4.xbm ( X Bitmap )
'///+- papagei2.xpm ( X PixMap )

 Dim i : Dim StartTime
 Dim DieGrafik as String, Filtername as String

  StartTime = Now()
   printlog "- insert all graphic-types ( not linked )"

'///- open a new document
'///+- insert/graphic/from file
   Call hNewDocument
      for i=1 to 25

         ' use this snippet to exclude one fileformat from testing
         'if ( i = 23 ) then      
         '   warnlog( "wmf excluded due to #ixxxx" )
         '   goto skipformat
         'endif

         Kontext "GrafikEinfuegenDlg"
         if GrafikEinfuegenDlg.NotExists then InsertGraphicsFromFile
         Sleep 2
         select case i
            case 1  :  DieGrafik = "desp.bmp"
            case 2  :  DieGrafik = "columbia.dxf"
            case 3  :  DieGrafik = "extrud.emf"
            case 4  :  DieGrafik = "ball.eps"
            case 5  :  DieGrafik = "airshw.met"
            case 6  :  DieGrafik = "eface.gif"
            case 7  :  DieGrafik = "purzel.gif"         ' Animated Gif
            case 8  :  DieGrafik = "borabora.jpg"
            case 9  :  DieGrafik = "grafix1.pbm"
            case 10 :  DieGrafik = "circle.pcx"
            case 11 :  DieGrafik = "papagei1.pcd"
            case 12 :  DieGrafik = "newtonme.pct"
            case 13 :  DieGrafik = "grafix2.pgm"
            case 14 :  DieGrafik = "obst.png"
            case 15 :  DieGrafik = "london.ppm"
            case 16 :  DieGrafik = "tiger.psd"
            case 17 :  DieGrafik = "grafix3.ras"
            case 18 :  DieGrafik = "mickym.sgf"
            case 19 :  DieGrafik = "faxpfeil.sgv"
            case 20 :  DieGrafik = "picture.svm"
            case 21 :  DieGrafik = "pilz.tga"
            case 22 :  DieGrafik = "stabler.tif"
            case 23 :  DieGrafik = "krokodil.wmf"
            case 24 :  DieGrafik = "grafix4.xbm"
            case 25 :  DieGrafik = "papagei2.xpm"
         end select
         printlog "- " + DieGrafik
         DieGrafik = ConvertPath ( gTesttoolPath + "global\input\graf_inp\" + DieGrafik )
         DateiName.SetText ( DieGrafik )
         DateiTyp.Select 1                           ' set filter to 'all formats'
         sleep(1)

'///+- uncheck 'link'
         Vorschau.Uncheck
         if Verknuepfen.Exists then
            if  Verknuepfen.IsEnabled then Verknuepfen.UnCheck
         end if

'///+- insert the graphic name and click 'insert'
         Oeffnen.Click
         sleep(2)
         Kontext "Active"
         if Active.Exists then
            Warnlog Active.GetText
            Warnlog "Bei der Grafik : " + DieGrafik
            Active.OK
         else
            try
               EditCopy
               sleep 1
               EditDeleteContents
               Sleep 1
            catch
               Warnlog "Probleme bei Grafik : " + DieGrafik
               gMouseClick ( 90, 90 )
            endcatch
         end if
         
         skipformat:
         
      next i

'///+- special handling for the PCD-files
'///+-   insert the file 'papagei1.pcd' with selected filtername
'///+-     PCD - Kodak Photo CD (768x512)
'///+-     PCD - Kodak Photo CD (384x256)
'///+-     PCD - Kodak Photo CD (192x128)

    printlog Chr(13) + "Test the PCD-Filters directly"
      for i=1 to 3
         Kontext "GrafikEinfuegenDlg"
         if GrafikEinfuegenDlg.NotExists then InsertGraphicsFromFile
         Sleep 2
         select case i
            case 1 : Filtername = "PCD - Kodak Photo CD (768x512) (*.pcd)"
            case 2 : Filtername = "PCD - Kodak Photo CD (384x256) (*.pcd)"
            case 3 : Filtername = "PCD - Kodak Photo CD (192x128) (*.pcd)"
         end select
         printlog "- " + Filtername
         DateiName.SetText ( ConvertPath ( gTesttoolPath + "global\input\graf_inp\papagei1.pcd" )
         DateiTyp.Select Filtername

         Vorschau.Uncheck
         if Verknuepfen.Exists then
            if  Verknuepfen.IsEnabled then Verknuepfen.UnCheck
         end if

         Oeffnen.Click
         Sleep 2
         Kontext "Active"
         if Active.Exists then
            Warnlog Active.GetText
            Warnlog "For filter : " + Filtername
            Active.OK
         else
            try
               EditCopy
               if i=13 OR i=16 then Sleep 3
               EditDeleteContents
               Sleep 1
            catch
               Warnlog "Problems with filtertype : " + Filtername
               gMouseClick ( 90, 90 )
            endcatch
         end if
      next i

'///after inserting all files the document will be closed
      Kontext "GrafikEinfuegenDlg"
      if GrafikEinfuegenDlg.Exists then GrafikEinfuegenDlg.Cancel
      Call hCloseDocument
   printlog "Dauer : " + Wielange (StartTime)
endcase

' *********************************
' *
testcase tQuickInsertGraphAsLink
'/// tQuickInsertGraphAsLink : insert all types of graphics ( StarOffice knows ) linked into a document
'///- the document will be opened depends on 'gApplication' -> so the test can used in all application tests
'///The following 25 files will be inserted ( the path is [TesttoolPath]/global/input/graf_inp ) without selecting the filtername
'///+- desp.bmp ( Windows Bitmap )
'///+- columbia.dxf ( AutoCAD Interchange Format )
'///+- extrud.emf ( Enhanced Metafile )
'///+- ball.eps ( Encapsulated PostScript )
'///+- airshw.met ( OS/2 Metafile )
'///+- eface.gif ( GIF : Graphics Interchange Format )
'///+- purzel.gif ( Animated Gif )
'///+- borabora.jpg ( Joint Photographic Experts Group )
'///+- grafix1.pbm ( Portable Bitmap )
'///+- circle.pcx ( Zsoft Paintbrush )
'///+- papagei1.pcd ( Kodak Photo CD (768x512) / (192x128) / (384x256) )
'///+- newtonme.pct ( Mac Pict )
'///+- grafix2.pgm ( Portable Graymap )
'///+- obst.png ( Portable Network Graphic )
'///+- london.ppm ( Portable Pixelmap )
'///+- tiger.psd ( Adobe Photoshop )
'///+- grafix3.ras ( Sun Raster Image )
'///+- mickym.sgf ( StarWriter Graphics Format )
'///+- faxpfeil.sgv ( StarDraw 2.0 )
'///+- picture.svm ( StarView Metafile )
'///+- pilz.tga ( Truevision Targa )
'///+- stabler.tif ( Tagged Image File Format )
'///+- krokodil.wmf ( Windows Metafile )
'///+- grafix4.xbm ( X Bitmap )
'///+- papagei2.xpm ( X PixMap )

 Dim i : Dim StartTime
 Dim DieGrafik as String, Filtername as String

  Start = Now()
   printlog "- insert all graphic-types ( linked )"

'///- open a new document
'///+- insert/graphic/from file
   Call hNewDocument
      for i=1 to 25
         Kontext "GrafikEinfuegenDlg"
         if GrafikEinfuegenDlg.NotExists then InsertGraphicsFromFile
         Sleep 2
         select case i
            case 1  :  DieGrafik = "desp.bmp"
            case 2  :  DieGrafik = "columbia.dxf"
            case 3  :  DieGrafik = "extrud.emf"
            case 4  :  DieGrafik = "ball.eps"
            case 5  :  DieGrafik = "airshw.met"
            case 6  :  DieGrafik = "eface.gif"
            case 7  :  DieGrafik = "purzel.gif"         ' Animated Gif
            case 8  :  DieGrafik = "borabora.jpg"
            case 9  :  DieGrafik = "grafix1.pbm"
            case 10 :  DieGrafik = "circle.pcx"
            case 11 :  DieGrafik = "papagei1.pcd"
            case 12 :  DieGrafik = "newtonme.pct"
            case 13 :  DieGrafik = "grafix2.pgm"
            case 14 :  DieGrafik = "obst.png"
            case 15 :  DieGrafik = "london.ppm"
            case 16 :  DieGrafik = "tiger.psd"
            case 17 :  DieGrafik = "grafix3.ras"
            case 18 :  DieGrafik = "mickym.sgf"
            case 19 :  DieGrafik = "faxpfeil.sgv"
            case 20 :  DieGrafik = "picture.svm"
            case 21 :  DieGrafik = "pilz.tga"
            case 22 :  DieGrafik = "stabler.tif"
            case 23 :  DieGrafik = "krokodil.wmf"
            case 24 :  DieGrafik = "grafix4.xbm"
            case 25 :  DieGrafik = "papagei2.xpm"
         end select
         printlog "- " + DieGrafik
         DieGrafik = ConvertPath ( gTesttoolPath + "global\input\graf_inp\" + DieGrafik )
         Dateityp.Select 1
         DateiName.SetText ( DieGrafik )

'///+- check 'link'
         Vorschau.Uncheck
         if Verknuepfen.Exists then
            if  Verknuepfen.IsEnabled then Verknuepfen.UnCheck
         end if

'///+- insert the graphic name and click 'insert'
         Oeffnen.Click
         Sleep 2
         Kontext "Active"
         if Active.Exists then
            Warnlog Active.GetText
            Warnlog "For graphic : " + DieGrafik
            Active.OK
         else
            try
               EditCopy
               if i=13 OR i=16 then Sleep 3
               EditDeleteContents
               Sleep 1
            catch
               Warnlog "Probleme bei Grafik : " + DieGrafik
               gMouseClick ( 90, 90 )
            endcatch
         end if
      next i

'///+- special handling for the PCD-files
'///+-   insert the file 'papagei1.pcd' with selected filtername
'///+-     PCD - Kodak Photo CD (768x512)
'///+-     PCD - Kodak Photo CD (384x256)
'///+-     PCD - Kodak Photo CD (192x128)
    printlog Chr(13) + "Test the PCD-Filters directly"
      for i=1 to 3
         Kontext "GrafikEinfuegenDlg"
         if GrafikEinfuegenDlg.NotExists then InsertGraphicsFromFile
         Sleep 2
         select case i
            case 1 : Filtername = "PCD - Kodak Photo CD (768x512) (*.pcd)"
            case 2 : Filtername = "PCD - Kodak Photo CD (384x256) (*.pcd)"
            case 3 : Filtername = "PCD - Kodak Photo CD (192x128) (*.pcd)"
         end select
         printlog "- " + Filtername
         DateiName.SetText ( ConvertPath ( gTesttoolPath + "global\input\graf_inp\papagei1.pcd" )
         DateiTyp.Select Filtername

         Vorschau.Uncheck
         if Verknuepfen.Exists then
            if  Verknuepfen.IsEnabled then Verknuepfen.UnCheck
         end if

         Oeffnen.Click
         Sleep 2
         Kontext "Active"
         if Active.Exists then
            Warnlog Active.GetText
            Warnlog "For filter : " + Filtername
            Active.OK
         else
            try
               EditCopy
               if i=13 OR i=16 then Sleep 3
               EditDeleteContents
               Sleep 1
            catch
               Warnlog "Problems with filtertype : " + Filtername
               gMouseClick ( 90, 90 )
            endcatch
         end if
      next i

'///after inserting all files the document will be closed
      Kontext "GrafikEinfuegenDlg"
      if GrafikEinfuegenDlg.Exists then GrafikEinfuegenDlg.Cancel
      Call hCloseDocument
   printlog "Dauer : " + Wielange (StartTime)
endcase

'*******************************************************************************

testcase tInFilterCountCompare

   '///check all import graphic filternames ( they are not depends on the language, they have allways the same name )
   '///the filternames are :
   '///+BMP - Windows Bitmap
   '///+DXF - AutoCAD Interchange Format
   '///+EMF - Enhanced Metafile
   '///+EPS - Encapsulated PostScript
   '///+GIF - Graphics Interchange Format
   '///+JPEG - Joint Photographic Experts Group
   '///+MET - OS/2 Metafile
   '///+PBM - Portable Bitmap
   '///+PCD - Kodak Photo CD (768x512)
   '///+PCD - Kodak Photo CD (192x128)
   '///+PCD - Kodak Photo CD (384x256)
   '///+PCT - Mac Pict
   '///+PCX - Zsoft Paintbrush
   '///+PNG - Portable Network Graphic
   '///+PGM - Portable Graymap
   '///+PPM - Portable Pixelmap
   '///+PSD - Adobe Photoshop
   '///+RAS - Sun Raster Image
   '///+SGF - StarWriter Graphics Format
   '///+SGV - StarDraw 2.0
   '///+SVM - StarView Metafile
   '///+TGA - Truevision Targa
   '///+TIFF - Tagged Image File Format
   '///+WMF - Windows Metafile
   '///+XBM - X Bitmap
   '///+XPM - X PixMap

   Dim i as Integer, j as Integer
   Dim iCounter as Integer
   Dim sList1 ( 30 ) as String  ' current filters in office dialog
   dim sList2 ( 30 ) as String  ' list with filters that have to be found
   dim lsList( 20 ) as String  ' translation of <all filters>
   Dim sFName as String, siSprache as String

   '///additionally the test check the translation of 'All formats' ( the first entry in the list )
   '///+ the comarison-list can be find in [TesttoolPath]/framework/first/input/filter.txt ( UTF8 encoded )

   ' open the file for the translation for the first list entry <all filters> into lsList()
   sFName = ConvertPath ( gTesttoolPath + "framework\first\input\filter.txt" )
   ListRead ( lsList (), sFName, "utf8" )
   if iSprache < 10 then
      siSprache = "0" & iSprache
   else
      siSprache = iSprache
   end if

   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument
   
   '///+- Insert/Graphic/From File
   '///+- check all filterentries

   InsertGraphicsFromFile
   Kontext "GrafikEinfuegenDlg"

   ' insert all entries from filter-listbox in a list    into lsList1()
   iCounter = DateiTyp.GetItemCount
   for i=1 to iCounter
      sList1(i) = DateiTyp.GetItemText (i)
   next i
   GrafikEinfuegenDlg.Cancel

   ' start creating of list with filters to find; start with the <all filters> entry
   for i=1 to ListCount ( lsList () )
      if Left ( lsList(i), 2 ) = siSprache then
         ListAppend ( sList2(), Right ( lsList(i), Len ( lsList(i) ) - 3 ) )
         ' REMOVED: + " (*.bmp;*.dxf;*.emf;*.eps;*.gif;*.jpg;*.jpeg;*.jfif;*.jif;*.met;*.pbm;*.pcd;*.pct;*.pcx;*.pgm;*.png;*.ppm;*.psd;*.ras;*.sgf;*.sgv;*.svm;*.tga;*.tif;*.tiff;*.wmf;*.xbm;*.xpm)" )
         i=100
      end if
   next i
   if i<100 then
      Warnlog siSprache + ": 1. entry of filterlist is missing in " + sFName + "!"
      Warnlog "The entry is added to the file, please check the list! The default is now english!"
      ListAppend ( lsList(), siSprache + "=" + sList1(1) )
      ListWrite  ( lsList(), sFname, "utf8" )
      ListAppend ( sList2(), "<All formats>" )
   end if

   ListAppend ( sList2(), "BMP - Windows Bitmap (*.bmp)" )
   ListAppend ( sList2(), "DXF - AutoCAD Interchange Format (*.dxf)" )
   ListAppend ( sList2(), "EMF - Enhanced Metafile (*.emf)" )
   ListAppend ( sList2(), "EPS - Encapsulated PostScript (*.eps)" )
   ListAppend ( sList2(), "GIF - Graphics Interchange Format (*.gif)" )
   ListAppend ( sList2(), "JPEG - Joint Photographic Experts Group (*.jpg;*.jpeg;*.jfif;*.jif)" )
   ListAppend ( sList2(), "MET - OS/2 Metafile (*.met)" )
   ListAppend ( sList2(), "PBM - Portable Bitmap (*.pbm)" )
   ListAppend ( sList2(), "PCD - Kodak Photo CD (768x512) (*.pcd)" )
   ListAppend ( sList2(), "PCD - Kodak Photo CD (192x128) (*.pcd)" )
   ListAppend ( sList2(), "PCD - Kodak Photo CD (384x256) (*.pcd)" )
   ListAppend ( sList2(), "PCT - Mac Pict (*.pct)" )
   ListAppend ( sList2(), "PCX - Zsoft Paintbrush (*.pcx)" )
   ListAppend ( sList2(), "PNG - Portable Network Graphic (*.png)" )
   ListAppend ( sList2(), "PGM - Portable Graymap (*.pgm)" )
   ListAppend ( sList2(), "PPM - Portable Pixelmap (*.ppm)" )
   ListAppend ( sList2(), "PSD - Adobe Photoshop (*.psd)" )
   ListAppend ( sList2(), "RAS - Sun Raster Image (*.ras)" )
   ListAppend ( sList2(), "SGF - StarWriter Graphics Format (*.sgf)" )
   ListAppend ( sList2(), "SGV - StarDraw 2.0 (*.sgv)" )
   ListAppend ( sList2(), "SVM - StarView Metafile (*.svm)" )
   ListAppend ( sList2(), "TGA - Truevision Targa (*.tga)" )
   ListAppend ( sList2(), "TIFF - Tagged Image File Format (*.tif;*.tiff)" )
   ListAppend ( sList2(), "WMF - Windows Metafile (*.wmf)" )
   ListAppend ( sList2(), "XBM - X Bitmap (*.xbm)" )
   ListAppend ( sList2(), "XPM - X PixMap (*.xpm)" )

   'compare the entries
   for i=1 to iCounter
      printlog( " - Checking: " + sList1(i) )
      for j=1 to ListCount ( sList2() )
         if sList1(i) = sList2(j) then
            ListDeleteString ( sList2(), sList1(i) )
            j=30
         end if
      next j
      if j < 30 then Warnlog "This filter is new : " + sList1(i)        ' if new entries in the filter-listbox => new
   next i

   iCounter = ListCount ( sList2 () )
   if iCounter > 0 then
      for i=1 to iCounter
         Warnlog "This filter is missing : " + sList2 (i)         ' if entries are not in the filter-listbox => missing
      next i
   end if

   '///+Close the document
   printlog( "Close the document" )
   hCloseDocument
   
endcase

'-------------------------------------------------------------------------

sub tGrafikEinfuegenSchnellUnverknuepft
   Call tQuickInsertGraphNotAsLink
end sub

'-------------------------------------------------------------------------

sub tGrafikEinfuegenSchnellVerknuepft
   Call tQuickInsertGraphAsLink
end sub

'-------------------------------------------------------------------------
