'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: security_tools.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/05 13:08:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Tools to ease testing of security related funtionality
'*
'*******************************************************************************
'**
' #1 hSetPasswordRecommendation ' Recommend password protection on save on/off
' #0 hWarnAtSaveOrSend ' check or uncheck to warn at save or send
' #1 hOpenDigitalSignaturesDialog ' open the digital signatures dialog via menu
'**
'\******************************************************************************

function hSetPasswordRecommendation( bEnable as boolean ) as boolean

    ' This tiny little function switches password recommendation on (=true)
    ' or off (=false) and returns the prior state

    printlog( "" )
    printlog( " * Open Tools/Options" )
    ToolsOptions
                                                                                                                               
    printlog( " * Go to the security page" )
    hToolsOptions( "STAROFFICE" , "SECURITY" )

    printlog( " * Get the current config for password recommendation" )
    
    kontext "TabSecurity"
    if ( RecommendPasswordProtectionOnSaving.isChecked() ) then
        hSetPasswordRecommendation() = true
    else
        hSetPasswordRecommendation() = false
    endif
                                            
                                                                                       
    if ( bEnable ) then
        printlog( " * Enable password recommendation" )
        RecommendPasswordProtectionOnSaving.check()
    else
        printlog( " * Disable password recommendation" )
        RecommendPasswordProtectionOnSaving.uncheck()
    endif

    Kontext "ToolsOptionsDlg"
    ToolsOptionsDlg.ok()

end function

'******************************************************************************

function hWarnAtSaveOrSend( iMode as integer ) as boolean

     '///<h3>Toggle security option warn at saving or sending of documents</h3>

     ' Imode: 0 = uncheck, 1 = check, -1 = default (uncheck)
     
     ' pessimistic assumption
     hWarnAtSaveOrSend() = false
     
     ToolsOptions

     hToolsOptions( "StarOffice" , "Security" )

     printlog( "" )
     printlog( " * Toggling Checkbox: Warn at saving or sending of documents" )

     kontext "TabSecurity"

     select case iMode
     case -1 : SavingOrSendingDocuments.uncheck()
               printlog( "   [-1] Resetting to default (disabled)" )
               sleep( 1 )
               if ( not SavingOrSendingDocuments.isChecked() ) then
                    hWarnAtSaveOrSend() = true
               endif

     case 0  : SavingOrSendingDocuments.uncheck()
               printlog( "   [0] Disabling warning" )
               sleep( 1 )
               if ( not SavingOrSendingDocuments.isChecked() ) then
                    hWarnAtSaveOrSend() = true
               endif

     case 1  : SavingOrSendingDocuments.check()
               sleep( 1 )
               printlog( "   [1] Enabling warning" )
               if ( SavingOrSendingDocuments.isChecked() ) then
                    hWarnAtSaveOrSend() = true
               endif
     case else
               warnlog( "Invalid parameter specified to hWarnAtSaveOrSend( int )" )
               printlog( "Your input: " & iMode & " Allowed are -1,0,1" )
               hWarnAtSaveOrSend() = false
     end select

     kontext "OptionenDlg"
     OptionenDlg.OK()

end function

'******************************************************************************

function hOpenDigitalSignaturesDialog() as boolean

    '///<h3>Open the Digital Signatures Dialog via File-Menu</h3>
    '///<ul>
    dim brc as boolean
    const CFN = "hOpenDigitalSignaturesDialog::"

    '///<li>Open the file-menu</li>
    call hUseMenu()
    call hMenuSelectNr( 1 )
                                                                                
    '///<li>Select "Digital signatures..."</li>
    try
        if ( ucase( gApplication ) = "MATH" ) then
            call hMenuSelectNr( 14 )
        else
            call hMenuSelectNr( 15 )
        endif
    catch
        warnlog( CFN & "Failed to execute menuitem <Digital Signature...>" )
    endcatch

    ' At this stage either the digital signatures dialog or the messagebox
    ' <The document needs to be saved> is open. In the latter case the function
    ' returns false. The possibility that neither of both dialogs are open
    ' must be handled in the parent function. This means there is no warning
    ' here either
    kontext "DigitalSignature"
    if ( DigitalSignature.exists() ) then
        printlog( CFN & "Digital signatures is open" )
        brc = true
    else
        brc = false
    endif

    '///</ul>
    hOpenDigitalSignaturesDialog() = brc

end function
