'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_namescheck.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/16 14:45:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Compare the names of templates and samples with a reference list
'*
'*******************************************************************************
'**
' #1 tNamesCheck ' Compare the names of templates and samples with a reference list
'**
'\******************************************************************************

testcase tNamesCheck( cCategory )

    ' Allowed cCategory: NEWDOCUMENTS, TEMPLATES, SAMPLES
    '///<h3>Show documents in the preview pane of the teplates-dialog</h3>
    '///<i></i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Name of category (string). Options are:</li>
    '///<ul>
    '///+<li>&quot;NEWDOCUMENTS&quot;</li>
    '///+<li>&quot;TEMPLATES&quot;</li>
    '///+<li>&quot;SAMPLES&quot;</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>


    dim iObjectFolder as Integer   ' the current folder in loops
    dim iObjectFolders as integer  ' the number of template/sample-folders
    dim iObject as Integer         ' the current template/sample within loops
    dim iObjectCount( 20 ) as integer  ' number of templates/samples in the folders
    
    dim cObjectName as string      ' the name of the current object (e.g. Template)
    dim cObjectNameList( 200 ) as string ' List of object names
    dim cReferenceList( 200 ) as string  ' Reference list of object names
    
    dim cFolder as string  ' name of a folder (req. for reference list)
    dim sFileIn as string  ' Name and location of the reference file
    dim sFileOut as string ' Here the lists go if they are newly created
    dim sFile as string    ' The filename
    
    dim brc as boolean
    
    printlog( "" )
    printlog( "Category: " & cCategory )
    printlog( "" )
    
    ' build the filename
    select case cCategory
    case "NEWDOCUMENTS" : sFile = "new_"
    case "TEMPLATES"    : sFile = "tem_"
    case "SAMPLES"      : sFile = "sam_"
    case else
        warnlog( "Invalid category passed to function" )
        goto endsub
    end select
    
    '///+<li>Build the filename we want to work with</li>
    sFile = sFile & iSprache & ".txt"
    
    '///+<li>Build the path to the reference file.</li>
    sFileIn  = gTesttoolPath & "framework/update/input/templdoc/"
    sFileIn  = sFileIn & gProductName & "/" & sFile
    sFileIn  = convertpath( sFileIn )
    sFileOut = hGetWorkPath & sFile

    '///+<li>Open File->New->Templates and documents</li>
    FileNewFromTemplate

    '///+<li>Close possible messagebox with OK</li>
    kontext "active"
    if ( active.exists( 2 ) ) then
        warnlog( "Unexpected messagebox: " & active.gettext() )
        active.ok()
        sleep( 2 )
    end if

    '///+<li>select the requested category</li>
    hSelectCategory( cCategory )
    ' get the number of FOLDERS in the category (not for NEWDOCUMENTS)
    ' For "NEWDOCUMENTS" the number of folders is 1, set directly below "else"

    '///+<li>Get the number of folders in the current category</li>
    if ( cCategory <> "NEWDOCUMENTS" ) then
        iObjectFolders = FileList.getItemCount()

        for iObject = 1 to iObjectFolders
            hSelectFileFolder( iObject , true )
            iObjectCount( iObject ) = FileList.getItemCount()
            UpOneLevel.click()
        next iObject

    else
        iObject = 1
        iObjectCount( iObject ) = FileList.getItemCount()
        iObjectFolders = 1
    endif

    kontext "templateanddocuments"
    '///+<li>Step through all folders and templates/samples</li>

    for iObjectFolder = 1 to iObjectFolders
    
        '///<ol>
        '///+<li>Select the category (samples, templates ...)</li>
	
        hSelectCategory( cCategory )
	
        '///+<li>Select the current folder</li>
        ' select a folder to look in. for NEWDOCUMENTS we are already there so
        ' this stepped is skipped.
        if ( cCategory <> "NEWDOCUMENTS" ) then
            cFolder = hGetFileFolderName( iObjectFolder )
            hSelectFileFolder( iObjectFolder , false )
        end if

        ' Now run through all objects in the filelist, get the names for each one
        for iObject = 1 to iObjectCount( iObjectFolder )
        
            '///+<li>Select the desired template</li>
            cObjectName = cFolder & ":" & hSelectDocumentObject( iObject , 0 )
            listappend( cObjectNameList() , cObjectName )
            wait( 100 )
            
            '///+<li>Next document</li>
        next iObject

        '///</ol>
    next iObjectFolder

    
    '///+<li>Cancel Templates and Documents</li>
    kontext "templateanddocuments"
    TemplateAndDocuments.cancel()
    
    '///+<li>Compare the items from the UI against the reference file</li>
    hManageComparisionList( sFileIn, sFileOut, cObjectNameList() )
    '///</ul>

endcase

