'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: status.inc,v $
'*
'*  $Revision: 1.47 $
'*
'*  last change: $Author: tbo $ $Date: 2006/02/09 15:45:49 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Routines for the status page feature
'*
'*********************************************************************************************
'*
' #1   hStatusIn                   ' initilize variables before the teststart
' #1   hStatusOut                  ' last routine to generate write datas for status-page
' #1   hStatusWriteOutput          ' write the data in a list and when Duration <> '00:00:00' then the list will be writen
' #1   StatusIntoDatabase          ' put all data out of the log-file into the history-database
'*
'\*****************************************************************************************

sub hStatusIn ( sTestAppArea as String, sTestname as String, optional sName as String )
    '///hStatusIn : initilize variables before the teststart
    '///  input  : sTestAppArea => name of the application, to where the test is bound in status database -> gTestAppArea
    '              sTestname    => name of the test (converted to LOWERCASE in this sub!) -> gTestName
    '///+ output : gStatusDuration => starttime of the test
    '///+_       : gTestname    => global name of the test
    '///+_       : gTestAppArea => global name of the tested application as defined in status database
    '///+_       : gTestDate    => global start date of the test ( yyyy-mm-dd )
    '///+_       : gTestTime    => global start time of the test
    ' DEPRECATED: 
    '         sNname       => DEPRECATED just kept for compatibility  
    
    dim bOverRide as boolean
    
    bOverRide = false
    gStatusDuration = now ()                    '(1) used in hStatusOut
                          ' temporarly misused to set the start Date and Time!

    ' Always neede for crashreporter test hint
    gTestName = lcase (sTestname)               '(2)

    ' -------------- EXIT condition ----------------------
    if (NOT isStatusEnabled()) then
        exit sub
    end if

'        if ("true" = Lcase(sName)) then 
'            bOverRide = true
'        endif

    gTestAppArea = lcase (sTestAppArea)         '(3)
    
    gTestDate = convertDateToDatabase (gStatusDuration)  '(4)
    gTestTime = convertTimeToDatabase (gStatusDuration)  '(5)
    
    ListAllDelete(glsStatusPage())
    gErrorSum = getErrorCount()      ' not 0! if you run 2-times status in/out in one bas-file!
    gWarningSum = getWarningCount()
    gQaErrorSum = getQaErrorCount()
    
    ' make shure we have all to update the status-database.
    '/// if you want to simulate 'mahler' create the directory X/history/tooling
    '/// win32: X= a Volume device like 'c:\' in the mahler.inf
    '/// unix: X= any absolute path you like
    gDatabasePath = getDatabasePath("/history/tooling/")
    printlog "** Status will be written to: " + gDatabasePath
end sub

sub hStatusOut ( optional NoKill as Boolean )
    '///hStatusOut : last output for the status-page feature
    '///+ -> create the duration value for the test and call the routine to write the data into the database
    
    ' -------------- EXIT condition ----------------------
    ' don't record status for CWS and if outside of MAHLER
    if (NOT isStatusEnabled()) then
        Printlog "Date: " + Date() + "; Time: " + Time() + "; Duration: " + WieLange ( gStatusDuration )
        exit sub
    end if
    
    if (""=gTestName) then
        warnlog "status.inc::hStatusOut: You forgot to call hStatusIn(''Application'',''FileName.bas'')"
    else
        if isMissing(NoKill) then
            hStatusWriteOutput(FALSE)
        else
            hStatusWriteOutput(NoKill)
        end if
    end if
    
    PrintLog Chr(13) + "* - End of the test - *"
    Printlog "Date : " + Date() + "   Time: " + Time()
    Printlog "Duration : " + WieLange( gStatusDuration )
end sub

sub hStatusAddTestcase()
    ' called from master.inc::TestExit() after every testcase
    ' add to list for second file : testresult table / glsStatusPage()
    ' reset gErrorSum, gWarningSum
    dim sTestcaseDuration as string
    dim sTestcaseStart as string
    Dim sTCname as String
    Dim iCut as Integer
    dim iErrorCount as integer
    dim sErrorList() as string
    dim iQaErrorCount as integer
    dim sQaErrorList() as string
    dim iWarningCount as integer
    dim sWarningList() as string
    Dim sOutput as String
    dim iAllErrorCount as integer
    dim sAllErrorList(42000) as string
    dim i, x as integer
    dim iErrorLevel as integer
    dim sErrorString(4) as string

    '///The entries in the list are ( seperated by TAB ) :
    '///+ testcase name => name of the current testcase in the running test
    '///+ errors => only the errors for the current testcase
    '///+ warnings => only the warnings for the current testcase
    '///+ duration => the duration of the testcase

    sTestcaseDuration = wielange(gTestcaseStart, 1)     '(2)
    sTestcaseStart    = convertDateToDatabase(gTestcaseStart) + " " + convertTimeToDatabase(gTestcaseStart) ' TODO: ask HDE/TBO
    
    sTCname = GetTestcaseName  ' testtool basic command
        iCut = Instr ( sTCname, "(" )
        if (iCut <> 0) then 
            sTCname = Left ( sTCname, iCut - 1 )
        endif
        sTCname = Trim ( sTCname )                      '(1)
    iErrorCount = getErrorCount() - gErrorSum               ' only the errors in a testcase
    iWarningCount = getWarningCount() - gWarningSum         ' only the warnings in a testcase
    iQaErrorCount = getQaErrorCount() - gQaErrorSum         ' only the qaErrors in a testcase

    iAllErrorCount = iErrorCount + iWarningCount + iQaErrorCount
    if (iAllErrorCount > 0) then
        x=1
        sWarningList() = getWarningList()
        for i = (GetWarningCount()+1-iWarningCount) to GetWarningCount()
            sAllErrorList(x) = sWarningList(i)
'd                printlog "++ " + sAllErrorList(x)
            inc(x)
        next i
        sErrorList() = getErrorList()
        for i = (GetErrorCount()+1-iErrorCount) to GetErrorCount()
            sAllErrorList(x) = sErrorList(i)
'd                printlog "++ " + sAllErrorList(x)
            inc(x)
        next i
        sQaErrorList() = getQaErrorList()
        for i = (getQaErrorCount()+1-iQaErrorCount) to getQaErrorCount()
            sAllErrorList(x) = sQaErrorList(i)
'd                printlog "++ " + sAllErrorList(x)
            inc(x)
        next i
    else
        sAllErrorList(0) = "0;0;0;0"
    endif
    
    ' generate status line for testcase and append to global array
    '/// iErrorLevel: 0: no faults; 1: Warning; 2: Error; 3: qaError ///'
    iErrorLevel = -1
'D    printlog "Iall: " + iAllErrorCount + " W:" + iWarningCount + " E: " + iErrorCount
    for i = 0 to iAllErrorCount
        select case i
            case 0: if (0 = iAllErrorCount) then          ' no errors at all
                        iErrorLevel = 0
                    endif
            case 1 to iWarningCount: iErrorLevel = 1      'warnings
            case (iWarningCount +1) to (iWarningCount + iErrorCount): iErrorLevel = 2 ' Errors
            case (iWarningCount + iErrorCount +1) to (iWarningCount + iErrorCount + iQaErrorCount): iErrorLevel = 3 ' qaErrors
        end select
        if (iErrorLevel > -1) then
'd            printlog " " + i + " -------------"
'd            printlog "'" + sAllErrorList(i) + "'"
            sGetErrorStringFields(sAllErrorList(i), sErrorString())
'd            printlog " -------------"
            sOutput =          sTCname _
                    + Chr(9) + sTestcaseDuration _
                    + Chr(9) + iErrorLevel _
                    + Chr(9) + fRemoveLineBreaks(sErrorString(4)) _
                    + Chr(9) + sErrorString(2) _
                    + Chr(9) + trim(sErrorString(3)) _
                    + Chr(9) + fgetFileName(sErrorString(1)) _
                    + Chr(9) 'Description (4)_ 'Line (2)_ 'CVSversion (3)_ 'Filename (1)
            if (sTCname <> "") then
                ListAppend (glsStatusPage(), sOutput)
'd            printlog sOutput
            else
                qaErrorlog "please try not to call a testcase from a testcase #116584#"
            endif
        endif
    next i
    
    ' to set the variables to the current numbers    
    gErrorSum = getErrorCount()
    gQaErrorSum = getQaErrorCount()
    gWarningSum = getWarningCount()
end sub


sub hStatusWriteOutput (optional NoKill as Boolean)
    ' called from hStatusOut    
    Dim sPlat as String
    Dim sOutFile as String
    Dim sOutFileTemp as String
    Dim sBuildHisPath as string
    Dim sResultPath as string    ' location where to write the files for status to
    Dim i,j as Integer
    Dim bNoKill as Boolean
    dim iIsNet as integer
    dim lTestrun(20) as string
    dim sVersionMajor as string
    dim sVersionMinor as string
    dim sVersionBuilID as string
    dim sDebugInfo as string
    dim sTemp as string
    dim sFileName as string
    dim slVersion() as string
    dim ilVersion as integer
    dim sLastVersion as string
    dim sVersionCWS as string
    dim iPosA as integer
    dim iPosB as integer
    dim bError as boolean
    dim sTestDuration as string
    
    '///hStatusWriteOutput : output routine for status page of our testscripts
    '///The entries in the list are ( seperated by NEWLINE ) :
    '///+ major => major number of full buildID of StarOffice ( e.g. '642' )
    '///+ minor => minor number of full buildID of StarOffice ( e.g.'L' )
    '///+ buildID => only the buildID of full buildID of StarOffice ( e.g.'7733' )
    '///+ date ( gTestDate ) time ( gTestTime ) => fix date when the test started
    '///+ platform => short cut for platform
    '///+ machine name => name of the PC or UNIX-machine where the test is running
    '///+ user name => namen of the user who run the test ( on windows vcsid must be set as globale system variable )
    '///+ installation type (gNetzInst) => user / system
    '///+ language => language of the office
    '///+ test name => name of the test ( e.g. first.bas )
    '///+ test application area (gApplication) => which application is tested
    '///+ test duration => Hours:Minutes:Seconds ( e.g.'01:20:33' )
    '///+ cws name => if it is the master: 'Master' else teh name of the childworkspace

    if isMissing(NoKill) then
        bNoKill = FALSE
    else
        bNoKill = NoKill
    end if
    
    if gNetzInst then                                             '(8)
        iIsNet = 1
    else
        iIsNet = 0
    endif

    if ("unx" = gPlatgroup) then                                  '(5)
        sPlat = gPlatform
    else
        sPlat = "win"
    end if

    ' since #112922# we'll be able to see the applied patches: '645m18(Build:8687),645m18(Build:8687)[CWS:so7aighotpatch],schnubbel'
    slVersion() = Split(gVersionsnummer, ",") 
    ilVersion = uBound(slVersion()) ' array counts from 0 on!
    sLastVersion = slVersion(ilVersion)
    ' major is from start to 'm'
    iPosA = 1
    iPosB = instr(sLastVersion, "m")
    if (iPosB = 0) then ' there is no minor
        iPosB = instr(sLastVersion, "(")
    endif    
    sVersionMajor = Mid(sLastVersion, iPosA, (iPosB-iPosA))      '(1) Major
    iPosA = iPosB
    iPosB = instr(sLastVersion, "(")
    sVersionMinor  = Mid(sLastVersion, iPosA, iPosB-iPosA)        '(2) Minor
    iPosA = instr(sLastVersion, ":") + 1
    iPosB = instr(sLastVersion, ")")
    sVersionBuilID = Mid(sLastVersion, iPosA, iPosB-iPosA)        '(3) Build
    if gCWS then
        iPosA = instr(iPosB, sLastVersion, ":") + 1
        iPosB = instr(iPosA, sLastVersion, "]")
        sVersionCWS = Mid(sLastVersion, iPosA, iPosB-iPosA)       '(13) CWS
    else
        sVersionCWS = "Master"
    endif
    
    ' for MSC calculation of test duration hh:mm
    sTestDuration = wielange(gStatusDuration, 1)                  '(12)

    ' generate list for test - database 'testrun' in first file : testrun table
    '/// the list will be written at /export/home/q_testtool/history/tooling/database/*.log
    ListAppend ( lTestrun(), sVersionMajor)
    ListAppend ( lTestrun(), sVersionMinor)
    ListAppend ( lTestrun(), sVersionBuilID)
    ListAppend ( lTestrun(), gTestDate + " " + gTestTime)         '(4)  ' generated in hStatusIn
    ListAppend ( lTestrun(), sPlat       )
    ListAppend ( lTestrun(), gPCName     )                        '(6)
    ListAppend ( lTestrun(), gUser       )                        '(7)
    ListAppend ( lTestrun(), iIsNet      )
    ListAppend ( lTestrun(), iSprache    )                        '(9)
    ListAppend ( lTestrun(), gTestName   )                        '(10) ' generated in hStatusIn
    ListAppend ( lTestrun(), gTestAppArea)                        '(11) ' generated in hStatusIn
    ListAppend ( lTestrun(), sTestDuration)
    ListAppend ( lTestrun(), sVersionCWS)
    
    ' wget is at gDatabasePath
    ' files are created at (convertPath'ed):
    sResultPath = convertPath(gDatabasePath + "database/")
    ' all files start with (LOWERCASE); there will exists four of them "NAMEi.txt":
    sFileName   = lcase(sPlat + gUser + gPCname + Left(gTestname, Len(gTestname)-4) + "-" + iSprache + "-" )
    sOutFile    = sResultPath + sFileName
    
    ' TODO: make shure location is writeable! with file 'sOutFile'!!! 

    ' delete old files
    for i = 1 to 4
        sOutFileTemp = sOutFile+i+".txt"
        if (FileExists(sOutFileTemp)) then
'            printlog sOutFileTemp
            kill sOutFileTemp
            Sleep (1)
            if (dir(sOutFileTemp) <> "") then 
                warnLog "OLD File can't get deleted: " + sOutFileTemp
            endif
        end if
    next i

    'write 'testrun' 
    ListWrite (lTestrun(), sOutFile+"1.txt")
'    printlog "------------------------------------------------------------------"
'    for i = 1 to ListCount(glsStatusPage())
'        printlog ""+i+": " + glsStatusPage(i)
'    next i
'    printlog "------------------------------------------------------------------"
    fCalculateStatusPage() ' check if test was run for several gApplications
'    printlog "------------------------------------------------------------------"
'    for i = 1 to ListCount(glsStatusPage())
'        printlog ""+i+": " + glsStatusPage(i)
'    next i
'    printlog "------------------------------------------------------------------"
    'write 'testresult' 
    ListWrite (glsStatusPage(), sOutFile+"2.txt")
    for i = 1 to 2
        sOutFileTemp = sOutFile+i+".txt"
        if (dir(sOutFileTemp) = "") then warnlog "File wasn't created: " + sOutFileTemp
    next i

    ' debug
' from now on the status routines are not executed, because i use tescases for displaying debug information, that should not get recorded
gTestName="" '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!    
    if (bNoKill) then 
        for i = 1 to 2
            sOutFileTemp = sOutFile+i+".txt"
            if hFileExists(sOutFileTemp) then
                tDebugInfoMysql (sOutFileTemp)
            endif
        next i
    endif

    ' call php-script to get 2 files into the database
    bError = StatusIntoDatabase (sFileName, sPlat, bNoKill, gDatabasePath)
    if bError then
        exit sub ' -> on error no file get's deleted!
    end if

    ' wait until result-file got created; after 3 minutes cancel wait!
    sOutFileTemp = sOutFile+"3.txt"
    i = 0
    listAllDelete(glsStatusPage())
    while (("" = dir(sOutFileTemp)) AND (i < 18))
        sleep 10
        inc (i)
    wend
    bError = True
    if (i = 18) then ' big database error; resultfile wasn't created
        warnlog "Status Write Error! (TimeOut waiting for php-OK-message-file)"' Copied files to '" + convertPath(gOfficePath + "user/work/ttstatus/") + "'"
        sOutFileTemp = sOutFile+"4.txt"
        if hFileExists(sOutFileTemp) then
            ListRead(glsStatusPage(), sOutFileTemp)
            tDebugInfoMysql (sOutFileTemp)
        ' further parsing of file!
        endif
    else
        ListRead(glsStatusPage(), sOutFileTemp)   '3
        i = ListCount(glsStatusPage())
        if (1 = i) then
            if (glsStatusPage(1) <> "OK") then
                warnlog "Error in writing status to database (<> OK): '" + glsStatusPage(1) + "'"
            else
                printlog " * - Status successfull written into database - * "
                bError = False
            endif
        else
            warnlog "Error in writing status to database (<> 1 line)"
        endif
        if bError then
            tDebugInfoMysql (sOutFile+"4.txt")'4.
        endif
    endif

'    ' copy files to user/work/ttstatus/        
'    try
'        mkdir(convertPath(gOfficePath + "user/work/ttstatus"))
'    catch
'        printlog "cant create : " + convertPath(gOfficePath + "user/work/ttstatus")
'    endcatch
'    for j = 1 to 4
'        sOutFileTemp = sOutFile+j+".txt"
'        if hFileExists(sOutFileTemp) then
'            try
'                fileCopy(sOutFileTemp,convertPath(gOfficePath + "user/work/ttstatus/"+sFileName+j+".txt"))
'            catch
'                printlog "cant copy : " + convertPath(gOfficePath + "user/work/ttstatus"+sFileName+j+".txt")
'            endcatch
'        endif
'    next j


    ' delete files
    if ((bNoKill=FALSE) AND (bError=FALSE)) then 
        for j = 1 to 4
            sOutFileTemp = sOutFile+j+".txt"
            for i=1 to 20
                try
                    if (dir(sOutFileTemp) <> "") then
                            kill ( sOutFileTemp )
                    end if
                catch
                    Sleep (2)
                    printlog "catched " + j + " " + i
                endcatch
            next i
            if (dir (sOutFileTemp) <> "") then 
                if (bNoKill = FALSE) then warnlog "File wasn't deleted: " + sOutFileTemp
            endif
        next j
    endif
    ListAllDelete (glsStatusPage())   ' delete the list, because if you want to use hStatusIn twice or more
end sub


function StatusIntoDatabase (sFile as String, sPlat as String, NoKill as Boolean, sPath as string) as boolean
    dim sSource as string
    dim sDestination as string
    dim i as integer

    '///StatusIntoDatabase : write the collected data into the database
    if (gMahlerLocal = "") then
        StatusIntoDatabase = getWebPage (sPath, sPath+"database/"+sFile+"4.txt", sPlat, "http://10.16.64.74/qa_status/admin/ttdocs/data_add.php?result_file=" + sFile)
    else
        StatusIntoDatabase = FALSE
        'create 3. file with OK :-)
        sSource = convertPath(sPath+"database/")
        sDestination = sSource+"mahlerlocal"
        TextInDatei("OK", sSource+sFile+"3.txt")
        'move other files to directory, because standard is to delele successfull submitted data
        if (dir(sDestination, 16) = "") then ' doesn't exist      
            MkDir (sDestination)
            if (dir(sDestination, 16) = "") then ' doesn't exist      
                warnlog "Database directory can't get created: '" + sDestination + "'"
            else
                printlog "Database directory created: '" + sDestination + "'"
            endif
        endif
        sDestination = sDestination + gPathSigne
        'check file exist before copieing!
        i = 0
        while (fileExists(sDestination+sFile+i+"-1.txt"))
            inc(i)
        wend
        filecopy(sSource+sFile+"1.txt", sDestination+sFile+i+"-1.txt")
        filecopy(sSource+sFile+"2.txt", sDestination+sFile+i+"-2.txt")
        if (i<>0) then
            qaErrorlog "The same test already exists in the local database."
            printlog "Test: " + sFile + " Count: " + i
        endif
    endif
end function

function getWebPage (sPath as string, sResult as String, sPlat as String, sURL as string) as boolean
    Dim iShellReturn as integer
    dim i as integer

    if (sPlat = "win") then
        sPlat = "exe"
    endif

    try
        ' try to use the wget that is installed on the system
        iShellReturn = Shell ("wget", 1,"-q -O " + sResult + " " + sURL , false) ' don't wait - to try to find a culprint
            i = 0
            ' wait 10 minutes for resultfile creation from php-script
            while (i<200 and (not fileexists(left(sResult,len(sResult)-5)+"3.txt")))
                Sleep (3)
                inc(i)
            wend
    catch
        iShellReturn = 99
    endcatch
    if (iShellReturn <> 0) then 
        try
             ' have to use the global wget
    '        printlog sPath + "wget."+sPlat+" -q -O " + sResult + " " + sURL 
            iShellReturn = Shell (sPath + "wget."+sPlat, 1,"-q -O " + sResult + " " + sURL , true)
        catch
            iShellReturn = 99
        endcatch
    endif
    if (iShellReturn <> 0) then 
        warnlog "no program called 'wget' available." + iShellReturn
        getWebPage = true
    else
        getWebPage = false
    endif
    Sleep 10
end function


testcase tDebugInfoMysql (sTemp as string)
' to show the debuginfo folded in a testcase (if nokill = true)
    dim fTemp(900) as string

    fTemp(0)=0
    printlog stemp
    try
        ListRead (fTemp(), sTemp)
        for i=1 to ListCount (fTemp())
            if (fTemp(i) <> "") then printlog fTemp(i)
        next i
    catch
    endcatch
endcase

function isStatusEnabled() as boolean
    '/// enable status only when: ///'
    '///+ basedirectory is on mahler (file exists: errorlog/mahler/mahler.inf) ///'
    isStatusEnabled = gMahler
end function

function convertDateToDatabase(byVal inDate as Date) as string
    Dim IsoData$, y$, m$, d$
    Dim dValue
    
    try
        dValue = DateValue(inDate)
        IsoData$ = CDateToIso (dValue)
    catch
        qaErrorLog "global::system::inc::status.inc::convertDateToDatabase; looking for root cause: 'Data type mismatch'; Input: '" + inDate + "'"
    endcatch
    y$ = left$( IsoData$, 4 )
    m$ = mid$( IsoData$, 5, 2 )
    d$ = right$( IsoData$, 2 )
    convertDateToDatabase = y$ + "-" + m$ + "-" + d$
end function

function convertTimeToDatabase(byVal inTime as Date) as string
    dim iSpace as integer
    
    iSpace = inStr(inTime, " ")
    if (iSpace > 0) then
        inTime = right(inTime, len(inTime) - iSpace)
    endif
    if (iSystemSprache = 1) then
        try
            convertTimeToDatabase = TimeValue(inTime)
        catch
            qaErrorLog "global::system::inc::status.inc::convertTimeToDatabase; looking for root cause: 'Data type mismatch'; Input: '" + inTime + "'"
        endcatch
    else
        convertTimeToDatabase = Format (inTime, "hh:mm:ss")
    endif
end function

function getDatabasePath(sSubDirectory as string) as string
    Dim i,j as Integer
    dim iPosA as integer
    dim iPosB as integer
    dim lTemp(100) as string
    dim sPath as string
    dim sVolume as string
    dim sPathSeed as string

    ' get the 'volume'
    ' assumption: the only supported testcases are always on mahler -> gTestToolPath provides a valid volume !
    ' on unix take the gTestToolPath and travel up from there, until the directory sCommomPath exists :-))
    ' on windows it has to start with [Letter]:\
    ' -> if i know where gTestToolPath points to, i'll get the directory i want
    ' ---->>> set sVolume
    if (gMahlerLocal <> "") then
    ' local simulation of mahler
        sPathSeed = gMahlerLocal
    else
        ' mahler is realy available
        sPathSeed = gTestToolPath
    endif
    if gPlatGroup = "unx" then
'        printlog sPathSeed
        i = DirNameList(sPathSeed, lTemp())
'        for j = 1 to i 
'            printlog "" + j + ": '" + lTemp(j) + "'"
'        next j
        iPosA = i
        do
            sPath = ""
            for j = 1 to iPosA
                sPath = sPath + lTemp(j)
            next j
'            printlog sPath
            dec(iPosA)
        loop while ((app.Dir(sPath+sSubDirectory, 16) = "") AND (iPosA > 0))
        if (iPosA < 1) then
            ' last try: hard fallback
            sPath = "/net/mahler/export/software/q_testtool/"
            if (app.Dir(sPath+sSubDirectory, 16) = "") then
                qaErrorLog "status.inc::hStatusWriteOutput: unix can't find database anywhere: '" + sPathSeed+ "'"
            else
                sVolume = sPath
            endif
            ' TODO: nice exit...
        else
            sVolume = sPath
        end if
    else
        if (inStr(sPathSeed,":") <> 2) then
            qaErrorLog "status.inc::hStatusWriteOutput: win32 wrong assumption, why doesn't it look like 'V:\' ??? - '" + sPathSeed+"'"
            ' TODO: nice exit...
            ' IDEA: or try as last fallback on usual mount point and maybe //mahler/software....
        else
            try
                sVolume = left(sPathSeed, 2)
            catch
                qaErrorLog "global::system::inc::status.inc::getDatabasePath; looking for root cause: 'Data type mismatch'; Input: '" + sPathSeed + "'"
            endcatch
        endif
    end if

    getDatabasePath = sVolume + sSubDirectory
end function    

sub sGetErrorStringFields(sIn as string, sOut() as string)
    '/// put semicolon seperated string into an array ///'
    '/// only used on every line from returnvalue of get*List() ///'
    dim sTemp(3) as string
    dim sTemp2() as string
    dim i as integer
    if ("" = sIn) then     ' workaround for i23697 split() returns wrong value on empty string
        for i=0 to 3
            sTemp(i) = ""
        next i
    else
        sTemp() = Split(sIn, ";") 
    endif
    if ((uBound(sTemp())+1) <>  uBound(sOut())) then
        for i = 1 to (uBound(sOut()) -1)
             sOut(i) =  sTemp(i-1)
        next i
        redim sTemp2(uBound(sTemp()) - uBound(sOut())+1) as string
        for i = (uBound(sOut())-1) to uBound(sTemp())
             sTemp2(i-(uBound(sOut())-1)) = sTemp(i)
        next i
        sOut(uBound(sOut())) = join(sTemp2(), ":")
    else
        for i = 0 to uBound(sTemp())
            sOut(i+1) = sTemp(i)
        next i
    endif
    
'    for i = 0 to uBound(sTemp())
'd        printlog "" + i + ": " + sTemp(i)
'    next i
end sub

function fRemoveLineBreaks(sIn as string) as string
    '/// Clean string from reserved characters and remove linebreaks ///'
    '/// only used for errormessage in third field from get*List() ///'
    dim sLocal as string
    dim x as integer
    dim iCharacters(6) as integer
    iCharacters(1) = 9  ' TAB  because it is field seperator in data file
    iCharacters(2) = 10 ' LF   because no linebreak is allowed in data file
    iCharacters(3) = 13 ' CR   because no linebreak is allowed in data file
    iCharacters(4) = 39 ' '    because is string delemiter for mysql        
    iCharacters(5) = 8216 ' '  because is string delemiter for mysql        
    iCharacters(6) = 8217 ' '  because is string delemiter for mysql        
    
    sLocal = sIn
    
    for x = 1 to 6
        sLocal = removeCharacter(sLocal,iCharacters(x))
    next x
    
    fRemoveLineBreaks = sLocal
end function

function removeCharacter(sIn as string, iCharacter as integer) as string
    dim sLocal as string
    dim sArray() as string
    dim i as integer
    dim iBound as integer
    sLocal = sIn
        if ("" = sLocal) then     ' workaround for i23697 split() returns wrong value on empty string
'            for i=0 to 3
'                sTemp(i) = ""
'            next i
        else
            sArray() = split(sLocal, chr(iCharacter))
        endif
        sLocal = ""
        iBound = uBound(sArray())
'        if (iBound > 0) then printlog "########## " + i + " - " + iCharacters(x) + " ++++ " + iBound 
        for i = 0 to iBound
            sLocal = sLocal + sArray(i)
        next i
    removeCharacter = sLocal
end function

function fgetFileName(byVal sIn as string) as string
    '/// extract file name from string, where PathSeperator is always Backslash ///'
    '/// only used for filestring in first field from get*List() ///'
    dim sTemp(0) as string
    if ("" = sIn) then     ' workaround for i23697 split() returns wrong value on empty string
        sTemp(0) = ""
    else
        sTemp() = split(sIn, "\") ' GH returns hopefully always a Backslash as seperator
    endif
    fgetFileName = sTemp(uBound(sTemp()))
end function


function fCalculateStatusPage() ' check if test was run for several gApplications
    dim aListLine() as string
    dim lListSeperated(32000,8) as string
    dim i as integer
    dim x as integer
    dim sTemp(10) as string
    dim aListLine2(7) as string
    dim iStatusPage as integer
    
    if (ListCount(glsStatusPage()) > 1) then
        lListSeperated(0,0) = ListCount(glsStatusPage())
            ' sort to get all testcases after another
            ListSort (glsStatusPage())
            ' split to evaluate the testcases
            ' presupposition: only 2 gApplications are used!
            for i = 1 to val(lListSeperated(0,0))
                aListLine() = split(glsStatusPage(i),Chr(9))
                for x = 0 to uBound(aListLine())
                    lListSeperated(i,x) = aListLine(x)
                next x
            next i
'd            printlog "1st testcase: " + lListSeperated(1,0) + " + " + lListSeperated(1,1) 
'd            printlog "2nd testcase: " + lListSeperated(2,0) + " + " + lListSeperated(2,1)
            ' we now have to look for the 0-error entries - everything else works just as it is!
            ' these entries are either at the beginning or end of the testcase boundaries
            ' just look for 0-error entries; if the same testcase name follows:
 'TODO:  !! respect the array bundaries !!
            '      - with 0-errors: delete the entry and add the time
            '      - with more errors: delete current entry and add time
            '      - no entry follows: look back one entry:
            '            - same testcase: has an error, just delete entry
            '            - different testcase: unique run - do nothing
            iStatusPage=1
            for i = 1 to val(lListSeperated(0,0))
                if (val(lListSeperated(i,2)) = 0) then
                    if ((i<val(lListSeperated(0,0))) AND (lListSeperated(i,0) = lListSeperated(i+1,0))) then
                        if (val(lListSeperated(i+1,2)) = 0) then
                            'delete i+1 and add time
                            lListSeperated(i,1) = addDuration(lListSeperated(i+1,1), lListSeperated(i,1))
                            for x = 0 to 6
                                aListLine(x) = lListSeperated(i,x)
                                lListSeperated(i+1,x) = "99"
                            next x
                            glsStatusPage(iStatusPage) = join(aListLine(),Chr(9))
                            inc(i)
                            inc(iStatusPage)
                        else
                            ' delete i and add time
                            lListSeperated(i+1,1) = addDuration(lListSeperated(i+1,1), lListSeperated(i,1))
                            for x = 0 to 6
                                aListLine(x) = lListSeperated(i+1,x)
                                lListSeperated(i,x) = "99"
                            next x
                            glsStatusPage(iStatusPage) = join(aListLine(),Chr(9))
                            inc(iStatusPage)
                        endif
                    else
                        if ((i<>1) AND (lListSeperated(i,0) = lListSeperated(i-1,0))) then
                            'delete i
                            for x = 0 to 6
                                lListSeperated(i,x) = "99"
                            next x
                        else
                            'copy
                            for x = 0 to 6
                                aListLine(x) = lListSeperated(i,x)
                            next x
                            glsStatusPage(iStatusPage) = join(aListLine(),Chr(9))
                            inc(iStatusPage)
                        endif
                    endif
                else
                    'copy
                    for x = 0 to 6
                        aListLine(x) = lListSeperated(i,x)
                    next x
                    glsStatusPage(iStatusPage) = join(aListLine(),Chr(9))
                    inc(iStatusPage)
                endif
            next i
            glsStatusPage(0) = iStatusPage-1
    endif
end function

function addDuration(d1 as string, d2 as string) as string
    dim a1(2) as string
    dim a2(2) as string
    dim a3(2) as string
    dim i as integer
    dim x as integer 'Rest
    dim y as integer 'ȣbertrag
    dim z as integer 'Result
    
    a1() = split(d1,":")
    a2() = split(d2,":")
    y = 0
    for i = 2 to 0 step -1
        z = val(a1(i)) + val(a2(i)) + y
        x = z mod 60
        y = z / 60
        a3(i) = x
        if (val(a3(i)) < 10) then
            a3(i) = "0"+a3(i)
        endif
    next i
    if (a3(0) > 24) then
        a3(0) = 24
        qaErrorlog "not critical; writing duration to database: cutted hours: day has only 24h"
    endif
    addDuration = join(a3(),":")
end function

