'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: t_doc2.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:09:17 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Global Routines for Document Handling; Part two
'*
'************************************************************************
' #1 hTabelleEinfuegen
' #1 ZellenMarkieren
' #1 hRechteckErstellen
' #1 hTextrahmenErstellen
' #1 SchreibenInMathdok
'\***********************************************************************

sub hTabelleEinfuegen
'/// <b>WRITER only </b>///'
'///  hTabelleEinfuegen hInsertTable ///'
'/// insert a dummy table in writer/writerweb/masterdocument ///'
   TableInsertTable
   sleep(2)
   Kontext "TabelleEinfuegenWriter"
   wait 500
   TabelleEinfuegenWriter.OK
   sleep(1)

   Kontext "TableObjectbar"
   sleep(1)
   if TableObjectbar.NotExists then
      Kontext "TextObjectbar"
      TextObjectbar.SetNextToolBox
   end if

   Select Case gApplication
      Case "WRITER"
         Kontext "DocumentWriter"
      Case "MASTERDOC"
         Kontext "DocumentMasterDoc"
      Case "HTMLDOKUMENT"
         Kontext "DocumentWriterWeb"
   end select
   sleep(1)
end sub

'-------------------------------------------------------------------------

sub ZellenMarkieren ( Down%, Right% )
'/// <b>CALC only</b> ///'
'/// ZellenMarkieren ( Down%, Right% ) : mark the cells ///'
   Dim Anzahl as Integer

   Kontext "DocumentCalc"
   Anzahl = Right% - 1
   DocumentCalc.TypeKeys "<Shift Right>", Anzahl
   Anzahl = Down% - 1
   DocumentCalc.TypeKeys "<Shift Down>", Anzahl
end sub

'-------------------------------------------------------------------------

sub hRechteckErstellen ( BeginX%, BeginY%, EndX%, EndY% )
'/// <b>IMPRESS/DRAW only</b> ///'
'/// hRechteckErstellen ( BeginX, BeginY, EndX, EndY ) : create a rectangle ///'
   WL_DRAW_Rechteck
   gMouseMove ( BeginX%, BeginY%, EndX%, EndY% )
end sub

'-------------------------------------------------------------------------

sub hTextrahmenErstellen ( TextEingabe$, BeginX%, BeginY%, EndX%, EndY% )
'/// <b>IMPRESS/DRAW only</b> ///'
'/// hTextrahmenErstellen ( String, BeginX, BeginY, EndX, EndY ) : create a textbox with a textstring ///'
   WL_SD_TextEinfuegenDraw
   gMouseMove ( BeginX%, BeginY%, EndX%, EndY% )
   hTypeKeys TextEingabe$
end sub

'-------------------------------------------------------------------------

sub SchreibenInMathdok ( Eingabe as String )
'/// <b>MATH only</b> ///'
'/// SchreibenInMathDok ( String ) : write text in a mathdocument ( with clipboard ) ///'
   if Eingabe <> "Unsinn" then
      SetClipboard Eingabe
   else
      SetClipboard "NROOT <?> <?><over b==<?>"
   endif
   if (GetClipboard() <> Eingabe) then
      warnlog "--No Clipboard available :-(--"
      printlog "---ClipTest--- should: "+Eingabe +", is: "+GetClipboard
   endif
   EditPaste
   sleep(3)
end sub

'-------------------------------------------------------------------------

