'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: t_option2.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: tbo $ $Date: 2006/01/31 12:30:19 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Tools library for options testcases
'*
'************************************************************************
'*
' #0 OptionTabPageZaehler           ' Counting tab pages in Tools / Options
' #0 ToPosInOptionlist              ' Jumping to the correct position in the options tree
' #0 DialogeFuerTypenKontrollieren  'Complete test for path-options
' #1 hSetMacroSecurity ' switch between security levels in Tools/Options
' #0 fGetSetMacroSecurityUNO ' switch between security levels in Tools/Options without using UI
'*
'\***********************************************************************

function OptionTabPageZaehler ( SollAnzahl as Integer, optional Ausnahme as Boolean )
'parameter Ausnahme is depracted
   Dim IstAnzahl
   Kontext "ExtrasOptionenDlg"
   IstAnzahl = Optionsliste.GetItemCount - iSectionNumber
   if Ausnahme = FALSE then
      if IstAnzahl <> SollAnzahl then WarnLog "Number of tabpages old :  " + SollAnzahl + "   new :  " + IstAnzahl
   end if
   OptionTabPageZaehler = IstAnzahl
end function

'-------------------------------------------------------------------------

sub ToPosInOptionlist ( Sprung as Integer )
  Dim i as Integer
   Kontext "OptionenDlg"
   Optionsliste.TypeKeys "<HOME>"
   for i = 1 to 12
      Optionsliste.TypeKeys "-<DOWN>"
   next i
   Optionsliste.Select Sprung
   Optionsliste.TypeKeys "+"
end sub

'-------------------------------------------------------------------------

sub DialogeFuerTypenKontrollieren
' Complete test for path-options, for all entries the file-dialog or the path-dialog will be opened
  Dim i as Integer
  Dim iCount as Integer
  Dim iErrorCount as integer
  
   Kontext "TabPfade"
   Typ.TypeKeys "<Down><Down><Home>"
   iCount = 0
   iErrorCount = 0
   for i=1 to Typ.GetItemCount
      if i<>1 then Typ.TypeKeys "<Down>"
      if bAsianLan <> TRUE then
         try
            Bearbeiten.Click
            kontext
            if active.exists (3) then
                iErrorCount = iErrorCount + 1
                if (iErrorCount > 1) then
                    Warnlog active.getText
                endif
                qaErrorlog "WorkAround for #109107# has to come up only once @'Add-Ins'! else BUG!"
                active.ok
            endif
            Kontext "OeffnenDlg"
            if OeffnenDlg.Exists(2) then
               if Dateityp.IsVisible = TRUE then Warnlog "The normal FileOpen-Dialog is visible with the Filetype-Listbox => BUG!"
               OeffnenDlg.Cancel
            else
               Kontext "PfadeAuswaehlen"
               PfadeAuswaehlen.Cancel
            end if
            Sleep (1)
            Kontext "TabPfade"
         catch
            Warnlog "Error on entry " & i & "!"
            Exceptlog
         endcatch
      else
         try
            if Bearbeiten.IsEnabled = TRUE then
               Bearbeiten.Click
                kontext
                if active.exists (3) then
                    iErrorCount = iErrorCount + 1
                    if (iErrorCount > 1) then
                        Warnlog active.getText
                    endif
                    qaErrorlog "WorkAround for #109107# has to come up only once @'Add-Ins'! else BUG!"
                    active.ok
                endif
               Kontext "OeffnenDlg"
               if OeffnenDlg.Exists(2) then
                  if Dateityp.IsVisible = TRUE then Warnlog "The normal FileOpen-Dialog is visible with the Filetype-Listbox => BUG!"
                  OeffnenDlg.Cancel
               else
                  Kontext "PfadeAuswaehlen"
                  PfadeAuswaehlen.Cancel
               end if
               Sleep (1)
               Kontext "TabPfade"
            else
               iCount = iCount + 1
            end if
         catch
            Warnlog "Error on entry " & i & "!"
            Exceptlog
         endcatch
      end if
   next i
   if iCount > 3 then Warnlog "There are more than 3 entries are disabled!"
end sub

'-------------------------------------------------------------------------

function hSetMacroSecurity( iLevel as integer ) as integer
    ' Input:       Security level where 0 = low and 3 = very high
    ' Returnvalue: Previous security level, -1 on error
    ' NOTE:        If possible use this function outside the testcase

    '///Switch between macro security levels in Tools/Options
    '///<ul>    
    const CFN = "hSetMacroSecurity::"
    const IC_LOW      = 0
    const IC_MEDIUM   = 1
    const IC_HIGH     = 2
    const IC_VERYHIGH = 3
    dim iOldSecurityLevel as integer
    
    if ( ( iLevel < 0 ) or ( iLevel > 3 ) ) then
        warnlog( CFN & "Invalid index (0...3) passed to function: " & ilevel )
        hSetMacroSecurity() = -1
        exit function
    end if
    
    '///<li>Open Tools/Options -> OpenOffice.org/Security</li>
    ToolsOptions
    hToolsOptions( "Staroffice" , "Security" )
    
    '///<li>Click on the macro security button</li>
    Kontext "TabSecurity"
    if ( MacroSecurity.exists() ) then
        MacroSecurity.click()
        
        '///<li>Ensure we are on the Security Level page</li>
        Kontext
        active.setpage TabSecurityLevel
        '///<li>Get the current setting (=returnvalue)</li>
        Kontext "TabSecurityLevel"
        if ( veryhigh.isChecked() ) then
            iOldSecurityLevel = IC_VERYHIGH
        elseif( high.isChecked() ) then
            iOldSecurityLevel = IC_HIGH
        elseif( medium.isChecked() ) then
            iOldSecurityLevel = IC_MEDIUM
        elseif( low.isChecked() ) then
            iOldSecurityLevel = IC_LOW
        end if
    
        '///<li>Set the new security level</li>
        select case iLevel
            case IC_LOW
                low.check()
                printlog( CFN & "Setting macro security level to low" )
            case IC_MEDIUM
                medium.check()
                printlog( CFN & "Setting macro security level to medium" )
            case IC_HIGH
                high.check()
                printlog( CFN & "Setting macro security level to high" )
            case IC_VERYHIGH
                veryhigh.check()
                printlog( CFN & "Setting macro security level to very high" )
        end select

        '///<li>Close Tools/Options</li>    
        TabSecurityLevel.ok()
        '/// update global variable  gMacroSecurityLevel ///'
        gMacroSecurityLevel = iLevel
    else
        warnlog( CFN & "The Macro Security Button is not available" )
        iOldSecurityLevel = -1
    end if
    Kontext "OptionenDLG"
    OptionenDLG.OK()
    '///</ul>
    hSetMacroSecurity() = iOldSecurityLevel
end function

'-------------------------------------------------------------------------

function fGetSetMacroSecurityUNO (optional iLevel as integer) as integer
    ' Input  : Security level where 0 = low and 3 = very high; empty: just return current value
    ' Return : Previous security level, -1 on error
    ' Changes: If iLevel is given, update global variable gMacroSecurityLevel to new level
    ' NOTE   : If possible use this function outside the testcase
    '///Switch between macro security levels in Tools/Options without using the UI
    Dim sFileFunction as string
    Dim iOldSecurityLevel as integer
    Dim oUnoOfficeConnection as object
    Dim oUnoConfigurationAccess as object
    Dim aPropertyValue(1) As new com.sun.star.beans.PropertyValue ' Array of pairs: Property with Value
    Dim xViewRoot
    Dim bOptional as boolean

    sFileFunction = "global::tools::inc::t_option2.inc::hSetMacroSecurity::"
    bOptional = isMissing(iLevel)
    iOldSecurityLevel = -1

    ' Open OOo UNO-Port for communication
    oUnoOfficeConnection=hGetUnoService(TRUE)
    if (NOT isNull(oUnoOfficeConnection)) then
        try
            ' Open Configuration access
            oUnoConfigurationAccess=oUnoOfficeConnection.createInstance("com.sun.star.configuration.ConfigurationProvider")
            if (NOT isNull(oUnoConfigurationAccess)) then
                ' Specifies the location of the view root in the configuration:
                ' The value is the Path name of the configuration item to change.
                aPropertyValue(0).Name="nodepath"
                ' Controls how updates are handled in the cache: If false , the cache 
                ' must operate in  write-through mode, where updates are written to 
                ' persistent storage at once - that is before ::commitChanges()  returns.
                aPropertyValue(1).Name="lazywrite"
                aPropertyValue(1).Value=False
        
                '///Tools / Options / Security
                '///Check which 'Macro Security Level' is set and put it into returnvalue. 
                aPropertyValue(0).Value="/org.openoffice.Office.Common/Security/Scripting"
                xViewRoot=oUnoConfigurationAccess.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess",aPropertyValue())
                iOldSecurityLevel = xViewRoot.getByName("MacroSecurityLevel")
                ' If input is given, use it by setting the Security Level
                if NOT bOptional then
                    xViewRoot.setPropertyValue("MacroSecurityLevel", iLevel)
                    xViewRoot.commitChanges()
                    ' Since we use lazywrite=false, the call to '.commitChanges()' returns if all data is written.
                    ' This call to ask for pending changes is just to convince me;
                    if xViewRoot.hasPendingChanges() then
                        qaErrorLog(sFileFunction+"Changes still pending...")
                        ' At this point there is no needed to think about what to do, if it doesn't work.
                        ' If it doesn't work, the change is performed in the UI via
                        ' global::system::inc::master.inc::mMakeGeneralOptions
                    end if
                    ' Update global value
                    gMacroSecurityLevel = iLevel
                end if
                ' Destroy, discard, dump, get rid of, put away, throw away, trash, the object:
                xViewRoot.dispose()
            else
                qaErrorLog(sFileFunction+"Couldn't create Configuration access")
            end if
        catch
            qaErrorLog(sFileFunction+"Failure during reading or setting Configuration Value")
        endcatch
    else
        qaErrorLog(sFileFunction+"Couldn't get UNO service")
    end if
    fGetSetMacroSecurityUNO = iOldSecurityLevel
end function

