'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_option.inc,v $
'*
'*  $Revision: 1.38 $
'*
'*  last change: $Author: tbo $ $Date: 2006/01/02 08:05:27 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : update and resouce test for all option pages (at tools/options)
'*
'************************************************************************
'*
' #1  tToolsOptionsStarOffice
' #1  tToolsOptionsLoadSave
' #1  tToolsOptionsLanguageSettings
' #1  tToolsOptionsInternet
'*
'\***********************************************************************
global sErrMes as String
global iSectionNumber as Integer

sub ExtrasOptionenTest
    Call tToolsOptionsTest
end sub

sub tToolsOptionsTest
    dim sApplication as string
    
    sApplication = gApplication
    ' Document- and database related options are placed in the g_option2.inc library
    use "global\update\inc\g_option2.inc"
    ' subs and functions has been placed there
    use "global\tools\inc\t_option2.inc"

    ' To prevent users from running just a subsection from this file, without THIS 
    ' subroutine, in every subsection the value of 'iSectionNumber' is checked.
    ' The test will exist with warnlog, if iSectionNumber is 0
    sErrMes = ""
        select case uCase(gApplication)
            case "WRITER","MASTERDOC","HTMLDOKUMENT": iSectionNumber = 8
            case "IMPRESS","DRAW","MATH","CALC"     : iSectionNumber = 7
        end select
    ' common testcases are placed in this library
    ' these tab-sets are always available:
    Call tToolsOptionsStarOffice
    Call tToolsOptionsLoadSave
    Call tToolsOptionsLanguageSettings
    Call tToolsOptionsDataSources
    Call tToolsOptionsChart
    Call tToolsOptionsInternet

    ' these tabpages only exist in the respective application
    gApplication = "WRITER"
    iSectionNumber = 8
    Call tToolsOptionsTextdocument
    gApplication = "HTMLDOKUMENT"
    Call tToolsOptionsHTMLDocument
    gApplication = "CALC"
    iSectionNumber = 7
    Call tToolsOptionsSpreadsheet
    gApplication = "IMPRESS"
    iSectionNumber = 7
    Call tToolsOptionsPresentation
    gApplication = "DRAW"
    iSectionNumber = 7
    Call tToolsOptionsDrawing
    gApplication = "MATH"
    iSectionNumber = 7
    Call tToolsOptionsFormula

    gApplication = sApplication
end sub

testcase tToolsOptionsStarOffice
    dim EchteAnzahl as Integer, i as Integer
    dim gefunden as Boolean, bSave as Boolean
    dim iMenuShould as integer
    '/// usually we have 12 tabpages in this category, if the central configuration is used 13 (Single SignOn)///'
    '///- tools/options/StarOffice
    PrintLog "- Tools/Options/StarOffice  ( Extras/Optionen/StarOffice )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
    if gApplication <> "DESKTOP" then Call hNewDocument
    ToolsOptions
    ToPosInOptionlist ( 1 )
    Kontext "ExtrasOptionenDlg"
    EchteAnzahl = Optionsliste.GetItemCount - iSectionNumber
    iMenuShould = 12
    if EchteAnzahl <> iMenuShould then
        Warnlog "The number of entries is not " + iMenuShould + "! => the current number is " + EchteAnzahl
    end if
    Kontext "Active"
    try
        if Active.Exists then Active.OK
    catch
        if Active.Exists then Active.No
    endcatch
    for i=1 to EchteAnzahl
        gefunden = FALSE
        Kontext "OptionenDlg"
        Optionsliste.TypeKeys "<Down>"
        select case i
        case 1 : Kontext "TabAllgemeines"
                '///+-    user data
                printlog "  - Userdata / Benutzerdaten"
                if TabAllgemeines.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabAllgemeines )
                end if
        case 2 : Kontext "TabSonstigesAllgemein"
                '///+-    general
                printlog "  - General / Allgemein"
                if TabSonstigesAllgemein.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabSonstigesAllgemein )
                end if
        case 3 : Kontext "TabMemory"
                '///+-    memory
                printlog "  - Memory / Arbeitsspeicher"
                if TabMemory.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabMemory )
                end if
        case 4 : Kontext "TabAnsichtAllgemein"
                '///+-    view
                printlog "  - View / Ansicht"
                if TabAnsichtAllgemein.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabAnsichtAllgemein )
                end if
        case 5 : Kontext "TabPrintStarOffice"
                '///+-    Print
                printlog "  - Print / Drucken"
                if TabPrintStarOffice.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabPrintStarOffice )
                end if
        case 6 : Kontext "TabPfade"
                '///+-    paths ( click edit for all list entries and close the filedialog )
                printlog "  - Paths / Pfade"
                if TabPfade.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabPfade )
                   Call DialogeFuerTypenKontrollieren
                end if
        case 7 : Kontext "TabFarben"
                '///+-    colors ( 'add' => click; 'Messagebox' => OK; 'Name dialog' => cancel;
                '///+-             'edit' => click; 'Colors dialog' => close; )
                printlog "  - Color / Farben"
                Sleep 4
                if TabFarben.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabFarben )
                      Farbe.Select 1
                      Hinzufuegen.Click
                        Kontext "Active"
                        Active.OK
                        Kontext "NameDlg"
                        Call DialogTest ( NameDlg )
                        NameDlg.Cancel
                      Kontext "TabFarben"
                      Bearbeiten.Click
                        Sleep 3
                        Kontext "FarbeDlg"
                        FarbeDlg.Cancel
                end if
        case 8 : Kontext "TabSchriftErsetzung"
                '///+-    font replacement
                printlog "  - Font Replacement / Schriftersetzung"
                if TabSchriftErsetzung.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabSchriftErsetzung )
                end if
        case 9: Kontext "TabSecurity"
                '///+-    security
                printlog "  - Security / Sicherheit"
                if TabSecurity.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabSecurity )
                   MacroSecurity.click()
                       kontext
                       if active.exists(10) then
                           kontext ' needed! i50168
                           active.setpage TabSecurityLevel
                           kontext "TabSecurityLevel"
                           call DialogTest( TabSecurityLevel )
                           kontext
                           active.setpage TabTrustedSources
                           kontext "TabTrustedSources"
                           call DialogTest( TabTrustedSources )
                           TabTrustedSources.cancel
                       else
                           warnlog "#i45295# No dialog 'Macro Security' came up"
                       endif
                       sleep( 1 )
                   Kontext "TabSecurity"
                   if Protect.isEnabled then
                       Protect.click()
                       Kontext "PasswordDLG"
                       call DialogTest( PasswordDLG )
                       PasswordDLG.cancel()
                   else
                       select case uCase(gApplication)
                           case "WRITER","MASTERDOC"                          :WarnLog "Protect-Button is disabled."
                           case "MATH","IMPRESS","DRAW","HTMLDOKUMENT","CALC" :PrintLog "Protect-Button is disabled."
                       end select
                   endif
                   sleep( 1 )
                end if
        case 10: Kontext "TabAppearance"
                '///+-    Appearance
                printlog "  - Appearance / Aussehen"
                if TabAppearance.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabAppearance )
                end if
        case 11: Kontext "TabAccessibility"
                '///+-    Accessibility
                printlog "  - Accessibility"
                if TabAccessibility.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabAccessibility )
                end if
        case 12: Kontext "TabJava"
                '///+-    Java
                printlog "  - Java"
                if TabJava.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabJava )
                end if
                if useJava.isChecked then
                    Add.click
                        Kontext "OeffnenDlg"
                        Sleep (1)
                        OeffnenDlg.Cancel
                    Kontext "TabJava"
                    Parameters.click
                        Kontext "JavaStartParameter"
                        Call DialogTest ( JavaStartParameter )
                        JavaStartParameter.cancel
                    Kontext "TabJava"
                    ClassPath.click
                        Kontext "JavaClassPath"
                        Call DialogTest ( JavaClassPath )
                        JavaClassPath.cancel
                else
                    printlog "Use Java is disabled."
                end if
        end select
        if gefunden=FALSE then
            Warnlog "Error with the " + i + ".page, perhaps this page is deleted or change the place!"
            EchteAnzahl = EchteAnzahl - 1
            if EchteAnzahl < 12 then
                i=10
            else
                i=1-1
            end if
        end if
    next i
'///+- close the options dialog
   Kontext "OptionenDlg"
   OptionenDlg.Cancel
   if gApplication <> "DESKTOP" then Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tToolsOptionsLoadSave
  dim EchteAnzahl as Integer, i as Integer
  dim gefunden as Boolean
   PrintLog "- Tools/Options/Load Save  ( Extras/Optionen/Laden Speichern )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
   if gApplication <> "DESKTOP" then Call hNewDocument
'///- tools/options/load save
   ToolsOptions
   ToPosInOptionlist ( 2 )
   EchteAnzahl = OptionTabPageZaehler ( 4, FALSE )
   for i=1 to EchteAnzahl
      gefunden = FALSE
      Kontext "OptionenDlg"
      Optionsliste.TypeKeys "<Down>"
      select case i
       case 1 : Kontext "TabSpeichern"
                '///+-    general
                printlog "  - General / Save"
                if TabSpeichern.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabSpeichern )
                end if
       case 2 : Kontext "TabMicrosoftOffice97"
                '///+-    VBA settings
                printlog "  - VBA Settings / VBA Eigenschaften"
                if TabMicrosoftOffice97.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabMicrosoftOffice97 )
                end if
       case 3 : Kontext "TabMicrosoftOffice2"
                '///+-    Microsoft Office
                printlog "  - Microsoft Office"
                if TabMicrosoftOffice2.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabMicrosoftOffice2 )
                end if
       case 4 : Kontext "TabHTML"
                '///+-    HTML compatibility
                printlog "  - HTML Compatibility / HTML Kompatibilitaet"
                if TabHTML.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabHTML )
                end if
      end select
      if gefunden=FALSE then
         Warnlog "Error with the " + i + ".page, perhaps this page is deleted or change the place!"
         EchteAnzahl = EchteAnzahl - 1
         if EchteAnzahl < 5 then
            i=11
         else
            i=1-1
         end if
      end if
   next i
'///+- close the options dialog
   Kontext "OptionenDlg"
   OptionenDlg.Cancel

   if gApplication <> "DESKTOP" then Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tToolsOptionsLanguageSettings
  dim EchteAnzahl as Integer, i as Integer, j as Integer
  dim gefunden as Boolean
  dim bAsianSup as Boolean

   PrintLog "- Tools/Options/Language Settings  ( Extras/Optionen/Spracheinstellungen )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
   if gApplication <> "DESKTOP" then Call hNewDocument
 '///- tools / options / language settings
   ToolsOptions
    ToPosInOptionlist ( 3 )
   EchteAnzahl = Optionsliste.GetItemCount - iSectionNumber
   ' usually we only have 2 pages in this section : 'Languages' and 'Writing Aids'
   ' - on asian languages we have 2 additional: 'Japanese Find' and 'Asian Layout'
   ' - on ctl languages there is only one more: 'Complex Text Layout'
   select case (EchteAnzahl)
      case 2: printlog "Asian or Complex Text Layout support is not activated ( on languages-page )!"
      case 3: printlog "Complex Text Layout support is activated ( on languages-page )!"
      case 4: printlog "Asian support is activated ( on languages-page )!"
      case 5: if (gAsianSup AND gCTLSup) then
                  printlog "Asian and Complex Text Layout support is activated ( on languages-page )!"
              else
                  Warnlog "There are more than 4 pages!"
              endif
      case else
         Warnlog "There are more than 5 pages!"
   end select
   Kontext "Active"
   try
      if Active.Exists then Active.OK
   catch
      if Active.Exists then Active.No
   endcatch
   for i=1 to EchteAnzahl
      gefunden = FALSE
      Kontext "OptionenDlg"
      Optionsliste.TypeKeys "<Down>"
      select case i
       case 1 : Kontext "TabSprachen"
                '///+-    languages
                printlog "  - Languages / Sprachen"
                if TabSprachen.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabSprachen )
                end if
       case 2 : Kontext "TabLinguistik"
                '///+-    writing aids
                printlog "  - Writing Aids / Linguistik"
                if TabLinguistik.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabLinguistik )
                '///+-       'modules' edit -> close dialog
                   SprachmoduleBearbeiten.Click
                    Kontext "ModuleBearbeiten"
                    Call DialogTest ( ModuleBearbeiten )
                    ModuleBearbeiten.Close
                   Kontext "TabLinguistik"
                '///+-       'dictionaries' new -> close dialog
                   Neu.Click
                    Kontext "BenutzerwoerterbuchAnlegen"
                    Call DialogTest ( BenutzerwoerterbuchAnlegen )
                    BenutzerwoerterbuchAnlegen.Cancel
                '///+-       'dictionaries' edit -> close dialog
                   Kontext "TabLinguistik"
                   for j=1 to 5
                      if Bearbeiten.IsEnabled then
                         Bearbeiten.Click
                         j=6
                      else
                         Benutzerwoerterbuch.TypeKeys "<Down>"
                      end if
                   next j
                   Kontext "BenutzerwoerterbuchBearbeiten"
                   if BenutzerwoerterbuchBearbeiten.Exists then
                      Call DialogTest ( BenutzerwoerterbuchBearbeiten )
                      BenutzerwoerterbuchBearbeiten.Close
                   else
                        warnlog "Edit the 'user-defined dictionary' is not possible => Bug?"
                   end if
                '///+-       'options' ( 9, 10, 11 entry ) edit -> close dialog
                   Kontext "TabLinguistik"
                   Optionen.TypeKeys "<PageUp>", 3
                   Sleep 1
                   Optionen.TypeKeys "<Down>", 8
                   Sleep 1
                   OptionenBearbeiten.Click
                    Kontext "SilbentrennungOptionen"
                    Call DialogTest ( SilbentrennungOptionen )
                    SilbentrennungOptionen.Cancel
                   Kontext "TabLinguistik"
                   Optionen.TypeKeys "<Down>"
                   OptionenBearbeiten.Click
                    Kontext "SilbentrennungOptionen"
                    Call DialogTest ( SilbentrennungOptionen )
                    SilbentrennungOptionen.Cancel
                   Kontext "TabLinguistik"
                   Optionen.TypeKeys "<Down>"
                   OptionenBearbeiten.Click
                    Kontext "SilbentrennungOptionen"
                    Call DialogTest ( SilbentrennungOptionen )
                    SilbentrennungOptionen.Cancel
                end if
       case 3,5 : try
                   Kontext "TabJapaneseFind"
                   '///+-    japanese find
                   if TabJapaneseFind.IsVisible then
                      printlog "  - Japanese Find / Japanische Suche"
                      gefunden = TRUE
                      Call DialogTest ( TabJapaneseFind )
                   end if
                catch
                endcatch
                try
                   Kontext "TabComplexTextLayout"
                   '///+-    Complex Text Layout
                   if TabComplexTextLayout.IsVisible then
                      printlog "  - Complex Text Layout"
                      gefunden = TRUE
                      Call DialogTest ( TabComplexTextLayout )
                   end if
                catch
                endcatch
       case 4 : Kontext "TabAsianLayoutOptions"
                '///+-    asian layout
                printlog "  - Asian Layout / Asiatisches Layout"
                if TabAsianLayoutOptions.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabAsianLayoutOptions )
                end if
      end select
      if gefunden=FALSE then
         Warnlog "Error with the " + i + ".page, perhaps this page is deleted or change the place!"
         EchteAnzahl = EchteAnzahl - 1
         if EchteAnzahl < 5 then
            i=5
         else
            i=1-1
         end if
      end if
   next i
'///+- close the options dialog
   Kontext "OptionenDlg"
   OptionenDlg.Cancel

   if gApplication <> "DESKTOP" then Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tToolsOptionsInternet
  dim EchteAnzahl as Integer, i as Integer
  dim gefunden as Boolean

  PrintLog "- Tools/Options/Internet  ( Extras/Optionen/Internet )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
   if gApplication <> "DESKTOP" then Call hNewDocument
 '///- tools / options / internet
   ToolsOptions
   '/// (The last section in Tools / Options is 'Internet')
   ToPosInOptionlist ( iSectionNumber)

    if gPlatgroup = "w95" then
        '/// On Win32 systems this section includes 3 tab pages.
        '///+<ul><li>Proxy (1)</li><li>Search (2)</li><li>Mozilla Plugin (3)</li></ul>
        EchteAnzahl = OptionTabPageZaehler ( 3 , FALSE )
    else
        '/// On Unix systems this section includes 4 tab pages.
        '///+<ul><li>Proxy (1)</li><li>Search (2)</li><li>E-Mail (3)</li><li>Mozilla Plugin (4)</li></ul>
        EchteAnzahl = OptionTabPageZaehler ( 4 , FALSE )
    end if

   for i=1 to EchteAnzahl
      gefunden = FALSE
      Kontext "OptionenDlg"
      Optionsliste.TypeKeys "<Down>"
      Kontext "ProxyWarnung"
      if ProxyWarnung.Exists(1) then
         NichtMehrAnzeigen.Check
         ProxyWarnung.OK
      end if

      select case i
       case 1 : Kontext "TabProxyServer"
                '///+-    proxy
                printlog "  - Proxy / Proxy"
                if TabProxyServer.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabProxyServer )
                end if
       case 2 : Kontext "Active"
                '///+-    search
                printlog "  - Search / Suche"
                if Active.Exists then
                   sErrMes = Active.GetText
                   Warnlog "A messagebox exists => BUG  : " + sErrMes
                   Active.OK
                end if
                Kontext "TabSuche"
                if TabSuche.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabSuche )
                end if
       case 3 :
                if gPlatgroup = "unx" then
                    Kontext "TabEmail"
                    '///+-    E-mail
                    printlog "  - E-mail"
                    if TabEmail.IsVisible then
                        gefunden = TRUE
                        Call DialogTest ( TabEmail )
                    end if
                end if
                if gPlatgroup = "w95" then
                    Kontext "TabMozillaPlugin"
                    '///+-    Mozilla Plug-in (On Win32
                    printlog "  - Mozilla Plug-in"
                    if TabMozillaPlugin.IsVisible then
                        gefunden = TRUE
                        Call DialogTest ( TabMozillaPlugin )
                    end if
                end if
       case 4 :
                if gPlatgroup = "w95" then
                    warnlog "On Win32 platform there should be only 3 tab pages in section 'Internet'!?"
                else
                    Kontext "TabMozillaPlugin"
                    '///+-    Mozilla Plug-in (On Win32
                    printlog "  - Mozilla Plug-in"
                    if TabMozillaPlugin.IsVisible then
                        gefunden = TRUE
                        Call DialogTest ( TabMozillaPlugin )
                    end if
                end if
      end select
      if gefunden=FALSE then
         Warnlog "Error with the " + i + ".page, perhaps this page is deleted or change the place!"
         EchteAnzahl = EchteAnzahl - 1
         if EchteAnzahl < 4 then
            i=11
         else
            i=1-1
         end if
      end if
   next i
'///+- close the options dialog
   Kontext "OptionenDlg"
   OptionenDlg.Cancel

   if gApplication <> "DESKTOP" then Call hCloseDocument
endcase

'-------------------------------------------------------------------------

