'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_format_character1.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: hde $ $Date: 2005/12/01 11:16:16 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Standard character styles formatting 
'*
'\***********************************************************************

sub w_format_character1

   Call tFormatStyles1	'-> Format/Styles with contect menu
   Call tFormatStyles2	'-> Format/Styles with shortcuts

end sub


testcase tFormatStyles1
	
	'/// All format styles in context-menu ///
	'/// Open a new document ///
	Call hNewDocument
	printlog "- Style 'Bold' "
	'/// Write 'Style Bold' - execute Context menu 'Style Bold'
	Call wDokSchreiben "Style Bold"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(4)	' 4th entry should be 'Style'
    wait 500
    Call hMenuSelectNr(1)
    wait 500
	' /// Check if changes to style have been made ///
	FormatCharacter
	Kontext
	Active.Setpage TabFont
	Kontext "TabFont"
	if gAsianSup = True then
		if StyleWest.GetSelIndex <> 3 then Warnlog "Style 'Bold' with context menu has not been set!"
	else
		if Style.GetSelIndex <> 3 then Warnlog "Style 'Bold' with context menu has not been set!"
	endif
	TabFont.Cancel
	Call wDokSchreiben "<End><Mod1 Shift X>"
    wait 500
	Call wDokSchreiben "<Return>"
	
	printlog "- Style 'Italic' "
	'/// Write 'Style Itlaic' - execute Context menu 'Style Italic'
	Call wDokSchreiben "Style Italic"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(4)	' 4th entry should be 'Style'
    wait 500
    Call hMenuSelectNr(2)
    wait 500
	' /// Check if changes to style have been made ///
	FormatCharacter
	Kontext
	Active.Setpage TabFont
	Kontext "TabFont"
	if gAsianSup = True then
		if StyleWest.GetSelIndex <> 2 then QAErrorlog "#58722#Style 'Italic' with context menu has not been set!"
	else
		if Style.GetSelIndex <> 2 then QAErrorlog "#58722#Style 'Italic' with context menu has not been set!"
	endif
	TabFont.Cancel
	Call wDokSchreiben "<End><Right>"
	Call wDokSchreiben "<Return>"
	
	printlog "- Style 'Underline' "
	'/// Write 'Style Underline' - execute Context menu 'Style Underline'
	Call wDokSchreiben "Style Underline"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(4)	' 4th entry should be 'Style'
    wait 500
    Call hMenuSelectNr(3)
    wait 500
	' /// Check if changes to style have been made ///
	FormatCharacter
	Kontext
	Active.Setpage TabFontEffects
	Kontext "TabFontEffects"
	if Underline.GetSelIndex <> 2 then Warnlog "Style 'Underline' with context menu has not been set!"
	TabFontEffects.Cancel
	Call wDokSchreiben "<End><Right>"
	Call wDokSchreiben "<Return>"
	
	printlog "- Style 'StrikeThrough' "
	'/// Write 'Style Strikethrough' - execute Context menu 'Style Strikethrough'
	Call wDokSchreiben "Style Strikethrough"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(4)	' 4th entry should be 'Style'
    wait 500
    Call hMenuSelectNr(4)
    wait 500
	' /// Check if changes to style have been made ///
	FormatCharacter
	Kontext
	Active.Setpage TabFontEffects
	Kontext "TabFontEffects"
	if StrikeThrough.GetSelIndex <> 2 then Warnlog "Style 'StrikeThrough' with context menu has not been set!"
	TabFontEffects.Cancel
	Call wDokSchreiben "<End>"
	Call wDokSchreiben "<Right><Return>"

	printlog "- Style 'Shadow' "
	'/// Write 'Style Shadow' - execute Context menu 'Style Shadow'
	Call wDokSchreiben "Style Shadow"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(4)	' 4th entry should be 'Style'
    wait 500
    Call hMenuSelectNr(5)
    wait 500
	' /// Check if changes to style have been made ///
	FormatCharacter
	Kontext
	Active.Setpage TabFontEffects
	Kontext "TabFontEffects"
	if Shadow.IsChecked = False then Warnlog "Style 'Shadow' with context menu has not been set!"
	TabFontEffects.Cancel
	Call wDokSchreiben "<End><Right>"
	Call wDokSchreiben "<Return>"

	printlog "- Style 'Outline' "
	'/// Write 'Style Outline' - execute Context menu 'Style Outline'
	Call wDokSchreiben "Style Outline"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(4)	' 4th entry should be 'Style'
    wait 500
    Call hMenuSelectNr(6)
    wait 500
	' /// Check if changes to style have been made ///
	FormatCharacter
	Kontext
	Active.Setpage TabFontEffects
	Kontext "TabFontEffects"
	if Outline.IsChecked = false then Warnlog "Style 'Outline' with context menu has not been set!"
	TabFontEffects.Cancel

	Call hCloseDocument

endcase



testcase tFormatStyles2
	
	'/// All format styles with Shortcuts ///
    '/// This is tested in w_shortcuts.bas
    
endcase


testcase tFormatCharacter
  	Dim Vergleich1%, Vergleich2$, Vergleich3$, Vergleich4$
	'/// Format / Character ///
	PrintLog "- Format / Character"

	'/// New document ///
	Call hNewDocument
	printlog "  - adjust character"
	'/// Select Format / Character ///
	FormatCharacter
	Sleep 5
	Kontext
	'/// On Tabpage 'Font' adjust settings ///
	active.SetPage TabFont
	kontext "TabFont"
	try
    	FontWest.Select 1
		Vergleich2$ = FontWest.GetSelText
		Vergleich1% = StyleWest.GetItemCount
		StyleWest.Select Vergleich1%
		Vergleich3$ = StyleWest.GetSelText
		SizeWest.Select 24
	catch
    	Font.Select 1
		Vergleich2$ = Font.GetSelText
		Vergleich1% = Style.GetItemCount
		Style.Select Vergleich1%
		Vergleich3$ = Style.GetSelText
		Size.Select 24
	endcatch
	wait 100
	Kontext
	'/// On Tabpage 'Font Effects' adjust settings ///
	active.SetPage TabFontEffects
	kontext "TabFontEffects"
	Blinking.Check
	Kontext
	Active.Setpage TabFontPosition
	'/// On Tabpage 'Font Position ' adjust settings ///
	Kontext "TabFontPosition"
	Spacing.Select 2
	SpacingBy.More 3
	Vergleich4$ = SpacingBy.GetText
	if Right ( Vergleich4$, 2 ) <> "pt" then Warnlog "Wrong Unit at Spacing by"
	Kontext
	'/// On Tabpage 'Hyperlink' adjust settings ///
	active.SetPage TabHyperlinkZeichen
	kontext "TabHyperlinkZeichen"
	URLName.SetText "www.mikeportnoy.com"
	NameText.SetText "Ein Link mit dem Testtool"
	TargetFrame.Select 2

	UnbesuchterLink.Select 6
	Kontext
	active.SetPage TabHintergrund
	kontext "TabHintergrund"
	Sleep 1
	Hintergrundfarbe.Typekeys "<Down><Left>", 4
	TabHintergrund.OK
	'/// Close dialog and reopen with Format / Character ///

	Call wDokSchreiben "Dies ist ein formatierter Text <Home><Right>"

	printlog "  - check character"

	'/// Check settings made ///
	Call wDokSchreiben "<Home><Right>"
	FormatCharacter
	Kontext
	active.SetPage TabFont
	kontext "TabFont"
	try
    	if FontWest.GetSelText <> 1 then Warnlog "Font should "+ Vergleich2$ +" is "+ FontWest.GetSelText
		if StyleWest.GetSelIndex <> Vergleich1% then Warnlog "FontStyle should " +Vergleich3$+" is "+ StyleWest.GetSelText
		if SizeWest.GetSelIndex <> 24 then Warnlog "Wrong Font Size : " + SizeWest.GetSelText
	catch
    	if Font.GetSelText <> 1 then Warnlog "Font should "+ Vergleich2$ +" is "+ Font.GetSelText
		if Style.GetSelIndex <> Vergleich1% then Warnlog "FontStyle should " +Vergleich3$+" is "+ Style.GetSelText
		if Size.GetSelIndex <> 24 then Warnlog "Wrong Font Size : " + Size.GetSelText
	endcatch
	Kontext
	active.SetPage TabFontEffects
	kontext "TabFontEffects"
	if NOT Blinking.IsChecked then Warnlog "Blinking is not checked"
	Kontext
	Active.Setpage TabFontPosition
	Kontext "TabFontPosition"
	if Spacing.GetSelIndex <> 2 then Warnlog "Wrong Spacing activated, is not the 2. but " + Spacing.GetSelText
	if SpacingBy.GetText <> Vergleich4$ then Warnlog "Wrong Value selected. Not: " + Vergleich4$ +" but " + SpacingBy.GetText

	Kontext
	active.SetPage TabHyperlinkZeichen
	kontext "TabHyperlinkZeichen"
	if URLName.GetText <> "http://www.mikeportnoy.com/" then Warnlog "Wrong URL : " + URLName.GetText + " (#BugID:90982)"
	SetClipboard UrlName.Gettext
	if NameText.GetText <> "Ein Link mit dem Testtool" then Warnlog "Wrong Linkname : " + NameText.GetText
	if TargetFrame.GetSelIndex <> 2 then Warnlog "Wrong Target selected : " + TargetFrame.GetSelText
	if UnbesuchterLink.GetSelIndex <> 6 then Warnlog "Wrong Style for unused Link :" + UnbesuchterLink.GetSelIndex
	TabHyperlinkZeichen.OK

	if gApplication = "WRITER" then
    	Call hSpeichernUnter ( gOfficePath + "user\work\format1.sxw" )
	else
    	Call hSpeichernUnter ( gOfficePath + "user\work\format1.sxg" )
	endif
	'/// Save document as '../user/work/format1.sxw' and close it ///

	if getclipboardtext="http://www.mikeportnoy.com/" then
    	printlog "  - activate Link"
	endif
	Sleep 20

	printlog "  - check saved character format"
	Sleep 1
	Call hCloseDocument
	Sleep 2
	if gApplication = "WRITER" then
    	Call hDateiOeffnen ( gOfficePath + "user\work\format1.sxw" )
	else
    	Call hDateiOeffnen ( gOfficePath + "user\work\format1.sxg" )
	endif
   	Call wDokSchreiben "<Home><Right>"
	Wait 500
	'/// Reopen previous saved documentand check settings made under Format / Character ///

	FormatCharacter

	Sleep 3
	Kontext
	active.SetPage TabFont
	kontext "TabFont"
	try
		if FontWest.GetSelText <> 1 then Warnlog "Font should "+ Vergleich2$ +" is "+ FontWest.GetSelText
		if StyleWest.GetSelIndex <> Vergleich1% then Warnlog "FontStyle should " +Vergleich3$+" is "+ StyleWest.GetSelText
		if SizeWest.GetSelIndex <> 24 then Warnlog "Wrong Font Size : " + SizeWest.GetSelText
	catch
		if Font.GetSelText <> 1 then Warnlog "Font should "+ Vergleich2$ +" is "+ Font.GetSelText
		if Style.GetSelIndex <> Vergleich1% then Warnlog "FontStyle should " +Vergleich3$+" is "+ Style.GetSelText
		if Size.GetSelIndex <> 24 then Warnlog "Wrong Font Size : " + Size.GetSelText
	endcatch
	Kontext
	active.SetPage TabFontEffects
	kontext "TabFontEffects"
	if NOT Blinking.IsChecked then Warnlog "Blinking is not checked"
	Kontext
	Active.Setpage TabFontPosition
	Kontext "TabFontPosition"
	if Spacing.GetSelIndex <> 2 then Warnlog "Wrong Spacing selected. Not 2. but " + Spacing.GetSelText
	if SpacingBy.GetText <> Vergleich4$ then Warnlog "Wrong value selectzed. Not " + Vergleich4$ +" but " + SpacingBy.GetText
	Kontext
	active.SetPage TabHyperlinkZeichen
	kontext "TabHyperlinkZeichen"
	if URLName.GetText <> "http://www.mikeportnoy.com/" then Warnlog "Wrong URL : " + URLName.GetText
	if NameText.GetText <> "Ein Link mit dem Testtool" then Warnlog "Wrong Linkname : " + NameText.GetText
	if TargetFrame.GetSelIndex <> 2 then Warnlog "Wrong Target selected : " + TargetFrame.GetSelText
	TabHyperlinkZeichen.OK
	'/// Close document ///
	Call hCloseDocument
endcase


