'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_105c_.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: hde $ $Date: 2005/10/10 11:59:57 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_105c_
    printLog Chr(13) + "---------    Level 1:  Format Menu / Drawing Objects  ----------"

    ' Zeichenobjekt ( Rechteck )
    Call tFormatLine
    Call tFormatArea
    Call tFormatText
    Call tFormatPositionAndSize
    Call tFormatWrapArea
    Call tFormatGroup

    ' Legendenobjekt
    Call tFormatPositionAndSizeLegend
    Call tFormatWrapLegend

    ' Editmodus bei Zeichenobjekten
    Call tFormatParagraphEdit
end sub

'**********************************************************

testcase tFormatLine
    Dim SelectedStyle as integer
    PrintLog "- Format / Line for rectangle"
    '/// New writerdocument ///
    Call hNewDocument
    '/// Insert a drawing object (rectangle) ///
    Call wZeichenobjektEinfuegen("RECHTECK", 20, 20, 50, 50)

    Printlog "   - Format change"
    try
        '/// Select Format / Line ///
        FormatLine
    catch
        if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
            Call wDokSchreiben ( "<Shift F5>" )
        else
            Call wDokSchreiben ( "<Shift F4>" )
        endif
        try
            FormatLinie
        catch
            Warnlog "Unable to execute Format / Line. Maybe object not selected!"
            Call hCloseDocument
            goto endsub
        endcatch
    endcatch

    Kontext
    active.SetPage TabLinie
    kontext "TabLinie"
    '/// modify Style ,color and width ///
    try
        Stil.Select 3
        SelectedStyle = 3
    catch
        Stil.Select Stil.GetItemCount
        SelectedStyle = Stil.GetItemCount
    endcatch
    wait 500
    Farbe.Select 7
    wait 500
    if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
        Breite.SetText "0.20"
    else
        Breite.SetText "0,20"
    end if
    try
        Transparenz.More 3
    catch
        Warnlog "Adjust transpareny for line is not available!"
    endcatch
    '/// Close and reopen dialog ///
    Sleep 2
    TabLinie.OK

    Printlog "   - check Format"
    '/// check setiings ///
    FormatLine
    Kontext
    active.SetPage TabLinie
    kontext "TabLinie"
    if Stil.GetSelIndex <> SelectedStyle then Warnlog "Style is wrong, not 3 but "+ Stil.GetSelIndex
    if Farbe.GetSelIndex <> 7 then Warnlog "Colour is wrong, not 7 but "+ Farbe.GetSelIndex
    if iSystemSprache = 01 or iSystemSprache = 07 then
        if Breite.GetText <> "0.20" + mUnit then Warnlog "Width isn't .20" + mUnit + " but "+ Breite.GetText
    else
        if iSystemSprache = 48 then
            if Breite.GetText <> "0.20" + mUnit then Warnlog "Width is not 0.20" + mUnit + " but "+ Breite.GetText
        else
            if Breite.GetText <> "0,20" + mUnit then Warnlog "Width is not 0,20" + mUnit + " but "+ Breite.GetText
        endif
   end if
   if Transparenz.GetText <> "15%" then Warnlog "Transparency is wrong, not 15% but "+ Transparenz.GetText
   TabLinie.Cancel

  printlog "  -  check previous saved formattings"
   '/// Save, close and reopen document ///
   if gApplication = "WRITER" then
    Call hSpeichernUnterKill ( gOfficePath + "user\work\flinie.sxw" )
   else
    Call hSpeichernUnterKill ( gOfficePath + "user\work\flinie.sxg" )
   endif
   Sleep 2
   Call hCloseDocument
   Sleep 2
   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gOfficePath + "user\work\flinie.sxw" )
   else
    Call hDateiOeffnen ( gOfficePath + "user\work\flinie.sxg" )
   endif

   ' Selects the object
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif

   try
   '/// Select Format / Line and check properties of drawing object ///
    FormatLine
   catch
    Warnlog "Unable to execute Format/Line! Maybe object not selected!"
    Goto GoOn
   endcatch
   Kontext
   active.SetPage TabLinie
   kontext "TabLinie"
   if Stil.GetSelIndex <> SelectedStyle then Warnlog "Style is wrong, not 3 but "+ Stil.GetSelIndex
   if Farbe.GetSelIndex <> 7 then Warnlog "Colour is wrong, not 7 but "+ Farbe.GetSelIndex
   if iSystemSprache = 01 or iSystemSprache = 07 then
      if Breite.GetText <> "0.20" + mUnit then Warnlog "Width is not .20" + mUnit + " but "+ Breite.GetText
   else
      if iSystemSprache = 48 then
       if Breite.GetText <> "0.20" + mUnit then Warnlog "Width is not 0.20" + mUnit + " but "+ Breite.GetText
      else
       if Breite.GetText <> "0,20" + mUnit then Warnlog "Width is not 0,20" + mUnit + " but "+ Breite.GetText
      endif
   end if
   if Transparenz.Gettext <> "15%" then Warnlog "Transparency is wrong, not 15% but "+ Transparenz.Gettext + "(Bug#99054)"
   TabLinie.Cancel

   GoOn:
   '/// close document ///
   Call hCloseDocument
endcase

'**********************************************************

testcase tFormatArea
  Dim Vergleich1$, i as integer

  PrintLog "- Format / Area for rectangle"
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert a drawing object (rectangle) ///
   Call wZeichenobjektEinfuegen("RECHTECK", 20, 20, 50, 50)

  Printlog "  - adjust Format"
   '/// Select Format / Area ///
   try
    FormatArea
   catch
        if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
            Call wDokSchreiben ( "<Shift F5>" )
        else
            Call wDokSchreiben ( "<Shift F4>" )
        endif
    try
     FormatArea
    catch
     Warnlog "Unable to execute Format / Area. Maybe object not selected!"
     Call hCloseDocument
     goto endsub
    endcatch
   endcatch

   Kontext
   '/// modify properties of drawing object ///
   active.SetPage TabArea
   Kontext "TabArea"
   Bitmap.Check
   BitmapList.Select 3
   Tile.Check
   Original.Uncheck
   Relative.Check
   Width.SetText "90"
   XOffset.SetText "30"
   Column.Check
   Offset.SetText "20"
   Kontext
   active.SetPage TabSchatten
   kontext "TabSchatten"
   Anzeigen.Check
   if iSprache <> 01 then
      Entfernung.SetText "30,00mm"
   else
      Entfernung.SetText "13"
   end if
   Vergleich1$ = Entfernung.GetText
   Farbe.Select 15
   TabSchatten.OK
   Sleep 3

  Printlog "  - check Format"
   '/// close and reopen dialog ///
   FormatArea
   Kontext
   '/// check properties of drawing object ///
   active.SetPage TabArea
   Kontext "TabArea"
   if Not Bitmap.IsChecked then
      Warnlog "Bitmap is not checked anymore"
      TabArea.Ok
   else
      if BitmapList.GetSelIndex <> 3 then Warnlog "Wrong Bitmap has been inserted. Not Bitmap 3 but "+BitmapAuswahl.GetSelIndex
      if NOT Tile.IsChecked then Warnlog "Tile is not checked"
      if Original.IsChecked then Warnlog "Original is checked"
      if NOT Relative.IsChecked then Warnlog "Relative is not checked"
      if Width.GetText <> "90%" then Warnlog "Width is not 90% but "+Width.GetText
      if XOffset.GetText <> "30%" then Warnlog "XOffset not 30% but "+XOffset.GetText
      if NOT Column.IsChecked then Warnlog "Column is not checked anymore!"
      if Offset.GetText <> "20%" then Warnlog "Offset is not 20% but " + Offset.GetText
      Kontext
      active.SetPage TabSchatten
      kontext "TabSchatten"
      if NOT Anzeigen.IsChecked then
         Warnlog "Shadow is not checked"
      else
         if Entfernung.GetText <> Vergleich1$ then Warnlog "Distance is not "+ Vergleich1$+" but "+Entfernung.GetText
         if Farbe.GetSelIndex <> 15 then Warnlog "Wrong Colour for shadow. Not 15 but "+ Farbe.GetSelIndex
      end if
      TabSchatten.Cancel
   end if

  printlog "  - check previous saved formattings"
   Sleep 2
   '/// save, close and reopen document ///
   if gApplication = "WRITER" then
    Call hSpeichernUnterKill ( gOfficePath + "user\work\fflaeche.sxw" )
    Sleep 2
    Call hCloseDocument
    Sleep 2
    Call hDateiOeffnen ( gOfficePath + "user\work\fflaeche.sxw" )
   else
    Call hSpeichernUnterKill ( gOfficePath + "user\work\fflaeche.sxg" )
    Sleep 2
    Call hCloseDocument
    Sleep 2
    Call hDateiOeffnen ( gOfficePath + "user\work\fflaeche.sxg" )
   endif
    Sleep 5

  try
   '/// Select Format / Area and check properties of drawing object ///
    FormatArea
   catch
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif
    Sleep 5
    try
     FormatArea
    catch
     Warnlog "- Format / Area is disabled, because object could not be selected"
     Call hCloseDocument
     goto endsub
   endcatch
  endcatch

   Kontext
   active.SetPage TabArea
   Kontext "TabArea"
   if Not Bitmap.IsChecked then
      Warnlog "Bitmap is not checked anymore"
      TabArea.Ok
   else
      if BitmapList.GetSelIndex <> 3 then Warnlog "Wrong Bitmap has been inserted. Not Bitmap 3 but "+BitmapAuswahl.GetSelIndex
      if NOT Tile.IsChecked then Warnlog "Tile is not checked"
      if Original.IsChecked then Warnlog "Original is checked"
      if NOT Relative.IsChecked then Warnlog "Relative is not checked"
      if Width.GetText <> "90%" then Warnlog "Width is not 90% but "+ Width.GetText + "(Bug#90653)"
      if XOffset.GetText <> "30%" then Warnlog "XOffset not 30% but "+ XOffset.GetText
      if NOT Column.IsChecked then Warnlog "Column is not checked anymore!"
      if Offset.GetText <> "20%" then Warnlog "Offset is not 20% but " + Offset.GetText
      Kontext
      active.SetPage TabSchatten
      kontext "TabSchatten"
      if NOT Anzeigen.IsChecked then
         Warnlog "Shadow is not checked"
      else
         if Entfernung.GetText <> Vergleich1$ then Warnlog "Distance is not "+ Vergleich1$+" but "+Entfernung.GetText
         if Farbe.GetSelIndex <> 15 then Warnlog "Wrong Colour for shadow. Not 15 but "+ Farbe.GetSelIndex
      end if
      TabSchatten.Cancel
   end if

   '/// Close document ///
   hCloseDocument
endcase
'**********************************************************
testcase tFormatText
  Dim Wert1$ : Dim Wert2$ : Dim Wert3$ : Dim Wert4$

   PrintLog "- Format / Text for drawing object"
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert a drawing object (rectangle) ///
   Call wZeichenobjektEinfuegen("RECHTECK", 20, 20, 50, 50)

  Printlog "  - adjust Format"
   try
   '/// Select Format / Text ///
    FormatTextWriter
   catch
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif
    try
     FormatTextWriter
    catch
     Warnlog "Unable to execute Format / Text. Maybe object not selected!"
     Call hCloseDocument
     goto endsub
    endcatch
   endcatch

   Kontext
   '/// modify properties of drawing object ///
   Active.SetPage TabText
   Kontext "TabText"
   AmRahmenAnpassen.Check
   Links.More 3
   Wert1$ = Links.GetText
   Rechts.Less 2
   Wert2$ = Rechts.GetText
   Oben.More 9
   Wert3$ = Oben.GetText
   Unten.Less 5
   Wert4$ = Unten.GetText

   Kontext
   Active.SetPage TabLauftext
   Kontext "TabLauftext"
   Effekt.Select 3
   Nachoben.Click
   TextSichtbarBeimStarten.Check
   Endlos.Uncheck
   Anzahl.SetText "4"
   Pixel.Uncheck
   TabLauftext.OK
   '/// Close and reopen dialog ///

    Call gMouseClick ( 99, 99 )
    Sleep 1

    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif
    FormatTextWriter
    '/// Check properties of drawing object ///

    Printlog "  - check Formats the 1st time"
    Kontext
    Active.SetPage TabText
    Kontext "TabText"
    if NOT AmRahmenAnpassen.IsChecked then
        Warnlog "'BUG: 44656'  Values are wrong"
        TabText.Cancel
    else
        if Links.GetText <> Wert1$ then Warnlog "Wrong value for 'Left'. Not:"+ Wert1$ + " but: " + Links.GetText
        if Rechts.GetText <> Wert2$ then Warnlog "Wrong value for 'Right'. Not:"+ Wert2$ +" but: " + Rechts.GetText
        if Oben.GetText <> Wert3$ then Warnlog "Wrong value for 'Top'.Not:"+ Wert3$ +" but: " + Oben.GetText
        if Unten.GetText <> Wert4$ then Warnlog "Wrong value for 'Bottom'. Not:"+ Wert4$ +" but: " + Unten.GetText

        Kontext
        Active.SetPage TabLauftext
        Kontext "TabLauftext"
        if Effekt.GetSelIndex <> 3 then Warnlog "Wrong effect selected"
        if NOT TextSichtbarBeimStarten.IsChecked then Warnlog "Start inside is not checked anymore"
        if Endlos.IsChecked then
            Warnlog "Continouis is checked, though it had not benn checked"
        else
            if Anzahl.GetText <> "4" then Warnlog "Number of counts is not 4 but " + Anzahl.GetText
        end if
        if Pixel.IsChecked then Warnlog "Pixels is checked again, though it had been unchecked"
        TabLauftext.Cancel
    end if

    Printlog "  - Insert Scroll through text animation"
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif
    Call wDokSchreiben ("<Return>")
    wait 500
    Call wDokSchreiben "AAA"
    Call gMouseClick ( 99, 99 )
    Sleep 5
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif

    Printlog "  - check formats the second time"
    Sleep 3
    FormatTextWriter
    Kontext
    Active.SetPage TabText
    Kontext "TabText"
    if NOT AmRahmenAnpassen.IsChecked then Warnlog "Fit to frame is not checked"
    if Links.GetText <> Wert1$ then Warnlog "Wrong value for 'Left' Not:"+ Wert1$ +"but: " + Links.GetText
    if Rechts.GetText <> Wert2$ then Warnlog "Wrong value for 'Right'. Not:"+ Wert2$ +"but: " + Rechts.GetText
    if Oben.GetText <> Wert3$ then Warnlog "Wrong value for 'Top'. Not:"+ Wert3$ +"but: " + Oben.GetText
    if Unten.GetText <> Wert4$ then Warnlog "Wrong value for 'Bottom'. Not:"+ Wert4$ +"but: " + Unten.GetText

    Kontext
    Active.SetPage TabLauftext
    Kontext "TabLauftext"
    if Effekt.GetSelIndex <> 3 then Warnlog "Wrong effect selected"
    if NOT TextSichtbarBeimStarten.IsChecked then Warnlog "Start inside is not checked anymore"
    if Endlos.IsChecked then
        Warnlog "Continouis is checked again!"
    else
        if Anzahl.GetText <> "4" then Warnlog "Number of counts is not 4 but " + Anzahl.GetText
    end if
    if Pixel.IsChecked then Warnlog "Pixels is checked again."
    TabLauftext.OK

    printlog "  - checking previous saved format"
    '/// Save, close and reopen the document ///
    if gApplication = "WRITER" then
        Call hSpeichernUnterKill ( gOfficePath + "user\work\ftext.sxw" )
        Call hCloseDocument
        Call hDateiOeffnen ( gOfficePath + "user\work\ftext.sxw" )
    else
        Call hSpeichernUnterKill ( gOfficePath + "user\work\ftext.sxg" )
        Call hCloseDocument
        Call hDateiOeffnen ( gOfficePath + "user\work\ftext.sxg" )
    endif
    Sleep 2
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif

    try
    '/// Select Format / Text and check properties of the drawing object ///
        FormatTextWriter
    catch
        Warnlog "Unable to execute Format / Text ! Maybe object not selected!"
        Goto GoOn
    endcatch
    Kontext
    Active.SetPage TabText
    Kontext "TabText"
    if NOT AmRahmenAnpassen.IsChecked then Warnlog "Fit to frames is not checked!"
    if Links.GetText <> Wert1$ then Warnlog "Wrong value for 'Left'. Not:"+ Wert1$ +"but: " + Links.GetText
    if Rechts.GetText <> Wert2$ then Warnlog "Wrong value for 'Right'. Not:"+ Wert2$ +"but: " + Rechts.GetText
    if Oben.GetText <> Wert3$ then Warnlog "Wrong value for 'Top'. Not:"+ Wert3$ +"but: " + Oben.GetText
    if Unten.GetText <> Wert4$ then Warnlog "Wrong value for 'Bottom'. Not:"+ Wert4$ +"but: " + Unten.GetText

    Kontext
    Active.SetPage TabLauftext
    Kontext "TabLauftext"
    if Effekt.GetSelIndex <> 3 then Warnlog "Wrong effect selected"
    if NOT TextSichtbarBeimStarten.IsChecked then Warnlog "Start inside is not checked anymore"
    if Endlos.IsChecked then
        Warnlog "Continouis is checked, though it had been unchecked"
    else
        if Anzahl.GetText <> "4" then Warnlog "Number of counts is not 4 but " + Anzahl.GetText
    end if
    if Pixel.IsChecked then Warnlog "Pixels is not checked"
    TabLauftext.OK

    GoOn:
    '/// Close document ///
    Call hCloseDocument
endcase
'**********************************************************
testcase tFormatPositionAndSize
  Dim Wert1$ : Dim Wert2$ : Dim Wert3$ : Dim Wert4$ : Dim Wert5$ : Dim Wert6$ : Dim Wert7$ : Dim Wert8$ : Dim Wert9$

  PrintLog "- Format / Position and Size for drawing objects"
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert a drawing object (rectangle) ///
   Call wZeichenobjektEinfuegen("RECHTECK", 20, 20, 30, 30)

  PrintLog "   - adjust Formats ( Position and Size )"
   '/// Select Format / Position and size ///
   try
    ContextPositionAndSize
   catch
    Call gMouseClick(25,20)
    try
     ContextPositionAndSize
    catch
     Warnlog "Unable to execute Format / Position And Size. Maybe object not selected!"
     Call hCloseDocument
     goto endsub
    endcatch
   endcatch

   Kontext
   '/// modify properties of drawing object ///
   active.setpage TabPositionAndSizeWriter
  Kontext "TabPositionAndSizeWriter"
   Anchor.Select 1
   Sleep 1
   if NOT PositionX.IsEnabled then Warnlog "With anchor to paragraph Position X is inactive"
   if NOT PositionY.IsEnabled then Warnlog "With anchor to paragraph Position Y is inactive"
   if AnchorPosition.IsEnabled then Warnlog "With anchor to paragraph Listbox 'Position' is enabled"
   Anchor.Select 2
   Sleep 1
   if Not AnchorPosition.IsEnabled then Warnlog "With anchor as character Listbox 'Position' is not enabled"
   if PositionX.IsEnabled then Warnlog "With anchor as character Position X is active"
   if PositionY.IsEnabled then Warnlog "With anchor as character Position Y is active"
   Anchor.Select 3
   Sleep 1
   if NOT PositionX.IsEnabled then Warnlog "With anchor to page Position X is inactive"
   if NOT PositionY.IsEnabled then Warnlog "With anchor to page Position Y is inactive"
   if AnchorPosition.IsEnabled then Warnlog "With anchor to paragraph Listbox 'Position' is enabled"
   PositionX.Settext "3"
   PositionY.Settext "3"
   Wert1$ = PositionX.GetText
   Wert2$ = PositionY.GetText
   Kontext
   active.setpage TabPositionAndSizeWriter
  Kontext "TabPositionAndSizeWriter"
   Width.Settext "15"
   Height.Settext "3"
   Wert8$ = Width.GetText
   Wert9$ = Height.GetText
   TabPositionAndSizeWriter.OK
   '/// close and reopen dialog ///

  PrintLog "   - check formats"
   '/// check properties of drawing object ///
   ContextPositionAndSize
   Kontext
   active.setpage TabPositionAndSizeWriter
  Kontext "TabPositionAndSizeWriter"
   if Anchor.GetSelIndex <> 3 then Warnlog "Anchor is wrong"
   if PositionX.GetText <> Wert1$ then Warnlog "X-Position is wrong: Not -> "+Wert1$+"  but -> "+PositionX.GetText
   if PositionY.GetText <> Wert2$ then Warnlog "Y-Position is wrong: Not -> "+Wert2$+"  but -> "+PositionY.GetText
   Kontext
   active.setpage TabPositionAndSizeWriter
  Kontext "TabPositionAndSizeWriter"
   if Width.GetText <> Wert8$ then Warnlog "Width is not " + Wert8$+ " but " + Width.GetText
   if Height.GetText <> Wert9$ then Warnlog "Height is not " + Wert9$+ " but " + Height.GetText

  PrintLog "   - adjust formats ( Slant )"
   Kontext
   active.setPage TabSchraegstellen
   Kontext "TabSchraegstellen"
   Radius.More 5
   Wert6$ = Radius.GetText
   Winkel.More 12
   Wert7$ = Winkel.GetText
   TabSchraegstellen.OK

  PrintLog "   - check format"
   ContextPositionAndSize
   Kontext
   active.setpage TabSchraegstellen
   Kontext "TabSchraegstellen"
   if Radius.GetText <> Wert6$ then Warnlog "Corner radius is wrong. Not: " + Wert6$ +" but " +Radius.GetText
   if Winkel.GetText <> Wert7$ then Warnlog "Angle for slant is not " + Wert7$ +" but " +Winkel.GetText
   TabSchraegstellen.OK

  printlog "  - check previous saved format"
   '/// save, close and reopen document ///
   Sleep 2
   if gApplication = "WRITER" then
    Call hSpeichernUnterKill ( gOfficePath + "user\work\stufe1.sxw" )
    Sleep 2
    Call hCloseDocument
    Sleep 2
    Call hDateiOeffnen ( gOfficePath + "user\work\stufe1.sxw" )
   else
    Call hSpeichernUnterKill ( gOfficePath + "user\work\stufe1.sxg" )
    Sleep 2
    Call hCloseDocument
    Sleep 2
    Call hDateiOeffnen ( gOfficePath + "user\work\stufe1.sxg" )
   endif
   Sleep 2
   gMouseClick ( 25, 45 )

  PrintLog "   - check format"
   '/// Select Format / Position and Size and check properties ///
   try
    ContextPositionAndSize
    Kontext
    active.setpage TabSchraegstellen
    Kontext "TabSchraegstellen"
    if Radius.GetText <> Wert6$ then Warnlog "Corner radius is wrong. Not: " + Wert6$ +" but " +Radius.GetText
    if Winkel.GetText <> Wert7$ then Warnlog "Angle for slant is not " + Wert7$ +" but " +Winkel.GetText
    TabSchraegstellen.OK
   catch
    Warnlog "Unable to execute Format / Position and Size!"
   endcatch

   '/// Close document ///
   Call hCloseDocument
endcase
'**********************************************************
testcase tFormatWrapArea
  PrintLog "- Format / Wrap for all anchors"
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert autotext: dummy text ///
   Call wBlindtextEinfuegen
   Call wDokSchreiben "<Up>", 10
   '///  Insert a drawing object ///
   Call wZeichenobjektEinfuegen("RECHTECK", 20, 20, 30, 30)

  Printlog "   - anchor to page"
   try
   '/// Anchor drawing object to page ///
    FormatAnchorToPage
   catch
    Call wObjektSelektieren (15, 15, 55 ,55)
    try
     FormatAnchorToPage
    catch
     Warnlog "Unable to execute Format / Anchor. Maybe object not selected!"
     Call hCloseDocument
     goto endsub
    endcatch
   endcatch

   Sleep 1
   '/// check all wrap variants ///
   try
      FormatWrapFirstParagraph
      Warnlog "On anchor to page Format / Wrap / First paragraph is active"
   catch
   endcatch
  Printlog "      - Contour is not checked"
  try
   FormatWrapNoWrap
  catch
   Warnlog "'No wrap' on anchor to page is disabled!"
  endcatch
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
  try
   FormatWrapThrough
  catch
   Warnlog "'No wrap' on anchor to page is disabled!"
  endcatch
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  try
   FormatWrapNoWrap
  catch
  endcatch
   Sleep 1
   FormatWrapPageWrap
   Printlog "      - Contour checked"
   Sleep 1
   try
    FormatWrapContour
   catch
    Warnlog "Format / Wrap / Coontour should be enabled!"
   endcatch
   Sleep 1
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
  try
   FormatWrapThrough
  catch
   Warnlog "'Wrap through' is disabled on anchor to page!"
  endcatch
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "   - anchor to paragraph"
   FormatAnchorToParagraph
   Sleep 1
  Printlog "      - 1. Paragraph not checked"
   FormatWrapNoWrap
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
   FormatWrapThrough
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "      - 1. paragraph not checked"
   FormatWrapNoWrap
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
   FormatWrapThrough
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapFirstParagraph
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "      - 1st Paragraph checked"
   Sleep 1
   FormatWrapFirstParagraph
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
   FormatWrapThrough
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "      - 1. paragraph checked"
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
   FormatWrapThrough
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "   - anchor as character"
   Sleep 1
   FormatAnchorAsCharacter
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

   '/// Close document ///
   Call hCloseDocument
endcase

'**********************************************************

testcase tFormatGroup
    PrintLog "- Format / Group for Drawing objects"
    '/// New writerdocument ///
    Call hNewDocument
    ViewZoom
    Kontext "Massstab"
    Optimal.Check
    Massstab.OK
    Sleep 1
    '/// Insert 2 drawing objects (rectangle) ///

    Call wZeichenobjektEinfuegen ( "Rechteck", 20, 20, 30, 30 )
    Call wZeichenobjektEinfuegen ( "Rechteck", 20, 35, 30, 45 )

    Printlog "   - 1. Group"
    '/// Select both objects ///
    Call wObjektSelektieren ( 15, 15, 50, 50 )
    '/// Select Format / Group / Group ///
    try
        FormatGroupGroup
        Sleep 1
    catch
        Warnlog "Unable to execute 'Format / Group / Group' -> disabled!"
    endcatch

    Printlog "   - 2. Group"
    Call wZeichenobjektEinfuegen ( "Rechteck", 20, 50, 30, 60 )
    Call wObjektSelektieren ( 15, 15, 35, 65 )
    try
        FormatGroupGroup
        Sleep 1
    catch
        Warnlog "Unable to execute 'Format / Group / Group' -> disabled!"
    endcatch
    Sleep 1

    Printlog "   - 3. Group"
    Call wZeichenobjektEinfuegen ( "Rechteck", 20, 65, 30, 75 )
    Call wObjektSelektieren ( 15, 15, 35, 80 )
    try
        FormatGroupGroup
        Sleep 1
    catch
        Warnlog "Unable to execute 'Format / Group / Group' -> disabled!"
    endcatch
    Sleep 1

    Printlog "   - 1. Ungroup"
    '/// Select Format / Group / Ungroup ///
    FormatUngroupDraw
    Sleep 1
    Printlog "   - 2. Ungroup"
    FormatUngroupDraw
    Sleep 1
    Printlog "   - 3. Ungroup"
    FormatUngroupDraw
    Sleep 1
    '/// Close document ///
    Call hCloseDocument
endcase

'**********************************************************

testcase tFormatPositionAndSizeLegend
  Dim Wert1$ : Dim Wert2$ : Dim Wert3$

  PrintLog "- Format / Position and Size for legend"
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert drawing object (Legend) ///
   Call hLegendeEinfugen

   Sleep 2
  printlog "   - adjust format"
   '/// Select Format / Position and Size ///
   ContextPositionAndSize
   '/// modify properties for position and size ///
   Kontext
   active.setpage TabPositionAndSizeWriter
   Kontext "TabPositionAndSizeWriter"
   PositionX.More 4
   PositionY.Less 4
   Wert1$ = PositionX.GetText
   Wert2$ = PositionY.GetText
   Kontext
   active.setpage TabPositionAndSizeWriter
  Kontext "TabPositionAndSizeWriter"
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
      Width.SetText "3.00"
      Height.SetText "5.23"
   else
      Width.SetText "3,00"
      Height.SetText "5,23"
   end if
   Kontext
   active.setpage TabLegende
  Kontext "TabLegende"
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
    printlog "Dummy"
   else
    Abstand.More 3
   endif
   Wert3$ = Abstand.GetText
   Position.Select 1
   Optimal.Uncheck
   TabLegende.OK
   '/// Closed dialog, reopen and check properties ///

  PrintLog "   - check format"
   ContextPositionAndSize
   Kontext
   active.setpage TabPositionAndSizeWriter
  Kontext "TabPositionAndSizeWriter"
   if PositionX.GetText <> Wert1$ then Warnlog "X-Position is wrong: Not -> "+Wert1$+"  but -> "+PositionX.GetText
   if PositionY.GetText <> Wert2$ then Warnlog "Y-Position is wrong: Not -> "+Wert2$+"  but -> "+PositionY.GetText
   Kontext
   active.setpage TabPositionAndSizeWriter
  Kontext "TabPositionAndSizeWriter"
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
      if Width.GetText <> "3.00" + mUnit then Warnlog "Width is not 3.00" + mUnit + " but " + Width.GetText
      if Height.GetText <> "5.23" + mUnit then Warnlog "Height is not 4.23" + mUnit + " but " + Height.GetText
   else
      if Width.GetText <> "3,00" + mUnit then Warnlog "Width is not 3,00" + mUnit + " but " + Width.GetText
      if Height.GetText <> "5,23" + mUnit then Warnlog "Height is not 5,23" + mUnit + " but " + Height.GetText
   end if
   Kontext
   active.setpage TabLegende
  Kontext "TabLegende"
   if Abstand.GetText <> Wert3$ then Warnlog "Spacing not " + Wert3$ + " but " + Abstand.GetText
   if Position.GetSelIndex <> 1 then Warnlog "Position is not 'From top'"
   if Optimal.IsChecked then Warnlog "Optimal is checked"
   TabLegende.OK

   '/// close document ///
   Call hCloseDocument
endcase
'**********************************************************
testcase tFormatWrapLegend
  PrintLog "- Format / Wrap for all anchors"
   '/// New writerdocument ///
   hNewDocument
   '/// Insert autotext: Dummy text ///
   Call wBlindtextEinfuegen
   '/// Insert a drawing object ( Legend ) ///
   Call hLegendeEinfugen

  Printlog "   - Anchor to page"
   '/// Choose all anchor modes and wrap modes successively ///
   FormatAnchorToPage
   Sleep 1
   try
     FormatWrapFirstParagraph
     Warnlog "On anchor to page Format / Wrap / First Paragraph is enabled"
   catch
   endcatch
  Printlog "      - Contour is not checked"
  try
   FormatWrapNoWrap
  catch
   Warnlog "On anchor to page Format / Wrap / 'No Wrap' is not active!"
  endcatch
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
  try
   FormatWrapThrough
  catch
   Warnlog "On anchor to page Format / Wrap / Wrap through is not active"
  endcatch
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "      - Contour checked"
   Sleep 1
  try
   FormatWrapNoWrap
  catch
   Warnlog "On anchor to page Format / Wrap / 'No Wrap' is inactive!"
  endcatch
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   try
    FormatWrapContour
   catch
    Warnlog "Format / Wrap / Contour should be enabled!"
   endcatch
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
  try
   FormatWrapThrough
  catch
    Warnlog "On anchor to page Format / Wrap / Wrap through is not active"
  endcatch
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "   - Anchor to paragraph"
   Sleep 1
   FormatAnchorToParagraph
   Sleep 1
  Printlog "      - Contour / 1. Paragraph not checked"
   FormatWrapNoWrap
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   try
    FormatWrapContour         ' Kontur wieder ausmachen
   catch
    Warnlog "Format / Wrap / Contour is disabled!"
   endcatch
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
   FormatWrapThrough
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "      - 1. paragraph not checked"
   FormatWrapNoWrap
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
   FormatWrapThrough
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapFirstParagraph
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "      - Contour not checked, 1st paragraph checked"
   FormatWrapFirstParagraph
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
   FormatWrapThrough
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "      - 1. Paragraph checked"
   Sleep 1
   FormatWrapPageWrap
   Sleep 1
   FormatWrapOptimalPageWrap
   Sleep 1
   FormatWrapThrough
   Sleep 1
   FormatWrapInBackground
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

  Printlog "   - Anchor As character"
   Sleep 1
   FormatAnchorAsCharacter
   Sleep 1
   FormatWrapEdit
   Kontext "TabUmlauf"
   TabUmlauf.Cancel

   '/// Close document ///
   Call hCloseDocument
endcase
'**********************************************************
testcase tFormatParagraphEdit
  Dim Wert1$ : Dim Wert2$ : Dim Wert3$ : Dim Wert4$ : Dim Wert5$ : Dim Wert6$

  PrintLog "- Format / Paragraph for text objects"
   '/// New writerdocument ///
   Call hNewDocument
   Kontext "WL_SW"
   Zeichnen.TearOff
   Kontext "TB_Zeichenfunktionen"
   '/// Insert drawing object (Text) ///
   Textobjekt.Click
   Call gMouseMove(20,20,40,40)
   Sleep 1
   '/// Insert some text in text object ///
   Call wDokSchreiben "Hallo dies ist <Shift Return>ein Text in einer Box."
   Call wDokSchreiben "<Shift Home Up>"
   Kontext "TB_Zeichenfunktionen"
   TB_Zeichenfunktionen.Close
   Call wDocSetContext
'  Call gMouseDoubleClick(5,5)
  printlog "   - adjust formats"
   '/// Select Format / Paragraph and adjust properties ///
   FormatParagraph
   Sleep 2
   Kontext
   Active.SetPage TabEinzuegeUndAbstaende
  Kontext "TabEinzuegeUndAbstaende"
   VonLinks.More 4
   Wert1$ = VonLinks.GetText
   VonRechts.Less 3
   Wert2$ = VonRechts.GetText
   ErsteZeile.More 2
   Wert3$ = ErsteZeile.GetText
   Oben.Less 1
   Wert4$ = Oben.GetText
   Unten.More 3
   Wert5$ = Unten.GetText
   Kontext
   Active.SetPage TabAusrichtungAbsatz
  Kontext "TabAusrichtungAbsatz"
   Blocksatz.Check
   if NOT LetzteZeile.IsEnabled then Warnlog "Last Line has not been activated when justify was selected"
   TabAusrichtungAbsatz.OK

  printlog "   - check formats"
   '///  close and reopen dialog ///
   FormatParagraph
   Kontext
   Active.SetPage TabEinzuegeUndAbstaende
   '/// check properties ///
  Kontext "TabEinzuegeUndAbstaende"
   if VonLinks.GetText <> Wert1$ then Warnlog "From left is not "+ Wert1$+" but "+ VonLinks.GetText + " Bug:64143"
   if VonRechts.GetText <> Wert2$ then Warnlog "From right is not "+ Wert2$+" but "+ VonRechts.GetText
   if ErsteZeile.GetText <> Wert3$ then Warnlog "First line is not "+ Wert3$+" but "+ ErsteZeile.GetText + " Bug:64143"
   if Oben.GetText <> Wert4$ then Warnlog "Top is not "+ Wert4$+" but "+ Oben.GetText
   if Unten.GetText <> Wert5$ then Warnlog "Bottom is not "+ Wert5$+" but "+ Unten.GetText
   Kontext
   Active.SetPage TabAusrichtungAbsatz
  Kontext "TabAusrichtungAbsatz"
   if NOT Blocksatz.IsChecked then Warnlog "Justify is not checked!"
   TabAusrichtungAbsatz.OK

   '/// Close document ///
   hCloseDocument
endcase

