'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: wr_o_5.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: hde $ $Date: 2006/01/10 10:57:51 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : This testcase is for thai issues only
'*
'\***********************************************************************


sub wr_o_5

    Call tLanguageSettingsComplexTextLayout

end sub




testcase tLanguageSettingsComplexTextLayout
    
    Dim i as integer, j as integer
    Dim bAsianLanguage as boolean
    Dim bCTLLanguage as boolean
    Dim sCTLLan() as string    
    Dim sCurrentDocumentLanguage as string
    Dim sCurrentCTLLanguage as string
    Dim bSequenceChecking as boolean
	if Val(mid$(gMinor, 2, Len(gMinor))) < 141 then        
        goto endsub
    endif
    '/// Open new writerdocument
    Call hNewDocument
    '/// Activate Asian support    
    bAsianLanguage = ActiveDeactivateAsianSupport(True)
    '/// Activate CTL support 
    bCTLLanguage = ActiveDeactivateCTLSupport(True)

	ToolsOptions
    '/// Goto 'Tools->Options->Language settings->Languages
	Call hToolsOptions ("LanguageSettings","Languages")
    sCurrentCTLLanguage = LanguageComplexScript.GetSelText
	Kontext "TabSprachen"                 	
    For i = 1 to LanguageComplexScript.GetItemCount
        '/// Select CTL-Language
        LanguageComplexScript.Select i
        sCurrentDocumentLanguage = LanguageComplexScript.GetSelText
        printlog "- Current selected CTL Language: " & sCurrentDocumentLanguage
        '/// close options dialog with 'ok'
        Kontext "ExtrasOptionenDlg"
        ExtrasOptionenDlg.Ok
        '/// Reopen options and go to Tabpage 'Complex Text Layout'
        ToolsOptions
        Call hToolsOptions ("LanguageSettings","ComplexTextLayout")
        
        Kontext "TabComplexTextLayout"
		bSequenceChecking = FALSE
		Select Case iSprache
			Case 01
				'/// Checkboxes under 'Sequence checking' should all be checked for CTL languages
                '/// + like "Thai", "Lao", "Khmer", "Vietnamese"
                sCTLLan = Array("Thai", "Lao", "Khmer", "Vietnamese")
				for j = 0 to 2
					if sCTLLan(j) = sCurrentDocumentLanguage then
						bSequenceChecking = TRUE
						exit for
					endif				
				next j
			Case else
				QAErrorlog "Please adapt testcase for this language"
				Kontext "ExtrasOptionenDlg"
				ExtrasOptionenDlg.Ok
				exit for
		end select

		Select Case bSequenceChecking
			Case TRUE
				if UseSequenceChecking.IsChecked = False then
					Warnlog "'Sequence Checking' should be checked for language: " & sCurrentDocumentLanguage
				endif
				if Restricted.IsEnabled = False or Restricted.IsChecked = False then
					Warnlog "'Restricted' should be enabled and checked for language: " & sCurrentDocumentLanguage
				endif
				if TypeAndReplace.IsEnabled = False or TypeAndReplace.IsChecked = False then
					Warnlog "'Type And Replace' should be enabled and checked for language: " & sCurrentDocumentLanguage
				endif				
			Case FALSE
				if UseSequenceChecking.IsChecked = True then
					QAErrorlog "'Sequence Checking' should not be checked for language: " & sCurrentDocumentLanguage
				endif
				if Restricted.IsEnabled = True AND Restricted.IsChecked = True then
					QAErrorlog "'Restricted' should not be checked for language: " & sCurrentDocumentLanguage
				endif
				if TypeAndReplace.IsEnabled = True AND TypeAndReplace.IsChecked = True then
					QAErrorlog "'Type And Replace' should not checked for language: " & sCurrentDocumentLanguage
				endif				
		end select				        
        Kontext "ExtrasOptionenDlg"
		ExtrasOptionenDlg.Ok
        ToolsOptions
        Call hToolsOptions ("LanguageSettings","Languages")
        Kontext "TabSprachen"                 		
    next i

    Kontext "ExtrasOptionenDlg"
	if ExtrasOptionenDlg.Exists then ExtrasOptionenDlg.Ok
    
    '/// Choose Thai as CTL language
    ToolsOptions
    Call hToolsOptions ("LanguageSettings","Languages")
    Kontext "TabSprachen"
    LanguageComplexScript.Select sCTLLan(0)
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Ok

    '/// Restart office
    Call wOfficeRestart
    
    '/// Reopen options and go to Tabpage 'Complex Text Layout'
    ToolsOptions
    Call hToolsOptions ("LanguageSettings","ComplexTextLayout")
    '/// Check if all checkboxes under 'Sequence checking' are checked 
    if UseSequenceChecking.IsChecked = False then
        Warnlog "'Sequence Checking' should be checked for language: " & sCTLLan(0)
    endif
    if Restricted.IsEnabled = False or Restricted.IsChecked = False then
        Warnlog "'Restricted' should be enabled and checked for language: " & sCTLLan(0)
    endif
    if TypeAndReplace.IsEnabled = False or TypeAndReplace.IsChecked = False then
        Warnlog "'Type And Replace' should be enabled and checked for language: " & sCTLLan(0)
    endif	
    '/// Reset CTL Language
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Ok        
    ToolsOptions
    Call hToolsOptions ("LanguageSettings","Languages")
    Kontext "TabSprachen"
    LanguageComplexScript.Select sCurrentCTLLanguage
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Ok    
    
IfNoSupport:   
    Call ActiveDeactivateAsianSupport(bAsianLanguage)
    Call ActiveDeactivateCTLSupport(bCTLLanguage)
    Call hCloseDocument
    
endcase
