'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_spellcheck.inc,v $
'*
'*  $Revision: 1.21 $
'*
'*  last change: $Author: hde $ $Date: 2006/01/30 13:26:46 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_spellcheck

   Call tToolsSpellcheckCorrect
   Call tToolsSpellcheck1Mistake
   Call tToolsSpellcheckForward
   Call tToolsSpellcheckOnlyOneWord
   Call tToolsSpellcheckAutomatic
   Call tToolsSpellcheckChangeLanguageAttribute
   Call tToolsThesaurus

end sub


testcase tToolsSpellcheckWithShortcut
    '/// Check if Spellcheck dialog comes up with shortcut 'F7'
    Call hNewDocument
    Call wDokSchreiben "Check if sp�llchecker comes ap!" 
    wait 500    
    Call wDokSchreiben "<F7>"
    
    Kontext "Spellcheck"
    if Spellcheck.Exists then
        printlog "OK, Spellchecker comes up"
        Spellcheck.Close
    else
        QAErrorlog "#i35000#Spellchecker does not come up with shortcut 'F7'"
    endif
    
    Call hCloseDocument

endcase


testcase tToolsSpellcheckCorrect
    Dim DieDatei as String
    '/// Checking if dictionary-files exists ///
    Printlog "- Checking Dictionary-Files"
    select case iSprache
        case 01 : DieDatei = "01-44-hyph.dat"
        case 81 : Printlog "- No Spellcheck in Japanese!"
                  goto endsub
        case 82 : Printlog "- No Spellcheck in Korean!"
                  goto endsub
        case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
                  goto endsub
        case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
                  goto endsub
        case else : DieDatei =  "" & iSprache & "-hyph.dat"
    end select
    if gNetzInst = TRUE then
        DieDatei = Convertpath (gNetzOfficePath + "share\dict\" + trim$(DieDatei))
    else
        DieDatei = Convertpath (gOfficePath + "share\dict\" + trim$(DieDatei))
    endif

    PrintLog "- Tools / Spellcheck without text"
    '/// New writerdocument ///
    Call hNewDocument
    Sleep 1
    '/// Call Spellcheck in empty document ///
    ToolsSpellcheck
    Sleep 2
    Kontext "Active"
    if NOT Active.Exists(1) then
        Warnlog "No Finished message"
    else
        Active.OK
    end if

    Dim FFText as String
    PrintLog "- Tools / Spellcheck with correct text"
    '/// Call Spellcheck for correct text ///
    select case iSystemSprache
        case 01   : FFText = "This is a text without any error.<Return>"
        case 03   : FFText = "Escreva os seus dados de utilizador correctamente e tome nota deles (guardar / imprimir).<Return>"
        case 31   : FFText = "Dit werk is beschermd door de Auteurswet.<Return>"
        case 33   : FFText = "Il nous faut donc un de temps pour examiner avec soin tous les dossiers.<Return>"
        case 34   : FFText = "Este archivo contiene información importante sobre el programa.<Return>"
        case 36   : FFText = "Boszniai amerikai kontingens háromnegyedesek – mintegy négyezer katona – magyarországi telepítése egy éven belül megtörténhet.<Return>"
        case 39   : FFText = "La ringraziamo per l'interesse mostrato a collaborare con la firma.<Return>"
        case 45   : FFText = "Danmark ikke er sikret maksimal indflydelse på den fremtidige europæiske udlændingepolitik.<Return>"
        case 46   : FFText = "Den här filen innehåller viktig programinformation.<Return>"
        case 48   : FFText = "Nie wolno w zadnim wypadku przerywa uruchomionego serwisu !<Return>"
        case 49   : FFText = "Dies ist ein Text ohne Fehler.<Return>"
        case 55	  : FFText = "Ele ouviu passos silenciosos atrás dele. Isso não estava certo.<Return>"
        case else : QAErrorLog " - The language " + iSystemSprache +" has no defined language text. No Test !"
                    exit Sub
    end select

    Call wDokSchreiben FFText
    wait 500
    ToolsSpellcheck
    Sleep 2
    Kontext
    try
        Active.Yes
        Sleep 1
    catch
        Warnlog "No message to jump to start"
    endcatch

    try
        Active.OK
    catch
        Kontext "Spellcheck"
        if Spellcheck.Exists then
            Warnlog "With correct text the Spellcheck dialog appears ( maybe wrong language selected )"
            Spellcheck.Close
        end if
    endcatch

    '/// Close document ///
    Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsSpellcheck1Mistake
    Dim Fehler$ : Dim Sprachenname$ : Dim Dummy$ : Dim  FehlerText$
    PrintLog "- Tools / Spellcheck with a defined mistake"
    select case iSystemSprache
        case 01   : FehlerText$ = "Thats not a trick, it's a Sony."
                    Fehler$ = "Thats"
                    Sprachenname$ = "English (USA)"
        case 03   : FehlerText$ = "Escrive os seus dados de utilizador correctamente e tome nota deles."
                    Fehler$ = "Escrive"
                    Sprachenname$ = "Português"
        case 31   : FehlerText$ = "Wijek danken u voor uw interesse in het samenwerken met Sun Microsystems."
                    Fehler$ = "Wijek"
                    Sprachenname$ = "Nederlands (NL)"
        case 33   : FehlerText$ = "Ilk nous faut donc un de temps pour examiner avec soin"
                    Fehler$ = "Ilk"
                    Sprachenname$ = "Français (France)"
        case 34   : Fehlertext$ = "Este archivo contiene información importnte sobre el programa."
                    Fehler$ = "importnte"
                    Sprachenname$ = "Español (España)"
        case 36   : Fehlertext$ = "Boszniai amerikai kontingens háromnegyedének – mintegy négyezer katona – magyarországi telepítése egy éven belül megtörténhet."
                    Fehler$ = "háromnegyedének"                    
                    Sprachenname$ = "Magyar"
        case 39   : FehlerText$ = "Lab ringraziamo per l'interesse"
                    Fehler$ = "Lab"
                    Sprachenname$ = "Italiano (Italia)"
        case 45   : FehlerText$ = "Igke er sikret maksimal indflydelse på den fremtidige europæiske udlændingepolitik."
                    Fehler$ = "Igke"
                    Sprachenname$ = "Dansk"
        case 46   : FehlerText$ = "Dön här filen innehåller viktig programinformation."
                    Fehler$ = "Dön"
                    Sprachenname$ = "svenska (Sverige)"
        case 48   : FehlerText$  = "walno w zadnim wypadku przerywa uruchomionego serwisu !"
                    Fehler$ = "Walno"
                    Sprachenname$ = "Polski"
        case 49   : FehlerText$ = "Diees ist ein Fehler."
                    Fehler$ = "Diees"
                    Sprachenname$ = "Deutsch (Deutschland)"
        case 55	  : FehlerText$ = "Esta poderia ser a respista para suas preces?"
        			Fehler$ = "respista"
        			Sprachenname$ = "Português (Brasil)"
        case 81 : Printlog "- No Spellcheck in Japanese!"
                  goto endsub
        case 82 : Printlog "- No Spellcheck in Korean!"
                  goto endsub
        case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
                  goto endsub
       case 88 :  Printlog "- No Spellcheck in Chinese (traditional)!"
                  goto endsub
        case else : QAErrorLog "The language " + iSystemSprache +" has no defined Errortext. No test"
                  goto endsub
    end select
    '/// New writerdocument ///
    Call hNewDocument
    '/// Insert a sentence with one definded mistake and execute spellcheck ///
    Call wDokSchreiben FehlerText$
    Call wDokSchreiben "<Return><Up>"
	wait 500
    ToolsSpellcheck
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.Yes
            catch
                Warnlog Active.Gettext
                Active.Ok
            endcatch
        endif
    endif
    Sleep 2
    Kontext "Spellcheck"
    if Not Spellcheck.Exists then
        Warnlog "Spellchecker is not up !"
        Call hCloseDocument
        goto endsub
    endif
    '  Dictionary Language is language dependend. Function to be created
    printlog "   - check language"
    'if DictionaryLanguage.GetSelText <> gLanguage then Warnlog "Dictionary language " + DictionaryLanguage.GetSelText +" selected"
    printlog "   - replace wrong word with a suggestion"
    '/// replace wrong word with a suggestion ///
    if trim$(NotInDictionary.GetText) <> trim(FehlerText$) then Warnlog FehlerText$ +" has not been detected as mistake. Detected mistake is:" + NotInDictionary.GetText
    if Suggestions.GetItemCount > 0 then
        try
            Dummy$ = Suggestions.GetItemText (2)
            Suggestions.Select 2
        catch
            Dummy$ = Suggestions.GetItemText (1)
            Suggestions.Select 1
        endcatch
        ' Next check does not work because if word is selected it will only be highlited!!"
		' if Not NotInDictionary.GetText <> FehlerText$ then Warnlog "Text in preview has not been replaced with the suggestion"
        Change.Click
    else
        QAErrorLog "Please choose another word to check suggestions, because no suggestion found!"
    endif
    Kontext "Active"
    if Active.Exists then
        try
            Active.OK
        catch
            Warnlog Active.Gettext
            Active.No
        endcatch
    end if
    
    Kontext "Spellcheck"
    if Spellcheck.Exists then SpellcheckClose.Click

	Call wDokSchreiben "<Up><Home>"
    Call wDokSchreiben "<Shift End>"
    Sleep 1
	EditCopy
    if GetClipboardText = FehlerText$ then Warnlog "Replaced text in document is wrong. Not "+ FehlerText$ + " but " + GetClipboardText
    Call hCloseDocument

endcase

' *******************************************************************

testcase tToolsSpellcheckForward
    Dim Dummy$ : Dim Aufnahme$ : Dim InsFile as string
    Dim Add_Word as string, sDictionary as string
    PrintLog "- Tools / Spellcheck / check forward"
    '/// Open specified document depending on language to check spellcheck ///
    '/// document has 4 defined wrong words ///
    InsFile = wGetSpellcheckDocumentName(1)
    Select Case InsFile
        Case "None"
            Printlog "- No Spellcheck for this language available!"
            goto endsub
        case "Empty"
            QAErrorLog "The language " + iSystemSprache +" has no defined Errortext. No test!"
            goto endsub
    end select
    
    if gApplication = "MASTERDOC" then
        if wInsertDocumentinMasterDoc(InsFile) = False then goto endsub
            EditPaste
    else
        Call hDateiOeffnen(InsFile)
    endif
    '/// point cursor to beginning of document and execute spellcheck ///
    Call wDokSchreiben "<Mod1 Home>"
    
    select case iSprache
        case 01   : Dummy$ = "exprass"   : Aufnahme$ = "pablischer"
        case 03   : Dummy$ = "quante"   : Aufnahme$ = "cempas"
        case 31   : Dummy$ = "haaientanden"   : Aufnahme$ = "widerzijdse"
        case 33   : Dummy$ = "votrex"   : Aufnahme$ = "recontacterons"
        case 34   : Dummy$ = "Asegúree"   : Aufnahme$ = "diretorio"
        case 36   : Dummy$ = "hétezres"   : Aufnahme$ = "jelentos"
        case 39   : Dummy$ = "meczanici" : Aufnahme$ = "anniche"
        case 45   : Dummy$ = "grend" : Aufnahme$ = "lando"
        case 46   : Dummy$ = "fillen" : Aufnahme$ = "viktik"
        case 48   : Dummy$ = "znajdujacej" : Aufnahme$ = "usuniete"
        case 49   : Dummy$ = "reichtt"   : Aufnahme$ = "viierter"
        case 55   : Dummy$ = "horta"   : Aufnahme$ = "dpa"
    end select

    wait 500
    ToolsSpellcheck
    Sleep 2
    Kontext "Spellcheck"
    Printlog "   - Replace all (" + NotInDictionary.Gettext + ") ...."
    '/// Replace first found word with 1 suggestion in list ///
    Suggestions.Select 1
    Printlog "   - .... with (" + NotInDictionary.Gettext + ")"
    wait 500
    try
        ChangeAll.Click
    catch
        Warnlog "Button 'change all' is not accessible!"
    endcatch
    '/// Select 'Always replace' ///
    Sleep 1

    Printlog "   - Ignore All (" + NotInDictionary.Gettext + ")"
    '/// For second wrong word select 'Ignore all' ///
    wait 500
    try
        IgnoreAll.Click
    catch
        Warnlog "Button 'Ignore all' is not accessible"
    endcatch
    Sleep 1

    Printlog "   - Ignore (" + NotInDictionary.Gettext + ")"
    '/// For 3rd wrong word select 'Ignore' ///
    wait 500
    try
        IgnoreOnce.Click
    catch
        Warnlog "Button 'Ignore once' is not accessible"
    endcatch
    Sleep 1

    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog "Spellcheck has ended! Not reproducable by hand !"
        endif
    else
        Kontext "Spellcheck"
        Add_Word = trim$(NotInDictionary.Gettext)
        Printlog "   - Add (" + Aufnahme$ + ")"
        '/// Add 4th word to dictionary ///
        if AddToDictionary.IsEnabled then
            AddToDictionary.Click
			wait 500
			'/// remember selected dictionary
			sDictionary = MenuGetitemText(1)
			Call hMenuSelectNr(1)
			Sleep 1
		else
			Warnlog "Unable to add word to dictionary->button is disabled!"
		endif
    endif

	Kontext "Active"
	if Active.Exists then
		If Active.GetRT = 304 then
			Active.Ok
		endif
	endif
	
    Kontext "Spellcheck"
    if Spellcheck.Exists then Spellcheck.Close
    Call wDokSchreiben "<Home>"

    Printlog "   - recheck: One mistake has to be found 3 times"
    wait 500
    '/// Recheck: One mistake has to be found 3 times ///
    ToolsSpellcheck
    Sleep 2
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.Ok
            catch
                Active.Yes
                Warnlog Active.Gettext
            endcatch
        endif
    endif
    Kontext "Spellcheck"
    if Spellcheck.Exists then
        if Instr(NotInDictionary.GetText, Dummy$) = 0 then
            Warnlog "Jumped to wrong mistake! Not " & Dummy$ & " but " & Suggestions.GetSelText
        else
            try
                IgnoreAll.Click
            catch
                Warnlog "Button 'Ignore all' is not accessible"
            endcatch
        endif
    endif
    Sleep 2
    Kontext
    if Active.Exists(2) then
        Active.OK
    else
        Kontext "Spellcheck"
        if Spellcheck.Exists then Spellcheck.Close
    end if
    Sleep 1

    GoOn:
    Printlog "- Deleting the Ignore list"
    '/// Delete entrys in Ignorelist ///
    Call wIgnorierenListeLoeschen

    Printlog "   - Delete added word in dictionary"
    '/// Delete added word in dictionary ///
    Call WortAusWoerterbuchLoeschen ( Aufnahme$ )

    '/// Close document ///
    Call hCloseDocument
endcase
' *******************************************************************
testcase tToolsSpellcheckBackward
    Dim Dummy$ : Dim Aufnahme$ : Dim InsFile as string
    '/// Open specified document depending on language to check spellcheck ///
    '/// document has 4 defined wrong words ///
    PrintLog "- Tools / Spellcheck / check backwards"
    select case iSystemSprache
        case 01   : InsFile =  Convertpath(gTesttoolpath + "writer\level1\input\spellcheck\st1_2_01.sxw")
                    Dummy$ = "exprass"   : Aufnahme$ = "pablischer"
        case 03   : InsFile =  Convertpath(gTesttoolpath + "writer\level1\input\spellcheck\st1_2_03.sxw")
                    Dummy$ = "quante"   : Aufnahme$ = "cempas"
        case 31   : InsFile = Convertpath( gTesttoolpath + "writer\level1\input\spellcheck\st1_2_31.sxw")
                    Dummy$ = "haaietanden"   : Aufnahme$ = "widerzijdse"
        case 33   : InsFile = Convertpath( gTesttoolpath + "writer\level1\input\spellcheck\st1_2_33.sxw")
                    Dummy$ = "votrex"   : Aufnahme$ = "recontacterons"
        case 34   : InsFile = Convertpath( gTesttoolpath + "writer\level1\input\spellcheck\st1_2_34.sxw")
                    Dummy$ = "Asegúree"   : Aufnahme$ = "diretorio"
        case 36   : InsFile = Convertpath( gTesttoolpath + "writer\level1\input\spellcheck\st1_2_36.sxw")
                    Dummy$ = "hétezres"   : Aufnahme$ = "jelentos"                    
        case 39   : InsFile = Convertpath( gTesttoolpath + "writer\level1\input\spellcheck\st1_2_39.sxw")
                    Dummy$ = "meczanici" : Aufnahme$ = "anniche"
        case 45   : InsFile = Convertpath( gTesttoolpath + "writer\level1\input\spellcheck\st1_2_45.sxw")
                    Dummy$ = "grend" : Aufnahme$ = "lando"
        case 46   : InsFile = Convertpath( gTesttoolpath + "writer\level1\input\spellcheck\st1_2_46.sxw")
                    Dummy$ = "fillen" : Aufnahme$ = "viktik"
        case 48   : InsFile = Convertpath( gTesttoolpath + "writer\level1\input\spellcheck\st1_2_48.sxw")
                    Dummy$ = "znajdujacej" : Aufnahme$ = "usuniete"
        case 49   : InsFile = Convertpath( gTesttoolpath + "writer\level1\input\spellcheck\st1_2_49.sxw")
                    Dummy$ = "reichtt"   : Aufnahme$ = "viierter"
        case 55   : InsFile = Convertpath( gTesttoolpath + "writer\level1\input\spellcheck\st1_2_55.sxw")
                    Dummy$ = "horat"   : Aufnahme$ = "dpa"
        case 81 : Printlog "- No Spellcheck in Japanese!"
                  goto endsub
        case 82 : Printlog "- No Spellcheck in Korean!"
                  goto endsub
        case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
                  goto endsub
        case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
                  goto endsub
        case else : QAErrorLog "The language " + iSystemSprache +" has no defined Errortext. No text!"
                  goto endsub
    end select

    if gApplication = "MASTERDOC" then
        if wInsertDocumentinMasterDoc(InsFile) = False then goto endsub
        EditPaste
    else
        Call hDateiOeffnen(InsFile)
    endif
    '/// point cursor to start of document and execute spellcheck ///
    Call wDokSchreiben "<Mod1 Home>"
    wait 500
    ToolsSpellcheck
    Sleep 2
    Kontext "Active"
    If Active.Exists then
        If Active.GetRT = 304 then
            try
                Active.Ok
            catch
                active.yes
            endcatch
        endif
    endif
    Kontext "Rechtschreibung"
    wait 500
    '/// check 'Backwards' in dialog ///
    Backwards.Check

    Printlog "   - Replace all"
    '/// Replace first found word with first suggestion in list ///
    Vorschlaege.Select 1
    '/// Select 'Always replace' ///
    ReplaceAll.Click
    Sleep 1

    Kontext "Active"
    if Active.Exists then
        printlog "-  " + Active.Gettext
        Active.Yes
    else
        Warnlog "Notice: 'Continue checking at beginning of document?' not appeared !"
    end if

    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog Active.Gettext & " Bug#110893"
            Active.Ok
            Kontext "Rechtschreibung"
            if Rechtschreibung.Exists then Rechtschreibung.Close
            Call hCloseDocument
            goto endsub
        endif
    endif

    Printlog "   - Add"
    '/// Add next word to dictionary ///
    Kontext "Rechtschreibung"
    if Wort.Gettext <> Aufnahme$ then
        Warnlog " Not the latter mistake in document selected!"
    else
        if Woerterbuch.GetItemCount > 0 then
            Woerterbuch.Select 1
            Aufnehmen.Click
            Kontext "Active"
            if Active.Exists then
                if Active.GetRT = 304 then
                    Warnlog Active.Gettext
                    Active.Ok
                endif
            endif
        else
            Warnlog "- No Default-dictionary!"
        endif
    endif
    Sleep 1

    Kontext "Rechtschreibung"
    Printlog "   - Ignore"
    '/// §rd word has to be ignored ///
    Ignorieren.Click
    Sleep 1

    Printlog "   - Ignore all"
    '/// 4th word select 'Ignore all' ///
    AlleIgnorieren.Click
    Sleep 1

    Printlog "   - check if mistake has been correctly treated"
    '/// check if mistakes have been correctly treated ///

    Kontext
    if Active.Exists then
        Active.OK
    else
        Kontext "Rechtschreibung"
        if Rechtschreibung.Exists then Rechtschreibung.Close
    endif
    Call wDokSchreiben "<Home>"

    Printlog "   - recheck: One mistake has to be found 3 times"
    '/// Recheck: One mistake has to be found 3 times ///
    wait 500
    ToolsSpellcheck
    Sleep 2
    Kontext
    if Active.Exists then Active.Yes

    Kontext "Rechtschreibung"
    AlleIgnorieren.Click
    Sleep 1
    Kontext
    if Active.Exists then
        Active.OK
    else
        Kontext "Rechtschreibung"
        Rechtschreibung.Close
    end if

    Printlog "- deleting the Ignore list"
    '/// delte entrys in Ignore list ///
    Call wIgnorierenListeLoeschen

    Printlog "   - delete added word in dictionary"
    '/// delete added word in dictionary ///
    WortAusWoerterbuchLoeschen ( Aufnahme$ )

    printlog "   - Uncheck backwards in Spellchecking dialog"
    '/// Uncheck 'Backwards' in Spellcheck dialog ///
    wait 500
    ToolsSpellcheck
    Sleep 2
    Kontext "Active"
    if Active.Exists then Active.Yes
    Kontext "Rechtschreibung"
    if Backwards.IsChecked then
        Backwards.UnCheck
    else
        Warnlog "Deleting the Ignore list sets backward search back. Backward is not checked anymore!"
    end if
    Rechtschreibung.Close

    '/// Close document ///
    Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsSpellcheckOnlyOneWord
    Dim Fehler$, InsFile as string, ReplacedWith as String, i as integer
    '/// Open specified document depending on language to check spellcheck ///
    '/// document has 1 defined wrong word ///
    PrintLog "- Tools / Spellchecking / Check only one word"
    InsFile = wGetSpellcheckDocumentName(2)
    Select Case InsFile
        Case "None"
            Printlog "- No Spellcheck for this language available!"
            goto endsub
        case "Empty"
            QAErrorLog "The language " + iSystemSprache +" has no defined Errortext. No test!"
            goto endsub
    end select
    
    if gApplication = "MASTERDOC" then
        if wInsertDocumentinMasterDoc(InsFile) = False then goto endsub
            EditPaste
    else
        Call hDateiOeffnen(InsFile)
    endif
    Call wDokSchreiben "<Mod1 Home>"
    
    select case iSprache
        case 01   : Fehler$ = "excetionally"      ' this word is wrong
        case 03   : Fehler$ = "semstre"           ' this word is wrong
        case 31   : Fehler$ = "lidstartesn"        ' this word is wrong
        case 33   : Fehler$ = "heues"            ' this word is wrong
        case 34   : Fehler$ = "vacunaión"         ' this word is wrong
        case 36   : Fehler$ = "fekvo"         ' this word is wrong
        case 39   : Fehler$ = "brasilianir"       ' this word is wrong
        case 45   : Fehler$ = "Amserdam"         ' this word is wrong
        case 46   : Fehler$ = "avrttades"         ' this word is wrong
        case 48   : Fehler$ = "stosowanei"         ' this word is wrong
        case 49   : Fehler$ = "georaphischen"     ' this word is wrong
        case 55   : Fehler$ = "Veigo"     ' this word is wrong
    end select

    EditSearchAndReplace
    Kontext "FindAndReplace"
    try
        SearchFor.Settext ""
    catch
    endcatch
    if SimilaritySearch.IsVisible = False then More.Click
    if SimilaritySearch.IsEnabled then SimilaritySearch.Uncheck
    if SearchForStyles.IsEnabled then SearchForStyles.Uncheck
    if RegularExpressions.IsEnabled then RegularExpressions.Uncheck
    if NoFormat.IsEnabled then NoFormat.Click
    if CurrentSelectionOnly.IsEnabled then CurrentSelectionOnly.Uncheck
    WholeWordsOnly.Uncheck
    Backwards.Uncheck
    MatchCase.Uncheck
    RegularExpressions.Check

    SearchFor.Settext Fehler$
    SearchNow.Click
    Kontext "Active"
    if Active.Exists then
        if Active.getRT = 304 then
            Warnlog Active.Gettext
            try
                Active.Ok
            catch
                Active.No
            endcatch
        endif
    endif

    Kontext "FindAndReplace"
    if FindAndReplace.Exists then FindAndReplace.Close

    ToolsSpellcheck
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then 
            Warnlog "Spellcheck doesn't work correctly:" & Active.Gettext
            try
                Active.Ok
            catch
                Active.No
            endcatch
            Call hCloseDocument
            goto endsub
        endif
    endif

    Kontext "Spellcheck"
    Printlog "   - Replace all"
    if Suggestions.GetItemCount > 0 then
        Suggestions.Select 1
        wait 500
        Suggestions.TypeKeys "<Down><Up>"
        ReplacedWith = Suggestions.GetSelText
        wait 500
        if Change.IsEnabled then Change.Click
        Sleep 1
    else
        Warnlog "No suggestion for word: " & Fehler$ & " found. Test stops"
        Spellcheck.Close
        Call hCloseDocument
        goto endsub
    endif

    
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.Ok
            catch
                Active.No
                Warnlog Active.Gettext
            endcatch
        endif
    endif       
    
    Kontext "Spellcheck"
    if Spellcheck.Exists then SpellcheckClose.Click
    
    Call wDokSchreiben "<Mod1 Shift Left>"
    try
        EditCopy
        if GetClipboardtext = Fehler$ then
            Warnlog "#i40498#Spellchecker does not commit changes correctly (" & GetClipboardtext & " found )"
            Call hCloseDocument
            goto endsub
        endif
    catch
        Warnlog "- Didn't found the word to check! No Spellchecking for one word!"
        Call hCloseDocument
        goto endsub
    endcatch

    '/// Execute spellcheck again ///
    wait 500
    ToolsSpellcheck
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.Yes
                Kontext "Active"
                if Active.Exists then
                    if Active.GetRT = 304 then
                        Active.Ok
                        Warnlog "#i40480#Spellchecker finishes though wrong words in documents"
                    endif
                endif
            catch
                Active.Ok
            endcatch
        endif
    else
        Sleep 2
        Kontext "Spellcheck"
        if Spellcheck.Exists then
            Warnlog "Probably the replaced word found wrong again!"
            Spellcheck.Close
        endif
    endif
        
    Kontext "Spellcheck"
    if Spellcheck.Exists then Spellcheck.Close
    
    '/// Close document ///
    Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsSpellcheckAutomatic
    Dim Fehler1% : Dim Fehler2% : Dim sFehler1$ : Dim sFehler2$
    Dim j as integer, soviele as string, dasIsser as string, dasIsserNich as string
    PrintLog "- Tools / Spellcheck / AutoSpellcheck"
    '/// New writerdocument ///
    Call hNewDocument
    '/// Enable Auto-Spellcheck in options
    Call wEnableAutoSpellcheck ( true ) 
    
    '/// Check Auto-Spellcheck and insert a sentence with 2 mistakes ///
    printlog "   - write text"
    select case iSystemSprache
        case 01   : wDokSchreiben "Hello thiis here are too errorrs "
                  Fehler1% = 1 : Fehler2% = 4
                  sFehler1$ = "thiis"  : sFehler1$ = "errorrs"
                  dasIsserNich = "Standard"
        case 03   : wDokSchreiben "Aqui poderá elimitnar componentes já instalados ou instalar novos compotentes numa "
                  Fehler1% = 2 : Fehler2% = 7
                  sFehler1$ = "elimitnar"  : sFehler1$ = "compotentes"
                  dasIsserNich = "Padrão"
        case 31   : wDokSchreiben "Betaling binnern 14 dagen rekeningsdatum met 2% kortng, binnen 30 dagen nettor "
                  Fehler1% = 1 : Fehler2% = 7
                  sFehler1$ = "binnern"  : sFehler1$ = "rekeningsdatum"
                  dasIsserNich = "Standaard"
        case 33   : wDokSchreiben "Je vious remercie d'accuser réception dex ce courrier "
                  Fehler1% = 1 : Fehler2% = 4
                  sFehler1$ = "vious"  : sFehler1$ = "dex"
                  dasIsserNich = "Standard"
        case 34   : wDokschreiben "Este archvo contiene información importnte sobre el programa."
                  Fehler1% = 1 : Fehler2% = 3
                  sFehler1$ = "archvo"  : sFehler1$ = "importnte"
                  dasIsserNich = "Estándar"
        case 36   : wDokSchreiben "A hétezres koszovói amerikai kontingens jelentos részét is a magyarországi bázison helyezi majd el."
                  Fehler1% = 1 : Fehler2% = 4
                  sFehler1$ = "hétezres"  : sFehler1$ = "jelentos"
                  dasIsserNich = "Alapértelmezett"                
        case 39   : wDokSchreiben "La sfumaturar è statsi modificata senza salvare "
                  Fehler1% = 1 : Fehler2% = 2
                  sFehler1$ = "sfumaturar"  : sFehler1$ = "statsi"
                  dasIsserNich = "Standard"
        case 45   : wDokSchreiben "Han advarade både mod at kalde traktüten et fredens projekt "
                  Fehler1% = 1 : Fehler2% = 5
                  sFehler1$ = "advarade"  : sFehler1$ = "traktüten"
                  dasIsserNich = "Standard"
        case 46   : wDokSchreiben "Den här fiten innehåller viktit programinformation "
                  Fehler1% = 2 : Fehler2% = 2
                  sFehler1$ = "fiten"  : sFehler1$ = "viktit"
                  dasIsserNich = "Standard"
        case 48   : wDokSchreiben "Nie wolno w zadim wypadku przerywa uruchomiongo serwisu "
                  Fehler1% = 3 : Fehler2% = 3
                  sFehler1$ = "zadim"  : sFehler1$ = "uruchomiongo"
                  dasIsserNich = "Standard"
        case 49   : wDokSchreiben "Hallo hiaer sind swei Fehler "
                  Fehler1% = 1 : Fehler2% = 2
                  sFehler1$ = "hiaer"  : sFehler1$ = "swei"
                  dasIsserNich = "Standard"
        case 55   : wDokSchreiben "Aqui poderá elimitnar componentes já instalados ou instalar novos compotentes numa "
                  Fehler1% = 2 : Fehler2% = 7
                  sFehler1$ = "elimitnar"  : sFehler1$ = "compotentes"
                  dasIsserNich = "Padrão"                  
        case 81 : Printlog "- No Spellcheck in Japanese!"
                 Call hCloseDocument
                 goto endsub
        case 82 : Printlog "- No Spellcheck in Korean!"
                 Call hCloseDocument
                 goto endsub
        case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
                 Call hCloseDocument
                 goto endsub
        case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
                 Call hCloseDocument
                 goto endsub
        case else : QAErrorlog "The language " + iSystemSprache +" has no defined errortext. No Test!"
                  Call hCloseDocument
                  goto endsub
    end select

    Call wDokSchreiben "<Space><Return>"
    
    printlog "   -  relieve mistake"
    Call wDokSchreiben "<Up><Home>"
    Sleep 5
    Call wDokSchreiben "<Mod1 Right>", Fehler1%
    Call wDokSchreiben "<Right>"          ' Cursor in fehlerhaftes NotInDictionary stellen
    '/// Open contextmenu in first wrong word ///
    Call wOpenContextMenu
    dasIsser=hMenuItemGetText (1)
    if dasIsser<>dasIsserNich then
        soviele=MenuGetItemCount - 4
        '/// Check if there is a suggestion and replace word ///
        if soviele <=0 then
            Warnlog "- No suggestions in Context menu for the first wrong word!"
        else
            printlog "- Context menu has " + soviele + " suggestions to the 1. wrong word!"
            Call hMenuSelectNr (1)
            Call wDokSchreiben "<Shift Mod1 Left>"
            try
                EditCopy
                if GetClipboardtext<> dasIsser then
                    Warnlog "- 1. wrong Word has not been replaced with " + dasIsser + " but "+ GetClipBoardtext
                else
                    printlog "- 1. wrong word has been replaced with the 1. entry in context menu!"
                endif
            catch
            endcatch
        endif
    else
        Warnlog "- AutoSpellcheck doesn't work , wrong Context menu! (1.Word)"
    endif

    Call wDokSchreiben "<Mod1 Right>", Fehler2%
    Call wDokSchreiben "<Right>"          ' Cursor in fehlerhaftes NotInDictionary stellen
    Call wOpenContextMenu
    dasIsser=hMenuItemGetText (1)
    if dasIsser<>dasIssernich then
        soviele=MenuGetItemCount - 4
        if soviele <=0 then
            Warnlog "- No suggestions in Contextmenu for 2. wrong Word !"
        else
            printlog "- Context menu has " + soviele + " suggestions for the 2. wrong word!"
            Call hMenuSelectNr (1)
            Call wDokSchreiben "<Shift Mod1 Left>"
            try
                EditCopy
                if GetClipboardtext<> dasIsser then
                    Warnlog "- 2. wrong word has not been replaced with " + dasIsser + " but "+ GetClipBoardtext
                else
                    printlog "- 2. mistake has been replaced with the 1. entry in context menu!"
                endif
            catch
            endcatch
        endif
    else
        Warnlog "- AutoSpellcheck doesn't work, wrong Context menu (2.Word)!"
    endif

    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<F7>"
    Sleep 2
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.ok
            catch
                Active.Gettext
                Active.No
            endcatch
        endif
    else
        Kontext "Spellcheck"
        if Spellcheck.Exists then
            QAErrorlog "- Spellchecking dialog is still open. Not all words have been replaced!"
            Spellcheck.Close
        end if
    end if

    Kontext "Active"
    if Active.Exists then Active.ok

    '/// Close document ///
    Call hCloseDocument
endcase



testcase tToolsSpellcheckChangeLanguageAttribute
      
    Dim Fehler$, InsFile as string, i as integer, ReplacedWith as string
    Dim PriorLanguage as string, CurrentLanguage as string
    '/// Open specified document depending on language to check spellcheck ///
    '/// document has 1 defined wrong word ///
    PrintLog "- Tools / Spellchecking / Check only one word"
    InsFile = wGetSpellcheckDocumentName(2)
    Select Case InsFile
        Case "None"
            Printlog "- No Spellcheck for this language available!"
            goto endsub
        case "Empty"
            QAErrorLog "The language " + iSystemSprache +" has no defined Errortext. No test!"
            goto endsub
    end select
    
    if gApplication = "MASTERDOC" then
        if wInsertDocumentinMasterDoc(InsFile) = False then goto endsub
            EditPaste
    else
        Call hDateiOeffnen(InsFile)
    endif
    Call wDokSchreiben "<Mod1 Home>"
    
    select case iSprache
        case 01   : Fehler$ = "excetionally"      ' this word is wrong
        case 03   : Fehler$ = "semstre"           ' this word is wrong
        case 31   : Fehler$ = "lidstartesn"        ' this word is wrong
        case 33   : Fehler$ = "heues"            ' this word is wrong
        case 34   : Fehler$ = "vacunaión"         ' this word is wrong
        case 36   : Fehler$ = "jelentos"
        case 39   : Fehler$ = "brasilianir"       ' this word is wrong
        case 45   : Fehler$ = "Amserdam"         ' this word is wrong
        case 46   : Fehler$ = "avrttades"         ' this word is wrong
        case 48   : Fehler$ = "stosowanei"         ' this word is wrong
        case 49   : Fehler$ = "georaphischen"     ' this word is wrong
        case 55   : Fehler$ = "Veigo"     ' this word is wrong
    end select

    EditSearchAndReplace
    Kontext "FindAndReplace"
    try
        SearchFor.Settext ""
    catch
    endcatch
    if SimilaritySearch.IsVisible = False then More.Click
    if SimilaritySearch.IsEnabled then SimilaritySearch.Uncheck
    if SearchForStyles.IsEnabled then SearchForStyles.Uncheck
    if RegularExpressions.IsEnabled then RegularExpressions.Uncheck
    if NoFormat.IsEnabled then NoFormat.Click
    if CurrentSelectionOnly.IsEnabled then CurrentSelectionOnly.Uncheck
    WholeWordsOnly.Uncheck
    Backwards.Uncheck
    MatchCase.Uncheck
    RegularExpressions.Check

    SearchFor.Settext Fehler$
    SearchNow.Click
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog "- Didn't found the word to check! No Spellchecking for one word!"
            Active.Ok
            Kontext "FindAndReplace"
            FindAndReplace.Cancel
            Call hCloseDocument
            goto endsub
        endif
    endif
    Kontext "FindAndReplace"
    if FindAndReplace.Exists then FindAndReplace.Cancel
    EditCopy

    '/// Execute spellcheck: change language Attributes
    wait 500
    ToolsSpellcheck
    Sleep 2
    Kontext "Spellcheck"
    if Not Spellcheck.Exists then
        Kontext "Active"
        If Active.Exists then
            If Active.GetRT = 304 then
                Warnlog Active.Gettext
                Warnlog "- Probably didn't found the word to check! No Spellchecking for one word!"
                Active.ok
            endif
        endif
        ToolsSpellcheck
        Kontext "Spellcheck"
    endif
	'/// Replace found word with suggestion from list
    if Spellcheck.Exists then
        PriorLanguage = DictionaryLanguage.GetSelText
        printlog "- remember selected language: " & PriorLanguage
        for i = 1 to DictionaryLanguage.GetItemCount
            DictionaryLanguage.Select i
            if Suggestions.GetItemCount > 0 then
                CurrentLanguage = DictionaryLanguage.GetSelText
                if Suggestions.IsEnabled and CurrentLanguage <> PriorLanguage then
                    printlog "-  replace with language: " & CurrentLanguage
                    Suggestions.Select 1
                    ReplacedWith = Suggestions.GetSelText
                    printlog "-  replace with word: " & ReplacedWith
                    i = DictionaryLanguage.GetItemCount + 1 
                endif
            endif        
        next i    
        '/// Close spellcheck dialog and check if properties have been set
        if ReplacedWith > "" then
            Change.Click        
            Kontext "Active"
            if Active.Exists then
                if Active.GetRT = 304 then
                    try
                        Active.Yes
                    catch
                    endcatch
                endif
            endif
            ' Finished message ?
            Kontext "Active"
            if Active.Exists then
                if Active.GetRT = 304 then
                    try
                        Active.Ok
                    catch
                    endcatch
                endif
            endif
            wait 500
            Kontext "Spellcheck"                       
            if Spellcheck.Exists then
                SpellcheckClose.Click
            endif
            wait 500
            Call wDokSchreiben "<Mod1 Home>"
            printlog "- find replaced word"
            
            EditSearchAndReplace
            Kontext "FindAndReplace"
            try
                SearchFor.Settext ""
            catch
            endcatch

            SearchFor.Settext ReplacedWith
            SearchNow.Click
            Kontext "Active"
            if Active.Exists then
                if Active.GetRT = 304 then
                    Warnlog "- Didn't found the replaced word !"
                    Active.Ok
                    Kontext "FindAndReplace"
                    FindAndReplace.Cancel
                    Call hCloseDocument
                    goto endsub
                endif
            endif
            Kontext "FindAndReplace"
            if FindAndReplace.Exists then FindAndReplace.Cancel
            wait 500
            FormatCharacter
            Kontext
            Active.Setpage TabFont
            Kontext "TabFont"
            try 
                if Language.GetSelText <> CurrentLanguage then
                    if Language.GetSelText = PriorLanguage then
                        Warnlog "Language Attributes has not been set to" & CurrentLanguage
                    else
                        Warnlog "Language Attributes has not been set to " & CurrentLanguage & " but " & Language.GetSelText                    
                    endif
                endif
            catch
                if LanguageWest.GetSelText <> CurrentLanguage then
                    if LanguageWest.GetSelText = PriorLanguage then
                        Warnlog "Language Attributes has not been set to" & CurrentLanguage
                    else
                        Warnlog "Language Attributes has not been set to " & CurrentLanguage & " but " & LanguageWest.GetSelText                    
                    endif
                endif
            endcatch
            TabFont.Cancel
        else
            Warnlog "No suggestions found!"
        endif
    else
        Warnlog "Spellcheck dialog is not up !"
    endif    
    '/// Close document ///
    Call hCloseDocument

endcase

' *******************************************************************

testcase tToolsSpellcheckButtonChange
    Dim InsFile as string, i as integer
    '/// Open specified document depending on language to check spellcheck ///
    '/// document has 1 defined wrong word ///
    PrintLog "- Tools / Spellchecking / Check button 'change'"
    InsFile = wGetSpellcheckDocumentName(2)
    Select Case InsFile
        Case "None"
            Printlog "- No Spellcheck for this language available!"
            goto endsub
        case "Empty"
            QAErrorLog "The language " + iSystemSprache +" has no defined Errortext. No test!"
            goto endsub
    end select
    
    if gApplication = "MASTERDOC" then
        if wInsertDocumentinMasterDoc(InsFile) = False then goto endsub
            EditPaste
    else
        Call hDateiOeffnen(InsFile)
    endif
    Call wDokSchreiben "<Mod1 Home>"

    '/// invoke the spellchecker
    ToolsSpellcheck
    '/// Check if button change if disabled if
    '/// 1. No suggestion has been given from spellchecker
    '/// 2. The button 'change' should be enabled if found mistake has been changed!"
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.Ok
                Warnlog "No mistake found in sample document -> Bug!"
            catch
            endcatch
        else
            Kontext "Spellcheck"
            if Spellcheck.Exists then
                for i = 1 to DictionaryLanguage.GetItemCount
                    DictionaryLanguage.Select i
                    if Suggestions.GetItemCount = 0 then
                        if Change.IsEnabled = true then
                            Warnlog "Button 'Change' is enabled though no sugggestion is given"
                        else
                            NotInDictionary.TypeKeys "Enable me"
                            wait 500
                            if Not Change.IsEnabled = true then
                                Warnlog "Button 'Change' is disabled though text has been changed"
                            endif
                         endif
                     endif
                next i    
            endif
        endif
    endif
    Kontext "Spellcheck"
    if Spellcheck.Exists then SpellcheckClose.Click
    '/// Close document
    Call hCloseDocument    

endcase

' *******************************************************************

testcase tToolsSpellcheckButtonChangeAll
    Dim InsFile as string, i as integer
    '/// Open specified document depending on language to check spellcheck ///
    '/// document has 1 defined wrong word ///
    PrintLog "- Tools / Spellchecking / Check button 'change all'"
    InsFile = wGetSpellcheckDocumentName(2)
    Select Case InsFile
        Case "None"
            Printlog "- No Spellcheck for this language available!"
            goto endsub
        case "Empty"
            QAErrorLog "The language " + iSystemSprache +" has no defined Errortext. No test!"
            goto endsub
    end select
    
    if gApplication = "MASTERDOC" then
        if wInsertDocumentinMasterDoc(InsFile) = False then goto endsub
            EditPaste
    else
        Call hDateiOeffnen(InsFile)
    endif
    Call wDokSchreiben "<Mod1 Home>"

    '/// invoke the spellchecker
    ToolsSpellcheck
    '/// Check if button 'change all' disabled if found mistake has been changed!"
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.Ok
                Warnlog "No mistake found in sample document -> Bug!"
            catch
            endcatch
        else
            Kontext "Spellcheck"
            if ChangeAll.IsEnabled then
                NotInDictionary.TypeKeys "Disable me"
                wait 500
                if ChangeAll.IsEnabled = true then
                    Warnlog "Button 'Change all' is disabled though text has been changed"
                endif
            else
                Warnlog "Button 'Change all' should be enabled"
            endif
            SpellcheckClose.Click
        endif
    endif
    '/// Close document
    Call hCloseDocument
    
endcase

' *******************************************************************

testcase tToolsSpellcheckButtonUndo
    Dim InsFile as string, Fehler$, i as integer
    printlog "Check functionality of undo-button in spellchecker"
    '/// new document
    Call hNewDocument
    '///  enter 1 word with a mistake and select it
    select case iSystemSprache
        case 01   : Fehler$ = "excetionally"      ' this word is wrong
        case 03   : Fehler$ = "semstre"           ' this word is wrong
        case 31   : Fehler$ = "lidstartesn"        ' this word is wrong
        case 33   : Fehler$ = "heues"            ' this word is wrong        
        case 34   : Fehler$ = "vacunaión"         ' this word is wrong
        case 36   : Fehler$ = "jelentos"
        case 39   : Fehler$ = "brasilianir"       ' this word is wrong
        case 45   : Fehler$ = "Amserdam"         ' this word is wrong
        case 46   : Fehler$ = "avrttades"         ' this word is wrong
        case 48   : Fehler$ = "stosowanei"         ' this word is wrong
        case 49   : Fehler$ = "georaphischen"     ' this word is wrong
        case 55   : Fehler$ = "Veigo"     ' this word is wrong
    end select

    Call wDokSchreiben ( Fehler$ )
    Call wDokSchreiben ( "<Shift Home>" )
    '/// invoke the spellchecker
    ToolsSpellcheck
    '/// Undo-Button should be disabled
    Kontext "Spellcheck"
    if Spellcheck.Exists then
        if SpellcheckUndo.IsEnabled then
            Warnlog "Undo button is initially enabled"
        else
            '/// change text in window    
            NotInDictionary.TypeKeys "<Home>"
            NotInDictionary.TypeKeys "Enable me"
            '///    Undo-Button should be enabled
            if Not SpellcheckUndo.IsEnabled then
                Warnlog "Undo-button isn't enabled though text has been edited"
            else
                '/// Undo changes in window    
                for i = 1 to 9
                    SpellcheckUndo.Click
                next i
                if SpellcheckUndo.IsEnabled = true then
                    Warnlog "Undo-Button is enabled though changes have been undone"
                endif
            endif
        endif
        '/// Close spellcheck dialog
        SpellcheckClose.Click
    else
        Warnlog "Spellcheck is not up!"
    endif
    
    '/// Close Document
    Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsSpellcheckButtonAutoCorrect
    Dim Fehler$ , i as integer, wSuggestion as string   

    printlog "Check if word will be added to AutoCorrect-list"
    '/// New document
    Call hNewDocument
    '/// Clear autocorrect-list
    ToolsAutocorrect
    Kontext
    Active.Setpage TabWortergaenzung
    Kontext "TabWortergaenzung"
    if GesammelteWorte.GetItemCount > 0 then
        for i= 1 to GesammelteWorte.GetItemCount
            GesammelteWorte.Select 1
            if EintragLoeschen.IsEnabled then
                EintragLoeschen.Click
            else
                i = GesammelteWorte.GetItemCount + 1
            endif
       next i
    endif
    TabWortergaenzung.Ok
    
    '///  enter 1 word with a mistake and select it
    select case iSystemSprache
        case 01   : Fehler$ = "excetionally"      ' this word is wrong
        case 03   : Fehler$ = "semstre"           ' this word is wrong
        case 31   : Fehler$ = "lidstartesn"        ' this word is wrong
        case 33   : Fehler$ = "heues"            ' this word is wrong
        case 34   : Fehler$ = "vacunaión"         ' this word is wrong
        case 36   : Fehler$ = "jelentos"
        case 39   : Fehler$ = "brasilianir"       ' this word is wrong
        case 45   : Fehler$ = "Amserdam"         ' this word is wrong
        case 46   : Fehler$ = "avrttades"         ' this word is wrong
        case 48   : Fehler$ = "stosowanei"         ' this word is wrong
        case 49   : Fehler$ = "georaphischen"     ' this word is wrong
        case 55   : Fehler$ = "Veigo"     ' this word is wrong
    end select

    Call wDokSchreiben ( Fehler$ )
    Call wDokSchreiben ( "<Shift Home>" )
    '/// invoke the spellchecker
    ToolsSpellcheck
    
    Kontext "Spellcheck"
    if Spellcheck.Exists then
        '/// Add word to autocorrection-list (click button)
        Suggestions.Select 1
        wSuggestion = Suggestions.GetSelText
        wait 500
        AutoCorrect.Click
        wait 500
        '/// Close spellchecker
        SpellcheckClose.Click
        '/// Check if word has been added to autocorrect list
        ToolsAutocorrect
        Kontext
        Active.Setpage TabWortergaenzung
        Kontext "TabWortergaenzung"
        try
            GesammelteWorte.Select 1
            if GesammelteWorte.GetSelText <> Fehler$ then
                Warnlog "Word has not been added to autocorrect-list"
            endif
        catch
            Warnlog "Word has not been added to autocorrect-list"
        endcatch
        TabWortergaenzung.Cancel
        
    else
        Warnlog "Spellchecker is not up"
    endif
    
    '/// Close Document
    Call hCloseDocument

endcase

' *******************************************************************

testcase tToolsThesaurus
    Dim DasWort$ : Dim sSprache$ : Dim Nachschlag$ : Dim sErsetzt$
    Dim i as integer
    PrintLog "- Tools / Thesaurus"

    select case iSystemSprache
        case 01 : DasWort$ = "Morning"
        case 03 : DasWort$ = "Confirmam"
        case 07 : Printlog "- No Thesaurus in Russian!"
                  goto endsub
        case 31 : DasWort$ = "Hulp"
        case 33 : DasWort$ = "Payer"
        case 34 : DasWort$ = "Suficiente"
        case 36 : Printlog "- No Thesaurus in Hungarian!"
                  goto endsub
        case 39 : DasWort$ = "Inserisci"
        case 45 : DasWort$ = "Først"
        case 46 : DasWort$ = "Vill"
        case 48 : Printlog "- No Thesaurus in Polish!"
                  goto endsub
        case 49 : DasWort$ = "Mann"
        case 55 : Printlog "- No Thesaurus in Portuguese (Brazil) !"
        		  goto endsub
        case 81 : Printlog "- No Thesaurus in Japanese!"
                  goto endsub
        case 82 : Printlog "- No Thesaurus in Korean!"
                  goto endsub
        case 86 : Printlog "- No Thesaurus in Chinese (simplified)!"
                  goto endsub
        case 88 : Printlog "- No Thesaurus in Chinese (traditional)!"
                  goto endsub
        case 30, 35, 36, 37, 42, 47, 48, 51, 90
                  Printlog "- No Thesaurus available !"
                  goto endsub                    
        case else : QAErrorlog "The language " +  iSystemSprache + " has no defined errortext. No Test!"
                    goto endsub
    end select

    Call hNewDocument
    '/// New writerdocument ///
    printlog "-  Thesaurus without a word"
    '/// Call Thesaurus without a written word ///
	ToolsLanguageThesaurus
    Kontext "Thesaurus"
    if Ersetzen.GetText <> "" then Warnlog "- Though no word has been selected there is a replacetext in the textfield!"
    printlog "-  enter one word and search"
    Ersetzen.SetText DasWort$
    Nachschlagen.Click
    Kontext "Active"
    if Active.Exists then
        Warnlog Active.Gettext
        Active.ok
    endif
    Kontext "Thesaurus"
    if Bedeutung.GetSelText(1) = "" then Warnlog "No meaning text"
    if Ersetzen.Gettext = "" then Ersetzen.SetText = DasWort$
    Nachschlag$ = Ersetzen.GetText
    Thesaurus.OK
    Call wDokSchreiben "<Home><Shift End>"
    wait 200
    EditCopy
    if iSystemSprache = 1 then
        if GetClipboardText <> Nachschlag$ then Warnlog "Wrong word has been replaced, not => " + DasWort$ + " but => " + GetClipboardText
    else
        if LCase (GetClipboardText) <> LCase (Nachschlag$) then Warnlog "Wrong word has been replaced, not => " + Nachschlag$ + " but => " + GetClipboardText
    end if
    Call hCloseDocument
    wait 500
    Call hNewDocument

    printlog "-  check the language"
    Call wDokSchreiben DasWort$ + "<Home>"
    '/// Check language in Thesaurus ///
    ToolsLanguageThesaurus
    Kontext "Thesaurus"

    Sprache.Click
    Kontext "SpracheAuswaehlen"
    select case iSystemSprache
        case 01 : sSprache$ = "English (USA)"
        case 03 : sSprache$ = "Português"
        case 31 : sSprache$ = "Nederlands (NL)"
        case 33 : sSprache$ = "Français (France)"
        case 34 : sSprache$ = "Español (España)"
        case 36 : sSprache$ = "Madyar"
        case 39 : sSprache$ = "Italiano (Italia)"
        case 45 : sSprache$ = "Dansk"
        case 46 : sSprache$ = "svenska (Sverige)"
        case 48 : sSprache$ = "Polski"
        case 49 : sSprache$ = "Deutsch (Deutschland)"
    end select
    'if Auswahl.GetSelText <> gLanguage then Warnlog "Selected language is " + Auswahl.GetSelText + " and not "+ sSprache$
    SpracheAuswaehlen.OK
    Sleep 5

    Kontext "Thesaurus"
    printlog "-  Search for a Synonym"
    '/// Search for a synonym ///
    Synonym.Select 1
    wait 500
    Nachschlag$ = Synonym.GetSelText
    if Ersetzen.GetText <> Nachschlag$ then Warnlog "Synonym has not been taken over"
    Nachschlagen.Click
	wait 500
	if Wort.GetSelText <> Nachschlag$ then Warnlog "Synonym has not been added to the word listand activated"
	
    printlog "-  Search for a meaning"
    '/// Search for a meaning ///
    wait 500
	Bedeutung.Select 1
    wait 500
	Nachschlagen.Click
    Sleep 1
    Kontext "Active"
    if Active.Exists then
        printlog "-   " + Active.Gettext
        Active.Ok
        Kontext "Thesaurus"
    else                                               ' Nur wenn Wort auch enthalten ist
        Kontext "Thesaurus"
        for i = 1 to 100
            if Bedeutung.GetSeltext <> "" then i = 101
            Sleep 1
        next i
        Nachschlag$ = Bedeutung.GetSelText
        if Ersetzen.GetText <> Nachschlag$ then Warnlog "Meaning has not been overtaken"
    endif

    printlog "-  Replace unchecked ( Cursor in front of words 1. character )"
    '/// replace unchecked ///
    sErsetzt$ = Ersetzen.GetText
    Thesaurus.OK
    Call wDokSchreiben "<Shift Home>"
    wait 200
    EditCopy
    if GetClipboardText <> sErsetzt$ then Warnlog "Text has not been correctly replaced, not => " + sErsetzt$ + " but => " + GetClipboardText

    Call wDokSchreiben "<End><Shift Home><Delete>" + DasWort$
    Call wDokSchreiben "<Home><Right><Right>"

    printlog "-  Replace unchecked ( Cursor in word )"
    ToolsLanguageThesaurus
    Kontext "Thesaurus"
    wait 500
    if Synonym.GetItemCount >0 then
        Synonym.Select 1
        sErsetzt$ = Ersetzen.GetText
        Thesaurus.OK
        Call wDokSchreiben "<Home><Shift End>"
        wait 200
        EditCopy
        if GetClipboardText <> sErsetzt$ then Warnlog "Text has not been correctly replaced, not => " + sErsetzt$ + " but => " + GetClipboardText
    else
        Warnlog "- No Synonym when cursor is in word!"
        Thesaurus.Ok
    endif

    Call wDokSchreiben "<End><Shift Home><Delete>"
    Call wDokSchreiben DasWort$ + "<End><Left>"

    printlog "-  Replace unchecked ( Cursor at words end )"
    ToolsLanguageThesaurus
    Kontext "Thesaurus"
    if Synonym.GetItemCount >0 then
        Synonym.Select 1
        sErsetzt$ = Ersetzen.GetText
        Thesaurus.OK
        Call wDokSchreiben "<Home><Shift End>"
        wait 200
        EditCopy
        if GetClipboardText <> sErsetzt$ then Warnlog "Text has not been correctly replaced, not => " + sErsetzt$ + " but => " + Trim$(GetClipboardText)
    else
        Warnlog "- No sysnonym when cursor pointed to words end!"
        Thesaurus.Ok
    endif

    Call wDokSchreiben "<End><Shift Home><Delete>"
    Call wDokSchreiben DasWort$ + "<End><Left><Shift Mod1 Left>"

    printlog "-  Replace checked ( back to front )"
    '/// replace checked ///
    ToolsLanguageThesaurus
    Kontext "Thesaurus"
    if Synonym.GetItemCount >0 then
        Synonym.Select 1
        sErsetzt$ = Ersetzen.GetText
        Thesaurus.Ok
        Call wDokSchreiben "<Home><Shift End><Shift Left>"
        wait 200
        EditCopy
        if GetClipboardText <> sErsetzt$ then Warnlog "Text has not been correctly replaced, not => " + sErsetzt$ + " but => " + GetClipboardText
    else
        Nachschlagen.Click
        Kontext "Active"
        if Active.Exists then
            Active.Ok
            Kontext "Thesaurus"
            Thesaurus.OK
        endif
    endif

    Call wDokSchreiben "<End><Shift Home><Delete>"
    Call wDokSchreiben DasWort$ + "<Home><Shift End>"
    printlog "-  Replace checked ( front to back )"
    ToolsLanguageThesaurus
    Kontext "Thesaurus"
    if Synonym.GetItemCount >0 then
        Synonym.Select 1
        sErsetzt$ = Ersetzen.GetText
        Thesaurus.Ok
        Call wDokSchreiben "<Home><Shift End>"
        wait 200
        EditCopy
        if GetClipboardText <> sErsetzt$ then Warnlog "Text has not been correctly replaced, not => " + sErsetzt$ + " but => " + GetClipboardText
    else
        Warnlog "- No sysnonym when word is marked!"
        Thesaurus.Ok
    endif

    Call wDokSchreiben "<End><Shift Home><Delete>"
    Call wDokSchreiben DasWort$ + "<Home><Right><Shift Right><Shift Right>"

    printlog "-  Part of Replace checked ( back to front )  - no checking anymore"
    ToolsLanguageThesaurus
    Kontext "Thesaurus"
    Thesaurus.OK
    '/// Close thesaurus and writerdocument ///
    Call hCloseDocument
endcase
