'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: calc_xml_7_export.bas,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:28:13 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Export test for the Calc XML 6.0/7/OOo 1.x format
'*
'\***********************************************************************************
Global gCalc7Filter as string
sub main
    Dim sUIFiltername as string
    Dim vExtension(10) as string
    Dim sCalc7FilterReference as string

       printlog "---------------------------------------------------------------------"
       printlog "-----     Export test for the Calc XML 6.0/7/OOo 1.x format     -----"
       printlog "---------------------------------------------------------------------"

   use "xml\level1\inc\sxc7_01.inc"
   use "xml\level1\inc\sxc7_02.inc"
   use "xml\level1\inc\sxc7_03.inc"

   call hStatusIn ("XML" , "calc_xml_7_export.bas")

       Dim Startes
       Startes = Now

       call CreateWorkXMLExportDir ( "user\work\xml\calc\level1\" )

       SetClipboard "This is the first doc"
       EditPaste

       'Get the StarOffice|StarSuite 6.0/7 and OpenOffice.org 1.x filter names
       sUIFiltername = hGetUIFiltername("StarOffice XML (Calc)")
       vExtension() = hGetFilternameExtension("calc_StarOffice_XML_Calc")
       gCalc7Filter = sUIFiltername & " (." & vExtension(0) & ")"
              
       sCalc7FilterReference = hGetFilter( "645" )
       if sCalc7FilterReference <> gCalc7Filter then
           warnlog "#i48165# - Corrupt filters in filterlist"     
           'warnlog "Reference file and real filter name in UI are not the same!"
           printlog "Reference file: " & sCalc7FilterReference
           printlog "UI Name in Office: " & gCalc7Filter
       end if
       
       'Be sure that pretty printing is DISABLED
       call hEnablePrettyPrinting(1)
       call sxc7_01
       call sxc7_02
       call sxc7_03

   call hStatusOut

       printlog "---------------------------------------------------------------------"
       printlog "End: " & Date & ", " & Time & ". (" & wielange(Startes) & ")"
       printlog "---------------------------------------------------------------------"
end sub


sub LoadIncludeFiles
   use "global\system\inc\master.inc"
   use "global\system\inc\gvariabl.inc"
   use "global\tools\inc\t_dir.inc"
   use "global\tools\inc\t_lists.inc"
   use "global\tools\inc\t_xml2.inc"
   use "xml\tools\xmltool1.inc"
   Call GetUseFiles
   gApplication   = "CALC"
end sub

'-------------------------------------------------------------------------
