'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: mperform.bas,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/08 08:33:29 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : XML Performance Test for one document
'*
'\************************************************************************************
Dim MeinDoc as string
Dim MeinFilter as string
sub main
       printlog "---------------------------------------------------------------------"
       printlog "-----                   XML Profiling Test                      -----"
       printlog "---------------------------------------------------------------------"

       MeinDoc = InputBox ( "Which document should be tested (incl. full qualified path!)?" , "Input needed" )
       MeinFilter = InputBox ( "Which filter file do you want to use?" , "Input needed" )           
       printlog "--------------------------- Initialisation --------------------------"
       call CreateWorkXMLExportDir ( "user\work\xml\profile" )
       printlog "------------------------------ Calc XML -----------------------------"
       call ttestdocument
       call tinitnormal
       call xCreateDocs      
end sub

'-------------------------------------------------------------------------

sub LoadIncludeFiles
   use "global\system\inc\master.inc"
   use "global\system\inc\gvariabl.inc"
   call GetUseFiles
   gApplication   = "WRITER"
end sub


'-------------------------------------------------------------------------

testcase ttestdocument
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("testdoc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (ConvertPath(MeinDoc))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
'/// It will be named testdoc1.
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\testdoc" & i & Right(MeinDoc, 3)))  
  printlog "Document should has been saved as 'testdoc" & i & "." & Right(MeinDoc, 3) & "' in user/work/xml/profile/..."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

sub CreateWorkXMLExportDir ( DirName as string )
'/*** <i>CreateWorkXMLExportDir</i> creates in the StarOffice/work-
'/*** +directory a directory. If the same name exists the content (files only)
'/*** +will be deleted.
 Dim OutputPath as string
 Dim Isliste(200) as string
 Dim i, BornToKill
 printlog "Checking work-dir & creating '" & gOfficePath & ConvertPath(DirName) & "'."
  if hDirectoryExists ( gOfficePath & ConvertPath(DirName) ) = TRUE then
    OutputPath = gOfficePath & ConvertPath(DirName)
    IsListe(0) = 0
    GetFileList ( OutputPath ,  "*", IsListe() )
    BornToKill = KillFileList ( IsListe() )
     for i = 1 to BornToKill
      warnlog IsListe(i) & " could not be deleted!"
     next i
   else
    app.mkDir( gOfficePath & ConvertPath(DirName))
  end if
end sub

'-------------------------------------------------------------------------

sub hExitAndRestart (xFileName as string)
'/// (Re)Starts the Office with parameters for the profiling
'/// support inside the Office.
'/// <u>Note</u>: Not all versions of StarOffice have this feature enabled!
'/// <b>The finals are defenetivly do not have this feature enabled!</b>   
  Dim sParameter as String
  Dim sPath as String
  Dim specialgOfficePath as string
   sleep (2)
   FileExit "SynchronMode", TRUE
   try
      Kontext "Messagebox"
       if Messagebox.GetRT = 304 then
        if Messagebox.Exists(2) then Messagebox.No
       end if
    catch
   endcatch
   sleep (40)
  if gPlatGroup = "w95" then
    specialgOfficePath = ReplaceCharacter( gOfficePath , "\" , "\\")
    sPath = specialgOfficePath + "user\\work\\xml\\profile\\results\\"
    mkdir ( gOfficePath + "user\work\xml\profile\results\" )
   else
    sPath = ConvertPath ( gOfficePath + "user\work\xml\profile\results\"  )
    mkdir ( sPath )
  end if
  sParameter = "-env:RTL_LOGFILE=" + sPath + xFileName
  Start sAppExe, sParameter
  printlog "hExitAndRestart [mperform.bas]: " & sParameter 
  sleep(3)
  SetClipboard "The first doc!"
  EditPaste
end sub

'-------------------------------------------------------------------------

testcase tinitnormal
'/// The office will be closed and started <u><b>without</b></u> profiling environment. ///
 call ExitRestartTheOffice
endcase

'-------------------------------------------------------------------------
 
testcase xCreateDocs
 Dim OfficeBuild as string
 Dim CommandlineString(1) as string
 Dim ShellExec as integer
 Dim i as integer
'/// With the Perl scripts from <a href="mailto:andre.fischer@germany">Andre Fischer</a> ///
'///+ the logfiles in <i>..user/work/xml/profile</i> directory a Calc ///
'///+ document will be created. ///
'/// The filter which is needed for the perl script came from the &acute;xmloff&acute; development team, resp. engineer <a href="mailto:daniel.vogelheim@germany">Daniel Vogelheim</a>. ///
'///+ and are located in <i>...testtool/input/profile/filter</i>. ///
'/// In this round the logs of the XML files will be analyzed.///
  printlog "Build: " & OfficeBuild
  '-------------------
  CommandlineString(1) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & MeinFilter & gOfficePath & "user\work\xml\profile\results\testdoc.nopid " & gOfficePath & "user\work\xml\profile\results\result_testdoc.sxc")
  '-------------------
 for i = 1 to 1
  printlog "Command (" & i & "): " & lcase(CommandlineString(i))
  if gPlatGroup = "unx" then
    ShellExec = Shell("perl " & CommandlineString(i) , 1 )
   else
    ShellExec = Shell("perl.exe " & CommandlineString(i) , 1)
  end if
  if ShellExec(i) = 0 then
    printlog "Succesfully executed."
   else
    warnlog "A mistake has been happened."
  end if
 next i
endcase

'-------------------------------------------------------------------------

