/*************************************************************************
 *
 *  $RCSfile: IndexAccessor.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.util;

import java.io.*;

public class IndexAccessor {
  private final String _dirName;
  
  public IndexAccessor(String dirName) {
    _dirName = dirName;
  }
  
  public IndexAccessor(IndexAccessor another) {
    _dirName = another._dirName;
  }

  public void createIfNeeded() throws Exception {
    File test = indexFile(".");
    if (test.exists() == false)
      test.mkdirs();
  }

  public void clear() throws IOException {
    File thisDir = indexFile(".");
    File[] components = thisDir.listFiles();
    if (components != null)
      for (int i = 0; i < components.length; i++)
	components[i].delete();
  }

  public File indexFile(String name) {
    return new File(_dirName, name);
  }

  public RandomAccessFile getRAF(String name, boolean update)
    throws IOException {
      //      System.out.println("IndexAccessor: getRAF " + name + " update " + update);
      return new RandomAccessFile(indexFile(name), update ? "rw" : "r");
  }
  
  public InputStream getInputStream(String name) throws IOException {
    return new BufferedInputStream(new FileInputStream(indexFile(name)));
  }

  public OutputStream getOutputStream(String name) throws IOException {
    return new BufferedOutputStream(new FileOutputStream(indexFile(name)));
  }

  public FileWriter makeFileWriter(String name) throws IOException {
    return new FileWriter(indexFile(name));
  }

  public byte[] readByteArray(String fileName) throws IOException {
    int i;
    final ByteArrayOutputStream data = new ByteArrayOutputStream();
    final byte[] buffer = new byte[1024*16];
    final InputStream in = getInputStream(fileName);
    while ((i = in.read(buffer)) != -1)
      data.write(buffer, 0, i);
    in.close();
    return data.toByteArray();
  }

  public LineInput getLineInput(String name) throws FileNotFoundException {
    return new LineInput(indexFile(name));
  }

  public void outputObject(String fileName, Object object) throws IOException {
    OutputStream fos = getOutputStream(fileName);
    ObjectOutputStream oos = new ObjectOutputStream(fos);
    oos.writeObject(object);
    oos.flush();
    fos.close();
  }
  
  public Object readObject(String fileName)
    throws IOException, ClassNotFoundException {
      ObjectInputStream ois = new ObjectInputStream(getInputStream(fileName));
      Object object = ois.readObject();
      ois.close();
      return object;
  }
}
