/*************************************************************************
 *
 *  $RCSfile: basobj.hxx,v $
 *
 *  $Revision: 1.21 $
 *
 *  last change: $Author: obo $ $Date: 2004/11/17 10:47:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _BASOBJ_HXX
#define _BASOBJ_HXX


#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAMPROVIDER_HXX_
#include <com/sun/star/io/XInputStreamProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_SCRIPT_XLIBRARYCONTAINER_HPP_
#include <com/sun/star/script/XLibraryContainer.hpp>
#endif

enum LibraryLocation { LIBRARY_LOCATION_UNKNOWN, LIBRARY_LOCATION_USER, LIBRARY_LOCATION_SHARE, LIBRARY_LOCATION_DOCUMENT };
enum LibraryType { LIBRARY_TYPE_UNKNOWN, LIBRARY_TYPE_MODULE, LIBRARY_TYPE_DIALOG, LIBRARY_TYPE_ALL };

class SfxMDIFrame;
class SfxMacro;
class SbMethod;
class SbModule;
class SbxObject;
class SbxVariable;
class StarBASIC;
class BasicManager;
class SfxObjectShell;
class SfxViewFrame;
class SfxUInt16Item;
class SfxBindings;
struct BasicIDE_Impl;

extern "C" {
	rtl_uString* basicide_choose_macro( BOOL bExecute, BOOL bChooseOnly, rtl_uString* pMacroDesc );
	void basicide_macro_organizer( INT16 nTabId );
}

extern "C" {
	long basicide_handle_basic_error( void* pPtr );
}


class BasicIDE
{
protected:
	static BOOL		    StringCompareLessThan( const String& rStr1, const String& rStr2 )
						    { return (rStr1.CompareIgnoreCaseToAscii( rStr2 ) == COMPARE_LESS); }
public:
						BasicIDE();
						~BasicIDE();

	static SfxMacro*	CreateMacro();
    static void			Organize( INT16 tabId );

	static USHORT		GetBasicDialogCount();
	static void			IncBasicDialogCount();
	static void			DecBasicDialogCount();


	// Hilfsmethoden fuer den allg. Gebrauch:
    static SbMethod*	FindMacro( SbModule* pModule, const String& rMacroName );
    static SbMethod*	CreateMacro( SbModule* pModule, const String& rMacroName );
	static void			RunMethod( SbMethod* pMethod );

	static StarBASIC*	FindBasic( const SbxVariable* pVar );
	static void			StopBasic();
    static long         HandleBasicError( StarBASIC* pBasic );
	static void			BasicStopped( BOOL* pbAppWindowDisabled = 0, BOOL* pbDispatcherLocked = 0, USHORT* pnWaitCount = 0,
							SfxUInt16Item** ppSWActionCount = 0, SfxUInt16Item** ppSWLockViewCount = 0 );

	static BOOL			IsValidSbxName( const String& rName );

    static BasicManager* 		FindBasicManager( StarBASIC* pLib );
    static String               GetTitle( SfxObjectShell* pShell, LibraryLocation eLocation, USHORT nSFXTitleType = 0, LibraryType eType = LIBRARY_TYPE_ALL );
    static SfxObjectShell* 		FindDocShell( BasicManager* pBasMgr );

	static SfxBindings& 		GetBindings();
    static SfxBindings* 		GetBindingsPtr();

	static void			InvalidateDebuggerSlots();

    // libraries

	static ::com::sun::star::uno::Sequence< ::rtl::OUString > GetLibraryNames( SfxObjectShell* pShell );

    static ::com::sun::star::uno::Sequence< ::rtl::OUString > GetMergedLibraryNames(
        const ::com::sun::star::uno::Reference< ::com::sun::star::script::XLibraryContainer >& xModLibContainer,
        const ::com::sun::star::uno::Reference< ::com::sun::star::script::XLibraryContainer >& xDlgLibContainer );

	// new methods for modules

	static BOOL                 HasShell( SfxObjectShell* pShell );

	static ::com::sun::star::uno::Reference< ::com::sun::star::script::XLibraryContainer > GetModuleLibraryContainer(
		SfxObjectShell* pShell );

	static BOOL                 HasModuleLibrary(
		SfxObjectShell* pShell, const String& rLibName );

	static ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameContainer > GetModuleLibrary(
		SfxObjectShell* pShell, const String& rLibName, BOOL bLoadLibrary = FALSE )
		throw( ::com::sun::star::container::NoSuchElementException );

	static ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameContainer > CreateModuleLibrary(
		SfxObjectShell* pShell, const String& rLibName )
		throw( ::com::sun::star::container::ElementExistException );

	static ::com::sun::star::uno::Sequence< ::rtl::OUString > GetModuleNames(
        SfxObjectShell* pShell, const String& rLibName )
		throw( ::com::sun::star::container::NoSuchElementException );

	static BOOL					HasModule(
		SfxObjectShell* pShell, const String& rLibName, const String& rModName );

	static ::rtl::OUString		GetModule(
		SfxObjectShell* pShell, const String& rLibName, const String& rModName )
		throw( ::com::sun::star::container::NoSuchElementException );

	static String				CreateModuleName( SfxObjectShell* pShell, const String& rLibName );

	static ::rtl::OUString		CreateModule(
		SfxObjectShell* pShell, const String& rLibName, const String& rModName, BOOL bCreateMain = FALSE )
		throw( ::com::sun::star::container::ElementExistException, ::com::sun::star::container::NoSuchElementException );

	static void					RenameModule(
		SfxObjectShell* pShell, const String& rLibName, const String& rOldName, const String& rNewName )
		throw( ::com::sun::star::container::ElementExistException, ::com::sun::star::container::NoSuchElementException );

	static void					RemoveModule( 
		SfxObjectShell* pShell, const String& rLibName, const String& rModName )
		throw( ::com::sun::star::container::NoSuchElementException );

	static void					InsertModule( 
		SfxObjectShell* pShell, const String& rLibName, const String& rModName, ::rtl::OUString& aModule )
		throw( ::com::sun::star::container::ElementExistException, ::com::sun::star::container::NoSuchElementException );

	static void					UpdateModule( 
		SfxObjectShell* pShell, const String& rLibName, const String& rModName, ::rtl::OUString& aModule )
		throw( ::com::sun::star::container::NoSuchElementException );

	// new methods for macros

    static ::rtl::OUString		ChooseMacro( BOOL bExecute = TRUE, BOOL bChooseOnly = FALSE, const ::rtl::OUString& rMacroDesc = ::rtl::OUString() );

	static ::com::sun::star::uno::Sequence< ::rtl::OUString > GetMethodNames(
		SfxObjectShell* pShell, const String& rLibName, const String& rModName )
		throw( ::com::sun::star::container::NoSuchElementException );

	static BOOL					HasMethod(
		SfxObjectShell* pShell, const String& rLibName, const String& rModName, const String& rMethName );

	// new methods for dialogs

	static ::com::sun::star::uno::Reference< ::com::sun::star::script::XLibraryContainer > GetDialogLibraryContainer( 
		SfxObjectShell* pShell );

	static BOOL                 HasDialogLibrary( 
		SfxObjectShell* pShell, const String& rLibName );

	static ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameContainer > GetDialogLibrary( 
		SfxObjectShell* pShell, const String& rLibName, BOOL bLoadLibrary = FALSE )
		throw( ::com::sun::star::container::NoSuchElementException );

	static ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameContainer > CreateDialogLibrary( 
		SfxObjectShell* pShell, const String& rLibName )
		throw( ::com::sun::star::container::ElementExistException );

	static ::com::sun::star::uno::Sequence< ::rtl::OUString > GetDialogNames( 
        SfxObjectShell* pShell, const String& rLibName )
		throw( ::com::sun::star::container::NoSuchElementException );

	static BOOL					HasDialog(
		SfxObjectShell* pShell, const String& rLibName, const String& rDlgName );

	static ::com::sun::star::uno::Reference< ::com::sun::star::io::XInputStreamProvider > GetDialog(
		SfxObjectShell* pShell, const String& rLibName, const String& rDlgName )
		throw( ::com::sun::star::container::NoSuchElementException );

	static String				CreateDialogName( SfxObjectShell* pShell, const String& rLibName );

	static ::com::sun::star::uno::Reference< ::com::sun::star::io::XInputStreamProvider > CreateDialog( 
		SfxObjectShell* pShell, const String& rLibName, const String& rDlgName )
		throw( ::com::sun::star::container::ElementExistException, ::com::sun::star::container::NoSuchElementException );

	static void					RenameDialog( 
		SfxObjectShell* pShell, const String& rLibName, const String& rOldName, const String& rNewName )
		throw( ::com::sun::star::container::ElementExistException, ::com::sun::star::container::NoSuchElementException );

	static void					RemoveDialog( 
		SfxObjectShell* pShell, const String& rLibName, const String& rDlgName )
		throw( ::com::sun::star::container::NoSuchElementException );

	static void					InsertDialog( 
		SfxObjectShell* pShell, const String& rLibName, const String& rDlgName,
		const com::sun::star::uno::Reference< com::sun::star::io::XInputStreamProvider >& xISP )
		throw( ::com::sun::star::container::ElementExistException, ::com::sun::star::container::NoSuchElementException );

	static void 				MarkDocShellModified( SfxObjectShell* pShell );

    static bool                 IsLibraryShared( SfxObjectShell* pShell, const String& rLibName, LibraryType eType );

    static LibraryLocation      GetLibraryLocation( SfxObjectShell* pShell, const String& rLibName );
};

#endif	// _BASOBJ_HXX
