/*************************************************************************
 *
 *  $RCSfile: bridge.h,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2003/10/06 13:14:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _BRIDGES_CPP_UNO_BRIDGE_H_
#define _BRIDGES_CPP_UNO_BRIDGE_H_

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _OSL_INTERLOCK_H_
#include <osl/interlck.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _RTL_UNLOAD_H_
#include <rtl/unload.h>
#endif

#ifndef _UNO_MAPPING_H_
#include <uno/mapping.h>
#endif
#ifndef _UNO_ENVIRONMENT_H_
#include <uno/environment.h>
#endif
#ifndef _UNO_DISPATCHER_H_
#include <uno/dispatcher.h>
#endif
#ifndef _TYPELIB_TYPEDESCRIPTION_H_
#include <typelib/typedescription.h>
#endif

#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HDL_
#include <com/sun/star/uno/XInterface.hdl>
#endif


namespace CPPU_CURRENT_NAMESPACE
{

extern rtl_StandardModuleCount g_moduleCount;

// these have to be defined in some C file in the current compiler_named namespace
void SAL_CALL cppu_cppInterfaceProxy_patchVtable(
	::com::sun::star::uno::XInterface * pCppI, typelib_InterfaceTypeDescription * pTypeDescr )
	throw ();

void SAL_CALL cppu_unoInterfaceProxy_dispatch(
	uno_Interface * pUnoI, const typelib_TypeDescription * pMemberDescr,
	void * pReturn, void * pArgs[], uno_Any ** ppException )
	throw ();

//==================================================================================================
struct cppu_Bridge;
struct cppu_Mapping : public uno_Mapping
{
	cppu_Bridge * pBridge;
};
//==== holding environments and mappings ===========================================================
struct cppu_Bridge
{
	oslInterlockedCount			nRef;
	
	uno_ExtEnvironment *		pCppEnv;
	uno_ExtEnvironment *		pUnoEnv;
	
	cppu_Mapping				aCpp2Uno;
	cppu_Mapping				aUno2Cpp;
	
	sal_Bool					bExportCpp2Uno;
	
	inline void SAL_CALL acquire() SAL_THROW( () );
	inline void SAL_CALL release() SAL_THROW( () );
	
	inline cppu_Bridge(
		uno_ExtEnvironment * pCppEnv_, uno_ExtEnvironment * pUnoEnv_,
		sal_Bool bExportcpp2Uno_ ) SAL_THROW( () );
	inline ~cppu_Bridge() SAL_THROW( () );
};

//==== a cpp proxy wrapping an uno interface =======================================================
struct cppu_cppInterfaceProxy : public ::com::sun::star::uno::XInterface
{
	oslInterlockedCount					nRef;
	cppu_Bridge *						pBridge;
	
	// mapping information
	uno_Interface *						pUnoI; // wrapped interface
	typelib_InterfaceTypeDescription *	pTypeDescr;
	::rtl::OUString						oid;
	
	// non virtual methods called on incoming vtable calls #1, #2
	inline void SAL_CALL acquireProxy() SAL_THROW( () );
	inline void SAL_CALL releaseProxy() SAL_THROW( () );
	
	// XInterface: these are only here for dummy, there will be a patched vtable!
	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type & )
		throw (::com::sun::star::uno::RuntimeException) { return ::com::sun::star::uno::Any(); } // dont use this, use cppu_queryInterface()!
	virtual void SAL_CALL acquire() throw () {} // dont use this, use cppu_acquire()!
	virtual void SAL_CALL release() throw () {} // dont use this, use cppu_release()!
	
	// ctor
	inline cppu_cppInterfaceProxy(
		cppu_Bridge * pBridge_,
		uno_Interface * pUnoI_,
		typelib_InterfaceTypeDescription * pTypeDescr_,
		const ::rtl::OUString & rOId_ ) SAL_THROW( () );
};

//==== a uno proxy wrapping a cpp interface ========================================================
struct cppu_unoInterfaceProxy : public uno_Interface
{
	oslInterlockedCount					nRef;
	cppu_Bridge *						pBridge;
	
	// mapping information
	::com::sun::star::uno::XInterface *	pCppI; // wrapped interface
	typelib_InterfaceTypeDescription *	pTypeDescr;
	::rtl::OUString						oid;
	
	// ctor
	inline cppu_unoInterfaceProxy(
		cppu_Bridge * pBridge_,
		::com::sun::star::uno::XInterface * pCppI_,
		typelib_InterfaceTypeDescription * pTypeDescr_,
		const ::rtl::OUString & rOId_ ) SAL_THROW( () );
};

//--------------------------------------------------------------------------------------------------
inline void SAL_CALL cppu_cppenv_initEnvironment(
	uno_Environment * pCppEnv ) SAL_THROW( () );

//--------------------------------------------------------------------------------------------------
inline void SAL_CALL cppu_ext_getMapping(
	uno_Mapping ** ppMapping, uno_Environment * pFrom, uno_Environment * pTo ) SAL_THROW( () );

}

#endif
