/*************************************************************************
 *
 *  $RCSfile: cli_base.h,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2003/09/04 10:48:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#if ! defined INCLUDED_CLI_BASE_H
#define INCLUDED_CLI_BASE_H

#pragma unmanaged
// Workaround: osl/mutex.h contains only a forward declaration of _oslMutexImpls.
// When using the inline class in Mutex in osl/mutex.hxx, the loader needs to find
// a declaration for the struct. If not found a TypeLoadException is being thrown.
struct _oslMutexImpl
{
};
#pragma managed
#include <memory>
#include "rtl/ustring.hxx"
#include "typelib/typedescription.hxx"

#using <mscorlib.dll>
#using <system.dll>

#define OUSTR(x) ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(x) )

namespace cli_uno
{
System::Type* loadCliType(System::String * typeName);
System::Type* mapUnoType(typelib_TypeDescription const * pTD);
System::Type* mapUnoType(typelib_TypeDescriptionReference const * pTD);
typelib_TypeDescriptionReference* mapCliType(System::Type* cliType);
rtl::OUString mapCliString(System::String const * data);
System::String* mapUnoString(rtl_uString const * data);
System::String* mapUnoTypeName(rtl_uString const * typeName);

__gc struct Constants
{
    static const System::String* sXInterfaceName= new System::String(
        S"unoidl.com.sun.star.uno.XInterface");
    static const System::String* sObject= new System::String(S"System.Object");
    static const System::String* sType= new System::String(S"System.Type");
    static const System::String* sUnoidl= new System::String(S"unoidl.");
    static const System::String* sVoid= new System::String(S"System.Void");
    static const System::String* sAny= new System::String(S"uno.Any");
    static const System::String* sArArray= new System::String(S"System.Array[]");
    static const System::String* sBoolean= new System::String(S"System.Boolean");
    static const System::String* sChar= new System::String(S"System.Char");
    static const System::String* sByte= new System::String(S"System.Byte");
    static const System::String* sInt16= new System::String(S"System.Int16");
    static const System::String* sUInt16= new System::String(S"System.UInt16");
    static const System::String* sInt32= new System::String(S"System.Int32");
    static const System::String* sUInt32= new System::String(S"System.UInt32");
    static const System::String* sInt64= new System::String(S"System.Int64");
    static const System::String* sUInt64= new System::String(S"System.UInt64");
    static const System::String* sString= new System::String(S"System.String");
    static const System::String* sSingle= new System::String(S"System.Single");
    static const System::String* sDouble= new System::String(S"System.Double");
    static const System::String* sArBoolean= new System::String(S"System.Boolean[]");
    static const System::String* sArChar= new System::String(S"System.Char[]");
    static const System::String* sArByte= new System::String(S"System.Byte[]");
    static const System::String* sArInt16= new System::String(S"System.Int16[]");
    static const System::String* sArUInt16= new System::String(S"System.UInt16[]");
    static const System::String* sArInt32= new System::String(S"System.Int32[]");
    static const System::String* sArUInt32= new System::String(S"System.UInt32[]");
    static const System::String* sArInt64= new System::String(S"System.Int64[]");
    static const System::String* sArUInt64= new System::String(S"System.UInt64[]");
    static const System::String* sArString= new System::String(S"System.String[]");
    static const System::String* sArSingle= new System::String(S"System.Single[]");
    static const System::String* sArDouble= new System::String(S"System.Double[]");
    static const System::String* sArType= new System::String(S"System.Type[]");
    static const System::String* sArObject= new System::String(S"System.Object[]");
    static const System::String* sBrackets= new System::String(S"[]");
    static const System::String* sAttributeSet= new System::String(S"set_");
    static const System::String* sAttributeGet= new System::String(S"get_");
};

#pragma unmanaged
// Other String constants:
static rtl::OUString usXInterface(RTL_CONSTASCII_USTRINGPARAM(
                                               "com.sun.star.uno.XInterface"));
static const rtl::OUString usVoid(RTL_CONSTASCII_USTRINGPARAM("void"));
static const rtl::OUString usType(RTL_CONSTASCII_USTRINGPARAM("type"));
static const rtl::OUString usAny(RTL_CONSTASCII_USTRINGPARAM("any"));
static const rtl::OUString usBrackets(RTL_CONSTASCII_USTRINGPARAM("[]"));
static const rtl::OUString usBool(RTL_CONSTASCII_USTRINGPARAM("boolean"));
static const rtl::OUString usByte(RTL_CONSTASCII_USTRINGPARAM("byte"));
static const rtl::OUString usChar(RTL_CONSTASCII_USTRINGPARAM("char"));
static const rtl::OUString usShort(RTL_CONSTASCII_USTRINGPARAM("short"));
static const rtl::OUString usUShort(RTL_CONSTASCII_USTRINGPARAM("unsigned short"));
static const rtl::OUString usLong(RTL_CONSTASCII_USTRINGPARAM("long"));
static const rtl::OUString usULong(RTL_CONSTASCII_USTRINGPARAM("unsigned long"));
static const rtl::OUString usHyper(RTL_CONSTASCII_USTRINGPARAM("hyper"));
static const rtl::OUString usUHyper(RTL_CONSTASCII_USTRINGPARAM("unsigned hyper"));
static const rtl::OUString usString(RTL_CONSTASCII_USTRINGPARAM("string"));
static const rtl::OUString usFloat(RTL_CONSTASCII_USTRINGPARAM("float"));
static const rtl::OUString usDouble(RTL_CONSTASCII_USTRINGPARAM("double"));
static const rtl::OUString usUnoException(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.uno.Exception"));
static const rtl::OUString usMessageMember(RTL_CONSTASCII_USTRINGPARAM("Message"));
#pragma managed
                                      
struct BridgeRuntimeError
{
    ::rtl::OUString m_message;
    
    inline BridgeRuntimeError( ::rtl::OUString const & message )
        : m_message( message )
        {}
};

//==================================================================================================
struct rtl_mem
{
	inline static void * operator new ( size_t nSize )
		{ return rtl_allocateMemory( nSize ); }
	inline static void operator delete ( void * mem )
		{ if (mem) rtl_freeMemory( mem ); }
	inline static void * operator new ( size_t, void * mem )
		{ return mem; }
	inline static void operator delete ( void *, void * )
		{}
    
    static inline ::std::auto_ptr< rtl_mem > allocate( ::std::size_t bytes );
};
//--------------------------------------------------------------------------------------------------
inline ::std::auto_ptr< rtl_mem > rtl_mem::allocate( ::std::size_t bytes )
{
    void * p = rtl_allocateMemory( bytes );
    if (0 == p)
        throw BridgeRuntimeError(OUSTR("out of memory!") );
    return ::std::auto_ptr< rtl_mem >( (rtl_mem *)p );
}

//==================================================================================================
class TypeDescr
{
    typelib_TypeDescription * m_td;
    
    TypeDescr( TypeDescr & ); // not impl
    void operator = ( TypeDescr ); // not impl
    
public:
    inline explicit TypeDescr( typelib_TypeDescriptionReference * td_ref );
    inline ~TypeDescr() SAL_THROW( () )
        { TYPELIB_DANGER_RELEASE( m_td ); }
    
    inline typelib_TypeDescription * get() const
        { return m_td; }
};

inline TypeDescr::TypeDescr( typelib_TypeDescriptionReference * td_ref )
    : m_td( 0 )
{
    TYPELIB_DANGER_GET( &m_td, td_ref );
    if (0 == m_td)
    {
        throw BridgeRuntimeError(
            OUSTR("cannot get comprehensive type description for ") +
            *reinterpret_cast< ::rtl::OUString const * >( &td_ref->pTypeName ) );
    }
}


} //end namespace cli_uno
 #endif
