/*************************************************************************
 *
 *  $RCSfile: bitmapcanvasbase.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 17:01:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_CANVAS_BITMAPCANVASBASE_HXX
#define INCLUDED_CANVAS_BITMAPCANVASBASE_HXX

#ifndef _DRAFTS_COM_SUN_STAR_RENDERING_XINTEGERBITMAP_HPP_
#include <drafts/com/sun/star/rendering/XIntegerBitmap.hpp>
#endif

#ifndef INCLUDED_CANVAS_CANVASBASE_HXX
#include <canvas/canvasbase.hxx>
#endif


namespace canvas { namespace internal
{
    /** Helper template to handle XBitmapCanvas method forwarding to
        BitmapCanvasHelper

    	Use this helper to handle the XBitmapCanvas part of your
    	implementation.

        @tpl Base
        Base class to use, most probably one of the
        WeakComponentImplHelperN templates with the appropriate
        interfaces. At least XBitmapCanvas should be among them (why
        else would you use this template, then?). Base class must have
        an Base( const Mutex& ) constructor (like the
        WeakComponentImplHelperN templates have).

        @tpl CanvasHelper
        Canvas helper implementation for the backend in question

        @tpl Mutex
        Lock strategy to use. Defaults to using the
        OBaseMutex-provided lock.  Everytime one of the methods is
        entered, an object of type Mutex is created with m_aMutex as
        the sole parameter, and destroyed again when the method scope
        is left.

     */
    template< class Base, class CanvasHelper, class Mutex=::osl::MutexGuard > class BitmapCanvasBase : 
        public CanvasBase< Base, CanvasHelper, Mutex >
    {
    public:
        typedef CanvasBase< Base, CanvasHelper, Mutex >	BaseType;

        /** Create BitmapCanvasBase
         */
        BitmapCanvasBase()
        {
        }

        // XBitmapCanvas
        virtual void SAL_CALL copyRect( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XBitmapCanvas >& 	sourceCanvas, 
                                        const ::drafts::com::sun::star::geometry::RealRectangle2D& 										sourceRect, 
                                        const ::drafts::com::sun::star::rendering::ViewState& 											sourceViewState, 
                                        const ::drafts::com::sun::star::rendering::RenderState& 										sourceRenderState, 
                                        const ::drafts::com::sun::star::geometry::RealRectangle2D& 										destRect, 
                                        const ::drafts::com::sun::star::rendering::ViewState& 											destViewState, 
                                        const ::drafts::com::sun::star::rendering::RenderState& 										destRenderState ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            typename BaseType::MutexType aGuard( BaseType::m_aMutex );
            
            BaseType::mbSurfaceDirty = true;

            BaseType::maCanvasHelper.copyRect( sourceCanvas, 
                                               sourceRect, 
                                               sourceViewState, 
                                               sourceRenderState, 
                                               destRect, 
                                               destViewState, 
                                               destRenderState );
        }

        // XBitmap
        virtual ::drafts::com::sun::star::geometry::IntegerSize2D SAL_CALL getSize(  ) throw (::com::sun::star::uno::RuntimeException)
        {
            typename BaseType::MutexType aGuard( BaseType::m_aMutex );

            return BaseType::maCanvasHelper.getSize();            
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XBitmapCanvas > SAL_CALL queryBitmapCanvas(  ) throw (::com::sun::star::uno::RuntimeException)
        {
            return this;            
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XBitmap > SAL_CALL getScaledBitmap( const ::drafts::com::sun::star::geometry::RealSize2D& newSize, sal_Bool beFast ) throw (::com::sun::star::uno::RuntimeException)
        {
            typename BaseType::MutexType aGuard( BaseType::m_aMutex );

            return BaseType::maCanvasHelper.getScaledBitmap( newSize, beFast );
        }

        // XIntegerBitmap
        virtual ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL getData( const ::drafts::com::sun::star::geometry::IntegerRectangle2D& rect ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::drafts::com::sun::star::rendering::VolatileContentDestroyedException, ::com::sun::star::uno::RuntimeException)
        {
            typename BaseType::MutexType aGuard( BaseType::m_aMutex );

            return BaseType::maCanvasHelper.getData( rect );
        }

        virtual void SAL_CALL setData( const ::com::sun::star::uno::Sequence< sal_Int8 >& data, const ::drafts::com::sun::star::rendering::IntegerBitmapLayout& bitmapLayout, const ::drafts::com::sun::star::geometry::IntegerRectangle2D& rect ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
        {
            typename BaseType::MutexType aGuard( BaseType::m_aMutex );

            BaseType::mbSurfaceDirty = true;

            BaseType::maCanvasHelper.setData( data, rect );
        }

        virtual void SAL_CALL setPixel( const ::com::sun::star::uno::Sequence< sal_Int8 >& color, const ::drafts::com::sun::star::rendering::IntegerBitmapLayout& bitmapLayout, const ::drafts::com::sun::star::geometry::IntegerPoint2D& pos ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
        {
            typename BaseType::MutexType aGuard( BaseType::m_aMutex );

            BaseType::mbSurfaceDirty = true;

            BaseType::maCanvasHelper.setPixel( color, pos );
        }

        virtual ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL getPixel( const ::drafts::com::sun::star::geometry::IntegerPoint2D& pos ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::drafts::com::sun::star::rendering::VolatileContentDestroyedException, ::com::sun::star::uno::RuntimeException)
        {
            typename BaseType::MutexType aGuard( BaseType::m_aMutex );

            return BaseType::maCanvasHelper.getPixel( pos );
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XBitmapPalette > SAL_CALL getPalette(  ) throw (::com::sun::star::uno::RuntimeException)
        {
            typename BaseType::MutexType aGuard( BaseType::m_aMutex );

            return BaseType::maCanvasHelper.getPalette();
        }

        virtual ::drafts::com::sun::star::rendering::IntegerBitmapLayout SAL_CALL getMemoryLayout(  ) throw (::com::sun::star::uno::RuntimeException)
        {
            typename BaseType::MutexType aGuard( BaseType::m_aMutex );

            return BaseType::maCanvasHelper.getMemoryLayout();
        }

    protected:
        ~BitmapCanvasBase() {} // we're a ref-counted UNO class. _We_ destroy ourselves.

    private:
        // default: disabled copy/assignment
        BitmapCanvasBase(const BitmapCanvasBase&);
        BitmapCanvasBase& operator=( const BitmapCanvasBase& );
    };
} }

#endif /* INCLUDED_CANVAS_BITMAPCANVASBASE_HXX */
