/*************************************************************************
 *
 *  $RCSfile: dx_impltools.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 17:21:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <canvas/debug.hxx>
#include <canvas/verbosetrace.hxx>

#ifndef _DRAFTS_COM_SUN_STAR_GEOMETRY_REALPOINT2D_HPP_
#include <drafts/com/sun/star/geometry/RealPoint2D.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _DRAFTS_COM_SUN_STAR_GEOMETRY_INTEGERRECTANGLE2D_HPP__
#include <drafts/com/sun/star/geometry/IntegerRectangle2D.hpp>
#endif

#ifndef _BGFX_MATRIX_B2DHOMMATRIX_HXX
#include <basegfx/matrix/b2dhommatrix.hxx>
#endif
#ifndef _BGFX_RANGE_B2IRECTANGLE_HXX
#include <basegfx/range/b2irectangle.hxx>
#endif
#ifndef _BGFX_NUMERIC_FTOOLS_HXX
#include <basegfx/numeric/ftools.hxx>
#endif
#ifndef _BGFX_POLYGON_B2DPOLYPOLYGON_HXX
#include <basegfx/polygon/b2dpolypolygon.hxx>
#endif

#include <canvas/canvastools.hxx>

#include <dx_impltools.hxx>
#include <dx_linepolypolygon.hxx>
#include <dx_canvasbitmap.hxx>
#include <dx_canvasfont.hxx>

#include <vector>
#include <algorithm>


using namespace ::com::sun::star;
using namespace ::drafts::com::sun::star;


namespace dxcanvas
{
    namespace tools
    {
        ::basegfx::B2DPolyPolygon polyPolygonFromXPolyPolygon2D( const uno::Reference< rendering::XPolyPolygon2D >& xPoly )
        {    
            uno::Reference< lang::XServiceInfo > xRef( xPoly, 
                                                       uno::UNO_QUERY );

            if( xRef.is() && 
                xRef->getImplementationName().equals( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(LINEPOLYPOLYGON_IMPLEMENTATION_NAME))) )
            {
                // TODO(Q1): Maybe use dynamic_cast here
                
                // TODO(F1): Provide true beziers here!
                return static_cast<LinePolyPolygon*>(xPoly.get())->getPolyPolygon();
            }
            else
            {
                // TODO(F1): extract points from polygon interface
                ENSURE_AND_THROW( false, 
                                  "polyPolygonFromXPolyPolygon2D(): could not extract points" );
            }
 
            return ::basegfx::B2DPolyPolygon();
        }

        void setupGraphics( Gdiplus::Graphics& rGraphics )
        {
            // setup graphics with (somewhat arbitrary) defaults
            //rGraphics.SetCompositingQuality( Gdiplus::CompositingQualityHighQuality );
            rGraphics.SetCompositingQuality( Gdiplus::CompositingQualityHighSpeed );
            //rGraphics.SetInterpolationMode( Gdiplus::InterpolationModeHighQualityBilinear ); // with prefiltering for shrinks
            rGraphics.SetInterpolationMode( Gdiplus::InterpolationModeBilinear );
            rGraphics.SetPixelOffsetMode( Gdiplus::PixelOffsetModeHalf ); // Pixel center at (0.5, 0.5) etc.
            //rGraphics.SetPixelOffsetMode( Gdiplus::PixelOffsetModeNone );
            //rGraphics.SetSmoothingMode( Gdiplus::SmoothingModeHighSpeed ); // no line/curve antialiasing
            //rGraphics.SetSmoothingMode( Gdiplus::SmoothingModeHighQuality );
            rGraphics.SetSmoothingMode( Gdiplus::SmoothingModeAntiAlias );
            //rGraphics.SetTextRenderingHint( Gdiplus::TextRenderingHintAntiAlias );
            rGraphics.SetTextRenderingHint( Gdiplus::TextRenderingHintSystemDefault );
        }

        void gdiPlusMatrixFromB2DHomMatrix( Gdiplus::Matrix& rGdiplusMatrix, const ::basegfx::B2DHomMatrix& rMatrix )
        {
            rGdiplusMatrix.SetElements( static_cast<Gdiplus::REAL>(rMatrix.get(0,0)),
                                        static_cast<Gdiplus::REAL>(rMatrix.get(1,0)),
                                        static_cast<Gdiplus::REAL>(rMatrix.get(0,1)),
                                        static_cast<Gdiplus::REAL>(rMatrix.get(1,1)),
                                        static_cast<Gdiplus::REAL>(rMatrix.get(0,2)),
                                        static_cast<Gdiplus::REAL>(rMatrix.get(1,2)) );
        }

        void gdiPlusMatrixFromAffineMatrix2D( Gdiplus::Matrix& 					rGdiplusMatrix, 
                                              const geometry::AffineMatrix2D&	rMatrix )
        {
            rGdiplusMatrix.SetElements( static_cast<Gdiplus::REAL>(rMatrix.m00),
                                        static_cast<Gdiplus::REAL>(rMatrix.m10),
                                        static_cast<Gdiplus::REAL>(rMatrix.m01),
                                        static_cast<Gdiplus::REAL>(rMatrix.m11),
                                        static_cast<Gdiplus::REAL>(rMatrix.m02),
                                        static_cast<Gdiplus::REAL>(rMatrix.m12) );
        }

        namespace
        {
            // TODO(P2): Check whether this gets inlined. If not, make functor
            // out of it
            inline Gdiplus::PointF implGdiPlusPointFromRealPoint2D( const ::drafts::com::sun::star::geometry::RealPoint2D& rPoint )
            {
                return Gdiplus::PointF( static_cast<Gdiplus::REAL>(rPoint.X), 
                                        static_cast<Gdiplus::REAL>(rPoint.Y) );
            }
        }

        Gdiplus::PointF gdiPlusPointFromRealPoint2D( const ::drafts::com::sun::star::geometry::RealPoint2D& rPoint )
        {
            return implGdiPlusPointFromRealPoint2D( rPoint );
        }

        Gdiplus::Rect gdiPlusRectFromIntegerRectangle2D( const geometry::IntegerRectangle2D& rRect )
        {
            return Gdiplus::Rect( rRect.X1, 
                                  rRect.Y1, 
                                  rRect.X2 - rRect.X1, 
                                  rRect.Y2 - rRect.Y1 );
        }

        RECT gdiRectFromB2IRect( const ::basegfx::B2IRange& rRect )
        {
            RECT aRect = {rRect.getMinX(),
                          rRect.getMinY(),
                          rRect.getMaxX(),
                          rRect.getMaxY()};

            return aRect;
        }

        uno::Sequence< double > argbToDoubleSequence( const uno::Reference< rendering::XGraphicDevice >& 	xDevice,
                                                      const Gdiplus::ARGB&									rColor		 )
        {
            // TODO(F1): handle color space conversions, when defined on canvas/graphicDevice
            uno::Sequence< double > aRet(4);

            aRet[0] = ((rColor >> 16) & 0xFF) / 255.0; 	// red
            aRet[1] = ((rColor >> 8) & 0xFF) / 255.0;	// green
            aRet[2] = (rColor & 0xFF) / 255.0;			// blue
            aRet[3] = ((rColor >> 24) & 0xFF) / 255.0;	// alpha	

            return aRet;
        }

        uno::Sequence< sal_Int8 > argbToIntSequence( const uno::Reference< rendering::XGraphicDevice >& xDevice,
                                                     const Gdiplus::ARGB&								rColor		 )
        {
            // TODO(F1): handle color space conversions, when defined on canvas/graphicDevice
            uno::Sequence< sal_Int8 > aRet(4);

            aRet[0] = static_cast<sal_Int8>((rColor >> 16) & 0xFF);	// red
            aRet[1] = static_cast<sal_Int8>((rColor >> 8) & 0xFF);	// green
            aRet[2] = static_cast<sal_Int8>(rColor & 0xFF);			// blue
            aRet[3] = static_cast<sal_Int8>((rColor >> 24) & 0xFF);	// alpha	

            return aRet;
        }

        Gdiplus::ARGB sequenceToArgb( const uno::Reference< rendering::XGraphicDevice >& 	xDevice,
                                      const uno::Sequence< sal_Int8 >&						rColor	)
        {
            ENSURE_AND_THROW( rColor.getLength() > 2, 
                              "sequenceToArgb: need at least three channels" );

            // TODO(F1): handle color space conversions, when defined on canvas/graphicDevice
            Gdiplus::ARGB aColor;

            aColor = (static_cast<sal_uInt8>(rColor[0]) << 16) | (static_cast<sal_uInt8>(rColor[1]) << 8) | static_cast<sal_uInt8>(rColor[2]);

            if( rColor.getLength() > 3 )
                aColor |= static_cast<sal_uInt8>(rColor[3]) << 24;

            return aColor;
        }

        Gdiplus::ARGB sequenceToArgb( const uno::Reference< rendering::XGraphicDevice >& 	xDevice,
                                      const uno::Sequence< double >&						rColor		 )
        {
            ENSURE_AND_THROW( rColor.getLength() > 2, 
                              "sequenceToColor: need at least three channels" );

            // TODO(F1): handle color space conversions, when defined on canvas/graphicDevice
            Gdiplus::ARGB aColor;

            ::canvas::tools::checkRange(rColor[0],0.0,1.0);
            ::canvas::tools::checkRange(rColor[1],0.0,1.0);
            ::canvas::tools::checkRange(rColor[2],0.0,1.0);

            aColor = 
                (static_cast<UINT8>( ::basegfx::fround( 255*rColor[0] ) ) << 16) | 
                (static_cast<UINT8>( ::basegfx::fround( 255*rColor[1] ) ) << 8) | 
                static_cast<UINT8>( ::basegfx::fround( 255*rColor[2] ) );

            if( rColor.getLength() > 3 )
            {
                ::canvas::tools::checkRange(rColor[3],0.0,1.0);
                aColor |= static_cast<UINT8>( ::basegfx::fround( 255*rColor[3] ) ) << 24;
            }

            return aColor;
        }

        GraphicsPathSharedPtr graphicsPathFromRealPoint2DSequence( const uno::Sequence< uno::Sequence< geometry::RealPoint2D > >& points )
        {
            GraphicsPathSharedPtr pRes( new Gdiplus::GraphicsPath() );
            ::std::vector< Gdiplus::PointF > aPoints;

            int nCurrPoly;
            for( nCurrPoly=0; nCurrPoly<points.getLength(); ++nCurrPoly )
            {
                const int nCurrSize( points[nCurrPoly].getLength() );
                aPoints.reserve( nCurrSize );

                // TODO(F1): Closed/open polygons

                // convert from RealPoint2D array to Gdiplus::PointF array
                ::std::transform( const_cast< uno::Sequence< geometry::RealPoint2D >& >(points[nCurrPoly]).getArray(), 
                                  const_cast< uno::Sequence< geometry::RealPoint2D >& >(points[nCurrPoly]).getArray()+nCurrSize, 
                                  aPoints.begin(), 
                                  implGdiPlusPointFromRealPoint2D );

                pRes->AddLines( &aPoints[0], nCurrSize );
            }

            return pRes;
        }

        GraphicsPathSharedPtr graphicsPathFromXPolyPolygon2D( const uno::Reference< rendering::XPolyPolygon2D >& xPoly )
        {
            uno::Reference< lang::XServiceInfo > xRef( xPoly, 
                                                       uno::UNO_QUERY );

            if( xRef.is() && 
                xRef->getImplementationName().equals( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(LINEPOLYPOLYGON_IMPLEMENTATION_NAME))) )
            {
                // TODO(Q1): Maybe use dynamic_cast here
                
                // TODO(F1): Provide true beziers here!
                return static_cast<LinePolyPolygon*>(xPoly.get())->getGraphicsPath();
            }
            else
            {
                // TODO(F1): extract points from polygon interface
                return GraphicsPathSharedPtr();
            }
        }

        BitmapSharedPtr bitmapFromXBitmap( const uno::Reference< rendering::XBitmap >& xBitmap )
        {
            uno::Reference< lang::XServiceInfo > xRef( xBitmap, 
                                                       uno::UNO_QUERY );

            if( xRef.is() && 
                xRef->getImplementationName().equals( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(CANVASBITMAP_IMPLEMENTATION_NAME))) )
            {
                // TODO(Q1): Maybe use dynamic_cast here
                return static_cast<CanvasBitmap*>(xBitmap.get())->getBitmap();
            }
            else
            {
                // TODO(F1): extract points from bitmap interface
                return BitmapSharedPtr();
            }
        }

        CanvasFont::ImplRef	canvasFontFromXFont( const uno::Reference< rendering::XCanvasFont >& xFont )
        {
            uno::Reference< lang::XServiceInfo > xRef( xFont, 
                                                       uno::UNO_QUERY );

            if( xRef.is() && 
                xRef->getImplementationName().equals( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(CANVASFONT_IMPLEMENTATION_NAME))) )
            {
                // TODO(Q1): Maybe use dynamic_cast here
                return CanvasFont::ImplRef( static_cast<CanvasFont*>(xFont.get()) );
            }
            else
            {
                throw lang::IllegalArgumentException();
            }
        }

        void setModulateImageAttributes( Gdiplus::ImageAttributes& o_rAttr,
                                         double					   nRedModulation,
                                         double					   nGreenModulation,
                                         double					   nBlueModulation,
                                         double					   nAlphaModulation )
        {
            // This gets rather verbose, but we have to setup a color 
            // transformation matrix, in order to incorporate the global
            // alpha value mfAlpha into the bitmap rendering.
            Gdiplus::ColorMatrix	 aColorMatrix;

            aColorMatrix.m[0][0] = static_cast<Gdiplus::REAL>(nRedModulation);
            aColorMatrix.m[0][1] = 0.0;
            aColorMatrix.m[0][2] = 0.0;
            aColorMatrix.m[0][3] = 0.0;
            aColorMatrix.m[0][4] = 0.0;

            aColorMatrix.m[1][0] = 0.0;
            aColorMatrix.m[1][1] = static_cast<Gdiplus::REAL>(nGreenModulation);
            aColorMatrix.m[1][2] = 0.0;
            aColorMatrix.m[1][3] = 0.0;
            aColorMatrix.m[1][4] = 0.0;

            aColorMatrix.m[2][0] = 0.0;
            aColorMatrix.m[2][1] = 0.0;
            aColorMatrix.m[2][2] = static_cast<Gdiplus::REAL>(nBlueModulation);
            aColorMatrix.m[2][3] = 0.0;
            aColorMatrix.m[2][4] = 0.0;

            aColorMatrix.m[3][0] = 0.0;
            aColorMatrix.m[3][1] = 0.0;
            aColorMatrix.m[3][2] = 0.0;
            aColorMatrix.m[3][3] = static_cast<Gdiplus::REAL>(nAlphaModulation);
            aColorMatrix.m[3][4] = 0.0;

            aColorMatrix.m[4][0] = 0.0;
            aColorMatrix.m[4][1] = 0.0;
            aColorMatrix.m[4][2] = 0.0;
            aColorMatrix.m[4][3] = 0.0;
            aColorMatrix.m[4][4] = 1.0;

            o_rAttr.SetColorMatrix( &aColorMatrix,
                                    Gdiplus::ColorMatrixFlagsDefault, 
                                    Gdiplus::ColorAdjustTypeDefault );
        }

    }
}
