/*************************************************************************
 *
 *  $RCSfile: HStorage.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2004/11/11 15:15:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef CONNECTIVITY_HSQLDB_STORAGE_HXX
#include "HStorage.hxx"
#endif

#ifndef _COM_SUN_STAR_BEANS_NAMEDVALUE_HPP_
#include <com/sun/star/beans/NamedValue.hpp>
#endif
#ifndef _COM_SUN_STAR_EMBED_ELEMENTMODES_HPP_
#include <com/sun/star/embed/ElementModes.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include <string.h>
#include <rtl/logfile.hxx>

using namespace connectivity::hsqldb;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::embed;
using namespace ::com::sun::star::document;
using namespace ::osl;
//--------------------------------------------------------------------
OStorage::OStorage(const Reference< XMultiServiceFactory >&	_rxFactory)
:OStorage_Base(m_aMutex)
,m_xServiceFactory(_rxFactory)
{
}
// -----------------------------------------------------------------------------
void SAL_CALL OStorage::disposing()
{
	m_xServiceFactory = NULL;
	m_xSeek = NULL;
	m_xOut = NULL;
	m_xIn = NULL;
	m_xStream = NULL;
	m_xStorge = NULL;
	m_xDS = NULL;
}
// -----------------------------------------------------------------------------
::rtl::OUString SAL_CALL OStorage::getImplementationName(  ) throw(RuntimeException)
{
	MutexGuard aGuard(m_aMutex);
	return getImplementationName_Static();
}

//--------------------------------------------------------------------------
sal_Bool SAL_CALL OStorage::supportsService( const ::rtl::OUString& _rServiceName ) throw(RuntimeException)
{
	Sequence< ::rtl::OUString > aSupported(getSupportedServiceNames());
	const ::rtl::OUString* pSupported = aSupported.getConstArray();
	const ::rtl::OUString* pEnd = pSupported + aSupported.getLength();
	for (;pSupported != pEnd && !pSupported->equals(_rServiceName); ++pSupported)
		;

	return pSupported != pEnd;
}

//--------------------------------------------------------------------------
Sequence< ::rtl::OUString > SAL_CALL OStorage::getSupportedServiceNames(  ) throw(RuntimeException)
{
	return getSupportedServiceNames_Static();
}

//---------------------------------------OStorage----------------------------------
Reference< XInterface > SAL_CALL OStorage::Create(const Reference< XMultiServiceFactory >& _rxFactory)
{
	return static_cast<XStream*>(new OStorage(_rxFactory));
}

//--------------------------------------------------------------------------
::rtl::OUString SAL_CALL OStorage::getImplementationName_Static(  ) throw(RuntimeException)
{
	return ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.comp.sdbc.hsqldb.StorageAccessHelper"));
}
//--------------------------------------------------------------------------
Sequence< ::rtl::OUString > SAL_CALL OStorage::getSupportedServiceNames_Static(  ) throw(RuntimeException)
{
	Sequence< ::rtl::OUString > aSupported(1);
	aSupported[0] = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.comp.sdbc.hsqldb.StorageAccessHelper"));
	return aSupported;
}
// -----------------------------------------------------------------------------
void SAL_CALL OStorage::initialize( const Sequence< Any >& _aArguments ) throw(Exception, RuntimeException)
{
	sal_Int32 nMode = ElementModes::SEEKABLEREAD;
	::rtl::OUString sName;

	const Any* pIter = _aArguments.getConstArray();
	const Any* pEnd = pIter + _aArguments.getLength();
	NamedValue aValue;;
	for(;pIter != pEnd;++pIter)
	{
		*pIter >>= aValue;
		if ( aValue.Name.equalsAscii("DataSource") )
		{
			m_xDS.set(aValue.Value,UNO_QUERY);
		}
		else if ( aValue.Name.equalsAscii("Mode") )
		{
			aValue.Value >>= nMode;
		}
		else if ( aValue.Name.equalsAscii("Name") )
		{
			aValue.Value >>= sName;
		}
	}

	if ( m_xDS.is() )
	{
		m_xStorge = m_xDS->getDocumentSubStorage(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("database")),nMode);
		if ( !m_xStorge.is() )
			throw Exception();
		m_xStream = m_xStorge->openStreamElement(sName,nMode);
		if ( !m_xStream.is() )
			throw Exception();
		m_xSeek.set(m_xStream,UNO_QUERY);
		if ( !m_xSeek.is() )
			throw Exception();
		m_xIn = m_xStream->getInputStream();
		if ( !m_xIn.is() )
			throw Exception();
		m_xOut = m_xStream->getOutputStream();
	}
	else
		throw Exception();
}
// -----------------------------------------------------------------------------
// XStream
Reference< XInputStream > SAL_CALL OStorage::getInputStream(  ) throw (RuntimeException)
{
	OSL_ENSURE(m_xStream.is(),"Stream is NULL");
	return m_xStream.is() ? m_xStream->getInputStream() : Reference< XInputStream >();
}
// -----------------------------------------------------------------------------
Reference< XOutputStream > SAL_CALL OStorage::getOutputStream(  ) throw (RuntimeException)
{
	OSL_ENSURE(m_xStream.is(),"Stream is NULL");
	return m_xStream.is() ? m_xStream->getOutputStream() : Reference< XOutputStream >();
}
// -----------------------------------------------------------------------------
// XInputStream
::sal_Int32 SAL_CALL OStorage::readBytes( Sequence< ::sal_Int8 >& aData, ::sal_Int32 nBytesToRead ) throw (NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	OSL_ENSURE(m_xIn.is(),"Input Stream is NULL");
	return m_xIn->readBytes(aData,nBytesToRead);
}
// -----------------------------------------------------------------------------
::sal_Int32 SAL_CALL OStorage::readSomeBytes( Sequence< ::sal_Int8 >& aData, ::sal_Int32 nMaxBytesToRead ) throw (NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	OSL_ENSURE(m_xIn.is(),"Input Stream is NULL");
	return m_xIn->readSomeBytes(aData,nMaxBytesToRead);
}
// -----------------------------------------------------------------------------
void SAL_CALL OStorage::skipBytes( ::sal_Int32 nBytesToSkip ) throw (NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	OSL_ENSURE(m_xIn.is(),"Input Stream is NULL");
	m_xIn->skipBytes(nBytesToSkip);
}
// -----------------------------------------------------------------------------
::sal_Int32 SAL_CALL OStorage::available(  ) throw (NotConnectedException, IOException, RuntimeException)
{
	OSL_ENSURE(m_xIn.is(),"Input Stream is NULL");
	return m_xIn->available();
}
// -----------------------------------------------------------------------------
void SAL_CALL OStorage::closeInput(  ) throw (NotConnectedException, IOException, RuntimeException)
{
	OSL_ENSURE(m_xIn.is(),"Input Stream is NULL");
	m_xIn->closeInput();
}
// -----------------------------------------------------------------------------
// XOutputStream
void SAL_CALL OStorage::writeBytes( const Sequence< ::sal_Int8 >& aData ) throw (NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	OSL_ENSURE(m_xOut.is(),"Output Stream is NULL");
	m_xOut->writeBytes(aData);
}
// -----------------------------------------------------------------------------
void SAL_CALL OStorage::flush(  ) throw (NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	OSL_ENSURE(m_xOut.is(),"Output Stream is NULL");
	m_xOut->flush();
}
// -----------------------------------------------------------------------------
void SAL_CALL OStorage::closeOutput(  ) throw (NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	OSL_ENSURE(m_xOut.is(),"Output Stream is NULL");
	m_xOut->closeOutput();
}
// -----------------------------------------------------------------------------
// XSeekable
void SAL_CALL OStorage::seek( ::sal_Int64 location ) throw (IllegalArgumentException, IOException, RuntimeException)
{
	OSL_ENSURE(m_xSeek.is(),"Seek is NULL");
	::sal_Int64 nLen = m_xSeek->getLength();
	if ( nLen < location) 
	{
		static ::sal_Int64 BUFFER_SIZE = 9192;
        m_xSeek->seek(nLen);

        ::sal_Int64 diff = location - nLen;
        sal_Int32 n;
        while( diff != 0 )
		{
            if ( BUFFER_SIZE < diff )
			{
                n = static_cast<sal_Int32>(BUFFER_SIZE);
                diff = diff - BUFFER_SIZE;
            } 
			else 
			{
                n = static_cast<sal_Int32>(diff);
                diff = 0;
            }
			Sequence< ::sal_Int8 > aData(n);
			memset(aData.getArray(),0,n);
            m_xOut->writeBytes(aData);
        }
    }
    
	m_xSeek->seek(location);
}
// -----------------------------------------------------------------------------
::sal_Int64 SAL_CALL OStorage::getPosition(  ) throw (IOException, RuntimeException)
{
	OSL_ENSURE(m_xSeek.is(),"Seek is NULL");
	return m_xSeek->getPosition();
}
// -----------------------------------------------------------------------------
::sal_Int64 SAL_CALL OStorage::getLength(  ) throw (IOException, RuntimeException)
{
	OSL_ENSURE(m_xSeek.is(),"Seek is NULL");
	return m_xSeek.is() ? m_xSeek->getLength() : ::sal_Int64(0);
}
// -----------------------------------------------------------------------------
