/*************************************************************************
 *
 *  $RCSfile: ParameterSubstitution.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2004/08/02 17:15:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "ParameterSubstitution.hxx"

#ifndef _CONNECTIVITY_SQLPARSE_HXX 
#include "connectivity/sqlparse.hxx"
#endif
#ifndef _COM_SUN_STAR_BEANS_NAMEDVALUE_HPP_
#include <com/sun/star/beans/NamedValue.hpp>
#endif


using namespace connectivity;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::beans;
using namespace ::osl;
//--------------------------------------------------------------------
OParameterSubstitution::OParameterSubstitution(const Reference< XMultiServiceFactory >&	_rxFactory)
:m_xServiceFactory(_rxFactory)
{
}
// -----------------------------------------------------------------------------
::rtl::OUString SAL_CALL OParameterSubstitution::getImplementationName(  ) throw(RuntimeException)
{
	MutexGuard aGuard(m_aMutex);
	return getImplementationName_Static();
}

//--------------------------------------------------------------------------
sal_Bool SAL_CALL OParameterSubstitution::supportsService( const ::rtl::OUString& _rServiceName ) throw(RuntimeException)
{
	Sequence< ::rtl::OUString > aSupported(getSupportedServiceNames());
	const ::rtl::OUString* pSupported = aSupported.getConstArray();
	const ::rtl::OUString* pEnd = pSupported + aSupported.getLength();
	for (;pSupported != pEnd && !pSupported->equals(_rServiceName); ++pSupported)
		;

	return pSupported != pEnd;
}

//--------------------------------------------------------------------------
Sequence< ::rtl::OUString > SAL_CALL OParameterSubstitution::getSupportedServiceNames(  ) throw(RuntimeException)
{
	return getSupportedServiceNames_Static();
}

//---------------------------------------OParameterSubstitution----------------------------------
Reference< XInterface > SAL_CALL OParameterSubstitution::Create(const Reference< XMultiServiceFactory >& _rxFactory)
{
	return static_cast<XStringSubstitution*>(new OParameterSubstitution(_rxFactory));
}

//--------------------------------------------------------------------------
::rtl::OUString SAL_CALL OParameterSubstitution::getImplementationName_Static(  ) throw(RuntimeException)
{
	return ::rtl::OUString::createFromAscii("com.sun.star.comp.sdbc.ParameterSubstitution");
}
//--------------------------------------------------------------------------
Sequence< ::rtl::OUString > SAL_CALL OParameterSubstitution::getSupportedServiceNames_Static(  ) throw(RuntimeException)
{
	Sequence< ::rtl::OUString > aSupported(1);
	aSupported[0] = ::rtl::OUString::createFromAscii("com.sun.star.sdbc.ParameterSubstitution");
	return aSupported;
}
// -----------------------------------------------------------------------------
// ::com::sun::star::util::XStringSubstitution
::rtl::OUString SAL_CALL OParameterSubstitution::substituteVariables( const ::rtl::OUString& aText, sal_Bool bSubstRequired ) throw (::com::sun::star::container::NoSuchElementException, RuntimeException)
{
	::rtl::OUString sSqlStatement = aText;
	try
	{
		OSQLParser aParser(m_xServiceFactory);
		::rtl::OUString sErrorMessage;
		::rtl::OUString sNewSql;
		OSQLParseNode* pNode = aParser.parseTree(sErrorMessage,aText);
		if(pNode)
		{	// special handling for parameters
			// we recusive replace all occurences of ? in the statement and replace them with name like ""
			OSQLParseNode::substituteParameterNames(pNode);
			pNode->parseNodeToStr(sNewSql,m_xMetaData);
			delete pNode;
			sSqlStatement = sNewSql;
		}
	}
	catch(const Exception&)
	{
	}
	return sSqlStatement;
}
// -----------------------------------------------------------------------------
::rtl::OUString SAL_CALL OParameterSubstitution::reSubstituteVariables( const ::rtl::OUString& aText ) throw (RuntimeException)
{
	return aText;
}
// -----------------------------------------------------------------------------
::rtl::OUString SAL_CALL OParameterSubstitution::getSubstituteVariableValue( const ::rtl::OUString& variable ) throw (::com::sun::star::container::NoSuchElementException, RuntimeException)
{
	return variable;
}
// -----------------------------------------------------------------------------
void SAL_CALL OParameterSubstitution::initialize( const Sequence< Any >& _aArguments ) throw(Exception, RuntimeException)
{
	const Any* pIter = _aArguments.getConstArray();
	const Any* pEnd = pIter + _aArguments.getLength();
	NamedValue aValue;;
	for(;pIter != pEnd;++pIter)
	{
		*pIter >>= aValue;
		if ( aValue.Name.equalsAscii("MetaData") )
		{
			m_xMetaData.set(aValue.Value,UNO_QUERY);
			break;
		}
	}
}
// -----------------------------------------------------------------------------
