/*************************************************************************
 *
 *  $RCSfile: nr2function.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/07/12 15:47:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef COSV_NR2FUNCTION_HXX
#define COSV_NR2FUNCTION_HXX

// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
                 
namespace cosv
{

                                          
/** Allows to call a function by a number.
*/                 
class Nr2Function
{
  public:               
    typedef void (*FUNC)();
  
    // LIFECYCLE                               
                        Nr2Function()
                            :   aFunctions() { aFunctions.push_back(FUNC(0)); }
    intt                AddFunction(
                            FUNC                i_function )
                            { aFunctions.push_back(i_function);
                              return aFunctions.size() - 1; }
                        ~Nr2Function()  {}
                        
    // OPERATIONS
    /// @param  i_nr    [1 <= i_nr < @->aFunctions.size()]
    void                Call(
                            intt                i_nr ) const
                            { (*aFunctions[i_nr])(); }
  private:
    std::vector<FUNC>   aFunctions;                             
};


/** Allows to call a member function by a number.
*/                 
template <class CLASS>
class Nr2MemberFunction
{
  public: 
    typedef void (CLASS::*FUNC)();
                
    // LIFECYCLE                               
                        Nr2MemberFunction(
                            CLASS &             i_host )
                            :   aFunctions(),
                                rHost(i_host) { aFunctions.push_back(FUNC(0)); }
                            
    intt                AddFunction(
                            FUNC                i_function )
                            { aFunctions.push_back(i_function);
                              return aFunctions.size() - 1; }
                        ~Nr2MemberFunction() {}
                        
    // OPERATIONS
    /// @param i_nr     [1 <= i_nr < @->aFunctions.size()]
    void                Call(
                            intt                i_nr ) const
                            { (rHost.*aFunctions[i_nr])(); }
    // INQUIRY                            
    CLASS &             Host() const            { return rHost; }
                        
  private:
    std::vector<FUNC>   aFunctions;                             
    CLASS &             rHost;  
};


/** Allows to call a function with 1 parameter by a number.
*/                 
template <class PARA1>
class Nr2FunctionP1
{
  public:               
    typedef void (*FUNC)(PARA1);
  
    // LIFECYCLE                               
                        Nr2FunctionP1()
                            :   aFunctions() { aFunctions.push_back(FUNC(0)); }
    intt                AddFunction(
                            FUNC                i_function )
                            { aFunctions.push_back(i_function);
                              return aFunctions.size() - 1; }
                        ~Nr2FunctionP1()  {}
                        
    // OPERATIONS
    /// @param i_nr     [1 <= i_nr < @->aFunctions.size()]
    void                Call(
                            intt                i_nr,
                            PARA1               i_param ) const
                            { (*aFunctions[i_nr])(i_param); }
  private:
    std::vector<FUNC>   aFunctions;                             
};


/** Allows to call a member function with one parameter by a number.
*/                 
template <class CLASS, class PARA1>
class Nr2MemberFunctionP1
{
  public: 
    typedef void (CLASS::*FUNC)(PARA1);
                
    // LIFECYCLE                               
                        Nr2MemberFunctionP1(
                            CLASS &             i_host )
                            :   aFunctions(),
                                rHost(i_host) { aFunctions.push_back(FUNC(0)); }
                            
    intt                AddFunction(
                            FUNC                i_function )
                            { aFunctions.push_back(i_function);
                              return aFunctions.size() - 1; }
                        ~Nr2MemberFunctionP1() {}
                        
    // OPERATIONS             
    /// @param i_nr     [1 <= i_nr < @->aFunctions.size()]
    void                Call(
                            intt                i_nr,
                            PARA1               i_param ) const
                            { (rHost.*aFunctions[i_nr])(i_param); }
    // INQUIRY                            
    CLASS &             Host() const            { return rHost; }

  private:
    std::vector<FUNC>   aFunctions;                             
    CLASS &             rHost;  
};


}   // namespace cosv


#endif
