/*************************************************************************
 *
 *  $RCSfile: IAppElementNotification.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2004/09/09 09:40:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Ocke Janssen
 *
 *
 ************************************************************************/
#ifndef DBAUI_IAPPELEMENTNOTIFICATION_HXX
#define DBAUI_IAPPELEMENTNOTIFICATION_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif
#ifndef DBAUI_APPELEMENTTYPE_HXX
#include "AppElementType.hxx"
#endif

class SvTreeListBox;
class SvLBoxEntry;
class ListBox;
class SvtIconChoiceCtrl;
namespace rtl
{
	class OUString;
}
//........................................................................
namespace dbaui
{
//........................................................................
	class SAL_NO_VTABLE IApplicationElementNotification
	{
	public:

		/** called when the handle <method>OApplicationDetailView::OnEntryDoubleClick</method> was called.
			@param	_pTree
				The tree list box.
		*/
		virtual void onEntryDoubleClick(SvTreeListBox* _pTree) = 0;

		/** called when the handle <method>OApplicationSwapWindow::OnContainerSelectHdl</method> was called.
			@param	_pTree
				The tree list box.
			@return
				<TRUE/> if the cotainer could be changed otherwise <FALSE/>
		*/
		virtual sal_Bool onContainerSelect(ElementType _eType) = 0;

		/** called when the handle <method>OApplicationDetailView::OnEntrySelectHdl</method> was called.
			@param	_pEntry
				the selected entry
		*/
		virtual void onEntrySelect(SvLBoxEntry* _pEntry) = 0;

		/** called when the handle <method>OApplicationDetailView::OnDeSelectHdl</method> was called.
			@param	_pTree
				The tree list box.
		*/
		virtual void onEntryDeSelect(SvTreeListBox* _pTree) = 0;

		/** called when the handle <method>IApplicationElementNotification::OnCutEntry</method> was called.
			@param	_pEntry
				The entry which was cutted.
		*/
		virtual void onCutEntry(SvLBoxEntry* _pEntry) = 0;

		/** called when the handle <method>OApplicationDetailView::OnCopyEntry</method> was called.
			@param	_pEntry
				The entry which was cutted.
		*/
		virtual void onCopyEntry(SvLBoxEntry* _pEntry) = 0;

		/** called when the handle <method>OApplicationDetailView::OnPasteEntry</method> was called.
			@param	_pEntry
				The entry which was cutted.
		*/
		virtual void onPasteEntry(SvLBoxEntry* _pEntry) = 0;

		/** called when the handle <method>OApplicationDetailView::OnDeleteEntry</method> was called.
			@param	_pEntry
				The entry which was cutted.
		*/
		virtual void onDeleteEntry(SvLBoxEntry* _pEntry) = 0;

		/** called when the handle <method>OApplicationDetailView::OnCreationClickHdlHdl</method> was called.
			@param	_sCommand
				The command which should be executed.
		*/
		virtual void onCreationClick(const ::rtl::OUString& _sCommand) = 0;
	};
	
//........................................................................
} // namespace dbaui
//........................................................................
#endif // DBAUI_IAPPELEMENTNOTIFICATION_HXX

