/*************************************************************************
 *
 *  $RCSfile: lockfile.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: hjs $ $Date: 2004/06/25 17:45:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): lars.oppermann@sun.com
 *
 *
 ************************************************************************/

/* Information:
 * This class implements a mechanism to lock a users installation directory,
 * which is necessesary because instances of staroffice could be running on 
 * different hosts while using the same directory thus causing data 
 * inconsistency.
 * When an existing lock is detected, the user will be asked whether he wants
 * to continue anyway, thus removing the lock and replacing it with a new one
 *
 * ideas:
 * - store information about user and host and time in the lockfile and display 
 * these when asking whether to remove the lockfile.
 * - periodically check the lockfile and warn the user when it gets replaced
 *
 */

using namespace ::rtl;
namespace desktop {

	class Lockfile
	{
	public:

		// contructs a new lockfile onject
		Lockfile( bool bIPCserver = true );

        // separating GUI code:
        typedef bool (* fpExecWarning)( Lockfile * that );
        
		// checks the lockfile, asks user when lockfile is 
		// found (iff gui) and returns false when we may not continue
		sal_Bool check( fpExecWarning execWarning );

		// removes the lockfile. should only be called in exceptional situations
		void clean(void);

		// removes the lockfile
		~Lockfile(void);

	private:
		// data in lockfile
		static const ByteString Group();
		static const ByteString Userkey();
		static const ByteString Hostkey();
		static const ByteString Stampkey();
		static const ByteString Timekey();
		static const ByteString IPCkey();
		// lockfilename
		static const OUString Suffix();
		bool m_bIPCserver;
		// full qualified name (file://-url) of the lockfile
		OUString m_aLockname;
		// flag whether the d'tor should delete the lock
		sal_Bool m_bRemove;
		sal_Bool m_bIsLocked;
		// ID 
		OUString m_aId;
		OUString m_aDate;
		// access to data in file
		void syncToFile(void) const;
		sal_Bool isStale(void) const;
        friend bool Lockfile_execWarning( Lockfile * that );

	};

}
