/*************************************************************************
 *
 *  $RCSfile: dp_servicefactory.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2004/11/09 14:09:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "dp_servicefactory.h"
#include "cppuhelper/implbase2.hxx"
#include "com/sun/star/lang/XServiceInfo.hpp"


using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using ::rtl::OUString;

namespace dp_misc {
namespace {

//==============================================================================
class Factory
    : public ::cppu::WeakImplHelper2<lang::XServiceInfo,
                                     lang::XSingleComponentFactory>
{
    OUString m_implName;
    Sequence<OUString> m_supportedServices;
    fptr_create m_create;
    
public:
    Factory( OUString const & implName,
             Sequence<OUString> const & supportedServices,
             fptr_create create )
        : m_implName( implName ),
          m_supportedServices( supportedServices ),
          m_create( create )
        {}
    
    // XServiceInfo
    virtual OUString SAL_CALL getImplementationName() throw (RuntimeException);
    virtual sal_Bool SAL_CALL supportsService( OUString const & serviceName )
        throw (RuntimeException);
    virtual Sequence<OUString> SAL_CALL getSupportedServiceNames()
        throw (RuntimeException);
    
    // XSingleComponentFactory
    virtual Reference<XInterface> SAL_CALL createInstanceWithContext(
        Reference<XComponentContext> const & xContext ) throw (Exception);
    virtual Reference<XInterface> SAL_CALL
    createInstanceWithArgumentsAndContext(
        Sequence<Any> const & args,
        Reference<XComponentContext> const & xContext ) throw (Exception);
};

// XServiceInfo
//______________________________________________________________________________
OUString Factory::getImplementationName() throw (RuntimeException)
{
    return m_implName;
}

//______________________________________________________________________________
sal_Bool Factory::supportsService( OUString const & serviceName )
    throw (RuntimeException)
{
    OUString const * ar = m_supportedServices.getConstArray();
    for ( sal_Int32 pos = m_supportedServices.getLength(); pos--; ) {
        if (ar[pos] == serviceName)
            return true;
    }
    return false;
}

//______________________________________________________________________________
Sequence<OUString> Factory::getSupportedServiceNames() throw (RuntimeException)
{
    return m_supportedServices;
}

// XSingleComponentFactory
//______________________________________________________________________________
Reference<XInterface> Factory::createInstanceWithContext(
    Reference<XComponentContext> const & xContext ) throw (Exception)
{
    return (*m_create)( Sequence<Any>(), xContext );
}

//______________________________________________________________________________
Reference<XInterface> Factory::createInstanceWithArgumentsAndContext(
    Sequence<Any> const & args, Reference<XComponentContext> const & xContext )
    throw (Exception)
{
    return (*m_create)( args, xContext );
}

} // anon namespace

//==============================================================================
Reference<lang::XSingleComponentFactory> SAL_CALL createFactory(
    /* fptr_create */ ::cppu::ComponentFactoryFunc fptr,
    OUString const & implName,
    Sequence<OUString> const & supportedServices,
    rtl_ModuleCount * )
{
    return new Factory( implName, supportedServices, (fptr_create) fptr );
}

} // dp_misc
