/*************************************************************************
 *
 *  $RCSfile: pkgchk_balancing.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/21 17:14:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "dp_misc.h"
#include "unopkg_shared.h"
#include "rtl/strbuf.hxx"
#include "rtl/ustrbuf.hxx"
#include "rtl/uri.hxx"
#include "osl/thread.h"
#include "osl/file.hxx"
#include "ucbhelper/content.hxx"
#include "com/sun/star/util/XMacroExpander.hpp"
#include "com/sun/star/deployment/thePackageManagerFactory.hpp"
#include "com/sun/star/sdbc/XResultSet.hpp"
#include "com/sun/star/sdbc/XRow.hpp"
#include "com/sun/star/ucb/NameClash.hpp"
#include "com/sun/star/util/DateTime.hpp"
#ifdef SYSTEM_DB3
#include <db3/db_cxx.h>
#else
#include "berkeleydb/db_cxx.h"
#endif
#include <vector>
#include <hash_set>

using namespace ::com::sun::star;
using namespace ::com::sun::star::ucb;
using namespace ::com::sun::star::uno;
using namespace ::unopkg;
using ::rtl::OUString;

namespace {

//------------------------------------------------------------------------------
void throw_rtexc( int err )
{
    ::rtl::OString str( DbEnv::strerror(err) );
    throw RuntimeException(
        OUSTR("Berkeley Db error: ") +
        OUString( str.getStr(), str.getLength(), osl_getThreadTextEncoding() ),
        0 );
}

//------------------------------------------------------------------------------
sal_uInt32 calcStamp( ::ucb::Content & ucbContent )
{
    sal_uInt32 stamp = static_cast<sal_uInt32>(
        ucbContent.getPropertyValue( OUSTR("Size") ).get<sal_Int64>() );
    util::DateTime dt( ucbContent.getPropertyValue(
                           OUSTR("DateModified") ).get<util::DateTime>() );
    stamp ^= dt.HundredthSeconds;
    stamp ^= (dt.Seconds << 1);
    stamp ^= (dt.Minutes << 2);
    stamp ^= (dt.Hours << 3);
    stamp ^= (dt.Day << 4);
    stamp ^= (dt.Month << 5);
    stamp ^= (dt.Year << 6);
    return stamp;
}

} // anon namespace

//==============================================================================
void pkgchk_copyAndBalance(
    ::std::vector<OUString> const & cmd_packages,
    bool option_shared, bool option_renewal,
    Reference<XCommandEnvironment> const & xCmdEnv,
    Reference<XComponentContext> const & xComponentContext )
{
    OUString packages_dir(
        option_shared
        ? OUSTR("vnd.sun.star.expand:$UNO_SHARED_PACKAGES/")
        : OUSTR("vnd.sun.star.expand:$UNO_USER_PACKAGES/") );
    
    // copy packages:
    ::ucb::Content packages_dir_content( packages_dir, xCmdEnv );
    for ( ::std::size_t pos = 0; pos < cmd_packages.size(); ++pos )
    {
        if (! packages_dir_content.transferContent(
                ::ucb::Content( cmd_packages[ pos ], xCmdEnv ),
                ::ucb::InsertOperation_COPY,
                OUString(), NameClash::ASK ))
            throw RuntimeException( OUSTR("UCB transferContent() failed!"), 0 );
    }
    
    const Reference<deployment::XPackageManagerFactory> xPackageManagerFactory(
        deployment::thePackageManagerFactory::get( xComponentContext ) );
    const Reference<deployment::XPackageManager> xPackageManager(
        xPackageManagerFactory->getPackageManager(
            option_shared ? OUSTR("shared") : OUSTR("user") ) );
    
    if (option_renewal) // renewal first:
        xPackageManager->reinstallDeployedPackages(
            Reference<task::XAbortChannel>(), xCmdEnv );
    
    // collect all present packages:
    const OUString ar [] = { OUSTR("Title"), OUSTR("IsFolder") };
    const Reference<sdbc::XResultSet> xResultSet(
        packages_dir_content.createCursor(
            Sequence<OUString>( ar, ARLEN(ar) ),
            ::ucb::INCLUDE_FOLDERS_AND_DOCUMENTS ) );
    typedef ::std::hash_set<OUString, ::rtl::OUStringHash> t_stringset;
    t_stringset present_packages;
    while (xResultSet->next())
    {
        const Reference<sdbc::XRow> xRow( xResultSet, UNO_QUERY_THROW );
        const OUString title( xRow->getString( 1 /* Title */ ) );
        if (xRow->getBoolean( 2 /* IsFolder */ ) &&
            title.equalsIgnoreAsciiCaseAsciiL(
                RTL_CONSTASCII_STRINGPARAM("cache") ))
            continue;
        present_packages.insert( title );
    }
    
    try {
        // open berkeley DB for storing added packages:
        OUString packages_db_file(
            ::dp_misc::expandUnoRcTerm(
                option_shared
                ? OUSTR("$UNO_SHARED_PACKAGES_CACHE/legacy_packages.db")
                : OUSTR("$UNO_USER_PACKAGES_CACHE/legacy_packages.db") ) );
        ::osl::File::RC rc = ::osl::File::getSystemPathFromFileURL(
            packages_db_file, packages_db_file );
        OSL_ASSERT( rc == ::osl::File::E_None );
        Db packages_db(0, 0);
        int err = packages_db.open(
            ::rtl::OUStringToOString(
                packages_db_file, osl_getThreadTextEncoding() ).getStr(), 0,
            DB_RECNO, DB_CREATE, 0664 /* fs mode */ );
        if (err != 0)
            throw_rtexc( err );
        
        Dbc * pcurs = 0;
        err = packages_db.cursor( 0, &pcurs, 0 );
        if (err != 0)
            throw_rtexc( err );
        
        // balance with deployed ones:
        for (;;)
        {
            Dbt dbKey, dbData;
            err = pcurs->get( &dbKey, &dbData, DB_NEXT );
            if (err == DB_NOTFOUND)
                break;
            if (err != 0)
                throw_rtexc( err );
            
            // 4-byte stamp:
            sal_uInt8 const * data = reinterpret_cast<sal_uInt8 const *>(
                dbData.get_data() );
            sal_uInt32 stamp = *data++;
            stamp <<= 8;
            stamp |= *data++;
            stamp <<= 8;
            stamp |= *data++;
            stamp <<= 8;
            stamp |= *data;
            OUString name(
                static_cast<sal_Char const *>(dbData.get_data()) + 4,
                dbData.get_size() - 4, RTL_TEXTENCODING_UTF8 );
            t_stringset::const_iterator iFind( present_packages.find( name ) );
            if (iFind != present_packages.end())
            {
                Reference<deployment::XPackage> xPackage;
                try {
                    xPackage = xPackageManager->getDeployedPackage(
                        name, xCmdEnv );
                }
                catch (lang::IllegalArgumentException &) {
                    OSL_ENSURE( 0, "### inconsistent pkg cache!" );
                    // remove from db, and install new one:
                    err = pcurs->del(0);
                    if (err != 0)
                        throw_rtexc( err );                        
                    err = packages_db.sync(0);
                    if (err != 0)
                        throw_rtexc( err );
                    continue;
                }
                
                ::ucb::Content ucb_content(
                    ::dp_misc::makeURL( packages_dir, ::rtl::Uri::encode(
                                            name, rtl_UriCharClassPchar,
                                            rtl_UriEncodeIgnoreEscapes,
                                            RTL_TEXTENCODING_UTF8 ) ),
                    xCmdEnv );
                
                // check if stamp fits:
                if (calcStamp( ucb_content ) == stamp) {
                    // seems to be comp, do not install a new one:
                    present_packages.erase( name );
                    continue;
                }
            }
            
            try {
                // remove previous one:
                xPackageManager->removePackage(
                    name, Reference<task::XAbortChannel>(), xCmdEnv );
            }
            catch (deployment::DeploymentException & exc) {
                OSL_ENSURE( 0, ::rtl::OUStringToOString(
                                exc.Message, RTL_TEXTENCODING_UTF8 ).getStr() );
                // do not install a new one in case of error:
                present_packages.erase( name );
            }
            
            // remove from db:
            err = pcurs->del(0);
            if (err != 0)
                throw_rtexc( err );                        
            err = packages_db.sync(0);
            if (err != 0)
                throw_rtexc( err );
        }
        err = pcurs->close();
        if (err != 0)
            throw_rtexc( err );
        
        // install rest:
        t_stringset::const_iterator iPos( present_packages.begin() );
        t_stringset::const_iterator const iEnd( present_packages.end() );
        for ( ; iPos != iEnd; ++iPos )
        {
            const OUString package_url(
                ::dp_misc::makeURL( packages_dir, ::rtl::Uri::encode(
                                        *iPos, rtl_UriCharClassPchar,
                                        rtl_UriEncodeIgnoreEscapes,
                                        RTL_TEXTENCODING_UTF8 ) ) );
            const Reference<deployment::XPackage> xPackage(
                xPackageManager->addPackage(
                    package_url, OUString() /* to be detected */,
                    Reference<task::XAbortChannel>(), xCmdEnv ) );
            
            ::ucb::Content ucb_content( package_url, xCmdEnv );
            sal_uInt32 stamp( calcStamp( ucb_content ) );
            ::rtl::OStringBuffer buf;
            buf.append( static_cast<sal_Char>(stamp >> 24) );
            buf.append( static_cast<sal_Char>(stamp >> 16) );
            buf.append( static_cast<sal_Char>(stamp >> 8) );
            buf.append( static_cast<sal_Char>(stamp) );
            buf.append( ::rtl::OUStringToOString(
                            *iPos, RTL_TEXTENCODING_UTF8 ) );
            Dbt dbData( const_cast<sal_Char *>(buf.getStr()), buf.getLength() );
            Dbt dbKey;
            err = packages_db.put( 0, &dbKey, &dbData, DB_APPEND );
            if (err != 0)
                throw_rtexc( err );
            err = packages_db.sync(0);
            if (err != 0)
                throw_rtexc( err );
        }
        
        packages_db.close(0);
    }
    catch (DbException & exc) {
        ::rtl::OString str( exc.what() );
        throw RuntimeException(
            OUSTR("caught: ") + OUString(
                str.getStr(), str.getLength(), osl_getThreadTextEncoding() ),
            0 );
    }
}
