/*************************************************************************
 *
 *  $RCSfile: guid.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/18 15:12:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "common.h"

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif

::rtl::OUString getStorageTypeFromGUID_Impl( GUID* guid )
{
	if ( *guid == OID_WriterTextServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "soffice.StarWriterDocument.6" ) );

	if ( *guid == OID_WriterOASISTextServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "opendocument.WriterDocument.1" ) );

	if ( *guid == OID_CalcServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "soffice.StarCalcDocument.6" ) );

	if ( *guid == OID_CalcOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "opendocument.CalcDocument.1" ) );

	if ( *guid == OID_DrawingServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "soffice.StarDrawDocument.6" ) );

	if ( *guid == OID_DrawingOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "opendocument.DrawDocument.1" ) );

	if ( *guid == OID_PresentationServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "soffice.StarImpressDocument.6" ) );

	if ( *guid == OID_PresentationOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "opendocument.ImpressDocument.1" ) );

	if ( *guid == OID_MathServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "soffice.StarMathDocument.6" ) );

	if ( *guid == OID_MathOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "opendocument.MathDocument.1" ) );

	return ::rtl::OUString();
}

::rtl::OUString getServiceNameFromGUID_Impl( GUID* guid )
{
	if ( *guid == OID_WriterTextServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Writer.TextDocument" ) );

	if ( *guid == OID_WriterOASISTextServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Writer.TextDocument" ) );

	if ( *guid == OID_CalcServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Calc.SpreadsheetDocument" ) );

	if ( *guid == OID_CalcOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Calc.SpreadsheetDocument" ) );

	if ( *guid == OID_DrawingServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Draw.DrawingDocument" ) );

	if ( *guid == OID_DrawingOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Draw.DrawingDocument" ) );

	if ( *guid == OID_PresentationServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Draw.PresentationDocument" ) );

	if ( *guid == OID_PresentationOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Draw.PresentationDocument" ) );

	if ( *guid == OID_MathServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Math.FormulaDocument" ) );

	if ( *guid == OID_MathOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Math.FormulaDocument" ) );

	return ::rtl::OUString();
}

::rtl::OUString getFilterNameFromGUID_Impl( GUID* guid )
{
	if ( *guid == OID_WriterTextServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "StarOffice XML (Writer)" ) );

	if ( *guid == OID_WriterOASISTextServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "writer8" ) );

	if ( *guid == OID_CalcServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "StarOffice XML (Calc)" ) );

	if ( *guid == OID_CalcOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "calc8" ) );

	if ( *guid == OID_DrawingServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "StarOffice XML (Draw)" ) );

	if ( *guid == OID_DrawingOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "draw8" ) );

	if ( *guid == OID_PresentationServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "StarOffice XML (Impress)" ) );

	if ( *guid == OID_PresentationOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "impress8" ) );

	if ( *guid == OID_MathServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "StarOffice XML (Math)" ) );

	if ( *guid == OID_MathOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "math8" ) );

	return ::rtl::OUString();
}

::rtl::OUString getTestFileURLFromGUID_Impl( GUID* guid )
{
	if ( *guid == OID_WriterTextServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "file:///d:/OLE_TEST/test.sxw" ) );

	if ( *guid == OID_WriterOASISTextServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "file:///d:/OLE_TEST/test.odt" ) );

	if ( *guid == OID_CalcServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "file:///d:/OLE_TEST/test.sxc" ) );

	if ( *guid == OID_CalcOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "file:///d:/OLE_TEST/test.ods" ) );

	if ( *guid == OID_DrawingServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "file:///d:/OLE_TEST/test.sxd" ) );

	if ( *guid == OID_DrawingOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "file:///d:/OLE_TEST/test.odg" ) );

	if ( *guid == OID_PresentationServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "file:///d:/OLE_TEST/test.sxi" ) );

	if ( *guid == OID_PresentationOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "file:///d:/OLE_TEST/test.odp" ) );

	if ( *guid == OID_MathServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "file:///d:/OLE_TEST/test.sxm" ) );

	if ( *guid == OID_MathOASISServer )
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( "file:///d:/OLE_TEST/test.odf" ) );

	return ::rtl::OUString();
}

/*
::rtl::OUString getCurTypeNameFromGUID_Impl( const uno::Reference< lang::XMultiServiceFactory > xFactory, GUID* guid )
{
	::rtl::OUString aResult;

	const ::rtl::OUString aServiceName ( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.document.FilterFactory" ) );
	uno::Reference < container::XNameAccess > xFilters = uno::Reference < io::XOutputStream > ( 
															xFactory->createInstance ( aServiceName ),
															uno::UNO_QUERY );
	
	if ( xFilters.is() )
	{
		::rtl::OUString aFilterName = getFilterNameFromGUID_Impl( guid );
		if ( aFilterName.getLength() )
		{
			uno::Any aAnyProp = xFilters->getByName( aFilterName );
			uno::Sequence< beans::PropertyValue > aProperties;
			if ( aAnyProp >>= aProperties ) )
			{
				for ( sal_Int32 nInd = 0; nInd < aProperties.getLength; nInd++ )
					if ( aProperties[nInd].Name.equalsAscii( "UIName" )
					{
						aProperties[nInd].Value >>= aResult;
						break;
					}
			}
		}
	}

	return aResult;
}
*/


